/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigLogPanel;
import com.netscape.admin.dirserv.config.ErrorLogLevelDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigErrorLogPanel
extends ConfigLogPanel {
    private boolean _saveVerboseLog;
    private int _saveLogLevel;
    private boolean _isVerboseLogDirty;
    private boolean _isLogLevelDirty;
    private boolean _verboseLog;
    private int _logLevel;
    private JButton _bLogLevel;
    private ErrorLogLevelDialog _dlg;
    private String ERROR_LOG_VERBOSE_ATTRIBUTE = "nsslapd-infolog-level ";
    private String ERROR_LOG_LEVEL_ATTRIBUTE = "nsslapd-infolog-area ";
    private static final int ERROR_LOG_LEVEL_ACL = 128;
    private static final int ERROR_LOG_LEVEL_ARGS = 4;
    private static final int ERROR_LOG_LEVEL_HOUSE = 4096;
    private static final int ERROR_LOG_LEVEL_PARSE = 2048;
    private static final int ERROR_LOG_LEVEL_PLUGIN = 65536;
    private static final int ERROR_LOG_LEVEL_REPL = 8192;
    private static final int ERROR_LOG_LEVEL_ALL = 16384;
    private static final int ERROR_LOG_LEVEL_DSML = 131072;
    static final int[] LOG_LEVEL_MASKS = new int[]{128, 4, 4096, 2048, 65536, 8192, 131072};

    public ConfigErrorLogPanel() {
        this._section = "errorlogpanel";
        this.setTitle(ConfigBasePanel._resource.getString(this._section, "title"));
        this._helpToken = "configuration-logs-error-help";
        this.ENABLE_ATTRIBUTE = "nsslapd-errorlog-logging-enabled";
        this.LOG_FILE_ATTRIBUTE = "nsslapd-errorlog";
        this.LOG_NUMBER_ATTRIBUTE = "nsslapd-errorlog-maxlogsperdir";
        this.LOG_SIZE_ATTRIBUTE = "nsslapd-errorlog-maxlogsize";
        this.ROTATION_UNIT_ATTRIBUTE = "nsslapd-errorlog-logrotationtimeunit";
        this.ROTATION_ATTRIBUTE = "nsslapd-errorlog-logrotationtime";
        this.LOG_MAX_SIZE_ATTRIBUTE = "nsslapd-errorlog-logmaxdiskspace";
        this.DISK_SPACE_ATTRIBUTE = "nsslapd-errorlog-logminfreediskspace";
        this.EXPIRATION_UNIT_ATTRIBUTE = "nsslapd-errorlog-logexpirationtimeunit";
        this.EXPIRATION_ATTRIBUTE = "nsslapd-errorlog-logexpirationtime";
        this.ATTRS = new String[12];
        this.ATTRS[0] = this.ENABLE_ATTRIBUTE;
        this.ATTRS[1] = this.LOG_FILE_ATTRIBUTE;
        this.ATTRS[2] = this.LOG_NUMBER_ATTRIBUTE;
        this.ATTRS[3] = this.LOG_SIZE_ATTRIBUTE;
        this.ATTRS[4] = this.ROTATION_UNIT_ATTRIBUTE;
        this.ATTRS[5] = this.ROTATION_ATTRIBUTE;
        this.ATTRS[6] = this.LOG_MAX_SIZE_ATTRIBUTE;
        this.ATTRS[7] = this.DISK_SPACE_ATTRIBUTE;
        this.ATTRS[8] = this.EXPIRATION_UNIT_ATTRIBUTE;
        this.ATTRS[9] = this.EXPIRATION_ATTRIBUTE;
        this.ATTRS[10] = this.ERROR_LOG_LEVEL_ATTRIBUTE;
        this.ATTRS[11] = this.ERROR_LOG_VERBOSE_ATTRIBUTE;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this._bLogLevel) {
            this._dlg.show(this._logLevel, this._verboseLog);
            if (!this._dlg.isCancelled()) {
                this._logLevel = this._dlg.getLogLevel();
                this._verboseLog = this._dlg.isVerboseLog();
                this._isLogLevelDirty = this._logLevel != this._saveLogLevel;
                this._isVerboseLogDirty = this._verboseLog != this._saveVerboseLog;
                this.fireValidDirtyChange();
            }
        }
    }

    protected void enableFields(boolean bl) {
        super.enableFields(bl);
        this._bLogLevel.setEnabled(bl);
    }

    protected void createContentPanel() {
        super.createContentPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        this._bLogLevel = UIFactory.makeJButton(this, "errorlogpanel", "bloglevel", ConfigBasePanel._resource);
        this._buttonPanel.add((Component)this._bLogLevel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this._dlg = new ErrorLogLevelDialog(this._framework);
    }

    protected LDAPModificationSet getLDAPModificationSet() {
        LDAPModificationSet lDAPModificationSet = super.getLDAPModificationSet();
        if (this._cbEnableLog.isSelected()) {
            if (this._isVerboseLogDirty) {
                String string = this._verboseLog ? "1" : "0";
                lDAPModificationSet.add(2, new LDAPAttribute(this.ERROR_LOG_VERBOSE_ATTRIBUTE, string));
            }
            if (this._isLogLevelDirty) {
                lDAPModificationSet.add(2, new LDAPAttribute(this.ERROR_LOG_LEVEL_ATTRIBUTE, String.valueOf(this._logLevel)));
            }
        }
        return lDAPModificationSet;
    }

    protected LDAPEntry readDataFromServer() throws LDAPException, NullPointerException, NumberFormatException {
        LDAPEntry lDAPEntry = super.readDataFromServer();
        this._lastReadAttribute = this.ERROR_LOG_VERBOSE_ATTRIBUTE;
        this._verboseLog = this._saveVerboseLog = this.getValue(lDAPEntry, this._lastReadAttribute).equalsIgnoreCase("1");
        this._isVerboseLogDirty = false;
        this._lastReadAttribute = this.ERROR_LOG_LEVEL_ATTRIBUTE;
        this._saveLogLevel = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        if ((this._saveLogLevel & 0x4000) != 0) {
            int n = 0;
            while (n < LOG_LEVEL_MASKS.length) {
                this._saveLogLevel |= LOG_LEVEL_MASKS[n];
                ++n;
            }
        }
        this._logLevel = this._saveLogLevel;
        this._isLogLevelDirty = false;
        return lDAPEntry;
    }

    protected void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !this._cbEnableLog.isSelected() || this._isLogFileValidDirty[0] && this._isLogNumberValidDirty[0] && this._isLogSizeValidDirty[0] && this._isRotationTimeValidDirty[0] && this._isLogMaxSizeValidDirty[0] && this._isDiskSpaceValidDirty[0] && this._isExpirationValidDirty[0];
        boolean bl3 = bl = this._isEnableLogDirty || this._cbEnableLog.isSelected() && (this._isLogFileValidDirty[1] || this._isLogNumberValidDirty[1] || this._isLogSizeValidDirty[1] || this._isRotationTimeValidDirty[1] || this._isLogMaxSizeValidDirty[1] || this._isDiskSpaceValidDirty[1] || this._isExpirationValidDirty[1] || this._isVerboseLogDirty || this._isLogLevelDirty);
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

