/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public abstract class ConfigLogPanel
extends ConfigBasePanel
implements ActionListener,
DocumentListener {
    private boolean _isInitializing;
    protected boolean _isInitializingComponents;
    private boolean _isCancelled;
    private boolean _logFileChanged;
    protected boolean _needsRestartServer;
    protected JPanel _contentPanel;
    protected String _lastReadAttribute;
    private boolean _isLocal;
    private JTextField _tfLogFile;
    private JTextField _tfLogNumber;
    private JTextField _tfLogSize;
    private JCheckBox _cbUnlimitedLogSize;
    private JTextField _tfRotationTime;
    private JTextField _tfLogMaxSize;
    private JTextField _tfDiskSpace;
    private JTextField _tfExpiration;
    private JLabel _lLogNumber;
    private JLabel _lLogSize;
    private JLabel _lRotationTime;
    private JCheckBox _cbLogMaxSize;
    private JLabel _lDiskSpace;
    private JLabel _lExpiration;
    protected JCheckBox _cbEnableLog;
    private JButton _bBrowse;
    private JComboBox _comboRotation;
    private JComboBox _comboExpiration;
    protected JPanel _buttonPanel;
    private boolean _saveEnableLog;
    private String _saveLogFile;
    private int _saveLogNumber;
    private int _saveLogSize;
    private int _saveRotationTime;
    private int _saveRotationUnit;
    private int _saveLogMaxSize;
    private int _saveDiskSpace;
    private int _saveExpiration;
    private int _saveExpirationUnit;
    protected boolean _isEnableLogDirty;
    protected boolean[] _isLogFileValidDirty = new boolean[]{true, false};
    protected boolean[] _isLogNumberValidDirty = new boolean[]{true, false};
    protected boolean[] _isLogSizeValidDirty = new boolean[]{true, false};
    protected boolean[] _isRotationTimeValidDirty = new boolean[]{true, false};
    protected boolean[] _isLogMaxSizeValidDirty = new boolean[]{true, false};
    protected boolean[] _isDiskSpaceValidDirty = new boolean[]{true, false};
    protected boolean[] _isExpirationValidDirty = new boolean[]{true, false};
    protected String _section;
    protected String ENABLE_ATTRIBUTE;
    protected String LOG_FILE_ATTRIBUTE;
    protected String LOG_NUMBER_ATTRIBUTE;
    protected String LOG_SIZE_ATTRIBUTE;
    protected String ROTATION_UNIT_ATTRIBUTE;
    protected String ROTATION_ATTRIBUTE;
    protected String LOG_MAX_SIZE_ATTRIBUTE;
    protected String DISK_SPACE_ATTRIBUTE;
    protected String EXPIRATION_UNIT_ATTRIBUTE;
    protected String EXPIRATION_ATTRIBUTE;
    protected String[] ATTRS;
    private JLabel _lLimit;
    private JLabel _lMb1;
    private JLabel _lMb2;
    private JLabel _lMb3;
    private String _defaultLocation;
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("logpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("logpanel-no-rights", "label"), 2, 50);
    final int LIMIT_LOG_NUMBER = 300;
    final int LIMIT_LOG_SIZE = 100000;
    final int LIMIT_ROTATION_TIME = 1000;
    final int LIMIT_LOG_MAX_SIZE = 100000;
    final int LIMIT_DISK_SPACE = 100000;
    final int LIMIT_EXPIRATION = 1000;
    final int UNLIMITED_LOG_MAX_SIZE = -1;
    final int UNLIMITED_LOG_SIZE = -1;
    final String[] ROTATION_ITEMS = new String[]{ConfigBasePanel._resource.getString("logpanel", "minutes-label"), ConfigBasePanel._resource.getString("logpanel", "hours-label"), ConfigBasePanel._resource.getString("logpanel", "days-label"), ConfigBasePanel._resource.getString("logpanel", "weeks-label"), ConfigBasePanel._resource.getString("logpanel", "months-label")};
    final String[] ROTATION_UNIT_VALUES = new String[]{"minute", "hour", "day", "week", "month"};
    final String[] EXPIRATION_ITEMS = new String[]{ConfigBasePanel._resource.getString("logpanel", "days-label"), ConfigBasePanel._resource.getString("logpanel", "weeks-label"), ConfigBasePanel._resource.getString("logpanel", "months-label")};
    final String[] EXPIRATION_UNIT_VALUES = new String[]{"day", "week", "month"};

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigLogPanel.this._isLocal = DSUtil.isLocal(ConfigLogPanel.this.getServerInfo().getHost());
                        String string = (String)ConfigLogPanel.this._framework.getServerObject().getServerInfo().get("InstallPath");
                        String string2 = (String)ConfigLogPanel.this._framework.getServerObject().getServerInfo().get("ServerInstance");
                        ConfigLogPanel.this._defaultLocation = string + '/' + string2 + "/logs";
                        ConfigLogPanel.this.createContentPanel();
                        ConfigLogPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).initComponentsFromServerValues();
                                1.access$200(this.this$1).showComponent(1.access$200(this.this$1)._contentPanel, false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigLogPanel.access$300(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{1.access$200(this.this$1)._lastReadAttribute};
                                String string = ConfigBasePanel._resource.getString("logpanel", "formatting-error-label", stringArray);
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("logpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigLogPanel.this._isInitialized = true;
                    ConfigLogPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigLogPanel access$200(1 var0) {
                    return var0.ConfigLogPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigLogPanel.this.initComponentsFromServerValues();
                    ConfigLogPanel.this.fireValidDirtyChange();
                    ConfigLogPanel.this.showComponent(ConfigLogPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigLogPanel.this.showComponent((JComponent)ConfigLogPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigLogPanel.this._lastReadAttribute};
                    String string = ConfigBasePanel._resource.getString("logpanel", "formatting-error-label", stringArray);
                    ConfigLogPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("logpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigLogPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public boolean needsConfirmation() {
        boolean bl = this._cbUnlimitedLogSize.isSelected() && this._isLogSizeValidDirty[1] || !this._cbLogMaxSize.isSelected() && this._isLogMaxSizeValidDirty[1];
        return bl;
    }

    public boolean askForConfirmation() {
        int n = this._cbUnlimitedLogSize.isSelected() ? DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-unlimitedlogsize", (String[])null, "logpanel", ConfigBasePanel._resource) : DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-notdeletebasedonsize", (String[])null, "logpanel", ConfigBasePanel._resource);
        return n == 0;
    }

    public void okCallback() throws ConfigPanelException {
        this._needsRestartServer = false;
        this._logFileChanged = false;
        LDAPModificationSet lDAPModificationSet = this.getLDAPModificationSet();
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify("cn=config", lDAPModificationSet);
                if (this._logFileChanged) {
                    int n = -1;
                    if (this.LOG_FILE_ATTRIBUTE.equalsIgnoreCase("nsslapd-auditlog")) {
                        n = 2;
                    } else if (this.LOG_FILE_ATTRIBUTE.equalsIgnoreCase("nsslapd-errorlog")) {
                        n = 0;
                    } else if (this.LOG_FILE_ATTRIBUTE.equalsIgnoreCase("nsslapd-accesslog")) {
                        n = 1;
                    } else {
                        Thread.dumpStack();
                    }
                    this._framework.getServerObject().notifyLogFileChanged(n);
                }
            }
            catch (LDAPException lDAPException) {
                this._needsRestartServer = false;
                this._logFileChanged = false;
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString(this._section, "updating-server-error-title"), ConfigBasePanel._resource.getString(this._section, "updating-server-error-msg", stringArray));
            }
            this.resetCallback();
        }
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsRestartServer() {
        return this._needsRestartServer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbEnableLog) {
            this.enableFields(this._cbEnableLog.isSelected());
            boolean bl = this._isEnableLogDirty = this._cbEnableLog.isSelected() != this._saveEnableLog;
            if (this._isEnableLogDirty) {
                BlankPanel.setChangeState(this._cbEnableLog, 1);
            } else {
                BlankPanel.setChangeState(this._cbEnableLog, 2);
            }
            this.fireValidDirtyChange();
        } else if (object == this._bBrowse) {
            String string;
            String string2 = this._tfLogFile.getText().trim();
            if (string2.length() == 0 && DSFileDialog.getDefaultDirectory() == null) {
                DSFileDialog.setDefaultDirectory(this._defaultLocation);
            }
            if ((string = DSFileDialog.browseFiles(string2, true, null, null, this._bBrowse)) != null) {
                this._tfLogFile.setText(string);
            }
        } else if (object == this._cbUnlimitedLogSize) {
            this._tfLogSize.setEnabled(!this._cbUnlimitedLogSize.isSelected());
            this._lMb1.setEnabled(!this._cbUnlimitedLogSize.isSelected());
            if (this._cbUnlimitedLogSize.isSelected()) {
                if (this._cbLogMaxSize.isSelected()) {
                    this._cbLogMaxSize.doClick();
                }
            } else if (!this._cbLogMaxSize.isSelected()) {
                this._cbLogMaxSize.doClick();
            }
            this.checkLogSizes();
        } else if (object == this._cbLogMaxSize) {
            if (this._cbLogMaxSize.isSelected()) {
                if (this._cbUnlimitedLogSize.isSelected()) {
                    this._cbUnlimitedLogSize.doClick();
                }
            } else if (!this._cbUnlimitedLogSize.isSelected()) {
                this._cbUnlimitedLogSize.doClick();
            }
            this._tfLogMaxSize.setEnabled(this._cbLogMaxSize.isSelected());
            this._lMb2.setEnabled(this._cbLogMaxSize.isSelected());
            this.checkLogSizes();
        } else if (object == this._comboExpiration) {
            this.checkIntField(this._tfExpiration, this._lExpiration, this._isExpirationValidDirty, this._saveExpiration, 1000);
        } else if (object == this._comboRotation) {
            this.checkIntField(this._tfRotationTime, this._lRotationTime, this._isRotationTimeValidDirty, this._saveRotationTime, 1000);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitializingComponents) {
            Document document = documentEvent.getDocument();
            if (document == this._tfLogFile.getDocument()) {
                this._isLogFileValidDirty[0] = !this._tfLogFile.getText().trim().equals("");
                this._isLogFileValidDirty[1] = !this._tfLogFile.getText().equals(this._saveLogFile);
                this.fireValidDirtyChange();
            } else if (document == this._tfLogNumber.getDocument()) {
                this.checkIntField(this._tfLogNumber, this._lLogNumber, this._isLogNumberValidDirty, this._saveLogNumber, 300);
            } else if (document == this._tfLogSize.getDocument()) {
                if (!this._cbLogMaxSize.isSelected()) {
                    this._cbLogMaxSize.doClick();
                }
                this.checkLogSizes();
            } else if (document == this._tfRotationTime.getDocument()) {
                this.checkIntField(this._tfRotationTime, this._lRotationTime, this._isRotationTimeValidDirty, this._saveRotationTime, 1000);
            } else if (document == this._tfLogMaxSize.getDocument()) {
                this.checkLogSizes();
            } else if (document == this._tfDiskSpace.getDocument()) {
                this.checkIntField(this._tfDiskSpace, this._lDiskSpace, this._isDiskSpaceValidDirty, this._saveDiskSpace, 100000);
            } else if (document == this._tfExpiration.getDocument()) {
                this.checkIntField(this._tfExpiration, this._lExpiration, this._isExpirationValidDirty, this._saveExpiration, 1000);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void enableFields(boolean bl) {
        this._tfLogFile.setEnabled(bl);
        this._tfLogNumber.setEnabled(bl);
        this._tfLogSize.setEnabled(bl && !this._cbUnlimitedLogSize.isSelected());
        this._cbUnlimitedLogSize.setEnabled(bl);
        this._tfRotationTime.setEnabled(bl);
        this._tfLogMaxSize.setEnabled(bl && this._cbLogMaxSize.isSelected());
        this._tfDiskSpace.setEnabled(bl);
        this._tfExpiration.setEnabled(bl);
        this._lLogNumber.setEnabled(bl);
        this._lLogSize.setEnabled(bl);
        this._lRotationTime.setEnabled(bl);
        this._cbLogMaxSize.setEnabled(bl);
        this._lDiskSpace.setEnabled(bl);
        this._lExpiration.setEnabled(bl);
        this._lLimit.setEnabled(bl);
        this._lMb1.setEnabled(bl && !this._cbUnlimitedLogSize.isSelected());
        this._lMb2.setEnabled(bl && this._cbLogMaxSize.isSelected());
        this._lMb3.setEnabled(bl);
        this._bBrowse.setEnabled(bl && this._isLocal);
        this._comboRotation.setEnabled(bl);
        this._comboExpiration.setEnabled(bl);
    }

    protected LDAPModificationSet getLDAPModificationSet() {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isEnableLogDirty) {
            String string = this._cbEnableLog.isSelected() ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute(this.ENABLE_ATTRIBUTE, string));
        }
        if (this._cbEnableLog.isSelected()) {
            String string;
            if (this._isLogFileValidDirty[1]) {
                lDAPModificationSet.add(2, new LDAPAttribute(this.LOG_FILE_ATTRIBUTE, this._tfLogFile.getText()));
                this._needsRestartServer = true;
                this._logFileChanged = true;
            }
            if (this._isLogNumberValidDirty[1]) {
                lDAPModificationSet.add(2, new LDAPAttribute(this.LOG_NUMBER_ATTRIBUTE, this._tfLogNumber.getText()));
            }
            if (this._isLogSizeValidDirty[1]) {
                string = this._cbUnlimitedLogSize.isSelected() ? String.valueOf(-1) : this._tfLogSize.getText();
                lDAPModificationSet.add(2, new LDAPAttribute(this.LOG_SIZE_ATTRIBUTE, string));
            }
            if (this._isRotationTimeValidDirty[1]) {
                int n = this._comboRotation.getSelectedIndex();
                if (this._saveRotationUnit != n) {
                    lDAPModificationSet.add(2, new LDAPAttribute(this.ROTATION_UNIT_ATTRIBUTE, this.ROTATION_UNIT_VALUES[n]));
                }
                try {
                    if (this._saveRotationTime != Integer.parseInt(this._tfRotationTime.getText())) {
                        lDAPModificationSet.add(2, new LDAPAttribute(this.ROTATION_ATTRIBUTE, this._tfRotationTime.getText()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this._isLogMaxSizeValidDirty[1]) {
                string = this._cbLogMaxSize.isSelected() ? this._tfLogMaxSize.getText() : String.valueOf(-1);
                lDAPModificationSet.add(2, new LDAPAttribute(this.LOG_MAX_SIZE_ATTRIBUTE, string));
            }
            if (this._isDiskSpaceValidDirty[1]) {
                lDAPModificationSet.add(2, new LDAPAttribute(this.DISK_SPACE_ATTRIBUTE, this._tfDiskSpace.getText()));
            }
            if (this._isExpirationValidDirty[1]) {
                int n = this._comboExpiration.getSelectedIndex();
                if (this._saveExpirationUnit != n) {
                    lDAPModificationSet.add(2, new LDAPAttribute(this.EXPIRATION_UNIT_ATTRIBUTE, this.EXPIRATION_UNIT_VALUES[n]));
                }
                try {
                    if (this._saveExpiration != Integer.parseInt(this._tfExpiration.getText())) {
                        lDAPModificationSet.add(2, new LDAPAttribute(this.EXPIRATION_ATTRIBUTE, this._tfExpiration.getText()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return lDAPModificationSet;
    }

    protected LDAPEntry readDataFromServer() throws LDAPException, NullPointerException, NumberFormatException {
        LDAPEntry lDAPEntry = this.getServerInfo().getLDAPConnection().read("cn=config", this.ATTRS);
        this._saveEnableLog = this.getValue(lDAPEntry, this.ENABLE_ATTRIBUTE).equalsIgnoreCase("on");
        this._lastReadAttribute = this.LOG_FILE_ATTRIBUTE;
        this._saveLogFile = this.getValue(lDAPEntry, this._lastReadAttribute);
        this._lastReadAttribute = this.LOG_NUMBER_ATTRIBUTE;
        this._saveLogNumber = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = this.LOG_SIZE_ATTRIBUTE;
        this._saveLogSize = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = this.ROTATION_ATTRIBUTE;
        this._saveRotationTime = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        String string = this.getValue(lDAPEntry, this.ROTATION_UNIT_ATTRIBUTE);
        boolean bl = false;
        int n = 0;
        while (n < this.ROTATION_UNIT_VALUES.length && !bl) {
            if (this.ROTATION_UNIT_VALUES[n].equalsIgnoreCase(string)) {
                bl = true;
                this._saveRotationUnit = n;
            }
            ++n;
        }
        this._lastReadAttribute = this.LOG_MAX_SIZE_ATTRIBUTE;
        this._saveLogMaxSize = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = this.DISK_SPACE_ATTRIBUTE;
        this._saveDiskSpace = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = this.EXPIRATION_ATTRIBUTE;
        this._saveExpiration = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        String string2 = this.getValue(lDAPEntry, this.EXPIRATION_UNIT_ATTRIBUTE);
        bl = false;
        int n2 = 0;
        while (n2 < this.EXPIRATION_UNIT_VALUES.length && !bl) {
            if (this.EXPIRATION_UNIT_VALUES[n2].equalsIgnoreCase(string2)) {
                bl = true;
                this._saveExpirationUnit = n2;
            }
            ++n2;
        }
        return lDAPEntry;
    }

    protected void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbEnableLog = UIFactory.makeJCheckBox(this, "logpanel", "cbenablelog", false, ConfigBasePanel._resource);
        this._tfLogFile = UIFactory.makeJTextField(this, "", "", null, 20, ConfigBasePanel._resource);
        this._bBrowse = UIFactory.makeJButton(this, "logpanel", "bbrowse", ConfigBasePanel._resource);
        this._lLogNumber = UIFactory.makeJLabel("logpanel", "llognumber", ConfigBasePanel._resource);
        this._tfLogNumber = UIFactory.makeJTextField(this, "logpanel", "llognumber", null, 8, ConfigBasePanel._resource);
        this._lLogNumber.setLabelFor(this._tfLogNumber);
        this._lLogSize = UIFactory.makeJLabel("logpanel", "llogsize", ConfigBasePanel._resource);
        this._tfLogSize = UIFactory.makeJTextField(this, "logpanel", "llogsize", null, 8, ConfigBasePanel._resource);
        this._lLogSize.setLabelFor(this._tfLogSize);
        this._cbUnlimitedLogSize = UIFactory.makeJCheckBox(this, "logpanel", "cbunlimitedlogsize", false, ConfigBasePanel._resource);
        this._lRotationTime = UIFactory.makeJLabel("logpanel", "lrotationtime", ConfigBasePanel._resource);
        this._tfRotationTime = UIFactory.makeJTextField(this, "logpanel", "lrotationtime", null, 8, ConfigBasePanel._resource);
        this._lRotationTime.setLabelFor(this._tfRotationTime);
        this._comboRotation = new JComboBox<String>(this.ROTATION_ITEMS);
        this._comboRotation.setToolTipText(this._lRotationTime.getToolTipText());
        this._comboRotation.addActionListener(this);
        this._cbLogMaxSize = UIFactory.makeJCheckBox(this, "logpanel", "cblogmaxsize", false, ConfigBasePanel._resource);
        this._tfLogMaxSize = UIFactory.makeJTextField(this, "logpanel", "cblogmaxsize", null, 8, ConfigBasePanel._resource);
        this._lDiskSpace = UIFactory.makeJLabel("logpanel", "ldiskspace", ConfigBasePanel._resource);
        this._tfDiskSpace = UIFactory.makeJTextField(this, "logpanel", "ldiskspace", null, 8, ConfigBasePanel._resource);
        this._lDiskSpace.setLabelFor(this._tfDiskSpace);
        this._lExpiration = UIFactory.makeJLabel("logpanel", "lexpiration", ConfigBasePanel._resource);
        this._tfExpiration = UIFactory.makeJTextField(this, "logpanel", "lexpiration", null, 8, ConfigBasePanel._resource);
        this._lExpiration.setLabelFor(this._tfExpiration);
        this._comboExpiration = new JComboBox<String>(this.EXPIRATION_ITEMS);
        this._comboExpiration.setToolTipText(this._lExpiration.getToolTipText());
        this._comboExpiration.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), 16, 0, 0);
        this._contentPanel.add((Component)this._cbEnableLog, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        this._buttonPanel = new JPanel(new GridBagLayout());
        this._contentPanel.add((Component)this._buttonPanel, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("logpanel", "filepanel-title"));
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        groupPanel.add((Component)this._tfLogFile, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        GroupPanel groupPanel2 = new GroupPanel(ConfigBasePanel._resource.getString("logpanel", "creationpanel-title"));
        this._contentPanel.add((Component)groupPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel2.add((Component)this._lLogNumber, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel2.add((Component)this._tfLogNumber, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 0;
        groupPanel2.add((Component)this._lLogSize, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel2.add((Component)this._tfLogSize, gridBagConstraints);
        this._lMb1 = UIFactory.makeJLabel("logpanel", "mb", ConfigBasePanel._resource);
        this._lMb1.setLabelFor(this._tfLogSize);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._lMb1, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getDifferentSpace();
        jPanel.add((Component)this._cbUnlimitedLogSize, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        groupPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 0;
        groupPanel2.add((Component)this._lRotationTime, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel2.add((Component)this._tfRotationTime, gridBagConstraints);
        groupPanel2.add((Component)this._comboRotation, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        GroupPanel groupPanel3 = new GroupPanel(ConfigBasePanel._resource.getString("logpanel", "expirationpanel-title"));
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this._contentPanel.add((Component)groupPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel3.add((Component)this._cbLogMaxSize, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        --gridBagConstraints.gridwidth;
        groupPanel3.add((Component)this._tfLogMaxSize, gridBagConstraints);
        this._lMb2 = UIFactory.makeJLabel("logpanel", "mb", ConfigBasePanel._resource);
        this._lMb2.setLabelFor(this._tfLogMaxSize);
        gridBagConstraints.gridwidth = -1;
        groupPanel3.add((Component)this._lMb2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._lLimit = UIFactory.makeJLabel("logpanel", "limit", ConfigBasePanel._resource);
        this._lLimit.setFont(this._lLimit.getFont().deriveFont(2));
        this._lLimit.setLabelFor(this._tfLogMaxSize);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        groupPanel3.add((Component)this._lLimit, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel3.add((Component)this._lDiskSpace, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        --gridBagConstraints.gridwidth;
        groupPanel3.add((Component)this._tfDiskSpace, gridBagConstraints);
        this._lMb3 = UIFactory.makeJLabel("logpanel", "mb", ConfigBasePanel._resource);
        this._lMb3.setLabelFor(this._tfDiskSpace);
        gridBagConstraints.gridwidth = -1;
        groupPanel3.add((Component)this._lMb3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 0;
        groupPanel3.add((Component)this._lExpiration, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel3.add((Component)this._tfExpiration, gridBagConstraints);
        groupPanel3.add((Component)this._comboExpiration, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        groupPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    protected void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = !this._cbEnableLog.isSelected() || this._isLogFileValidDirty[0] && this._isLogNumberValidDirty[0] && this._isLogSizeValidDirty[0] && this._isRotationTimeValidDirty[0] && this._isLogMaxSizeValidDirty[0] && this._isDiskSpaceValidDirty[0] && this._isExpirationValidDirty[0];
        boolean bl3 = bl = this._isEnableLogDirty || this._cbEnableLog.isSelected() && (this._isLogFileValidDirty[1] || this._isLogNumberValidDirty[1] || this._isLogSizeValidDirty[1] || this._isRotationTimeValidDirty[1] || this._isLogMaxSizeValidDirty[1] || this._isDiskSpaceValidDirty[1] || this._isExpirationValidDirty[1]);
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    protected void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._cbEnableLog.setSelected(this._saveEnableLog);
        BlankPanel.setChangeState(this._cbEnableLog, 1);
        this._isEnableLogDirty = false;
        this._tfLogFile.setText(this._saveLogFile);
        this._isLogFileValidDirty[0] = true;
        this._isLogFileValidDirty[1] = false;
        this._tfLogNumber.setText(Integer.toString(this._saveLogNumber));
        BlankPanel.setChangeState(this._lLogNumber, 1);
        this._isLogNumberValidDirty[0] = true;
        this._isLogNumberValidDirty[1] = false;
        this._cbUnlimitedLogSize.setSelected(this._saveLogSize == -1);
        if (this._cbUnlimitedLogSize.isSelected()) {
            this._tfLogSize.setText(null);
        } else {
            this._tfLogSize.setText(Integer.toString(this._saveLogSize));
        }
        BlankPanel.setChangeState(this._lLogSize, 1);
        this._isLogSizeValidDirty[0] = true;
        this._isLogSizeValidDirty[1] = false;
        this._tfRotationTime.setText(Integer.toString(this._saveRotationTime));
        BlankPanel.setChangeState(this._lRotationTime, 1);
        this._comboRotation.setSelectedIndex(this._saveRotationUnit);
        this._isRotationTimeValidDirty[0] = true;
        this._isRotationTimeValidDirty[1] = false;
        this._cbLogMaxSize.setSelected(this._saveLogMaxSize != -1);
        if (this._cbLogMaxSize.isSelected()) {
            this._tfLogMaxSize.setText(Integer.toString(this._saveLogMaxSize));
        } else {
            this._tfLogMaxSize.setText(null);
        }
        BlankPanel.setChangeState(this._cbLogMaxSize, 1);
        this._isLogMaxSizeValidDirty[0] = true;
        this._isLogMaxSizeValidDirty[1] = false;
        this._tfDiskSpace.setText(Integer.toString(this._saveDiskSpace));
        BlankPanel.setChangeState(this._lDiskSpace, 1);
        this._isDiskSpaceValidDirty[0] = true;
        this._isDiskSpaceValidDirty[1] = false;
        this._tfExpiration.setText(Integer.toString(this._saveExpiration));
        BlankPanel.setChangeState(this._lExpiration, 1);
        this._comboExpiration.setSelectedIndex(this._saveExpirationUnit);
        this._isExpirationValidDirty[0] = true;
        this._isExpirationValidDirty[1] = false;
        this.enableFields(this._cbEnableLog.isSelected());
        this._isInitializingComponents = false;
    }

    private void checkIntField(JTextField jTextField, JComponent jComponent, boolean[] blArray, int n, int n2) {
        try {
            int n3 = Integer.parseInt(jTextField.getText());
            boolean bl = blArray[0] = 0 <= n3 && n3 <= n2;
            blArray[1] = jTextField == this._tfExpiration ? n3 != n || this._comboExpiration.getSelectedIndex() != this._saveExpirationUnit : (jTextField == this._tfRotationTime ? n3 != n || this._comboRotation.getSelectedIndex() != this._saveRotationUnit : n3 != n);
        }
        catch (NumberFormatException numberFormatException) {
            blArray[0] = false;
            blArray[1] = true;
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jComponent, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jComponent, 2);
        } else {
            BlankPanel.setChangeState(jComponent, 1);
        }
        this.fireValidDirtyChange();
    }

    private void checkLogSizes() {
        boolean bl = false;
        if (!this._cbUnlimitedLogSize.isSelected()) {
            this.checkIntField(this._tfLogSize, this._lLogSize, this._isLogSizeValidDirty, this._saveLogSize, 100000);
            if (this._cbLogMaxSize.isSelected()) {
                this.checkIntField(this._tfLogMaxSize, this._cbLogMaxSize, this._isLogMaxSizeValidDirty, this._saveLogMaxSize, 100000);
                bl = true;
            } else {
                this._isLogMaxSizeValidDirty[0] = false;
                this._isLogMaxSizeValidDirty[1] = false;
                BlankPanel.setChangeState(this._cbLogMaxSize, 3);
                BlankPanel.setChangeState(this._cbLogMaxSize, 3);
                this.fireValidDirtyChange();
            }
        } else {
            this._isLogSizeValidDirty[0] = true;
            boolean bl2 = this._isLogSizeValidDirty[1] = this._saveLogSize != -1;
            if (this._isLogSizeValidDirty[1]) {
                BlankPanel.setChangeState(this._lLogSize, 2);
            } else {
                BlankPanel.setChangeState(this._lLogSize, 1);
            }
            if (this._cbLogMaxSize.isSelected()) {
                this._isLogMaxSizeValidDirty[0] = false;
                this._isLogMaxSizeValidDirty[1] = false;
                BlankPanel.setChangeState(this._cbLogMaxSize, 3);
            } else {
                this._isLogMaxSizeValidDirty[0] = true;
                boolean bl3 = this._isLogMaxSizeValidDirty[1] = this._saveLogMaxSize != -1;
                if (this._isLogMaxSizeValidDirty[1]) {
                    BlankPanel.setChangeState(this._cbLogMaxSize, 2);
                } else {
                    BlankPanel.setChangeState(this._cbLogMaxSize, 1);
                }
            }
            this.fireValidDirtyChange();
        }
        if (bl && this._isLogSizeValidDirty[0] && this._isLogMaxSizeValidDirty[0]) {
            try {
                boolean bl4;
                boolean bl5 = bl4 = Integer.parseInt(this._tfLogSize.getText()) <= Integer.parseInt(this._tfLogMaxSize.getText());
                if (!bl4) {
                    this._isLogSizeValidDirty[0] = false;
                    this._isLogMaxSizeValidDirty[0] = false;
                    BlankPanel.setChangeState(this._lLogSize, 3);
                    BlankPanel.setChangeState(this._cbLogMaxSize, 3);
                    this.fireValidDirtyChange();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

