/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigPluginRootPanel
extends JPanel
implements ActionListener {
    private DSFramework _framework;
    private JPanel _contentPanel;
    private JPanel _innerPane;
    private JPanel _buttonPanel;
    private boolean _isReloading;
    private JRadioButton _rbDoNotVerify;
    private JRadioButton _rbAllowAll;
    private JRadioButton _rbAllowSigned;
    private JButton _bHelp;
    private JButton _bSave;
    private JButton _bReset;
    private boolean _saveVerifyPlugins;
    private boolean _saveAllowAll;
    private static final ResourceSet _resource = DSConfigPage._resource;
    private static final String _helpToken = "configuration-plugin-signature-help";
    private final JLabel REFRESH_LABEL = new JLabel(_resource.getString("pluginrootpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(_resource.getString("pluginrootpanel-no-rights", "label"), 2, 40);

    public ConfigPluginRootPanel(DSFramework dSFramework) {
        this._framework = dSFramework;
        this.basicLayout();
        this.createContentPanel();
    }

    private void basicLayout() {
        this.setLayout(new BorderLayout(0, 0));
        this.createButtonPanel();
        this.add((Component)this._buttonPanel, "South");
        this._innerPane = new JPanel(new GridBagLayout());
        this.add((Component)this._innerPane, "Center");
    }

    private void createButtonPanel() {
        this._bSave = UIFactory.makeJButton(this, "general", "apply", _resource);
        this._bSave.setEnabled(false);
        this._bReset = UIFactory.makeJButton(this, "general", "reset", _resource);
        this._bReset.setEnabled(false);
        this._bHelp = UIFactory.makeJButton(this, "general", "help", _resource);
        JButton[] jButtonArray = new JButton[]{this._bSave, this._bReset, this._bHelp};
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new BorderLayout());
        this._buttonPanel.add((Component)UIFactory.makeJButtonPanel(jButtonArray, true), "Center");
        this._buttonPanel.add(Box.createVerticalStrut(UIFactory.getDifferentSpace()), "North");
    }

    public void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ConfigPluginRootPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigPluginRootPanel.access$200(1.access$100(this.this$1));
                                ConfigPluginRootPanel.access$400(1.access$100(this.this$1), ConfigPluginRootPanel.access$300(1.access$100(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigPluginRootPanel.access$400(1.access$100(this.this$1), (JComponent)ConfigPluginRootPanel.access$500(1.access$100(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = _resource.getString("pluginrootpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                ConfigPluginRootPanel.access$400(1.access$100(this.this$1), (JComponent)new MultilineLabel(this.val$msg, 2, 40), true);
                            }
                        });
                    }
                    ConfigPluginRootPanel.this._isReloading = false;
                }

                static /* synthetic */ ConfigPluginRootPanel access$100(1 var0) {
                    return var0.ConfigPluginRootPanel.this;
                }
            });
            thread.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bHelp) {
            this.actionHelp();
        } else if (object == this._bSave) {
            this.actionSave();
        } else if (object == this._bReset) {
            this.actionReset();
        } else if (object instanceof JRadioButton) {
            this.actionRadioButton();
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._rbDoNotVerify = UIFactory.makeJRadioButton(null, "pluginrootpanel", "rbdonotverify", false, _resource);
        this._rbDoNotVerify.addActionListener(this);
        this._rbAllowAll = UIFactory.makeJRadioButton(null, "pluginrootpanel", "rballowall", false, _resource);
        this._rbAllowAll.addActionListener(this);
        this._rbAllowSigned = UIFactory.makeJRadioButton(null, "pluginrootpanel", "rballowsigned", false, _resource);
        this._rbAllowSigned.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbDoNotVerify);
        buttonGroup.add(this._rbAllowAll);
        buttonGroup.add(this._rbAllowSigned);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this._contentPanel.add((Component)this._rbDoNotVerify, gridBagConstraints);
        this._contentPanel.add((Component)this._rbAllowAll, gridBagConstraints);
        this._contentPanel.add((Component)this._rbAllowSigned, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void actionHelp() {
        DSUtil.help(_helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private void actionSave() {
        String string;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = !this._rbDoNotVerify.isSelected();
        boolean bl2 = this._rbAllowAll.isSelected();
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (bl != this._saveVerifyPlugins) {
            string = bl ? "on" : "off";
            lDAPModificationSet.add(2, new LDAPAttribute("ds-verify-plugin-signature", string));
        }
        if (bl2 != this._saveAllowAll) {
            string = bl2 ? "off" : "on";
            lDAPModificationSet.add(2, new LDAPAttribute("ds-require-valid-plugin-signature", string));
        }
        if (lDAPModificationSet.size() > 0) {
            try {
                lDAPConnection.modify("cn=config", lDAPModificationSet);
                this.readAndUpdate();
                DSUtil.showInformationDialog((Component)((Object)this._framework), "needsrestartserver", null, "pluginrootpanel", _resource);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-modifying-title", "error-modifying-msg", stringArray, "pluginrootpanel", _resource);
            }
        }
    }

    private void actionReset() {
        this.readAndUpdate();
    }

    private void actionRadioButton() {
        boolean bl = !this._rbDoNotVerify.isSelected();
        boolean bl2 = this._rbAllowAll.isSelected();
        boolean bl3 = bl != this._saveVerifyPlugins || bl2 != this._saveAllowAll;
        this._bReset.setEnabled(bl3);
        this._bSave.setEnabled(bl3);
    }

    private void showComponent(JComponent jComponent, boolean bl) {
        this._innerPane.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        if (bl) {
            gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.remove(this._buttonPanel);
        } else {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            if (!this.isAncestorOf(this._buttonPanel)) {
                this.add("South", this._buttonPanel);
            }
        }
        this._bHelp.setVisible(!bl);
        this._innerPane.add((Component)jComponent, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void readDataFromServer() throws LDAPException {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"ds-verify-plugin-signature", "ds-require-valid-plugin-signature"};
        LDAPEntry lDAPEntry = lDAPConnection.read("cn=config", stringArray);
        String string = (String)lDAPEntry.getAttribute("ds-verify-plugin-signature").getStringValues().nextElement();
        this._saveVerifyPlugins = string.equalsIgnoreCase("on");
        string = (String)lDAPEntry.getAttribute("ds-require-valid-plugin-signature").getStringValues().nextElement();
        this._saveAllowAll = !string.equalsIgnoreCase("on");
    }

    private void initComponentsFromServerValues() {
        if (this._saveVerifyPlugins) {
            this._rbAllowAll.setSelected(this._saveAllowAll);
            this._rbAllowSigned.setSelected(!this._saveAllowAll);
        } else {
            this._rbDoNotVerify.setSelected(true);
        }
        this._bSave.setEnabled(false);
        this._bReset.setEnabled(false);
    }

    static /* synthetic */ void access$200(ConfigPluginRootPanel configPluginRootPanel) {
        configPluginRootPanel.initComponentsFromServerValues();
    }

    static /* synthetic */ JPanel access$300(ConfigPluginRootPanel configPluginRootPanel) {
        return configPluginRootPanel._contentPanel;
    }

    static /* synthetic */ void access$400(ConfigPluginRootPanel configPluginRootPanel, JComponent jComponent, boolean bl) {
        configPluginRootPanel.showComponent(jComponent, bl);
    }

    static /* synthetic */ MultilineLabel access$500(ConfigPluginRootPanel configPluginRootPanel) {
        return configPluginRootPanel.NO_RIGHTS_LABEL;
    }
}

