/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.ConfigChainedSuffixTabbedPanel;
import com.netscape.admin.dirserv.config.ConfigLocalSuffixTabbedPanel;
import com.netscape.admin.dirserv.config.ConfigRootNode;
import com.netscape.admin.dirserv.config.ConfigRootPanel;
import com.netscape.admin.dirserv.config.ConfigTabbedBasePanel;
import com.netscape.admin.dirserv.config.ConfirmDeleteSuffixDialog;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.ExportSuffixDialog;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.admin.dirserv.config.InitializeSuffixDialog;
import com.netscape.admin.dirserv.config.NewChainedSuffixDialog;
import com.netscape.admin.dirserv.config.NewSuffixDialog;
import com.netscape.admin.dirserv.config.ReindexSuffixDialog;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.config.replication.ConfigReplicationNode;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.util.DN;

public class ConfigSuffixNode
extends DefaultMutableTreeNode
implements IConfigNode {
    private DSFramework _framework;
    private Suffix _suffix;
    private int _suffixType;
    private DefaultTreeModel _treeModel;
    private JTree _tree;
    private boolean _refreshPanelOnRequest;
    private boolean _isLeaf;
    private boolean _isRefreshNeededOnExpansion;
    private Icon _icon;
    private Component _customPanel;
    private ConfigTabbedBasePanel _localCustomPanel;
    private ConfigTabbedBasePanel _chainedCustomPanel;
    private JPanel _nonSupportedCustomPanel;
    private JTextArea _taNonSupported;
    private IMenuItem[] _objectMenuItems;
    private IMenuItem[] _contextMenuItems;
    protected static final ResourceSet _resource = DSConfigPage._resource;
    private static final String NEW_SUB_SUFFIX = "NEW SUB SUFFIX";
    private static final String NEW_CHAINED_SUB_SUFFIX = "NEW CHAINED SUB SUFFIX";
    private static final String INITIALIZE_SUFFIX = "INITIALIZE SUFFIX";
    private static final String EXPORT_SUFFIX = "EXPORT SUFFIX";
    private static final String REINDEX_SUFFIX = "REINDEX SUFFIX";
    private static final String DELETE_SUFFIX = "DELETE SUFFIX";
    private static final DN LDBM_PLUGIN_DN = new DN("cn=ldbm database,cn=plugins,cn=config");
    static final int LOCAL_SUFFIX = 0;
    static final int CHAINED_SUFFIX = 1;
    static final int NON_SUPPORTED_SUFFIX = 2;
    final Icon LOCAL_SUFFIX_ICON = DSUtil.getPackageImage("plugin.gif");
    final Icon CHAINED_SUFFIX_ICON = DSUtil.getPackageImage("chobj.gif");
    final Icon NON_SUPPORTED_SUFFIX_ICON = DSUtil.getPackageImage("nonsupportedsuffix.gif");
    private final IMenuItem[] LOCAL_CONTEXT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("INITIALIZE SUFFIX", _resource.getString("menu", "initializesuffix"), _resource.getString("menu", "initializesuffix-description")), new MenuItemText("EXPORT SUFFIX", _resource.getString("menu", "exportsuffix"), _resource.getString("menu", "exportsuffix-description")), new MenuItemText("REINDEX SUFFIX", _resource.getString("menu", "reindexsuffix"), _resource.getString("menu", "reindexsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};
    private final IMenuItem[] LOCAL_OBJECT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("INITIALIZE SUFFIX", _resource.getString("menu", "initializesuffix"), _resource.getString("menu", "initializesuffix-description")), new MenuItemText("EXPORT SUFFIX", _resource.getString("menu", "exportsuffix"), _resource.getString("menu", "exportsuffix-description")), new MenuItemText("REINDEX SUFFIX", _resource.getString("menu", "reindexsuffix"), _resource.getString("menu", "reindexsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};
    private final IMenuItem[] CHAINED_CONTEXT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};
    private final IMenuItem[] CHAINED_OBJECT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};
    private final IMenuItem[] NON_SUPPORTED_CONTEXT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};
    private final IMenuItem[] NON_SUPPORTED_OBJECT_MENU_ITEMS = new IMenuItem[]{new MenuItemText("NEW SUB SUFFIX", _resource.getString("menu", "newsubsuffix"), _resource.getString("menu", "newsuffix-description")), new MenuItemText("NEW CHAINED SUB SUFFIX", _resource.getString("menu", "newchainedsubsuffix"), _resource.getString("menu", "newchainedsuffix-description")), new MenuItemSeparator(), new MenuItemText("DELETE SUFFIX", _resource.getString("menu", "deletesuffix"), _resource.getString("menu", "deletesuffix-description"))};

    public ConfigSuffixNode(DSFramework dSFramework, Suffix suffix, JTree jTree) {
        this._framework = dSFramework;
        this._suffix = suffix;
        this._tree = jTree;
        this._treeModel = (DefaultTreeModel)jTree.getModel();
        this._isRefreshNeededOnExpansion = true;
        this.checkSuffixType();
        if (this._suffixType == 0) {
            this.add(new ConfigReplicationNode(this._framework, this._suffix, this._treeModel));
            this._isLeaf = false;
        } else {
            this._isLeaf = this._suffix.getChildSuffixes().size() == 0;
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._suffix.getName();
    }

    public boolean isRefreshNeededOnExpansion() {
        return this._isRefreshNeededOnExpansion;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void menuAction(String string) {
        if (string == NEW_SUB_SUFFIX) {
            this.actionCreateNewSubSuffix();
        } else if (string == NEW_CHAINED_SUB_SUFFIX) {
            this.actionCreateNewChainedSubSuffix();
        } else if (string == INITIALIZE_SUFFIX) {
            this.actionInitializeSuffix();
        } else if (string == EXPORT_SUFFIX) {
            this.actionExportSuffix();
        } else if (string == REINDEX_SUFFIX) {
            this.actionReindexSuffix();
        } else if (string == DELETE_SUFFIX) {
            this.actionDeleteSuffix();
        }
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    public Component getCustomPanel() {
        switch (this._suffixType) {
            case 0: {
                this._customPanel = this._localCustomPanel;
                break;
            }
            case 1: {
                this._customPanel = this._chainedCustomPanel;
                break;
            }
            case 2: {
                this._customPanel = this._nonSupportedCustomPanel;
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            if (this._customPanel instanceof ConfigTabbedBasePanel) {
                ((ConfigTabbedBasePanel)this._customPanel).refreshPanel();
            } else {
                this.updateNonSupportedPanelText();
            }
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public void refreshNode() {
        Object object;
        if (this._customPanel != null) {
            this._refreshPanelOnRequest = true;
        }
        boolean bl = true;
        DatabaseConfig databaseConfig = this._framework.getServerObject().getDatabaseConfig();
        DN dN = new DN(this._suffix.getName());
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext() && bl) {
            Suffix suffix = (Suffix)listIterator.next();
            object = new DN(suffix.getName());
            if (!object.equals(dN)) continue;
            bl = false;
            this._suffix = suffix;
        }
        if (!bl) {
            Object object2;
            Object object3;
            Object object4;
            boolean bl2 = this.checkSuffixType();
            if (bl2) {
                this._treeModel.nodeChanged(this);
                if (this._suffixType == 0 && this.getReplicationNode() == null) {
                    this._isLeaf = false;
                    this._treeModel.insertNodeInto(new ConfigReplicationNode(this._framework, this._suffix, this._treeModel), this, this.getChildCount());
                } else {
                    object = this.getReplicationNode();
                    if (object != null) {
                        this._treeModel.removeNodeFromParent((MutableTreeNode)object);
                    }
                    this._isLeaf = this._suffix.getChildSuffixes().size() == 0;
                }
            }
            object = new ArrayList();
            ListIterator listIterator2 = ((AbstractList)this._suffix.getChildSuffixes()).listIterator();
            while (listIterator2.hasNext()) {
                object4 = (Suffix)listIterator2.next();
                object3 = this.getSuffixNode(((Suffix)object4).getName());
                if (object3 != null) continue;
                object2 = new ConfigSuffixNode(this._framework, (Suffix)object4, this._tree);
                ((ArrayList)object).add(object2);
            }
            object4 = ((AbstractList)object).listIterator();
            while (object4.hasNext()) {
                this._treeModel.insertNodeInto((DefaultMutableTreeNode)object4.next(), this, this.getChildCount());
            }
            object3 = this.children();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((ArrayList)object).contains(object2)) continue;
                ((IConfigNode)object2).refreshNode();
            }
        } else {
            this._treeModel.removeNodeFromParent(this);
        }
        this._isRefreshNeededOnExpansion = false;
    }

    private boolean checkSuffixType() {
        int n;
        boolean bl;
        int n2 = this._suffix.getDatabases().size();
        if (n2 == 1) {
            boolean bl2 = bl = ((Database)this._suffix.getDatabases().get(0)).getType() == 0;
            if (bl) {
                n = 0;
                this._icon = this.LOCAL_SUFFIX_ICON;
                this._objectMenuItems = this.LOCAL_OBJECT_MENU_ITEMS;
                this._contextMenuItems = this.LOCAL_CONTEXT_MENU_ITEMS;
            } else {
                n = 1;
                this._icon = this.CHAINED_SUFFIX_ICON;
                this._objectMenuItems = this.CHAINED_OBJECT_MENU_ITEMS;
                this._contextMenuItems = this.CHAINED_CONTEXT_MENU_ITEMS;
            }
        } else {
            n = 2;
            this._icon = this.NON_SUPPORTED_SUFFIX_ICON;
            this._objectMenuItems = this.NON_SUPPORTED_OBJECT_MENU_ITEMS;
            this._contextMenuItems = this.NON_SUPPORTED_CONTEXT_MENU_ITEMS;
        }
        bl = n != this._suffixType;
        this._suffixType = n;
        return bl;
    }

    private DefaultMutableTreeNode getSuffixNode(String string) {
        Enumeration<TreeNode> enumeration = this.children();
        boolean bl = false;
        DN dN = new DN(string);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements() && !bl) {
            IConfigNode iConfigNode = (IConfigNode)((Object)enumeration.nextElement());
            DN dN2 = new DN(iConfigNode.getName());
            if (!dN2.equals(dN)) continue;
            bl = true;
            defaultMutableTreeNode = (DefaultMutableTreeNode)((Object)iConfigNode);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getReplicationNode() {
        Enumeration<TreeNode> enumeration = this.children();
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements() && !bl) {
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof ConfigReplicationNode)) continue;
            bl = true;
            defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        }
        return defaultMutableTreeNode;
    }

    private void actionCreateNewSubSuffix() {
        NewSuffixDialog newSuffixDialog = new NewSuffixDialog(this._framework, this._suffix);
        newSuffixDialog.pack();
        newSuffixDialog.show();
        Suffix suffix = newSuffixDialog.getSuffix();
        if (suffix != null) {
            this._isLeaf = false;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSuffixNode(suffix.getName());
            if (defaultMutableTreeNode != null) {
                TreePath treePath = new TreePath(this._treeModel.getPathToRoot(defaultMutableTreeNode));
                this._tree.setSelectionPath(treePath);
            }
        }
    }

    private void actionCreateNewChainedSubSuffix() {
        NewChainedSuffixDialog newChainedSuffixDialog = new NewChainedSuffixDialog(this._framework, this._suffix);
        newChainedSuffixDialog.pack();
        newChainedSuffixDialog.show();
        Suffix suffix = newChainedSuffixDialog.getSuffix();
        if (suffix != null) {
            ConfigSuffixNode configSuffixNode = new ConfigSuffixNode(this._framework, suffix, this._tree);
            this._isLeaf = false;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSuffixNode(suffix.getName());
            if (defaultMutableTreeNode != null) {
                TreePath treePath = new TreePath(this._treeModel.getPathToRoot(defaultMutableTreeNode));
                this._tree.setSelectionPath(treePath);
            }
        }
    }

    private void actionInitializeSuffix() {
        String string = ((Database)this._suffix.getDatabases().elementAt(0)).getName();
        InitializeSuffixDialog initializeSuffixDialog = new InitializeSuffixDialog(this._framework, this._suffix);
        initializeSuffixDialog.pack();
        initializeSuffixDialog.show();
    }

    private void actionExportSuffix() {
        String string = ((Database)this._suffix.getDatabases().elementAt(0)).getName();
        ExportSuffixDialog exportSuffixDialog = new ExportSuffixDialog(this._framework, this._suffix.getName(), string);
        exportSuffixDialog.pack();
        exportSuffixDialog.show();
    }

    private void actionReindexSuffix() {
        String string = ((Database)this._suffix.getDatabases().elementAt(0)).getName();
        ReindexSuffixDialog reindexSuffixDialog = new ReindexSuffixDialog(this._framework, this._suffix.getName(), string, null);
        reindexSuffixDialog.pack();
        reindexSuffixDialog.show();
    }

    private void actionDeleteSuffix() {
        Object object;
        ConfirmDeleteSuffixDialog confirmDeleteSuffixDialog = new ConfirmDeleteSuffixDialog((JFrame)((Object)this._framework), this._suffix.getName(), this._suffix.getChildSuffixes().size() > 0, this._suffixType);
        confirmDeleteSuffixDialog.pack();
        confirmDeleteSuffixDialog.show();
        final LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("suffixnode", "delete-progressdialog-title"));
        genericProgressDialog.setLabelColumns(40);
        genericProgressDialog.setLabelRows(1);
        genericProgressDialog.addStep(_resource.getString("suffixnode", "deletedb-label"));
        genericProgressDialog.addStep(_resource.getString("suffixnode", "deletesuffix-label"));
        boolean bl = false;
        TreeNode treeNode = this.getParent();
        if (confirmDeleteSuffixDialog.getResult() == ConfirmDeleteSuffixDialog.DELETE_ALL_TREE) {
            object = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ConfigSuffixNode.this.deleteAllSuffix(lDAPConnection, ConfigSuffixNode.this._suffix, genericProgressDialog);
                    genericProgressDialog.closeCallBack();
                }
            });
            ((Thread)object).start();
            genericProgressDialog.packAndShow();
            bl = true;
        } else if (confirmDeleteSuffixDialog.getResult() == ConfirmDeleteSuffixDialog.DELETE_ONLY_SUFFIX) {
            object = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ConfigSuffixNode.this.deleteOneSuffix(lDAPConnection, ConfigSuffixNode.this._suffix, ConfigSuffixNode.this._suffix.getParentSuffix(), true, genericProgressDialog);
                    genericProgressDialog.closeCallBack();
                }
            });
            ((Thread)object).start();
            genericProgressDialog.packAndShow();
            bl = true;
        }
        if (bl) {
            object = new TreePath(this._treeModel.getPathToRoot(treeNode));
            this._tree.setSelectionPath((TreePath)object);
        }
    }

    private boolean deleteAllSuffix(LDAPConnection lDAPConnection, Suffix suffix, GenericProgressDialog genericProgressDialog) {
        boolean bl = false;
        Suffix[] suffixArray = new Suffix[suffix.getChildSuffixes().size()];
        suffix.getChildSuffixes().toArray(suffixArray);
        int n = 0;
        while (n < suffixArray.length && !bl) {
            bl = !this.deleteAllSuffix(lDAPConnection, suffixArray[n], genericProgressDialog);
            ++n;
        }
        if (!bl) {
            bl = !this.deleteOneSuffix(lDAPConnection, suffix, null, false, genericProgressDialog);
        }
        return !bl;
    }

    private boolean deleteOneSuffix(LDAPConnection lDAPConnection, Suffix suffix, Suffix suffix2, boolean bl, GenericProgressDialog genericProgressDialog) {
        Object object;
        genericProgressDialog.reset();
        String[] stringArray = new String[]{suffix.getName()};
        genericProgressDialog.setTextInLabel(_resource.getString("suffixnode", "delete-progressdialog-label", stringArray));
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        ListIterator listIterator = ((AbstractList)suffix.getDatabases()).listIterator();
        while (listIterator.hasNext() && !bl2) {
            object = (Database)listIterator.next();
            if (!DSUtil.deleteTree(((Database)object).getDn(), lDAPConnection, false)) {
                bl2 = true;
                stringArray[0] = ((Database)object).getName();
                this.displayError("deleting-database", stringArray);
                continue;
            }
            arrayList.add(object);
        }
        if (!bl2) {
            genericProgressDialog.stepCompleted(0);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            Suffix suffix3;
            listIterator = ((AbstractList)suffix.getChildSuffixes()).listIterator();
            object = new ArrayList();
            while (listIterator.hasNext() && !bl2) {
                suffix3 = (Suffix)listIterator.next();
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                if (suffix2 == null) {
                    lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-parent-suffix"));
                } else {
                    lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-parent-suffix", suffix2.getName()));
                }
                try {
                    lDAPConnection.modify(suffix3.getDn(), lDAPModificationSet);
                    ((ArrayList)object).add(suffix3);
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray2 = new String[]{LDAPDN.explodeDN((String)suffix3.getDn(), (boolean)true)[0], DSUtil.getLDAPErrorMessage(lDAPException)};
                    boolean bl3 = bl2 = !this.askToContinue("modifying-child", stringArray2);
                }
            }
            listIterator = ((AbstractList)object).listIterator();
            while (listIterator.hasNext()) {
                suffix3 = (Suffix)listIterator.next();
                this._framework.getServerObject().getDatabaseConfig().notifyParentChanged(suffix3, suffix2);
            }
        }
        if (!bl2) {
            if (!DSUtil.deleteTree(suffix.getDn(), lDAPConnection, false)) {
                bl2 = !this.askToContinue("deleting-suffix", null);
            } else {
                this._framework.getServerObject().getDatabaseConfig().notifySuffixDeleted(suffix);
            }
        } else {
            listIterator = ((AbstractList)arrayList).listIterator();
            object = this._framework.getServerObject().getDatabaseConfig();
            while (listIterator.hasNext()) {
                ((DatabaseConfig)object).notifyDatabaseDeleted((Database)listIterator.next());
            }
        }
        if (!bl2) {
            genericProgressDialog.stepCompleted(1);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !bl2;
    }

    private Component createCustomPanel() {
        JPanel jPanel = null;
        switch (this._suffixType) {
            case 0: {
                this._localCustomPanel = new ConfigLocalSuffixTabbedPanel(this._framework, this._suffix);
                ConfigRootNode configRootNode = (ConfigRootNode)this._treeModel.getRoot();
                ConfigRootPanel configRootPanel = (ConfigRootPanel)configRootNode.getCustomPanel();
                configRootPanel.addSSLConfigListener(((ConfigLocalSuffixTabbedPanel)this._localCustomPanel).getAttributeEncryptionPanel());
                jPanel = this._localCustomPanel;
                break;
            }
            case 1: {
                Database database = (Database)this._suffix.getDatabases().get(0);
                jPanel = this._chainedCustomPanel = new ConfigChainedSuffixTabbedPanel(this._framework, this._suffix.getName(), this._suffix.getDn(), database.getDn());
                break;
            }
            case 2: {
                this._nonSupportedCustomPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets.right = 0;
                gridBagConstraints.insets.left = UIFactory.getComponentSpace();
                this._taNonSupported = new MultilineLabel(4, 50);
                jPanel2.add((Component)this._taNonSupported, gridBagConstraints);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 10;
                JScrollPane jScrollPane = new JScrollPane(jPanel2);
                jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                this._nonSupportedCustomPanel.add((Component)jScrollPane, gridBagConstraints);
                jPanel = this._nonSupportedCustomPanel;
                this.updateNonSupportedPanelText();
                break;
            }
            default: {
                Thread.dumpStack();
            }
        }
        return jPanel;
    }

    private void updateNonSupportedPanelText() {
        String string;
        String[] stringArray;
        int n = this._suffix.getDatabases().size();
        if (n == 0) {
            stringArray = new String[]{this._suffix.getName()};
            string = _resource.getString("suffixnode", "nodatabasedefined-label", stringArray);
        } else {
            int n2;
            Object object;
            stringArray = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            ListIterator listIterator = ((AbstractList)this._suffix.getDatabases()).listIterator();
            while (listIterator.hasNext()) {
                object = (Database)listIterator.next();
                int n3 = n2 = ((Database)object).getType() == 0 ? 1 : 0;
                if (n2 != 0) {
                    arrayList.add(((Database)object).getName());
                    continue;
                }
                stringArray.add(((Database)object).getName());
            }
            object = "";
            if (arrayList.size() > 0) {
                n2 = 0;
                while (n2 < arrayList.size() - 1) {
                    object = (String)object + arrayList.get(n2) + ", ";
                    ++n2;
                }
                object = (String)object + arrayList.get(arrayList.size() - 1);
            }
            String string2 = "";
            if (stringArray.size() > 0) {
                int n4 = 0;
                while (n4 < stringArray.size() - 1) {
                    string2 = string2 + stringArray.get(n4) + ", ";
                    ++n4;
                }
                string2 = string2 + stringArray.get(stringArray.size() - 1);
            }
            if (stringArray.size() == 0) {
                String[] stringArray2 = new String[]{String.valueOf(arrayList.size()), object};
                string = _resource.getString("suffixnode", "distribution-ldbm-label", stringArray2);
            } else if (arrayList.size() == 0) {
                String[] stringArray3 = new String[]{String.valueOf(stringArray.size()), string2};
                string = _resource.getString("suffixnode", "distribution-chaining-label", stringArray3);
            } else {
                String[] stringArray4 = new String[]{String.valueOf(arrayList.size()), String.valueOf(stringArray.size()), object, string2};
                string = _resource.getString("suffixnode", "distribution-mix-label", stringArray4);
            }
        }
        stringArray = new String[]{string};
        this._taNonSupported.setText(_resource.getString("suffixnode", "nonsupportedsuffix", stringArray));
    }

    private boolean askToContinue(final String string, final String[] stringArray) {
        final boolean[] blArray = new boolean[]{true};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int n = DSUtil.showConfirmationDialog((Component)((Object)ConfigSuffixNode.this._framework), "error-" + string, stringArray, "suffixnode", _resource);
                    blArray[0] = n == 0;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    private void displayError(final String string, final String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)ConfigSuffixNode.this._framework), "error-" + string + "-title", "error-" + string + "-msg", stringArray, "suffixnode", _resource);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

