/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.NumSubordinateHacker;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.IDatabaseConfigListener;
import com.netscape.admin.dirserv.config.Suffix;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class DatabaseConfig {
    private NumSubordinateHacker _numSubordinateHacker;
    private Vector _suffixes = new Vector();
    private ArrayList _databases = new ArrayList();
    private ArrayList _listeners;
    private static final String CHAINING_CONFIG_BASEDN = "cn=chaining database, cn=plugins, cn=config";
    private static final String LDBM_CONFIG_BASEDN = "cn=ldbm database, cn=plugins, cn=config";
    private static final DN LDBM_PLUGIN_DN = new DN("cn=ldbm database, cn=plugins, cn=config");

    public DatabaseConfig() {
        this._numSubordinateHacker = new NumSubordinateHacker();
    }

    public synchronized void reload(LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        Object object2;
        String string;
        String[] stringArray;
        Object object3;
        this._suffixes.clear();
        this._databases.clear();
        Vector<String> vector = new Vector<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray2 = new String[]{"dn", "nsslapd-parent-suffix", "cn"};
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 2, "objectclass=nsMappingTree", stringArray2, false);
        while (lDAPSearchResults.hasMoreElements()) {
            object3 = lDAPSearchResults.next();
            stringArray = DSUtil.getAttrValue((LDAPEntry)object3, "cn");
            string = DatabaseConfig.unQuote((String)stringArray);
            object2 = new Suffix();
            ((Suffix)object2).setName(string);
            ((Suffix)object2).setDn(object3.getDN());
            boolean bl = this.hasRootEntry(lDAPConnection, (Suffix)object2);
            ((Suffix)object2).setHasRootEntry(bl);
            if (bl && DSUtil.getAttrValue((LDAPEntry)object3, "nsslapd-parent-suffix").equals("")) {
                vector.addElement(string);
            }
            this._suffixes.addElement(object2);
            arrayList.add(object3);
        }
        object3 = new ArrayList();
        stringArray = new String[]{"cn", "nsslapd-suffix", "nsslapd-directory"};
        string = lDAPConnection.search("cn=plugins, cn=config", 2, "objectclass=nsBackendInstance", stringArray, false);
        while (string.hasMoreElements()) {
            object2 = string.next();
            DN dN = new DN(object2.getDN());
            boolean bl = dN.isDescendantOf(LDBM_PLUGIN_DN);
            object = DSUtil.getAttrValue((LDAPEntry)object2, "cn");
            Database database = new Database();
            database.setName((String)object);
            database.setType(bl ? 0 : 1);
            database.setDn(object2.getDN());
            if (database.getType() == 0) {
                database.setLocation(DSUtil.getAttrValue((LDAPEntry)object2, "nsslapd-directory"));
            }
            this._databases.add(database);
            ((ArrayList)object3).add(object2);
        }
        this.initSuffixesAndDatabases(this._suffixes, arrayList, this._databases, (ArrayList)object3);
        object2 = new Vector();
        Vector vector2 = this.getSuffixes();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (Suffix)enumeration.nextElement();
            ((Vector)object2).addElement(((Suffix)object).getName());
        }
        this._numSubordinateHacker.update((Vector)object2, vector, lDAPConnection.getHost(), lDAPConnection.getPort());
        this.fireConfigChanged();
    }

    public Vector getSuffixes() {
        return this._suffixes;
    }

    public ArrayList getDatabases() {
        return this._databases;
    }

    public void notifyDatabaseDeleted(Database database) {
        ((AbstractCollection)this._databases).remove(database);
        Suffix suffix = database.getSuffix();
        if (suffix != null) {
            suffix.getDatabases().remove(database);
        }
        this.fireDatabaseDeleted(database);
    }

    public void notifySuffixDeleted(Suffix suffix) {
        Object object;
        this._suffixes.remove(suffix);
        ListIterator listIterator = ((AbstractList)suffix.getDatabases()).listIterator();
        while (listIterator.hasNext()) {
            object = (Database)listIterator.next();
            ((AbstractCollection)this._databases).remove(object);
        }
        object = suffix.getParentSuffix();
        if (object != null) {
            ((Suffix)object).removeChildSuffix(suffix);
        }
        this.fireSuffixDeleted(suffix);
    }

    public void notifySuffixAdded(Suffix suffix) {
        this._suffixes.addElement(suffix);
        ListIterator listIterator = ((AbstractList)suffix.getDatabases()).listIterator();
        while (listIterator.hasNext()) {
            this.notifyDatabaseAdded((Database)listIterator.next());
        }
        this.fireSuffixAdded(suffix);
    }

    public void notifyDatabaseAdded(Database database) {
        this._databases.add(database);
        this.fireDatabaseAdded(database);
    }

    public void notifyParentChanged(Suffix suffix, Suffix suffix2) {
        Suffix suffix3 = suffix.getParentSuffix();
        if (suffix3 != null) {
            suffix3.getChildSuffixes().remove(suffix);
        }
        suffix.setParentSuffix(suffix2);
        if (suffix2 != null) {
            suffix2.addChildSuffix(suffix);
        }
        this.fireParentChanged(suffix, suffix3, suffix2);
    }

    public void notifyRootEntryDeleted(Suffix suffix) {
        suffix.setHasRootEntry(false);
        this.fireRootEntryDeleted(suffix);
    }

    public void notifyRootEntryAdded(Suffix suffix) {
        suffix.setHasRootEntry(true);
        this.fireRootEntryAdded(suffix);
    }

    public NumSubordinateHacker getNumSubordinateHacker() {
        return this._numSubordinateHacker;
    }

    public void addChangeListener(IDatabaseConfigListener iDatabaseConfigListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(iDatabaseConfigListener);
    }

    public void removeChangeListener(IDatabaseConfigListener iDatabaseConfigListener) {
        if (this._listeners != null) {
            ((AbstractCollection)this._listeners).remove(iDatabaseConfigListener);
        }
    }

    private boolean hasRootEntry(LDAPConnection lDAPConnection, Suffix suffix) throws LDAPException {
        boolean bl;
        block4: {
            bl = false;
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getConstraints();
            String[] stringArray = new String[]{"dn"};
            try {
                if (lDAPConnection.read(suffix.getName(), stringArray, lDAPSearchConstraints) != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException instanceof LDAPReferralException) {
                    bl = true;
                }
                if (lDAPException.getLDAPResultCode() == 32) break block4;
                bl = true;
            }
        }
        return bl;
    }

    private void initSuffixesAndDatabases(Vector vector, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        DN dN;
        DN dN2;
        LDAPEntry lDAPEntry;
        Object object;
        LDAPEntry lDAPEntry2;
        Object object2;
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        ListIterator listIterator2 = ((AbstractList)arrayList).listIterator();
        while (listIterator.hasNext()) {
            object2 = (Suffix)listIterator.next();
            lDAPEntry2 = (LDAPEntry)listIterator2.next();
            object = DSUtil.getAttrValue(lDAPEntry2, "nsslapd-parent-suffix");
            if (((String)object).equals("")) continue;
            lDAPEntry = new DN(DatabaseConfig.unQuote((String)object));
            boolean bl = false;
            dN2 = ((AbstractList)vector).listIterator();
            while (dN2.hasNext() && !bl) {
                Suffix suffix = (Suffix)dN2.next();
                dN = new DN(suffix.getName());
                if (!dN.equals((DN)lDAPEntry)) continue;
                bl = true;
                ((Suffix)object2).setParentSuffix(suffix);
                suffix.addChildSuffix(object2);
            }
        }
        object2 = ((AbstractList)arrayList2).listIterator();
        lDAPEntry2 = ((AbstractList)arrayList3).listIterator();
        while (object2.hasNext()) {
            object = (Database)object2.next();
            lDAPEntry = (LDAPEntry)lDAPEntry2.next();
            String string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-suffix");
            if (string.equals("")) continue;
            dN2 = new DN(string);
            boolean bl = false;
            dN = ((AbstractList)vector).listIterator();
            while (dN.hasNext() && !bl) {
                Suffix suffix = (Suffix)dN.next();
                DN dN3 = new DN(suffix.getName());
                if (!dN3.equals(dN2)) continue;
                bl = true;
                ((Database)object).setSuffix(suffix);
                suffix.addDatabase(object);
            }
        }
    }

    private void readDSEEntry(LDAPConnection lDAPConnection) throws LDAPException {
        String string = "";
        String[] stringArray = new String[]{"nsBackendSuffix"};
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        String[] stringArray2 = DSUtil.getAttrValues(lDAPEntry, stringArray[0]);
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = stringArray2[n].indexOf(58);
                if (n2 > 0) {
                    Object object;
                    Suffix suffix;
                    String string2 = stringArray2[n].substring(0, n2);
                    String string3 = stringArray2[n].substring(n2 + 1);
                    DN dN = new DN(string3);
                    boolean bl = false;
                    Enumeration enumeration = this._suffixes.elements();
                    while (enumeration.hasMoreElements() && !bl) {
                        suffix = (Suffix)enumeration.nextElement();
                        object = new DN(suffix.getName());
                        bl = object.equals(dN);
                    }
                    if (!bl) {
                        suffix = new Suffix();
                        suffix.setName(string3);
                        suffix.setDn("cn=" + DatabaseConfig.Quote(string3) + ", cn=mapping tree, cn=config");
                        suffix.setHasRootEntry(this.hasRootEntry(lDAPConnection, suffix));
                        object = null;
                        boolean bl2 = false;
                        ListIterator listIterator = ((AbstractList)this._databases).listIterator();
                        while (listIterator.hasNext() && !bl2) {
                            Database database = (Database)listIterator.next();
                            if (!database.getName().equalsIgnoreCase(string2)) continue;
                            bl2 = true;
                            object = database;
                        }
                        if (!bl2) {
                            object = new Database();
                            ((Database)object).setName(string2);
                            ((Database)object).setType(2);
                        }
                        suffix.addDatabase(object);
                        this._suffixes.addElement(suffix);
                    }
                }
                ++n;
            }
        }
    }

    private void fireConfigChanged() {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).databaseConfigChanged();
            }
        }
    }

    private void fireSuffixAdded(Suffix suffix) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).suffixAdded(suffix);
            }
        }
    }

    private void fireSuffixDeleted(Suffix suffix) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).suffixDeleted(suffix);
            }
        }
    }

    private void fireParentChanged(Suffix suffix, Suffix suffix2, Suffix suffix3) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).parentChanged(suffix, suffix2, suffix3);
            }
        }
    }

    private void fireRootEntryDeleted(Suffix suffix) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).rootEntryDeleted(suffix);
            }
        }
    }

    private void fireRootEntryAdded(Suffix suffix) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).rootEntryAdded(suffix);
            }
        }
    }

    private void fireDatabaseAdded(Database database) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).databaseAdded(database);
            }
        }
    }

    private void fireDatabaseDeleted(Database database) {
        if (this._listeners != null) {
            ListIterator listIterator = ((AbstractList)this._listeners).listIterator();
            while (listIterator.hasNext()) {
                ((IDatabaseConfigListener)listIterator.next()).databaseDeleted(database);
            }
        }
    }

    public static String unQuote(String string) {
        if (string != null) {
            if (string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Character c = new Character(string.charAt(0));
                Character c2 = new Character(string.charAt(string.length() - 1));
                Character c3 = new Character('\"');
                if (c.compareTo(c3) == 0) {
                    int n = 1;
                    while (n < string.length() - 1) {
                        stringBuffer.append(string.charAt(n));
                        ++n;
                    }
                } else {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            return new String(string);
        }
        return null;
    }

    public static String Quote(String string) {
        Character c;
        StringBuffer stringBuffer = new StringBuffer();
        Character c2 = new Character(string.charAt(0));
        if (c2.compareTo(c = new Character('\"')) == 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }
}

