/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.config.BulkInitialize;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.LDAPInitialize;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InitializeSuffixDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    private DSFramework _framework;
    private Suffix _suffix;
    private boolean _isLocal;
    private JTextField _tfFile;
    private JButton _bBrowse;
    private JRadioButton _rbInConsole;
    private JRadioButton _rbInServer;
    private String _defaultLocation;
    private static final String HELP_TOKEN = "configuration-database-initialize-suffix-dbox-help";
    private static ResourceSet _resource = DSConfigPage._resource;

    public InitializeSuffixDialog(DSFramework dSFramework, Suffix suffix) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        this._suffix = suffix;
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix.getName(), 30)};
        ((Dialog)((Object)this)).setTitle(_resource.getString("initializesuffixdialog", "title", stringArray));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("initializesuffixdialog", "lfile", _resource);
        this._tfFile = UIFactory.makeJTextField(this, "initializesuffixdialog", "lfile", null, 30, _resource);
        jLabel.setLabelFor(this._tfFile);
        this._bBrowse = UIFactory.makeJButton(this, "initializesuffixdialog", "bbrowse", _resource);
        this._rbInConsole = UIFactory.makeJRadioButton(this, "initializesuffixdialog", "rbinconsole", false, _resource);
        this._rbInServer = UIFactory.makeJRadioButton(this, "initializesuffixdialog", "rbinserver", false, _resource);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbInConsole);
        buttonGroup.add(this._rbInServer);
        this._rbInServer.setSelected(false);
        this._rbInConsole.setSelected(true);
        this._isLocal = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        String string = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
        String string2 = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
        this._defaultLocation = string + '/' + string2 + "/ldif";
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bBrowse, gridBagConstraints);
        if (!this._isLocal) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.gridwidth = 3;
            jPanel2.add((Component)this._rbInConsole, gridBagConstraints);
            gridBagConstraints.insets.left = UIFactory.getComponentSpace();
            gridBagConstraints.gridwidth = -1;
            jPanel2.add((Component)this._rbInServer, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.top = UIFactory.getComponentSpace();
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.top = 0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this.setComponent(jPanel);
        this.setFocusComponent(this._tfFile);
        this.setOKButtonEnabled(false);
    }

    public void setFileName(String string) {
        this._tfFile.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bBrowse) {
            String string;
            String string2 = this._tfFile.getText().trim();
            String[] stringArray = new String[]{"ldif"};
            String[] stringArray2 = new String[]{_resource.getString("initializesuffixdialog", "ldif-description")};
            if (DSFileDialog.getDefaultDirectory() == null) {
                DSFileDialog.setDefaultDirectory(this._defaultLocation);
            }
            if ((string = DSFileDialog.browseFiles(string2, false, stringArray, stringArray2, this._bBrowse)) != null) {
                this._tfFile.setText(string);
            }
        } else if (object == this._rbInConsole || object == this._rbInServer) {
            this._bBrowse.setEnabled(this._rbInConsole.isSelected());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._tfFile.getDocument()) {
            this.setOKButtonEnabled(!this._tfFile.getText().trim().equals(""));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        Object object;
        boolean bl = this._isLocal || this._rbInConsole.isSelected();
        String string = this._tfFile.getText().trim();
        File file = new File(string);
        if (bl && !file.isAbsolute()) {
            string = DSFileDialog.getDefaultDirectory() != null ? DSFileDialog.getDefaultDirectory() + File.separator + string : this._defaultLocation + File.separator + string;
        }
        boolean bl2 = this._rbInServer.isSelected() || this._isLocal;
        boolean bl3 = false;
        if (!bl2 && !DSUtil.fileExists(file)) {
            object = new String[]{string};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "file-does-not-exist-title", "file-does-not-exist-msg", object, "initializesuffixdialog", _resource);
            bl3 = true;
        }
        if (!bl3 && !bl2) {
            try {
                object = new FileInputStream(file);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{string};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "cannott-open-file-title", "cannott-open-file-msg", stringArray, "initializesuffixdialog", _resource);
                bl3 = true;
            }
        }
        if (!bl3 && DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_OVERWRITE_DATABASE)) {
            if (DSUtil.equalDNs(this._suffix.getName(), "o=netscaperoot")) {
                object = bl2 ? "confirm-initialize-netscaperoot" : "confirm-bulk-netscaperoot";
                int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), (String)object, (String[])null, "initializesuffixdialog", _resource);
                bl3 = 0 != n;
            } else {
                object = bl2 ? "confirm-initialize-suffix" : "confirm-bulk-suffix";
                int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), (String)object, (String[])null, "initializesuffixdialog", _resource);
                boolean bl4 = bl3 = 0 != n;
            }
        }
        if (!bl3) {
            super.okInvoked();
            if (bl2) {
                new LDAPInitialize(this._framework, this._suffix, string);
            } else {
                new BulkInitialize(this._framework, this._suffix, string);
            }
        }
    }
}

