/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class LDAPInitialize
implements Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private Suffix _suffix;
    private String _fileName;
    private boolean _taskCancelled;
    private String _taskDn;
    private static ResourceSet _resource = DSConfigPage._resource;

    public LDAPInitialize(DSFramework dSFramework, Suffix suffix, String string) {
        this._framework = dSFramework;
        this._suffix = suffix;
        this._fileName = string;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            this.initTask();
        }
        catch (LDAPException lDAPException) {
            bl = true;
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)LDAPInitialize.this._framework), "error-launching-title", "error-launching-msg", stringArray, "ldapinitialize", _resource);
                }
            });
        }
        if (!bl) {
            this._dlg.enableButtons(true);
            try {
                this.updateProgressDialog();
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)LDAPInitialize.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "ldapinitialize", _resource);
                    }
                });
            }
            this.checkRootEntry();
            this._dlg.waitForClose();
        } else {
            this._dlg.closeCallBack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "ldapinitialize", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("ldapinitialize", "title"), null, this);
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix.getName(), 40), DSUtil.inverseAbreviateString(this._fileName, 40)};
        this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "initializing-label", stringArray));
        this._dlg.setLabelRows(2);
        this._dlg.enableButtons(false);
        this._dlg.addStep(_resource.getString("ldapinitialize", "firststep-label"));
        this._dlg.addStep(_resource.getString("ldapinitialize", "secondstep-label"));
        this._dlg.addStep(_resource.getString("ldapinitialize", "thirdstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("ldapinitialize", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException {
        this._taskCancelled = false;
        String string = ((Database)this._suffix.getDatabases().get(0)).getName();
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsFilename", this._fileName));
        lDAPAttributeSet.add(new LDAPAttribute("nsInstance", string));
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=import" + System.currentTimeMillis() + ", cn=import, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        while (!bl && !this._taskCancelled) {
            String[] stringArray;
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                stringArray = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                if (stringArray.lastIndexOf("Processing file") >= 0) {
                    this._dlg.stepCompleted(0);
                }
                if (stringArray.lastIndexOf("Finished scanning file") >= 0) {
                    this._dlg.stepCompleted(1);
                }
                if (stringArray.lastIndexOf("Import complete") >= 0) {
                    this._dlg.stepCompleted(2);
                }
                this._dlg.setTextInTextArea((String)stringArray);
                String string = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (string.equals("")) continue;
                bl = true;
                String[] stringArray2 = new String[]{DSUtil.abreviateString(this._suffix.getName(), 40)};
                if (string.equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "successful-label", stringArray2));
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "unsuccessful-label", stringArray2));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                stringArray = new String[]{DSUtil.abreviateString(this._suffix.getName(), 40)};
                this._dlg.setTextInLabel(_resource.getString("ldapinitialize", "successful-label", stringArray));
            }
        }
    }

    private void checkRootEntry() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = false;
        try {
            String[] stringArray = new String[]{"dn"};
            bl = lDAPConnection.read(this._suffix.getName(), stringArray) != null;
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        if (bl && !this._suffix.hasRootEntry()) {
            this._framework.getServerObject().getDatabaseConfig().notifyRootEntryAdded(this._suffix);
        } else if (!bl && this._suffix.hasRootEntry()) {
            this._framework.getServerObject().getDatabaseConfig().notifyRootEntryDeleted(this._suffix);
        }
    }
}

