/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.replication.DNDialog;
import com.netscape.admin.dirserv.config.replication.Replica;
import com.netscape.admin.dirserv.config.replication.ReplicaWizard;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPUrl;

class AdvancedReplicaDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private DSFramework _framework;
    private Replica _replica;
    private DefaultListModel _modelBindDn;
    private JList _listBindDn;
    private JButton _bAddBindDn;
    private JButton _bDeleteBindDn;
    private DefaultListModel _modelReferral;
    private JList _listReferral;
    private JButton _bAddReferral;
    private JButton _bDeleteReferral;
    private JCheckBox _cbOverwriteReferrals;
    private JComboBox _comboPurgeDelay;
    private JCheckBox _cbPurgeDelay;
    private JTextField _tfPurgeDelay;
    private boolean _isModified;
    private String _helpToken = "configuration-advanced-replica-dbox-help";
    private static final ResourceSet _resource = ReplicaWizard._resource;
    int[] CONVERSION_VALUES = new int[]{86400, 3600, 60, 1};

    public AdvancedReplicaDialog(DSFramework dSFramework, Replica replica) {
        super((Frame)((Object)dSFramework), _resource.getString("advancedreplicadialog", "title"), true, 11);
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("advancedreplicadialog", "description"));
        this._framework = dSFramework;
        this._replica = replica;
        this.layoutContentPane();
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bAddBindDn) {
            DNDialog dNDialog = new DNDialog(this._framework);
            dNDialog.pack();
            dNDialog.show();
            if (!dNDialog.isCancelled()) {
                this._modelBindDn.addElement(dNDialog.getDN());
            }
        } else if (object == this._bDeleteBindDn) {
            Object[] objectArray = this._listBindDn.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                this._modelBindDn.removeElement(objectArray[n]);
                ++n;
            }
            this._bDeleteBindDn.setEnabled(false);
        } else if (object == this._bAddReferral) {
            String string = "ldap:///" + this._replica.suffix;
            LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog((JFrame)((Object)this._framework), string, 6);
            lDAPUrlDialog.packAndShow();
            LDAPUrl lDAPUrl = lDAPUrlDialog.getLDAPUrl();
            if (lDAPUrl != null) {
                this._modelReferral.addElement(lDAPUrl.getUrl());
                this._cbOverwriteReferrals.setEnabled(true);
            }
        } else if (object == this._bDeleteReferral) {
            Object[] objectArray = this._listReferral.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                this._modelReferral.removeElement(objectArray[n]);
                this._cbOverwriteReferrals.setEnabled(this._modelReferral.size() > 0);
                if (this._modelReferral.size() == 0) {
                    this._cbOverwriteReferrals.setSelected(false);
                }
                ++n;
            }
            this._bDeleteReferral.setEnabled(false);
        } else if (object == this._cbPurgeDelay) {
            this._tfPurgeDelay.setEnabled(!this._cbPurgeDelay.isSelected());
            this._comboPurgeDelay.setEnabled(!this._cbPurgeDelay.isSelected());
            this.checkPurgeDelayValidity();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._listBindDn) {
            this._bDeleteBindDn.setEnabled(!this._listBindDn.isSelectionEmpty() && this._modelBindDn.getSize() > 0);
        } else if (object == this._listReferral) {
            this._bDeleteReferral.setEnabled(!this._listReferral.isSelectionEmpty() && this._modelReferral.getSize() > 0);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkPurgeDelayValidity();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void okInvoked() {
        boolean bl;
        Object object;
        LDAPAttribute lDAPAttribute;
        LDAPAttribute lDAPAttribute2;
        final LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        boolean bl2 = this._replica.bindDn.size() != this._modelBindDn.getSize();
        int n = 0;
        while (n < this._replica.bindDn.size() && !bl2) {
            bl2 = !this._replica.bindDn.elementAt(n).equals(this._modelBindDn.elementAt(n));
            ++n;
        }
        if (bl2) {
            lDAPAttribute2 = new LDAPAttribute("nsDS5ReplicaBindDN");
            lDAPAttribute = this._modelBindDn.elements();
            while (lDAPAttribute.hasMoreElements()) {
                lDAPAttribute2.addValue((String)lDAPAttribute.nextElement());
            }
            lDAPModificationSet.add(2, lDAPAttribute2);
        }
        lDAPAttribute2 = null;
        lDAPAttribute = null;
        boolean bl3 = this._replica.referral.size() != this._modelReferral.getSize();
        int n2 = 0;
        while (n2 < this._replica.referral.size() && !bl3) {
            bl3 = !this._replica.referral.elementAt(n2).equals(this._modelReferral.elementAt(n2));
            ++n2;
        }
        if (bl3) {
            lDAPAttribute2 = new LDAPAttribute("nsDS5ReplicaReferral");
            object = this._modelReferral.elements();
            while (object.hasMoreElements()) {
                lDAPAttribute2.addValue((String)object.nextElement());
            }
        }
        if (this._replica.overwriteReferrals != this._cbOverwriteReferrals.isSelected()) {
            int n3 = 0;
            if (this._replica.role != 2) {
                n3 |= 1;
            }
            if (this._cbOverwriteReferrals.isSelected()) {
                n3 |= 4;
            }
            lDAPAttribute = new LDAPAttribute("nsDS5Flags", String.valueOf(n3));
        }
        if (this._modelReferral.getSize() > 0) {
            if (lDAPAttribute != null) {
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            if (lDAPAttribute2 != null) {
                lDAPModificationSet.add(2, lDAPAttribute2);
            }
        } else {
            if (lDAPAttribute2 != null) {
                lDAPModificationSet.add(2, lDAPAttribute2);
            }
            if (lDAPAttribute != null) {
                lDAPModificationSet.add(2, lDAPAttribute);
            }
        }
        object = null;
        if (this._cbPurgeDelay.isSelected()) {
            object = "0";
        } else {
            try {
                int n4 = Integer.parseInt(this._tfPurgeDelay.getText());
                int n5 = this._comboPurgeDelay.getSelectedIndex();
                object = String.valueOf(n4 *= this.CONVERSION_VALUES[n5]);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        boolean bl4 = bl = !this._replica.purgeDelay.equals(object);
        if (bl) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsds5ReplicaPurgeDelay", (String)object));
        }
        if (lDAPModificationSet.size() > 0) {
            final GenericProgressDialog genericProgressDialog = new GenericProgressDialog((JFrame)((Object)this._framework), true, 1, _resource.getString("advancedreplicadialog", "modifying-title"));
            genericProgressDialog.setTextInLabel(_resource.getString("advancedreplicadialog", "modifying-msg"));
            genericProgressDialog.setLabelRows(1);
            genericProgressDialog.setLabelColumns(25);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LDAPConnection lDAPConnection = AdvancedReplicaDialog.this._framework.getServerObject().getServerInfo().getLDAPConnection();
                    try {
                        lDAPConnection.modify(((AdvancedReplicaDialog)AdvancedReplicaDialog.this)._replica.dn, lDAPModificationSet);
                        AdvancedReplicaDialog.this._isModified = true;
                        genericProgressDialog.closeCallBack();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                AdvancedReplicaDialog.access$401(1.access$300(this.this$1));
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        SwingUtilities.invokeLater(new Runnable(this, stringArray){
                            private final /* synthetic */ String[] val$arg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$arg = stringArray;
                            }

                            public void run() {
                                DSUtil.showErrorDialog(1.access$500(this.this$1), "error-updatingreplica-title", "error-updatingreplica-msg", this.val$arg, "advancedreplicadialog", AdvancedReplicaDialog.access$600());
                                1.access$500(this.this$1).closeCallBack();
                            }
                        });
                    }
                }

                static /* synthetic */ AdvancedReplicaDialog access$300(1 var0) {
                    return var0.AdvancedReplicaDialog.this;
                }

                static /* synthetic */ GenericProgressDialog access$500(1 var0) {
                    return var0.genericProgressDialog;
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
        } else {
            super.okInvoked();
        }
    }

    private void layoutContentPane() {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        this.setComponent(jTabbedPane);
        jTabbedPane.addTab(_resource.getString("advancedreplicadialog-binddnpanel", "title"), this.createBindDnPanel());
        jTabbedPane.addTab(_resource.getString("advancedreplicadialog-optionalpanel", "title"), this.createOptionalPanel());
    }

    protected void helpInvoked() {
        DSUtil.help(this._helpToken, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    private JPanel createBindDnPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextArea jTextArea = UIFactory.makeDescriptionArea(_resource.getString("advancedreplicadialog", "binddndescription-label"), 7);
        ((MultilineLabel)jTextArea).setLabelFor((Component)jPanel);
        this._modelBindDn = new DefaultListModel();
        Enumeration enumeration = this._replica.bindDn.elements();
        while (enumeration.hasMoreElements()) {
            this._modelBindDn.addElement(enumeration.nextElement());
        }
        this._listBindDn = new JList(this._modelBindDn);
        this._listBindDn.setVisibleRowCount(5);
        this._listBindDn.addListSelectionListener(this);
        this._bAddBindDn = UIFactory.makeJButton(this, "advancedreplicadialog", "baddbinddn", _resource);
        this._bDeleteBindDn = UIFactory.makeJButton(this, "advancedreplicadialog", "bdeletebinddn", _resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        JScrollPane jScrollPane = new JScrollPane(this._listBindDn);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._bAddBindDn, gridBagConstraints);
        jPanel2.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)this._bDeleteBindDn, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextArea, gridBagConstraints);
        return jPanel;
    }

    private JPanel createOptionalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("advancedreplicadialog", "lreferral", _resource);
        JTextArea jTextArea = UIFactory.makeDescriptionArea(_resource.getString("advancedreplicadialog", "referraldescription-label"), 4);
        ((MultilineLabel)jTextArea).setLabelFor((Component)jPanel);
        this._modelReferral = new DefaultListModel();
        Enumeration enumeration = this._replica.referral.elements();
        while (enumeration.hasMoreElements()) {
            this._modelReferral.addElement(enumeration.nextElement());
        }
        this._listReferral = new JList(this._modelReferral);
        jLabel.setLabelFor(this._listReferral);
        this._listReferral.setVisibleRowCount(5);
        this._listReferral.addListSelectionListener(this);
        this._bAddReferral = UIFactory.makeJButton(this, "advancedreplicadialog", "baddreferral", _resource);
        this._bDeleteReferral = UIFactory.makeJButton(this, "advancedreplicadialog", "bdeletereferral", _resource);
        this._cbOverwriteReferrals = UIFactory.makeJCheckBox(null, "advancedreplicadialog", "cboverwritereferrals", false, _resource);
        this._cbOverwriteReferrals.setSelected(this._replica.overwriteReferrals && this._modelReferral.size() > 0);
        this._cbOverwriteReferrals.setEnabled(this._modelReferral.size() > 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = 0;
        JScrollPane jScrollPane = new JScrollPane(this._listReferral);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._bAddReferral, gridBagConstraints);
        jPanel2.add(Box.createVerticalStrut(UIFactory.getComponentSpace()), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)this._bDeleteReferral, gridBagConstraints);
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)this._cbOverwriteReferrals, gridBagConstraints);
        this._comboPurgeDelay = new JComboBox();
        this._comboPurgeDelay.addItem(_resource.getString("advancedreplicadialog", "days"));
        this._comboPurgeDelay.addItem(_resource.getString("advancedreplicadialog", "hours"));
        this._comboPurgeDelay.addItem(_resource.getString("advancedreplicadialog", "minutes"));
        this._comboPurgeDelay.addItem(_resource.getString("advancedreplicadialog", "seconds"));
        this._tfPurgeDelay = UIFactory.makeJTextField(this, "advancedreplicadialog", "lpurgedelay", null, 5, _resource);
        JLabel jLabel2 = UIFactory.makeJLabel("advancedreplicadialog", "lpurgedelay", _resource);
        jLabel2.setLabelFor(this._tfPurgeDelay);
        jLabel2.setLabelFor(this._comboPurgeDelay);
        this._cbPurgeDelay = UIFactory.makeJCheckBox(this, "advancedreplicadialog", "cbpurgedelay", false, _resource);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 5;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._tfPurgeDelay, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._comboPurgeDelay, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)this._cbPurgeDelay, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jTextArea, gridBagConstraints);
        try {
            int n = Integer.parseInt(this._replica.purgeDelay);
            if (n == 0) {
                this._cbPurgeDelay.setSelected(true);
                this._comboPurgeDelay.setEnabled(false);
                this._tfPurgeDelay.setEnabled(false);
            } else {
                this._cbPurgeDelay.setSelected(false);
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.CONVERSION_VALUES.length && !bl) {
                    if (n % this.CONVERSION_VALUES[n2] == 0) {
                        this._comboPurgeDelay.setSelectedIndex(n2);
                        String string = String.valueOf(n / this.CONVERSION_VALUES[n2]);
                        this._tfPurgeDelay.setText(string);
                        bl = true;
                    }
                    ++n2;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._bDeleteBindDn.setEnabled(false);
        this._bDeleteReferral.setEnabled(false);
        return jPanel;
    }

    private void checkPurgeDelayValidity() {
        boolean bl = true;
        if (!this._cbPurgeDelay.isSelected()) {
            try {
                Integer.parseInt(this._tfPurgeDelay.getText());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        this.setOKButtonEnabled(bl);
    }

    static /* synthetic */ void access$401(AdvancedReplicaDialog advancedReplicaDialog) {
        super.okInvoked();
    }

    static /* synthetic */ ResourceSet access$600() {
        return _resource;
    }
}

