/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.AttributeElement;
import com.netscape.admin.dirserv.config.replication.SparseElement;
import com.netscape.admin.dirserv.config.replication.SubtreeElement;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

abstract class PartialElement {
    public static final String ANY = "any";
    public String name;
    public String description;

    PartialElement() {
    }

    public static PartialElement createElement(LDAPEntry lDAPEntry) {
        PartialElement partialElement = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        Enumeration enumeration = lDAPAttribute.getStringValues();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("dsFilterSPFractionElement")) {
                partialElement = new AttributeElement();
                string = DSUtil.getAttrValue(lDAPEntry, "dsFilterSPType");
                partialElement.exclude = string.equalsIgnoreCase("fractional_exclude");
                LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute("dsFilterSPFractionAttr");
                partialElement.attributes = lDAPAttribute2.getStringValueArray();
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase("dsFilterSPSparseElement")) {
                partialElement = new SparseElement();
                ((SparseElement)partialElement).filter = DSUtil.getAttrValue(lDAPEntry, "dsFilterSPSparse");
                bl = true;
                continue;
            }
            if (!string2.equalsIgnoreCase("dsFilterSPSubtreeElement")) continue;
            partialElement = new SubtreeElement();
            ((SubtreeElement)partialElement).subtree = DSUtil.getAttrValue(lDAPEntry, "dsFilterSPSubTree");
            string = DSUtil.getAttrValue(lDAPEntry, "dsFilterSPType");
            ((SubtreeElement)partialElement).exclude = string.equalsIgnoreCase("subtree_exclude");
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("The LDAPEntry does not contain objectclass attribute or is not an element entry");
        }
        partialElement.name = DSUtil.getAttrValue(lDAPEntry, "cn");
        partialElement.description = DSUtil.getAttrValue(lDAPEntry, "description");
        return partialElement;
    }
}

