/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.config.replication.PartialElement;
import com.netscape.admin.dirserv.config.replication.PartialRule;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class PartialReplication {
    private Hashtable _htRules;
    private Hashtable _htElements = new Hashtable();

    public PartialReplication() {
        this._htRules = new Hashtable();
    }

    public synchronized void reload(LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        LDAPEntry lDAPEntry;
        this._htElements.clear();
        this._htRules.clear();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=elements, cn=filtering service, cn=features, cn=config", 1, "(objectclass=*)", (String[])null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = lDAPSearchResults.next();
            object = PartialElement.createElement(lDAPEntry);
            this._htElements.put(((PartialElement)object).name.toLowerCase(), object);
        }
        lDAPSearchResults = lDAPConnection.search("cn=sets, cn=filtering service, cn=features, cn=config", 1, "(objectclass=dsFilterSPConfigSet)", (String[])null, false);
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = lDAPSearchResults.next();
            object = new PartialRule();
            PartialRule.updateRule(lDAPEntry, (PartialRule)object);
            String string = "(&(objectclass=nsDS5ReplicationAgreement)(ds5PartialReplConfiguration=" + ((PartialRule)object).name + "))";
            LDAPSearchResults lDAPSearchResults2 = lDAPConnection.search("cn=mapping tree, cn=config", 2, string, (String[])null, false);
            while (lDAPSearchResults2.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = lDAPSearchResults2.next();
                ReplicationAgreement replicationAgreement = new ReplicationAgreement();
                ReplicationAgreement.updateAgreement(lDAPEntry2, replicationAgreement);
                ((PartialRule)object).addAgreement(replicationAgreement);
            }
            this._htRules.put(((PartialRule)object).name.toLowerCase(), object);
        }
    }

    public Enumeration getRules() {
        return this._htRules.elements();
    }

    public PartialRule getRule(String string) {
        String string2 = string.toLowerCase();
        return (PartialRule)this._htRules.get(string2);
    }

    public Enumeration getElements() {
        return this._htElements.elements();
    }

    public PartialElement getElement(String string) {
        String string2 = string.toLowerCase();
        return (PartialElement)this._htElements.get(string2);
    }

    public void notifyRuleAdded(PartialRule partialRule) {
        this._htRules.put(partialRule.name.toLowerCase(), partialRule);
    }

    public void notifyRuleModified(PartialRule partialRule) {
        this._htRules.put(partialRule.name.toLowerCase(), partialRule);
    }

    public void notifyRuleDeleted(String string) {
        String string2 = string.toLowerCase();
        this._htRules.remove(string2);
    }

    public void notifyElementAdded(PartialElement partialElement) {
        this._htElements.put(partialElement.name.toLowerCase(), partialElement);
    }

    public void notifyElementModified(PartialElement partialElement) {
        this._htElements.put(partialElement.name.toLowerCase(), partialElement);
    }

    public void notifyElementDeleted(String string) {
        String string2 = string.toLowerCase();
        this._htElements.remove(string2);
    }
}

