/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.PartialSubRule;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.DN;

public class PartialRule {
    public String name;
    public String description;
    private List _subRules = new ArrayList();
    private List _agreements = new ArrayList();

    public void addAgreement(ReplicationAgreement replicationAgreement) {
        ReplicationAgreement replicationAgreement2 = this.getAgreementByDN(replicationAgreement.dn);
        if (replicationAgreement2 != null) {
            this._agreements.remove(replicationAgreement2);
        }
        this._agreements.add(replicationAgreement);
    }

    public void removeAgreement(String string) {
        ReplicationAgreement replicationAgreement = this.getAgreementByDN(string);
        if (replicationAgreement != null) {
            this._agreements.remove(replicationAgreement);
        }
    }

    public void clearAgreementList() {
        this._agreements.clear();
    }

    public List getAgreementList() {
        return this._agreements;
    }

    public void addSubRule(PartialSubRule partialSubRule) {
        this._subRules.add(partialSubRule);
    }

    public void removeSubRule(PartialSubRule partialSubRule) {
        this._subRules.remove(partialSubRule);
    }

    public void clearSubRuleList() {
        this._subRules.clear();
    }

    public List getSubRuleList() {
        return this._subRules;
    }

    public PartialRule createClone() {
        PartialRule partialRule = new PartialRule();
        partialRule.name = this.name;
        partialRule.description = this.description;
        partialRule._subRules = new ArrayList(this._subRules);
        partialRule._agreements = new ArrayList(this._agreements);
        return partialRule;
    }

    public static void updateRule(LDAPEntry lDAPEntry, PartialRule partialRule) {
        partialRule.name = DSUtil.getAttrValue(lDAPEntry, "cn");
        partialRule.description = DSUtil.getAttrValue(lDAPEntry, "description");
        partialRule._subRules.clear();
        String string = DSUtil.getAttrValue(lDAPEntry, "dsFilterSPConfigDefinition");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "||");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(40);
            int n2 = string2.lastIndexOf(41);
            if (n >= 0 && n2 >= 0) {
                string2 = string2.substring(n + 1, n2);
            }
            PartialSubRule partialSubRule = new PartialSubRule();
            int n3 = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "&&");
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken().trim();
                if (string3.equalsIgnoreCase("any")) {
                    string3 = "any";
                }
                switch (n3) {
                    case 0: {
                        partialSubRule.subtreeElementName = string3;
                        break;
                    }
                    case 1: {
                        partialSubRule.sparseElementName = string3;
                        break;
                    }
                    case 2: {
                        partialSubRule.attributeElementName = string3;
                        break;
                    }
                }
                ++n3;
            }
            partialRule._subRules.add(partialSubRule);
        }
    }

    private ReplicationAgreement getAgreementByDN(String string) {
        ReplicationAgreement replicationAgreement = null;
        DN dN = new DN(string);
        ListIterator listIterator = this._agreements.listIterator();
        while (listIterator.hasNext() && replicationAgreement == null) {
            ReplicationAgreement replicationAgreement2 = (ReplicationAgreement)listIterator.next();
            DN dN2 = new DN(replicationAgreement2.dn);
            if (!dN2.equals(dN)) continue;
            replicationAgreement = replicationAgreement2;
        }
        return replicationAgreement;
    }
}

