/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.effectiverights;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.effectiverights.AttributeLevelInfo;
import com.netscape.admin.dirserv.effectiverights.AttributeLevelTableModel;
import com.netscape.admin.dirserv.effectiverights.CheckBoxToolTipCellRenderer;
import com.netscape.admin.dirserv.effectiverights.EffectiveRightsInputDialog;
import com.netscape.admin.dirserv.effectiverights.EntryLevelInfo;
import com.netscape.admin.dirserv.effectiverights.EntryLevelTableModel;
import com.netscape.admin.dirserv.effectiverights.WriteCellRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.ToolTipCellRenderer;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;

class EffectiveRightsOutputDialog
extends AbstractDialog
implements ListSelectionListener {
    private int _displayOptions;
    private LDAPEntry _entry;
    private String _userDn;
    private JTextArea _taAttributeLevelInfo;
    private JTable _tAttributeLevel;
    private JTable _tEntryLevel;
    private AttributeLevelInfo[] _attributeLevelInfo;
    private EntryLevelInfo _entryLevelInfo;
    private String _adminURL;
    public static int DISPLAY_ENTRY_LEVEL_INFO = 1;
    public static int DISPLAY_ATTRIBUTE_LEVEL_INFO = 2;
    private static final ResourceSet _resource = EffectiveRightsInputDialog._resource;
    private static final String HELP_TOKEN = "effectiverights-output-dbox-help";
    public String[] REASONS = new String[]{"no reason available", "no allow acis", "result cached deny", "result cached allow", "evaluated allow", "evaluated deny", "no acis matched the resource", "no acis matched the subject", "allow anyone aci matched anon user", "no matching anyone aci for anon user", "eval context cached allow", "eval context cache not allowed", "eval context cached attr * allow", "root user"};
    public String[] LOCALIZED_REASONS = new String[]{_resource.getString("effectiverightsoutputdialog", "noreasonavailable"), _resource.getString("effectiverightsoutputdialog", "noallowacis"), _resource.getString("effectiverightsoutputdialog", "resultcacheddeny"), _resource.getString("effectiverightsoutputdialog", "resultcachedallow"), _resource.getString("effectiverightsoutputdialog", "evaluatedallow"), _resource.getString("effectiverightsoutputdialog", "evaluateddeny"), _resource.getString("effectiverightsoutputdialog", "noacismatchedtheresource"), _resource.getString("effectiverightsoutputdialog", "noacismatchedthesubject"), _resource.getString("effectiverightsoutputdialog", "allowanyoneacimatchedanonuser"), _resource.getString("effectiverightsoutputdialog", "nomatchinganyoneaciforanonuser"), _resource.getString("effectiverightsoutputdialog", "evalcontextcachedallow"), _resource.getString("effectiverightsoutputdialog", "evalcontextcachenotallowed"), _resource.getString("effectiverightsoutputdialog", "evalcontextcachedattr*allow"), _resource.getString("effectiverightsoutputdialog", "rootuser")};
    static final String ATTRIBUTE_INFO = _resource.getString("effectiverightsoutputdialog", "attributelevelinfo-attributeinfo");
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$java$lang$Integer;

    public EffectiveRightsOutputDialog(DSFramework dSFramework, LDAPEntry lDAPEntry, String string, int n) {
        super((Frame)((Object)dSFramework), null, true, 12);
        this._entry = lDAPEntry;
        this._userDn = string;
        this._displayOptions = n;
        this._adminURL = dSFramework.getServerObject().getServerInfo().getAdminURL();
        this.getEffectiveRightsInfo(this._entry);
        String[] stringArray = new String[]{DSUtil.abreviateString(this._entry.getDN(), 30)};
        ((Dialog)((Object)this)).setTitle(_resource.getString("effectiverightsoutputdialog", "title", stringArray));
        this.layoutContentPane();
    }

    public void packAndShow() {
        if ((this._displayOptions & DISPLAY_ATTRIBUTE_LEVEL_INFO) != 0) {
            this.setPreferredHeightToTable(this._tAttributeLevel);
            this.setPreferredWidthToTable(this._tAttributeLevel);
            this._tAttributeLevel.setPreferredScrollableViewportSize(new Dimension((int)this._tAttributeLevel.getPreferredSize().getWidth(), (int)this._tAttributeLevel.getPreferredScrollableViewportSize().getHeight()));
        }
        if ((this._displayOptions & DISPLAY_ENTRY_LEVEL_INFO) != 0) {
            this.setPreferredHeightToTable(this._tEntryLevel);
        }
        this.pack();
        if ((this._displayOptions & DISPLAY_ENTRY_LEVEL_INFO) != 0) {
            this.setPreferredWidthToTable(this._tEntryLevel);
            JComponent jComponent = null;
            Container container = this._tEntryLevel.getParent();
            while (jComponent == null && container != null) {
                if (container instanceof JScrollPane) {
                    jComponent = (JScrollPane)container;
                    continue;
                }
                container = container.getParent();
            }
            if (this._tEntryLevel.getPreferredSize().width > jComponent.getPreferredSize().width) {
                this._tEntryLevel.setAutoResizeMode(0);
            }
        }
        this.show();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if ((this._displayOptions & DISPLAY_ATTRIBUTE_LEVEL_INFO) != 0 && (listSelectionEvent.getSource() == this._tAttributeLevel.getSelectionModel() || listSelectionEvent.getSource() == this._tAttributeLevel.getColumnModel().getSelectionModel())) {
            String string = "";
            int n = this._tAttributeLevel.getSelectionModel().getMinSelectionIndex();
            int n2 = this._tAttributeLevel.getColumnModel().getSelectionModel().getMinSelectionIndex();
            if (n != -1 && n2 != -1 && this._attributeLevelInfo.length > 0) {
                int n3 = this._tAttributeLevel.convertColumnIndexToModel(n2);
                AttributeLevelInfo attributeLevelInfo = this._attributeLevelInfo[n];
                switch (n3) {
                    case 0: {
                        string = ATTRIBUTE_INFO;
                        break;
                    }
                    case 1: {
                        string = attributeLevelInfo.searchInfo;
                        break;
                    }
                    case 2: {
                        string = attributeLevelInfo.readInfo;
                        break;
                    }
                    case 3: {
                        string = attributeLevelInfo.compareInfo;
                        break;
                    }
                    case 4: {
                        string = attributeLevelInfo.proxyInfo;
                        break;
                    }
                    case 5: {
                        String[] stringArray = new String[]{attributeLevelInfo.writeInfo, attributeLevelInfo.globalRightMessage};
                        if (attributeLevelInfo.rightToWrite == AttributeLevelInfo.NOT_DEFINED) {
                            string = _resource.getString("effectiverightsoutputdialog", "writenodefinedreason-label", stringArray);
                            break;
                        }
                        string = _resource.getString("effectiverightsoutputdialog", "writereason-label", stringArray);
                        break;
                    }
                    case 6: {
                        String[] stringArray = new String[]{attributeLevelInfo.selfWriteAddInfo, attributeLevelInfo.globalRightMessage};
                        string = _resource.getString("effectiverightsoutputdialog", "selfwriteaddreason-label", stringArray);
                        break;
                    }
                    case 7: {
                        String[] stringArray = new String[]{attributeLevelInfo.selfWriteDeleteInfo, attributeLevelInfo.globalRightMessage};
                        string = _resource.getString("effectiverightsoutputdialog", "selfwritedeletereason-label", stringArray);
                        break;
                    }
                    default: {
                        Thread.dumpStack();
                    }
                }
            }
            if (string.equals("")) {
                this._taAttributeLevelInfo.setText("");
            } else {
                String[] stringArray = new String[]{string};
                this._taAttributeLevelInfo.setText(_resource.getString("effectiverightsoutputdialog", "taattributelevelinfo-label", stringArray));
            }
        }
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._adminURL);
    }

    private void getEffectiveRightsInfo(LDAPEntry lDAPEntry) {
        Object object;
        String string;
        Enumeration enumeration;
        Object object2;
        LDAPAttributeSet lDAPAttributeSet;
        if ((this._displayOptions & DISPLAY_ATTRIBUTE_LEVEL_INFO) != 0) {
            lDAPAttributeSet = new Hashtable();
            object2 = lDAPEntry.getAttributeSet();
            enumeration = object2.getAttributes();
            while (enumeration.hasMoreElements()) {
                Object object3;
                String string2;
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                string = lDAPAttribute.getName();
                object = lDAPAttribute.getStringValueArray()[0];
                if (this.isAttributeLevelAttribute(string)) {
                    string2 = this.getAttributeFromAttributeLevel(string);
                    object3 = (AttributeLevelInfo)lDAPAttributeSet.get(string2.toLowerCase());
                    if (object3 == null) {
                        object3 = new AttributeLevelInfo();
                        lDAPAttributeSet.put(string2.toLowerCase(), object3);
                        ((AttributeLevelInfo)object3).attributeName = string2;
                    }
                    this.updateAttributeLevel((AttributeLevelInfo)object3, (String)object);
                    continue;
                }
                if (!this.isAttributeLevelInfoAttribute(string)) continue;
                string2 = this.getOperationFromAttributeLevelInfo(string);
                object3 = this.getAttributeFromAttributeLevelInfo(string);
                AttributeLevelInfo attributeLevelInfo = (AttributeLevelInfo)lDAPAttributeSet.get(((String)object3).toLowerCase());
                if (attributeLevelInfo == null) {
                    attributeLevelInfo = new AttributeLevelInfo();
                    lDAPAttributeSet.put(((String)object3).toLowerCase(), attributeLevelInfo);
                    attributeLevelInfo.attributeName = object3;
                }
                this.updateAttributeLevelInfo(attributeLevelInfo, (String)object, string2);
            }
            this._attributeLevelInfo = new AttributeLevelInfo[lDAPAttributeSet.size()];
            lDAPAttributeSet.values().toArray(this._attributeLevelInfo);
            int n = 0;
            while (n < this._attributeLevelInfo.length - 1) {
                int n2 = n + 1;
                while (n2 < this._attributeLevelInfo.length) {
                    if (this._attributeLevelInfo[n].attributeName.compareTo(this._attributeLevelInfo[n2].attributeName) > 0) {
                        object = this._attributeLevelInfo[n];
                        this._attributeLevelInfo[n] = this._attributeLevelInfo[n2];
                        this._attributeLevelInfo[n2] = object;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if ((this._displayOptions & DISPLAY_ENTRY_LEVEL_INFO) != 0) {
            this._entryLevelInfo = new EntryLevelInfo();
            lDAPAttributeSet = lDAPEntry.getAttributeSet();
            object2 = lDAPAttributeSet.getAttributes();
            while (object2.hasMoreElements()) {
                enumeration = (LDAPAttribute)object2.nextElement();
                String string3 = enumeration.getName();
                string = enumeration.getStringValueArray()[0];
                if (this.isEntryLevelAttribute(string3)) {
                    this.updateEntryLevel(this._entryLevelInfo, string);
                    continue;
                }
                if (!this.isEntryLevelInfoAttribute(string3)) continue;
                object = this.getOperationFromEntryLevelInfo(string3);
                this.updateEntryLevelInfo(this._entryLevelInfo, string, (String)object);
            }
        }
    }

    private boolean isAttributeLevelAttribute(String string) {
        return string.indexOf("aclRights;attributeLevel") >= 0;
    }

    private boolean isAttributeLevelInfoAttribute(String string) {
        return string.indexOf("aclRightsInfo;logs;attributeLevel") >= 0;
    }

    private String getAttributeFromAttributeLevel(String string) {
        return string.substring(25);
    }

    private String getOperationFromAttributeLevelInfo(String string) {
        String string2 = string.substring(34);
        int n = string2.indexOf(59);
        return string2.substring(0, n);
    }

    private String getAttributeFromAttributeLevelInfo(String string) {
        String string2 = string.substring(34);
        int n = string2.indexOf(59);
        return string2.substring(n + 1);
    }

    private void updateAttributeLevel(AttributeLevelInfo attributeLevelInfo, String string) {
        attributeLevelInfo.rightToSearch = string.indexOf("search:1") != -1;
        attributeLevelInfo.rightToRead = string.indexOf("read:1") != -1;
        attributeLevelInfo.rightToCompare = string.indexOf("compare:1") != -1;
        attributeLevelInfo.rightToProxy = string.indexOf("proxy:1") != -1;
        String string2 = "write";
        if (string.indexOf(",write:-") != -1) {
            attributeLevelInfo.rightToWrite = AttributeLevelInfo.VIRTUAL;
        } else if (string.indexOf(",write:?") != -1) {
            attributeLevelInfo.rightToWrite = AttributeLevelInfo.NOT_DEFINED;
            string2 = string2 + 'x';
        } else if (string.indexOf(",write:1") != -1) {
            attributeLevelInfo.rightToWrite = AttributeLevelInfo.HAS_WRITE_RIGHTS;
            string2 = string2 + '1';
        } else {
            attributeLevelInfo.rightToWrite = AttributeLevelInfo.HAS_NOT_WRITE_RIGHTS;
            string2 = string2 + '0';
        }
        boolean bl = false;
        if (string.indexOf("selfwrite_add:-") != -1) {
            attributeLevelInfo.rightToSelfWriteAdd = AttributeLevelInfo.VIRTUAL;
            bl = true;
        } else if (string.indexOf("selfwrite_add:1") != -1) {
            attributeLevelInfo.rightToSelfWriteAdd = AttributeLevelInfo.HAS_WRITE_RIGHTS;
            string2 = string2 + '1';
        } else {
            attributeLevelInfo.rightToSelfWriteAdd = AttributeLevelInfo.HAS_NOT_WRITE_RIGHTS;
            string2 = string2 + '0';
        }
        if (string.indexOf("selfwrite_delete:-") != -1) {
            attributeLevelInfo.rightToSelfWriteDelete = AttributeLevelInfo.VIRTUAL;
            bl = true;
        } else if (string.indexOf("selfwrite_delete:1") != -1) {
            string2 = string2 + '1';
            attributeLevelInfo.rightToSelfWriteDelete = AttributeLevelInfo.HAS_WRITE_RIGHTS;
        } else {
            string2 = string2 + '0';
            attributeLevelInfo.rightToSelfWriteDelete = AttributeLevelInfo.HAS_NOT_WRITE_RIGHTS;
        }
        attributeLevelInfo.globalRightMessage = !bl ? _resource.getString("effectiverightsoutputdialog", string2) : _resource.getString("effectiverightsoutputdialog", "virtual-label");
    }

    private void updateAttributeLevelInfo(AttributeLevelInfo attributeLevelInfo, String string, String string2) {
        boolean bl = false;
        String string3 = null;
        int n = 0;
        while (n < this.REASONS.length && !bl) {
            boolean bl2 = bl = string.indexOf(this.REASONS[n]) != -1;
            if (bl) {
                string3 = this.LOCALIZED_REASONS[n];
            }
            ++n;
        }
        int n2 = string.indexOf("deciding_aci:");
        if (n2 > 0) {
            int n3 = string.lastIndexOf(", index");
            String string4 = n3 >= 0 ? string.substring(n2 + 13, n3) : string.substring(n2 + 13);
            String[] stringArray = new String[]{string4};
            string3 = string3 + "  " + _resource.getString("effectiverightsoutputdialog", "decidingaci-label", stringArray);
        }
        if (!bl) {
            string3 = this.LOCALIZED_REASONS[0];
            Thread.dumpStack();
        }
        if (string2.equals("search")) {
            attributeLevelInfo.searchInfo = string3;
        } else if (string2.equals("read")) {
            attributeLevelInfo.readInfo = string3;
        } else if (string2.equals("compare")) {
            attributeLevelInfo.compareInfo = string3;
        } else if (string2.equals("proxy")) {
            attributeLevelInfo.proxyInfo = string3;
        } else if (string2.equals("write")) {
            attributeLevelInfo.writeInfo = string3;
        } else if (string2.equals("selfwrite_add")) {
            attributeLevelInfo.selfWriteAddInfo = string3;
        } else if (string2.equals("selfwrite_delete")) {
            attributeLevelInfo.selfWriteDeleteInfo = string3;
        } else {
            Thread.dumpStack();
        }
    }

    private boolean isEntryLevelAttribute(String string) {
        return string.indexOf("aclRights;entryLevel") >= 0;
    }

    private boolean isEntryLevelInfoAttribute(String string) {
        return string.indexOf("aclRightsInfo;logs;entryLevel") >= 0;
    }

    private String getOperationFromEntryLevelInfo(String string) {
        return string.substring(30);
    }

    private void updateEntryLevel(EntryLevelInfo entryLevelInfo, String string) {
        entryLevelInfo.rightToAdd = string.indexOf("add:1") != -1;
        entryLevelInfo.rightToDelete = string.indexOf("delete:1") != -1;
        entryLevelInfo.rightToRead = string.indexOf("read:1") != -1;
        entryLevelInfo.rightToWrite = string.indexOf("write:1") != -1;
        entryLevelInfo.rightToProxy = string.indexOf("proxy:1") != -1;
    }

    private void updateEntryLevelInfo(EntryLevelInfo entryLevelInfo, String string, String string2) {
        boolean bl = false;
        String string3 = null;
        int n = 0;
        while (n < this.REASONS.length && !bl) {
            boolean bl2 = bl = string.indexOf(this.REASONS[n]) != -1;
            if (bl) {
                string3 = this.LOCALIZED_REASONS[n];
            }
            ++n;
        }
        if (!bl) {
            string3 = this.LOCALIZED_REASONS[0];
            Thread.dumpStack();
        }
        if (string2.equals("add")) {
            entryLevelInfo.addInfo = string3;
        } else if (string2.equals("delete")) {
            entryLevelInfo.deleteInfo = string3;
        } else if (string2.equals("read")) {
            entryLevelInfo.readInfo = string3;
        } else if (string2.equals("write")) {
            entryLevelInfo.writeInfo = string3;
        } else if (string2.equals("proxy")) {
            entryLevelInfo.proxyInfo = string3;
        }
    }

    private void layoutContentPane() {
        JComponent jComponent;
        MultilineLabel multilineLabel;
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (this._userDn == null) {
            object = new String[]{this._entry.getDN()};
            multilineLabel = new MultilineLabel(_resource.getString("effectiverightsoutputdialog", "lmain-anonymous-label", object), 2, 50);
        } else {
            object = new String[]{this._userDn, this._entry.getDN()};
            multilineLabel = new MultilineLabel(_resource.getString("effectiverightsoutputdialog", "lmain-label", object), 2, 50);
        }
        object = new GridBagConstraints();
        object.weightx = 1.0;
        object.fill = 1;
        object.gridwidth = 0;
        jPanel.add((Component)multilineLabel, object);
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        if ((this._displayOptions & DISPLAY_ENTRY_LEVEL_INFO) != 0) {
            jPanel3 = this.createEntryLevelInfoPane();
        }
        if ((this._displayOptions & DISPLAY_ATTRIBUTE_LEVEL_INFO) != 0) {
            jPanel2 = this.createAttributeLevelInfoPane();
        }
        if (jPanel2 != null && jPanel3 != null) {
            jComponent = new JTabbedPane();
            jPanel2.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
            jPanel3.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
            ((JTabbedPane)jComponent).addTab(_resource.getString("effectiverightsoutputdialog-attributetab", "title"), jPanel2);
            ((JTabbedPane)jComponent).addTab(_resource.getString("effectiverightsoutputdialog-entrytab", "title"), jPanel3);
            object.weightx = 1.0;
            object.weighty = 1.0;
            object.insets.top = UIFactory.getComponentSpace();
            jPanel.add((Component)jComponent, object);
        } else if (jPanel2 != null) {
            object.weightx = 1.0;
            object.insets.top = UIFactory.getComponentSpace();
            jComponent = UIFactory.makeJLabel("effectiverightsoutputdialog", "lattributelevelpanel", _resource);
            jPanel.add((Component)jComponent, object);
            object.insets.top = 0;
            object.weighty = 1.0;
            jPanel.add((Component)jPanel2, object);
        } else if (jPanel3 != null) {
            object.weightx = 1.0;
            object.insets.top = UIFactory.getComponentSpace();
            jComponent = UIFactory.makeJLabel("effectiverightsoutputdialog", "lentrylevelpanel", _resource);
            jPanel.add((Component)jComponent, object);
            object.insets.top = 0;
            object.weighty = 1.0;
            jPanel.add((Component)jPanel3, object);
        } else {
            Thread.dumpStack();
        }
        object.weighty = 0.0;
        object.weightx = 0.0;
        object.gridwidth = -1;
        object.fill = 0;
        object.insets.top = UIFactory.getDifferentSpace();
        object.anchor = 11;
        jPanel.add((Component)new JLabel((Icon)DSUtil.getPackageImage("failed.gif")), object);
        object.insets.left = UIFactory.getComponentSpace();
        object.weightx = 1.0;
        object.gridwidth = 0;
        object.fill = 1;
        jComponent = new MultilineLabel(_resource.getString("effectiverightsoutputdialog", "lwarning-label"), 3, 50);
        ((JTextArea)jComponent).setFont(jComponent.getFont().deriveFont(2));
        jPanel.add((Component)jComponent, object);
        this.setComponent(jPanel);
    }

    private JPanel createEntryLevelInfoPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTable jTable = new JTable(new EntryLevelTableModel(this._entryLevelInfo));
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        jTable.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EffectiveRightsOutputDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CheckBoxTableCellRenderer());
        jTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = EffectiveRightsOutputDialog.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        jTable.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = EffectiveRightsOutputDialog.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, labelCellRenderer);
        jTable.setShowGrid(true);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this._tEntryLevel = jTable;
        return jPanel;
    }

    private JPanel createAttributeLevelInfoPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTable jTable = new JTable(new AttributeLevelTableModel(this._attributeLevelInfo));
        jTable.getSelectionModel().addListSelectionListener(this);
        jTable.getSelectionModel().setSelectionMode(0);
        jTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        jTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        ToolTipCellRenderer toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(AttributeLevelTableModel.TOOL_TIPS);
        CheckBoxToolTipCellRenderer checkBoxToolTipCellRenderer = new CheckBoxToolTipCellRenderer();
        checkBoxToolTipCellRenderer.setToolTips(AttributeLevelTableModel.TOOL_TIPS);
        WriteCellRenderer writeCellRenderer = new WriteCellRenderer();
        writeCellRenderer.setToolTips(AttributeLevelTableModel.TOOL_TIPS);
        jTable.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EffectiveRightsOutputDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean, checkBoxToolTipCellRenderer);
        jTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = EffectiveRightsOutputDialog.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        jTable.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = EffectiveRightsOutputDialog.class$("java.lang.Integer")) : class$java$lang$Integer, writeCellRenderer);
        jTable.setShowGrid(true);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this._taAttributeLevelInfo = new MultilineLabel(4, 50);
        JScrollPane jScrollPane2 = new JScrollPane(this._taAttributeLevelInfo);
        jScrollPane2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane2.getViewport().setBackground(jPanel.getBackground());
        int n = (int)this._taAttributeLevelInfo.getPreferredSize().getHeight() + (int)jScrollPane2.getHorizontalScrollBar().getPreferredSize().getHeight();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        CompoundBorder compoundBorder = new CompoundBorder(UITools.createLoweredBorder(), new EmptyBorder(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), UIFactory.getDifferentSpace(), UIFactory.getComponentSpace()));
        jPanel2.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        int n2 = (int)this._taAttributeLevelInfo.getPreferredSize().getHeight() + (int)jScrollPane2.getHorizontalScrollBar().getPreferredSize().getHeight();
        jPanel2.add(Box.createVerticalStrut(n2), gridBagConstraints);
        this._taAttributeLevelInfo.setToolTipText(_resource.getString("effectiverightsoutputdialog", "taattributelevelinfo-ttip"));
        this._tAttributeLevel = jTable;
        return jPanel;
    }

    private void setPreferredHeightToTable(JTable jTable) {
        int n = Math.min(jTable.getRowCount(), 10);
        jTable.setPreferredScrollableViewportSize(new Dimension((int)jTable.getPreferredScrollableViewportSize().getWidth(), jTable.getRowHeight() * n));
    }

    private void setPreferredWidthToTable(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = 0;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), true, true, 0, n);
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(0, n);
            int n2 = (int)component.getPreferredSize().getWidth();
            int n3 = 0;
            while (n3 < jTable.getRowCount()) {
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(n3, n), true, true, n3, n);
                int n4 = (int)component.getPreferredSize().getWidth();
                n2 = Math.max(n2, n4);
                ++n3;
            }
            tableColumn.setPreferredWidth(n2 += 2 * jTable.getIntercellSpacing().width);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

