/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPUrl;

public class LDAPUrlDialog
extends AbstractDialog
implements ActionListener,
DocumentListener,
SuiConstants {
    private JLabel _refNewHostLabel;
    private JTextField _refNewHostText;
    private JLabel _refNewPortLabel;
    private JTextField _refNewPortText;
    private JLabel _refTargetDNLabel;
    private JTextField _refTargetDNText;
    private JLabel _refResult;
    private JCheckBox _cbIsSecure;
    private LDAPUrl _url;
    private int _editableOptions;
    private static final String _section = "construct-ldap-url";
    private static ResourceSet _resource = DSUtil._resource;
    static String INVALID_URL = _resource.getString("construct-ldap-url", "invalid-url-label");
    public static final int EDITABLE_DN = 1;
    public static final int EDITABLE_HOST = 2;
    public static final int EDITABLE_PORT = 4;
    public static final int ALL_EDITABLE = 7;

    public LDAPUrlDialog(JFrame jFrame, String string, int n) {
        super((Frame)jFrame, _resource.getString(_section, "title"), true, 3);
        this._editableOptions = n;
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "description"));
        this.setDefaultButton(1);
        this.setOKButtonEnabled(false);
        this.layoutComponents();
        this.initWithValue(string);
    }

    public LDAPUrlDialog(JFrame jFrame, String string) {
        this(jFrame, string, 7);
    }

    public LDAPUrlDialog(JFrame jFrame) {
        this(jFrame, null);
    }

    public LDAPUrl getLDAPUrl() {
        return this._url;
    }

    public void packAndShow() {
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cbIsSecure) {
            this.notifyUpdate();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.notifyUpdate();
    }

    protected void initWithValue(String string) {
        if (string != null) {
            try {
                LDAPUrl lDAPUrl = new LDAPUrl(string);
                this._refNewHostText.setText(lDAPUrl.getHost());
                this._refNewPortText.setText(String.valueOf(lDAPUrl.getPort()));
                this._refTargetDNText.setText(LDAPUrl.decode((String)lDAPUrl.getDN()));
                this._cbIsSecure.setSelected(lDAPUrl.isSecure());
                this.notifyUpdate();
            }
            catch (Exception exception) {
                this._refResult.setText(INVALID_URL);
            }
        }
    }

    protected void layoutComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setComponent(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this._refNewHostLabel = UIFactory.makeJLabel(_section, "new-host", _resource);
        this._refNewHostLabel.resetKeyboardActions();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._refNewHostLabel, gridBagConstraints);
        this._refNewHostText = UIFactory.makeJTextField((Object)this, 16);
        this._refNewHostText.setEnabled((this._editableOptions & 2) != 0);
        this._refNewHostLabel.setLabelFor(this._refNewHostText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 6;
        --gridBagConstraints.gridwidth;
        jPanel.add((Component)this._refNewHostText, gridBagConstraints);
        this._refNewPortLabel = UIFactory.makeJLabel(_section, "new-port", _resource);
        this._refNewPortLabel.resetKeyboardActions();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        --gridBagConstraints.gridwidth;
        jPanel.add((Component)this._refNewPortLabel, gridBagConstraints);
        this._refNewPortText = UIFactory.makeJTextField((Object)this, 5);
        this._refNewPortText.setEnabled((this._editableOptions & 4) != 0);
        this._refNewPortLabel.setLabelFor(this._refNewPortText);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.right = 6;
        jPanel.add((Component)this._refNewPortText, gridBagConstraints);
        this._cbIsSecure = UIFactory.makeJCheckBox(this, _section, "cbissecure", false, _resource);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._cbIsSecure, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._refTargetDNLabel = UIFactory.makeJLabel(_section, "new-targetDN", _resource);
        this._refTargetDNLabel.resetKeyboardActions();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)this._refTargetDNLabel, gridBagConstraints);
        this._refTargetDNText = UIFactory.makeJTextField((Object)this, -1);
        this._refTargetDNText.setEnabled((this._editableOptions & 1) != 0);
        this._refTargetDNLabel.setLabelFor(this._refTargetDNText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 6;
        jPanel2.add((Component)this._refTargetDNText, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(_resource.getString(_section, "result-title"));
        this._refResult = new JLabel(" ");
        this._refResult.setLabelFor(groupPanel);
        this._refResult.setToolTipText(_resource.getString(_section, "ttip"));
        groupPanel.add(this._refResult);
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets.bottom = 6;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this.setFocusComponent(this._refNewHostText);
    }

    private void notifyUpdate() {
        boolean bl;
        String string = this._refTargetDNText.getText();
        boolean bl2 = DSUtil.isValidDN(string);
        boolean bl3 = false;
        try {
            Integer.parseInt(this._refNewPortText.getText());
            bl3 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl4 = this._refNewHostText.getText().trim().length() > 0;
        boolean bl5 = bl = bl2 && bl3 && bl4;
        if (bl) {
            String string2 = this._refNewHostText.getText();
            String string3 = this._refNewPortText.getText();
            String string4 = LDAPUrl.encode((String)this._refTargetDNText.getText());
            String string5 = this._cbIsSecure.isSelected() ? "ldaps" : "ldap";
            String string6 = string5 + "://" + string2 + ":" + string3 + "/" + string4;
            try {
                this._url = new LDAPUrl(string6);
                this._refResult.setText(this._url.toString());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            this._refResult.setText(INVALID_URL);
            this._url = null;
        }
        this.setOKButtonEnabled(bl);
    }

    protected void cancelInvoked() {
        this._url = null;
        super.cancelInvoked();
    }
}

