/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.referraledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.ReferralAuthenticationDialog;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.DefaultResEditorPage;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPUrl;

public class ResEditorReferralURLPage
extends DefaultResEditorPage
implements Observer,
DocumentListener,
ActionListener,
ListSelectionListener {
    private ResourceEditor _resourceEditor;
    private ResourcePageObservable _observable;
    private ConsoleInfo _info;
    private String _id;
    private Vector _oldReferralValues;
    private LDAPConnectionPool _connectionPool;
    private JTextField _tfNewReferral;
    private JTextArea _lBindDN;
    private JButton _bConstruct;
    private JButton _bAdd;
    private JButton _bDelete;
    private JButton _bChange;
    private JButton _bChangeAuthentication;
    private JList _referralList;
    private DefaultListModel _referralListData;
    private String _section = "referralURLPage";
    private static final int REFERRAL_LIST_ROWS = 5;
    private final String REFERRAL_ATTR = "ref";
    private static ResourceSet _resource = DSUtil._resource;

    public void setConnectionPool(LDAPConnectionPool lDAPConnectionPool) {
        this._connectionPool = lDAPConnectionPool;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        Vector vector;
        this._id = _resource.getString(this._section, "id");
        this._resourceEditor = resourceEditor;
        this._observable = resourcePageObservable;
        this._info = resourcePageObservable.getConsoleInfo();
        if (this._tfNewReferral == null) {
            this.layoutComponents();
        }
        this._oldReferralValues = (vector = resourcePageObservable.get("ref")) == null ? new Vector(1) : new Vector(vector);
        this._referralListData.clear();
        Vector vector2 = resourcePageObservable.get("ref");
        Enumeration enumeration = this._oldReferralValues.elements();
        while (enumeration.hasMoreElements()) {
            this._referralListData.addElement(enumeration.nextElement());
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ResourcePageObservable) {
            String string;
            ResourcePageObservable resourcePageObservable = (ResourcePageObservable)observable;
            if (object instanceof String && (string = (String)object).equalsIgnoreCase("ref")) {
                this._referralListData.clear();
                Vector vector = resourcePageObservable.get("ref");
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this._referralListData.addElement(enumeration.nextElement());
                }
            }
        }
    }

    public String getID() {
        return this._id;
    }

    public String getDisplayName() {
        return this._id;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        Object object;
        Vector vector = resourcePageObservable.get("ref");
        boolean bl = false;
        boolean bl2 = bl = this._referralListData.getSize() != this._oldReferralValues.size();
        if (!bl) {
            object = this._referralListData.elements();
            while (object.hasMoreElements() && !bl) {
                boolean bl3 = bl = !this._oldReferralValues.contains(object.nextElement());
            }
        }
        if (bl) {
            object = new Vector(this._referralListData.getSize());
            Enumeration enumeration = this._referralListData.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)object).addElement(enumeration.nextElement());
            }
            resourcePageObservable.replace("ref", (Vector)object);
        }
        return true;
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this._referralListData.getSize() > 0;
        if (!bl) {
            DSUtil.showErrorDialog(this._resourceEditor.getFrame(), "Incomplete-title", "Incomplete-msg", null, this._section, _resource);
        }
        return bl;
    }

    public void help() {
        DSUtil.help("referraleditor-url-dbox-help", this._info.getAdminURL());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this._bConstruct)) {
            this.actionConstructReferral();
        } else if (object.equals(this._bAdd)) {
            this.actionAddOrChangeReferral(false);
        } else if (object.equals(this._bDelete)) {
            this.actionDeleteReferral();
        } else if (object.equals(this._bChange)) {
            this.actionAddOrChangeReferral(true);
        } else if (object.equals(this._bChangeAuthentication)) {
            this.actionChangeAuthentication();
        }
        this.checkEnablingState();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnablingState();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkNewReferralTextField();
        this.checkDeleteReferralButton();
        this.checkChangeReferralButton();
        this.checkAuthReferralButton();
    }

    private void layoutComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(_resource.getString(this._section, "values-label"));
        JLabel jLabel2 = new JLabel(_resource.getString(this._section, "new-value-label"));
        this._lBindDN = new MultilineLabel(_resource.getString(this._section, "bind-dn-label", ""));
        this._lBindDN.setRows(2);
        this._tfNewReferral = UIFactory.makeJTextField((Object)this, -1);
        this._bDelete = UIFactory.makeJButton(this, this._section, "delete", _resource);
        this._bConstruct = UIFactory.makeJButton(this, this._section, "construct", _resource);
        this._bAdd = UIFactory.makeJButton(this, this._section, "add", _resource);
        this._bChange = UIFactory.makeJButton(this, this._section, "change", _resource);
        this._bChangeAuthentication = UIFactory.makeJButton(this, this._section, "changeauthentication", _resource);
        this._referralListData = new DefaultListModel();
        this._referralList = new JList(this._referralListData);
        ((MultilineLabel)this._lBindDN).setLabelFor((Component)this._referralList);
        this._referralList.setVisibleRowCount(5);
        this._referralList.addListSelectionListener(this);
        jLabel.setLabelFor(this._referralList);
        jLabel2.setLabelFor(this._tfNewReferral);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._referralList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 6;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._bDelete, gridBagConstraints);
        gridBagConstraints.insets.top = 6;
        jPanel2.add((Component)this._bChange, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.insets.right = 6;
        jPanel.add((Component)this._tfNewReferral, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._bAdd, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bConstruct, gridBagConstraints);
        gridBagConstraints.insets.top = 6;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this._lBindDN, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 6;
        jPanel2.add((Component)this._bChangeAuthentication, gridBagConstraints);
        jPanel.setBorder(new EmptyBorder(9, 9, 9, 9));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", jPanel);
        this._bChange.setEnabled(false);
        this._bAdd.setEnabled(false);
        this._bDelete.setEnabled(false);
    }

    private void checkEnablingState() {
        this._bAdd.setEnabled(!this._tfNewReferral.getText().trim().equals(""));
        this.checkDeleteReferralButton();
        this.checkChangeReferralButton();
        this.checkAuthReferralButton();
    }

    protected void checkDeleteReferralButton() {
        this._bDelete.setEnabled(!this._referralList.isSelectionEmpty());
    }

    protected void checkChangeReferralButton() {
        int n = this._referralList.getMinSelectionIndex();
        int n2 = this._referralList.getMaxSelectionIndex();
        int n3 = n == -1 ? 0 : n2 - n + 1;
        int n4 = this._tfNewReferral.getText().trim().length();
        this._bChange.setEnabled(n3 == 1 && n4 >= 1);
    }

    protected void checkAuthReferralButton() {
        String string;
        block5: {
            int n;
            int n2 = this._referralList.getMinSelectionIndex();
            int n3 = this._referralList.getMaxSelectionIndex();
            int n4 = n = n2 == -1 ? 0 : n3 - n2 + 1;
            if (n == 1) {
                try {
                    String string2 = (String)this._referralListData.elementAt(n2);
                    LDAPUrl lDAPUrl = new LDAPUrl(string2);
                    String string3 = this._connectionPool.getAuthDN(lDAPUrl);
                    if (string3 == null || string3.equals("")) {
                        string = _resource.getString(this._section, "anonymous-dn-label");
                        break block5;
                    }
                    string = _resource.getString(this._section, "bind-dn-label", string3);
                }
                catch (MalformedURLException malformedURLException) {
                    string = _resource.getString(this._section, "non-standard-url-label");
                }
            } else {
                string = _resource.getString(this._section, "bind-dn-label", "");
            }
        }
        this._lBindDN.setText(string);
    }

    protected void checkNewReferralTextField() {
        int n = this._referralList.getMinSelectionIndex();
        int n2 = this._referralList.getMaxSelectionIndex();
        int n3 = n == -1 ? 0 : n2 - n + 1;
        String string = n3 == 1 ? (String)this._referralListData.elementAt(n) : "";
        this._tfNewReferral.setText(string);
    }

    private void actionDeleteReferral() {
        Object[] objectArray = this._referralList.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this._referralListData.removeElement(objectArray[n]);
                ++n;
            }
        }
        this._tfNewReferral.setText("");
    }

    private void actionAddOrChangeReferral(boolean bl) {
        int n;
        String string = this._tfNewReferral.getText().trim();
        boolean bl2 = true;
        if (!DSUtil.isValidLDAPUrl(string) && (n = DSUtil.showConfirmationDialog((Component)this._resourceEditor.getFrame(), "ldapurl-no-good", (String)null, this._section)) != 0) {
            bl2 = false;
        }
        if (bl2) {
            if (bl) {
                n = this._referralList.getSelectedIndex();
                this._referralListData.setElementAt(string, n);
            } else {
                this._referralListData.addElement(string);
            }
            this._tfNewReferral.setText("");
            this._bAdd.setEnabled(false);
            this._bChange.setEnabled(false);
        }
    }

    private void actionConstructReferral() {
        Object object;
        String string;
        Object object2;
        String string2 = this._observable.get(this._observable.getIndexAttribute(), 0);
        if (string2 == null) {
            string2 = "";
        }
        String string3 = this._observable.getIndexAttribute() + "=" + DSUtil.getRdnValue(string2);
        String string4 = "";
        if (this._observable.isNewUser()) {
            string4 = this._observable.getCreateBaseDN();
        } else {
            object2 = LDAPDN.explodeDN((String)this._observable.getDN(), (boolean)false);
            if (((String[])object2).length > 1) {
                string = object2[0];
                object = new StringBuffer();
                int n = 1;
                while (n < ((String[])object2).length) {
                    if (n != 1) {
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(object2[n]);
                    ++n;
                }
                string4 = ((StringBuffer)object).toString();
            }
        }
        object2 = string4.length() > 0 ? string3 + ", " + string4 : string3;
        string = "ldap:///" + (String)object2;
        object = new LDAPUrlDialog(this._resourceEditor.getFrame(), string, 7);
        ((LDAPUrlDialog)object).packAndShow();
        LDAPUrl lDAPUrl = ((LDAPUrlDialog)object).getLDAPUrl();
        if (lDAPUrl != null) {
            this._tfNewReferral.setText(lDAPUrl.getUrl());
        }
    }

    private void actionChangeAuthentication() {
        ReferralAuthenticationDialog referralAuthenticationDialog = new ReferralAuthenticationDialog(this._resourceEditor.getFrame(), this._connectionPool);
        referralAuthenticationDialog.pack();
        referralAuthenticationDialog.show();
        int[] nArray = this._referralList.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            this._referralList.clearSelection();
            this._referralList.setSelectedIndices(nArray);
        }
    }
}

