/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.management.client.util.ResourceSet;

class AgreementStatus {
    public String dn = "";
    public String suffix = "";
    public String remoteReplica = "";
    public String description = "";
    public String state = "";
    public String summary = "";
    public String numberChangesSent = "";
    public String lastUpdateStart = "";
    public String lastUpdateEnd = "";
    public String lastUpdateMessage = "";
    public String lastInitMessage = "";
    public String lastInitStart = "";
    public String lastInitEnd = "";
    private static ResourceSet _resource = DSStatusPage._resource;
    static String NOT_AVAILABLE = _resource.getString("agreementstatus", "not-available-label");
    static String NOT_PERTINENT = _resource.getString("agreementstatus", "not-pertinent-label");
    static String NOT_AVAILABLE_SUMMARY = _resource.getString("agreementstatus", "not-available-summary-label");
    static String DISABLED = _resource.getString("agreementstatus", "disabled-label");
    static String DISABLED_SUMMARY = _resource.getString("agreementstatus", "disabled-summary-label");
    static String INITIALIZING = _resource.getString("agreementstatus", "initializing-label");
    static String SUSPENDED = _resource.getString("agreementstatus", "suspended-label");
    static String REPLICATING = _resource.getString("agreementstatus", "replicating-label");

    AgreementStatus() {
    }

    public static void updateFromAgreement(AgreementStatus agreementStatus, ReplicationAgreement replicationAgreement) {
        agreementStatus.dn = replicationAgreement.dn;
        agreementStatus.suffix = replicationAgreement.suffix;
        agreementStatus.remoteReplica = replicationAgreement.host + ":" + replicationAgreement.port;
        agreementStatus.description = replicationAgreement.description;
        agreementStatus.numberChangesSent = String.valueOf(replicationAgreement.numberChangesSent);
        agreementStatus.lastUpdateStart = replicationAgreement.lastUpdateStart != "NO_TIME_AVAILABLE" ? DSUtil.getDateTime(replicationAgreement.lastUpdateStart).toString() : NOT_AVAILABLE;
        agreementStatus.lastUpdateEnd = replicationAgreement.lastUpdateEnd != "NO_TIME_AVAILABLE" ? DSUtil.getDateTime(replicationAgreement.lastUpdateEnd).toString() : NOT_AVAILABLE;
        agreementStatus.lastUpdateMessage = !replicationAgreement.lastUpdateMessage.equals("") ? ReplicationAgreement.convertStatusMessage(replicationAgreement.lastUpdateMessage) : NOT_AVAILABLE;
        agreementStatus.lastInitStart = replicationAgreement.lastInitStart != "NO_TIME_AVAILABLE" ? DSUtil.getDateTime(replicationAgreement.lastInitStart).toString() : NOT_AVAILABLE;
        agreementStatus.lastInitEnd = replicationAgreement.lastInitEnd != "NO_TIME_AVAILABLE" ? DSUtil.getDateTime(replicationAgreement.lastInitEnd).toString() : NOT_AVAILABLE;
        agreementStatus.lastInitMessage = !replicationAgreement.lastInitMessage.equals("") ? ReplicationAgreement.convertStatusMessage(replicationAgreement.lastInitMessage) : NOT_AVAILABLE;
        if (!replicationAgreement.isEnabled) {
            agreementStatus.state = DISABLED;
            agreementStatus.summary = DISABLED_SUMMARY;
        } else if (replicationAgreement.isSuspended) {
            String[] stringArray;
            agreementStatus.state = SUSPENDED;
            boolean bl = false;
            agreementStatus.summary = "";
            if (agreementStatus.lastInitStart != NOT_AVAILABLE) {
                stringArray = new String[]{agreementStatus.lastInitStart};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "suspended-date-summary", stringArray);
                bl = true;
            }
            if (agreementStatus.lastInitMessage != NOT_AVAILABLE) {
                if (bl) {
                    agreementStatus.summary = agreementStatus.summary + " ";
                }
                stringArray = new String[]{agreementStatus.lastInitMessage};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "suspended-message-summary", stringArray);
            }
            if (agreementStatus.summary.equals("")) {
                agreementStatus.summary = NOT_AVAILABLE_SUMMARY;
            }
            agreementStatus.numberChangesSent = NOT_PERTINENT;
            agreementStatus.lastUpdateStart = NOT_PERTINENT;
            agreementStatus.lastUpdateEnd = NOT_PERTINENT;
            agreementStatus.lastUpdateMessage = NOT_PERTINENT;
            agreementStatus.lastInitEnd = NOT_PERTINENT;
        } else if (replicationAgreement.isInitializing) {
            String[] stringArray;
            agreementStatus.state = INITIALIZING;
            boolean bl = false;
            agreementStatus.summary = "";
            if (agreementStatus.lastInitStart != NOT_AVAILABLE) {
                stringArray = new String[]{agreementStatus.lastInitStart};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "initializing-date-summary", stringArray);
                bl = true;
            }
            if (agreementStatus.lastInitMessage != NOT_AVAILABLE) {
                if (bl) {
                    agreementStatus.summary = agreementStatus.summary + " ";
                }
                stringArray = new String[]{agreementStatus.lastInitMessage};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "initializing-message-summary", stringArray);
            }
            if (agreementStatus.summary.equals("")) {
                agreementStatus.summary = NOT_AVAILABLE_SUMMARY;
            }
            agreementStatus.numberChangesSent = NOT_PERTINENT;
            agreementStatus.lastUpdateStart = NOT_PERTINENT;
            agreementStatus.lastUpdateEnd = NOT_PERTINENT;
            agreementStatus.lastUpdateMessage = NOT_PERTINENT;
            agreementStatus.lastInitEnd = NOT_PERTINENT;
        } else {
            String[] stringArray;
            agreementStatus.state = REPLICATING;
            boolean bl = false;
            agreementStatus.summary = "";
            if (agreementStatus.lastUpdateEnd != NOT_AVAILABLE) {
                stringArray = new String[]{agreementStatus.lastUpdateEnd};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "replicating-date-summary", stringArray);
                bl = true;
            }
            if (agreementStatus.lastUpdateMessage != NOT_AVAILABLE) {
                if (bl) {
                    agreementStatus.summary = agreementStatus.summary + " ";
                }
                stringArray = new String[]{agreementStatus.lastUpdateMessage};
                agreementStatus.summary = agreementStatus.summary + _resource.getString("agreementstatus", "replicating-message-summary", stringArray);
            }
            if (agreementStatus.summary.equals("")) {
                agreementStatus.summary = NOT_AVAILABLE_SUMMARY;
            }
        }
    }

    public void dumpAgreementStatus() {
        System.out.println("StatusReplicationPanel.dumpAgreementStatus()");
        System.out.println("suffix: " + this.suffix);
        System.out.println("remoteReplica: " + this.remoteReplica);
        System.out.println("description: " + this.description);
        System.out.println("state: " + this.state);
        System.out.println("summary: " + this.summary);
        System.out.println("numberChangesSent: " + this.numberChangesSent);
        System.out.println("lastUpdateStart: " + this.lastUpdateStart);
        System.out.println("lastUpdateEnd: " + this.lastUpdateEnd);
        System.out.println("lastInitMessage: " + this.lastInitMessage);
        System.out.println("lastInitStart: " + this.lastInitStart);
        System.out.println("lastInitEnd: " + this.lastInitEnd);
    }
}

