/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IStartStopListener;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.IDatabaseConfigListener;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.IStatusNode;
import com.netscape.admin.dirserv.status.IStatusPanel;
import com.netscape.admin.dirserv.status.StatusMenuController;
import com.netscape.admin.dirserv.status.StatusSuffixNode;
import com.netscape.admin.dirserv.status.StatusTreeController;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class DSStatusPage
extends JPanel
implements IPage,
IAuthenticationChangeListener,
IStartStopListener,
TreeSelectionListener,
TreeWillExpandListener,
MouseListener,
ActionListener,
IDatabaseConfigListener {
    StatusMenuController _menuController;
    DSFramework _framework;
    protected JTree _tree;
    protected JScrollPane _treePanel;
    protected JPanel _contentPanel;
    protected IStatusPanel _displayedCustomPanel;
    protected JPopupMenu _contextMenu;
    protected StatusTreeController _treeController;
    private boolean _isInitialized = false;
    private boolean _isPageSelected = false;
    private boolean _refreshUponSelect = false;
    private boolean _isAuthenticating = false;
    private boolean _ignoreDatabaseConfigEvents = false;
    private Vector _authListeners = new Vector();
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.status.status");

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        this.shutDown();
    }

    public Object clone() {
        throw new IllegalStateException("DSStatusPage.clone() should not be called");
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public String getPageTitle() {
        return _resource.getString("statuspage", "title");
    }

    public void initialize(IFramework iFramework) {
        this._framework = (DSFramework)iFramework;
        this._framework.getServerObject().getDatabaseConfig().addChangeListener(this);
        this._framework.getServerObject().addStartStopListener(this);
        this._tree = new JTree();
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        this._tree.addTreeWillExpandListener(this);
        this._tree.addMouseListener(this);
        this._treeController = new StatusTreeController(this._tree, this._framework);
        this.layoutComponents();
        this._contextMenu = new JPopupMenu();
        this._menuController = new StatusMenuController(this._contextMenu, (IFramework)this._framework, this);
        this._menuController.addShortCutRegisterer(this._tree);
        this._tree.setSelectionRow(0);
        this.getAccessibleContext().setAccessibleName(this.getPageTitle());
        this.getAccessibleContext().setAccessibleDescription(_resource.getString("statuspage", "description"));
        this._isInitialized = true;
    }

    public void pageSelected(IFramework iFramework) {
        this._isPageSelected = true;
        this._menuController.populateMenuItems();
        if (this._refreshUponSelect) {
            this.refreshPage();
        } else {
            IStatusNode iStatusNode = this._treeController.getSelectedNode();
            if (iStatusNode != null) {
                this.updateRightPane(iStatusNode);
            }
        }
        this._refreshUponSelect = false;
    }

    public void pageUnselected(IFramework iFramework) {
        this._isPageSelected = false;
        this.shutDown();
        this._menuController.unpopulateMenuItems();
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        if (!this._isAuthenticating) {
            if (this._isPageSelected) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSStatusPage.this.refreshPage();
                    }
                });
            } else if (this._isInitialized) {
                this._refreshUponSelect = true;
            }
        }
    }

    public boolean getNewAuthentication() {
        boolean bl = false;
        DSUtil.DeferAuthListeners deferAuthListeners = null;
        String string = (String)this._framework.getServerObject().getServerInfo().get("rootdn");
        deferAuthListeners = DSUtil.reauthenticateDefer(this._framework.getServerObject().getServerInfo().getLDAPConnection(), (JFrame)((Object)this._framework), this._authListeners, string, null);
        boolean bl2 = bl = deferAuthListeners != null;
        if (bl) {
            deferAuthListeners.notifyListeners();
        }
        return bl;
    }

    public void setAuthenticationChangeListener(Vector vector) {
        this._authListeners = vector;
    }

    public void serverStarted() {
        if (this._isInitialized) {
            if (!this._isPageSelected) {
                this._refreshUponSelect = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSStatusPage.this.refreshPage();
                    }
                });
            }
        }
    }

    public void serverStopped() {
        this.serverStarted();
    }

    public void serverRestarted() {
        this.serverStarted();
    }

    public void databaseConfigChanged() {
        if (!this._ignoreDatabaseConfigEvents) {
            this._refreshUponSelect = true;
        }
    }

    public void suffixAdded(Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents) {
            this._refreshUponSelect = true;
        }
    }

    public void suffixDeleted(Suffix suffix) {
        if (!this._ignoreDatabaseConfigEvents) {
            this._refreshUponSelect = true;
        }
    }

    public void parentChanged(Suffix suffix, Suffix suffix2, Suffix suffix3) {
    }

    public void rootEntryAdded(Suffix suffix) {
    }

    public void rootEntryDeleted(Suffix suffix) {
    }

    public void databaseAdded(Database database) {
        if (!this._ignoreDatabaseConfigEvents) {
            this._refreshUponSelect = true;
        }
    }

    public void databaseDeleted(Database database) {
        if (!this._ignoreDatabaseConfigEvents) {
            this._refreshUponSelect = true;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IStatusNode iStatusNode = this._treeController.getSelectedNode();
        this._menuController.updateMenu(iStatusNode);
        this.updateRightPane(iStatusNode);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null && treePath.getPathCount() <= 1) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("REFRESH")) {
            this.actionRefreshTree();
        } else if (string.equals("AUTHENTICATE")) {
            this.actionAuthenticate();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    protected void popupContextMenu(MouseEvent mouseEvent) {
        TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            if (!this._tree.isPathSelected(treePath)) {
                this._tree.setSelectionPath(treePath);
            }
            if (this._contextMenu.getComponentCount() > 0) {
                this._contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._treePanel = new JScrollPane();
        this._treePanel.getViewport().add(this._tree);
        this._treePanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._treePanel.setPreferredSize(new Dimension(200, 200));
        this._treePanel.setMinimumSize(new Dimension(1, 1));
        this._contentPanel = new JPanel();
        this._contentPanel.setLayout(new GridBagLayout());
        this._contentPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JSplitPane jSplitPane = new JSplitPane(1, this._treePanel, this._contentPanel);
        jSplitPane.setBorder(new EmptyBorder(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace()));
        jSplitPane.setDividerLocation((int)this._treePanel.getPreferredSize().getWidth());
        this.add((Component)jSplitPane, gridBagConstraints);
    }

    protected void updateRightPane(IStatusNode iStatusNode) {
        if (this._displayedCustomPanel != null) {
            this._displayedCustomPanel.stopRefresher();
        }
        this._contentPanel.removeAll();
        this._displayedCustomPanel = null;
        if (iStatusNode != null) {
            this._displayedCustomPanel = iStatusNode.getCustomPanel();
            if (this._displayedCustomPanel != null) {
                if (this._displayedCustomPanel.isRefreshing()) {
                    this._displayedCustomPanel.startRefresher();
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
                this._contentPanel.add((Component)((Object)this._displayedCustomPanel), gridBagConstraints);
            }
        }
        this._contentPanel.validate();
        this._contentPanel.repaint();
    }

    private void actionAuthenticate() {
        this._isAuthenticating = true;
        boolean bl = this.getNewAuthentication();
        if (bl) {
            this.actionRefreshTree();
        }
        this._isAuthenticating = false;
    }

    private void actionRefreshTree() {
        this._ignoreDatabaseConfigEvents = true;
        try {
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            this._framework.getServerObject().getDatabaseConfig().reload(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "error-reloading-databaseconfig-title", "error-reloading-databaseconfig-msg", stringArray, "statuspage", _resource);
        }
        this.refreshPage();
        this._ignoreDatabaseConfigEvents = false;
    }

    private void refreshPage() {
        this._treeController.refreshTree();
        IStatusNode iStatusNode = this._treeController.getSelectedNode();
        if (iStatusNode != null) {
            this.updateRightPane(iStatusNode);
        }
    }

    private void shutDown() {
        if (this._displayedCustomPanel != null) {
            this._displayedCustomPanel.stopRefresher();
        }
    }

    private StatusSuffixNode getSuffixNode() {
        StatusSuffixNode statusSuffixNode = null;
        Enumeration<? extends TreeNode> enumeration = ((TreeNode)this._tree.getModel().getRoot()).children();
        while (enumeration.hasMoreElements() && statusSuffixNode == null) {
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof StatusSuffixNode)) continue;
            statusSuffixNode = (StatusSuffixNode)treeNode;
        }
        return statusSuffixNode;
    }
}

