/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.status.AccessLogParser;
import com.netscape.admin.dirserv.status.AccessLogTableModel;
import com.netscape.admin.dirserv.status.ILogFileListener;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.LogData;
import com.netscape.admin.dirserv.status.StatusLogBasePanel;
import com.netscape.admin.dirserv.status.TableViewOptions;
import com.netscape.management.client.util.MultilineLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class StatusAccessLogPanel
extends StatusLogBasePanel
implements ILogFileListener {
    private String[] _headers;

    public StatusAccessLogPanel(IStatusModel iStatusModel) {
        super(iStatusModel);
        this._model.getFramework().getServerObject().addLogFileListener(this);
    }

    public void logFileChanged(int n) {
        if (n == 1) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StatusAccessLogPanel.this.refresh();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected void initResources() {
        this._helpToken = "status-logs-access-help";
        this._taRights = new MultilineLabel(this._resource.getString("accesslogpanel", "rights-label"), 8, 50);
        this._taError = new MultilineLabel(8, 50);
        this.CURRENT_LOG_FILE_ATTRIBUTE = "nsslapd-accesslog";
        this.LOG_FILE_LIST_ATTRIBUTE = "nsslapd-accesslog-list";
        this.LOG_SORTED_BY = "ACCESSLOG_SORTED_BY";
        this.LOG_SORT_ASCENDING = "ACCESSLOG_SORT_ASCENDING";
        this.LOG_VISIBLE_COLUMNS = "ACCESSLOG_VISIBLE_COLUMNS";
        this.LOG_COLUMN_ORDER = "ACCESSLOG_COLUMN_ORDER";
        String[] stringArray = new String[]{this._resource.getString("accesslogpanel", "date-header"), this._resource.getString("accesslogpanel", "connectionnumber-header"), this._resource.getString("accesslogpanel", "operationnumber-header"), this._resource.getString("accesslogpanel", "messageid-header"), this._resource.getString("accesslogpanel", "detail-header")};
        this._headers = stringArray;
        String[] stringArray2 = new String[]{this._resource.getString("accesslogpanel", "date-tooltip"), this._resource.getString("accesslogpanel", "connectionnumber-tooltip"), this._resource.getString("accesslogpanel", "operationnumber-tooltip"), this._resource.getString("accesslogpanel", "messageid-tooltip"), this._resource.getString("accesslogpanel", "detail-tooltip")};
        this._toolTips = stringArray2;
    }

    protected void createTableModel() {
        this._tableModel = new AccessLogTableModel();
        ((AccessLogTableModel)this._tableModel).setHeaders(this._headers);
    }

    protected void createDefaultViewOptions() {
        int n;
        this._defaultViewOptions = new TableViewOptions();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[tableColumnModel.getColumnCount()];
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            tableColumnArray[n2] = tableColumnModel.getColumn(n2);
            ++n2;
        }
        this._defaultViewOptions.init(tableColumnArray, 0, true);
        if (this._toolTips != null) {
            n = 0;
            while (n < this._defaultViewOptions.columns.length) {
                this._defaultViewOptions.columns[n].toolTip = this._toolTips[n];
                ++n;
            }
        }
        n = 0;
        while (n < this._defaultViewOptions.columns.length) {
            this._defaultViewOptions.columns[n].isVisible = true;
            ++n;
        }
    }

    protected void updateTableModel(LogData[] logDataArray) {
        ((AccessLogTableModel)this._tableModel).updateData(logDataArray);
    }

    protected void createParser() {
        this._logParser = new AccessLogParser();
    }

    protected void sortLogs(LogData[] logDataArray, int n, boolean bl) {
        if (n != 0) {
            String[] stringArray = null;
            int[] nArray = null;
            switch (n) {
                case 1: {
                    nArray = new int[logDataArray.length];
                    int n2 = 0;
                    while (n2 < logDataArray.length) {
                        if (logDataArray[n2].connectionNumber.length() > 0) {
                            try {
                                nArray[n2] = Integer.parseInt(logDataArray[n2].connectionNumber);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n2] = -2;
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    nArray = new int[logDataArray.length];
                    int n3 = 0;
                    while (n3 < logDataArray.length) {
                        if (logDataArray[n3].operationNumber.length() > 0) {
                            try {
                                nArray[n3] = Integer.parseInt(logDataArray[n3].operationNumber);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n3] = -2;
                        }
                        ++n3;
                    }
                    break;
                }
                case 3: {
                    nArray = new int[logDataArray.length];
                    int n4 = 0;
                    while (n4 < logDataArray.length) {
                        if (logDataArray[n4].messageId.length() > 0) {
                            try {
                                nArray[n4] = Integer.parseInt(logDataArray[n4].messageId);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n4] = -2;
                        }
                        ++n4;
                    }
                    break;
                }
                case 4: {
                    stringArray = new String[logDataArray.length];
                    int n5 = 0;
                    while (n5 < logDataArray.length) {
                        stringArray[n5] = logDataArray[n5].detail;
                        ++n5;
                    }
                    break;
                }
                default: {
                    Thread.dumpStack();
                }
            }
            if (stringArray != null) {
                this.sortBasedOnString(stringArray, logDataArray, bl);
            }
            if (nArray != null) {
                this.sortBasedOnInt(nArray, logDataArray, bl);
            }
        } else {
            this.sortBasedOnLineNumber(logDataArray, bl);
        }
    }
}

