/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.AuditLogParser;
import com.netscape.admin.dirserv.status.AuditLogReader;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.admin.dirserv.status.ILogFileListener;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.LogReaderException;
import com.netscape.admin.dirserv.status.NoLogsAvailableException;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class StatusAuditLogPanel
extends StatusRefreshPanel
implements ItemListener,
ILogFileListener {
    private JTextField _tfEntriesToShow;
    private JTextField _tfFilter;
    private JComboBox _comboFileName;
    private JTextArea _taLogs;
    private ArrayList _logFiles;
    private boolean _ignoreChangeStateEvents;
    private AuditLogReader _logReader;
    private AuditLogParser _logParser;
    private StringBuffer _logLines = new StringBuffer();
    private final int DEFAULT_ENTRY_COUNT = 20;
    private JLabel REFRESH_LABEL;

    public StatusAuditLogPanel(IStatusModel iStatusModel) {
        this._model = iStatusModel;
        this.initResources();
        this.basicLayout(false);
        this._model.getFramework().getServerObject().addLogFileListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._comboFileName) {
            this.refresh();
        }
    }

    public void logFileChanged(int n) {
        if (n == 2) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StatusAuditLogPanel.this.refresh();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected void initResources() {
        this._helpToken = "status-logs-audit-help";
        this._taRights = new MultilineLabel(this._resource.getString("auditlogpanel", "rights-label"), 8, 50);
        this._taError = new MultilineLabel(8, 50);
        this.REFRESH_LABEL = new JLabel(DSStatusPage._resource.getString("auditlogpanel", "reading-label"));
    }

    protected void createContentPane() {
        this._contentPane = new JPanel(new GridBagLayout());
        this._comboFileName = new JComboBox();
        this._comboFileName.addItemListener(this);
        JLabel jLabel = UIFactory.makeJLabel("auditlogpanel", "lselectlog", this._resource);
        jLabel.setLabelFor(this._comboFileName);
        JLabel jLabel2 = UIFactory.makeJLabel("auditlogpanel", "lentriestoshow", this._resource);
        this._tfEntriesToShow = UIFactory.makeJTextField(null, "auditlogpanel", "lentriestoshow", String.valueOf(20), 5, this._resource);
        jLabel2.setLabelFor(this._tfEntriesToShow);
        JLabel jLabel3 = UIFactory.makeJLabel("auditlogpanel", "lfilter", this._resource);
        this._tfFilter = UIFactory.makeJTextField(null, "auditlogpanel", "lfilter", null, 10, this._resource);
        jLabel3.setLabelFor(this._tfFilter);
        this._taLogs = new JTextArea();
        this._taLogs.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.createRefreshArea();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._comboFileName, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets.left = 0;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._tfEntriesToShow, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getDifferentSpace();
        --gridBagConstraints.gridwidth;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._tfFilter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this._contentPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jPanel2, gridBagConstraints);
        this._contentPane.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this._contentPane.add((Component)new JScrollPane(this._taLogs), gridBagConstraints);
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            if (this.hasRights()) {
                try {
                    if (this._contentPane == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this.REFRESH_LABEL, true);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusAuditLogPanel.this._lUpdating.setVisible(true);
                            }
                        });
                    }
                    this.readLogFiles();
                    this.readLogLines();
                    if (this._contentPane == null) {
                        this.createContentPane();
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                StatusAuditLogPanel.this._taLogs.setText(StatusAuditLogPanel.this._logLines.toString());
                                StatusAuditLogPanel.this.updateLogFilesCombo();
                                StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._contentPane, false);
                                StatusAuditLogPanel.this._lUpdating.setVisible(false);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (LogReaderException logReaderException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusAuditLogPanel.this._taError.setText(logReaderException.getMessage());
                            StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._taError, true);
                        }
                    });
                }
                catch (LDAPException lDAPException) {
                    final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusAuditLogPanel.this._taError.setText(StatusAuditLogPanel.this._resource.getString("auditlogpanel", "error-reading-logfiles-label", stringArray));
                            StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._taError, true);
                        }
                    });
                }
                catch (NullPointerException nullPointerException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._taRights, true);
                        }
                    });
                }
                catch (NoLogsAvailableException noLogsAvailableException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusAuditLogPanel.this._taError.setText(StatusAuditLogPanel.this._resource.getString("auditlogpanel", "no-log-files-available-label"));
                            StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._taError, true);
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusAuditLogPanel.this.showComponent(StatusAuditLogPanel.this._taRights, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    protected boolean hasRights() {
        DSAdmin dSAdmin = this._model.getFramework().getServerObject();
        boolean bl = dSAdmin.isTaskAvailable("ViewLog");
        return bl;
    }

    protected void createParser() {
        this._logParser = new AuditLogParser();
    }

    private void readLogLines() throws LogReaderException {
        Object object;
        if (this._logReader == null) {
            this._logReader = new AuditLogReader();
            this._logReader.setServerInfo(this.getServerInfo());
            this._logParser = new AuditLogParser();
            this._logReader.setParser(this._logParser);
        }
        this._logParser.reset();
        if (this._contentPane != null) {
            object = (String)this._comboFileName.getSelectedItem();
            this._logReader.setLogFileName((String)object);
            int n = 0;
            try {
                n = Integer.parseInt(this._tfEntriesToShow.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                n = this._logReader.getEntryCount();
                String string = String.valueOf(n);
                this._tfEntriesToShow.setText(string);
            } else {
                this._logReader.setEntryCount(n);
            }
            this._logReader.setFilter(this._tfFilter.getText());
        } else {
            object = (String)this._logFiles.get(0);
            this._logReader.setLogFileName((String)object);
            this._logReader.setEntryCount(20);
        }
        object = this._logReader.getLogs();
        this._logLines = this._logLines.delete(0, this._logLines.length());
        ListIterator listIterator = ((AbstractList)object).listIterator();
        if (listIterator.hasNext()) {
            this._logLines.append((String)listIterator.next());
        }
        while (listIterator.hasNext()) {
            this._logLines.append('\n');
            this._logLines.append((String)listIterator.next());
        }
    }

    private void readLogFiles() throws LDAPException, NoLogsAvailableException {
        Enumeration enumeration;
        if (this._logFiles == null) {
            this._logFiles = new ArrayList();
        } else {
            this._logFiles.clear();
        }
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"nsslapd-auditlog", "nsslapd-auditlog-list"};
        LDAPEntry lDAPEntry = lDAPConnection.read("cn=config", stringArray);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-auditlog");
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                this._logFiles.add(enumeration.nextElement());
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("nsslapd-auditlog-list")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                this._logFiles.add(enumeration.nextElement());
            }
        }
        if (this._logFiles.size() == 0) {
            throw new NoLogsAvailableException();
        }
    }

    private void updateLogFilesCombo() {
        this._ignoreChangeStateEvents = true;
        Object object = this._comboFileName.getSelectedItem();
        Object var2_2 = null;
        this._comboFileName.removeAllItems();
        ListIterator listIterator = ((AbstractList)this._logFiles).listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            this._comboFileName.addItem(e);
            if (var2_2 != null || !e.equals(object)) continue;
            var2_2 = e;
        }
        if (var2_2 == null) {
            this._comboFileName.setSelectedIndex(0);
        } else {
            this._comboFileName.setSelectedItem(var2_2);
        }
        this._ignoreChangeStateEvents = false;
    }
}

