/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.LabelCellRenderer;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.ChainingSuffixInfo;
import com.netscape.admin.dirserv.status.ChainingSuffixTableModel;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

class StatusChainingSuffixPanel
extends StatusRefreshPanel
implements ListSelectionListener {
    private JTable _table;
    private ChainingSuffixTableModel _tableModel;
    private JList _list;
    private DefaultListModel _listModel;
    private Hashtable _htData;
    private Hashtable _htReadData;
    private ArrayList _suffixList;
    private ChainingSuffixInfo VOID_CHAINING_SUFFIX_INFO;
    private final JLabel REFRESH_LABEL;
    private final String NO_CHAINING_SUFFIXES_AVAILABLE;
    private final String[] ATTRS;
    private final int TABLE_ROWS = 13;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JLabel;

    public StatusChainingSuffixPanel(IStatusModel iStatusModel) {
        super(iStatusModel, true);
        this.REFRESH_LABEL = new JLabel(this._resource.getString("chainingsuffixpanel", "reading-label"));
        this.NO_CHAINING_SUFFIXES_AVAILABLE = this._resource.getString("chainingsuffixpanel", "nochainingsuffixesavailable-label");
        this.ATTRS = new String[]{"nsbindcount", "nsunbindcount", "nssearchbasecount", "nssearchonelevelcount", "nssearchsubtreecount", "nsaddcount", "nsdeletecount", "nscomparecount", "nsmodifycount", "nsrenamecount", "nsabandoncount", "nsopenbindconnectioncount", "nsopenopconnectioncount"};
        this.TABLE_ROWS = 13;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this._list.getSelectedValue();
        if (e != null && e != this.NO_CHAINING_SUFFIXES_AVAILABLE) {
            this._tableModel.updateData((ChainingSuffixInfo)this._htData.get(e));
        } else {
            this._tableModel.updateData(this.VOID_CHAINING_SUFFIX_INFO);
        }
    }

    protected void initResources() {
        this._helpToken = "status-chainingsuffix-help";
        this._taRights = new MultilineLabel(this._resource.getString("chainingsuffixpanel", "rights-label"), 2, 50);
        this._taError = new MultilineLabel(2, 50);
        this.VOID_CHAINING_SUFFIX_INFO = new ChainingSuffixInfo();
        this.VOID_CHAINING_SUFFIX_INFO.bindCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.unbindCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.searchBaseCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.searchOneCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.searchSubtreeCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.addCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.deleteCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.compareCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.modifyCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.renameCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.abandonCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.openBoundConnectionCount = "";
        this.VOID_CHAINING_SUFFIX_INFO.openOperationMadeConnectionCount = "";
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            try {
                if (this._contentPane == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusChainingSuffixPanel.this.showComponent(StatusChainingSuffixPanel.this.REFRESH_LABEL, true);
                        }
                    });
                    this.createContentPane();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusChainingSuffixPanel.this._lUpdating.setVisible(true);
                        }
                    });
                }
                this.readData();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusChainingSuffixPanel.this.updatePanelData();
                        StatusChainingSuffixPanel.this.showComponent(StatusChainingSuffixPanel.this._contentPane, false);
                        StatusChainingSuffixPanel.this._lUpdating.setVisible(false);
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusChainingSuffixPanel.this.showComponent(StatusChainingSuffixPanel.this._taRights, true);
                    }
                });
            }
            catch (LDAPException lDAPException) {
                final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusChainingSuffixPanel.this._taError.setText(StatusChainingSuffixPanel.this._resource.getString("chainingsuffixpanel", "error-reloading-label", stringArray));
                        StatusChainingSuffixPanel.this.showComponent(StatusChainingSuffixPanel.this._taError, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    private void createContentPane() {
        this._contentPane = new JPanel(new GridBagLayout());
        JPanel jPanel = this.createRefreshArea();
        JLabel[] jLabelArray = new JLabel[13];
        int n = 0;
        while (n < 13) {
            jLabelArray[n] = UIFactory.makeJLabel("chainingsuffixpanel", "tablelabel" + n, this._resource);
            ++n;
        }
        this._tableModel = new ChainingSuffixTableModel();
        this._tableModel.updateData(this.VOID_CHAINING_SUFFIX_INFO);
        this._tableModel.setLabels(jLabelArray);
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this._table = new JTable(this._tableModel);
        this._table.setAutoResizeMode(3);
        this._table.setColumnSelectionAllowed(false);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusChainingSuffixPanel.class$("java.lang.String")) : class$java$lang$String, labelCellRenderer);
        this._table.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = StatusChainingSuffixPanel.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, labelCellRenderer);
        this._table.getTableHeader().setReorderingAllowed(false);
        this.setTableSize();
        JLabel jLabel = UIFactory.makeJLabel("chainingsuffixpanel", "ltable", this._resource);
        jLabel.setLabelFor(this._table);
        JScrollPane jScrollPane = new JScrollPane(this._table, 21, 30);
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel);
        this._list.setSelectionMode(0);
        this._list.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this._list, 20, 30);
        Component component = this._list.getCellRenderer().getListCellRendererComponent(this._list, "12345678901234567890", 0, true, true);
        jScrollPane2.setPreferredSize(new Dimension((int)component.getPreferredSize().getWidth(), (int)jScrollPane2.getPreferredSize().getHeight()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this._contentPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.gridwidth = -1;
        this._contentPane.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.7;
        this._contentPane.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPane.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void setTableSize() {
        Component component;
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        int n = 0;
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        int n2 = 0;
        TableCellRenderer tableCellRenderer = this._table.getCellRenderer(0, 0);
        int n3 = 0;
        while (n3 < this._table.getRowCount()) {
            component = tableCellRenderer.getTableCellRendererComponent(this._table, this._table.getValueAt(n3, 0), true, true, n3, 0);
            int n4 = (int)component.getPreferredSize().getWidth();
            n2 = Math.max(n2, n4);
            ++n3;
        }
        tableColumn.setPreferredWidth(n2 += this._table.getIntercellSpacing().width);
        n += n2;
        tableColumn = tableColumnModel.getColumn(1);
        tableCellRenderer = this._table.getCellRenderer(0, 1);
        component = tableCellRenderer.getTableCellRendererComponent(this._table, "1000000000", true, true, 0, 1);
        n2 = (int)component.getPreferredSize().getWidth() + this._table.getIntercellSpacing().width;
        tableColumn.setPreferredWidth(n2);
        this._table.setPreferredScrollableViewportSize(new Dimension(n += n2, this._table.getRowCount() * this._table.getRowHeight()));
    }

    private void readData() throws LDAPException {
        Database database;
        Object object;
        Suffix suffix;
        if (this._suffixList == null) {
            this._suffixList = new ArrayList();
        } else {
            this._suffixList.clear();
        }
        DatabaseConfig databaseConfig = this._model.getFramework().getServerObject().getDatabaseConfig();
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext()) {
            suffix = (Suffix)listIterator.next();
            object = suffix.getDatabases();
            if (object == null || ((Vector)object).size() != 1 || (database = (Database)((Vector)object).elementAt(0)).getType() != 1) continue;
            this._suffixList.add(suffix);
        }
        if (this._htReadData == null) {
            this._htReadData = new Hashtable(this._suffixList.size());
        } else {
            this._htReadData.clear();
        }
        listIterator = ((AbstractList)this._suffixList).listIterator();
        suffix = this.getServerInfo().getLDAPConnection();
        while (listIterator.hasNext()) {
            object = (Suffix)listIterator.next();
            database = (Database)((Suffix)object).getDatabases().get(0);
            try {
                String string = "cn=monitor, " + database.getDn();
                LDAPEntry lDAPEntry = suffix.read(string);
                if (lDAPEntry == null) {
                    throw new NullPointerException();
                }
                ChainingSuffixInfo chainingSuffixInfo = new ChainingSuffixInfo();
                this.updateChainingSuffixInfo(chainingSuffixInfo, lDAPEntry);
                this._htReadData.put(((Suffix)object).getName(), chainingSuffixInfo);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) continue;
                throw lDAPException;
            }
        }
    }

    private void updateChainingSuffixInfo(ChainingSuffixInfo chainingSuffixInfo, LDAPEntry lDAPEntry) {
        chainingSuffixInfo.bindCount = DSUtil.getAttrValue(lDAPEntry, "nsbindcount");
        chainingSuffixInfo.unbindCount = DSUtil.getAttrValue(lDAPEntry, "nsunbindcount");
        chainingSuffixInfo.searchBaseCount = DSUtil.getAttrValue(lDAPEntry, "nssearchbasecount");
        chainingSuffixInfo.searchOneCount = DSUtil.getAttrValue(lDAPEntry, "nssearchonelevelcount");
        chainingSuffixInfo.searchSubtreeCount = DSUtil.getAttrValue(lDAPEntry, "nssearchsubtreecount");
        chainingSuffixInfo.addCount = DSUtil.getAttrValue(lDAPEntry, "nsaddcount");
        chainingSuffixInfo.deleteCount = DSUtil.getAttrValue(lDAPEntry, "nsdeletecount");
        chainingSuffixInfo.compareCount = DSUtil.getAttrValue(lDAPEntry, "nscomparecount");
        chainingSuffixInfo.modifyCount = DSUtil.getAttrValue(lDAPEntry, "nsmodifycount");
        chainingSuffixInfo.renameCount = DSUtil.getAttrValue(lDAPEntry, "nsrenamecount");
        chainingSuffixInfo.abandonCount = DSUtil.getAttrValue(lDAPEntry, "nsabandoncount");
        chainingSuffixInfo.openBoundConnectionCount = DSUtil.getAttrValue(lDAPEntry, "nsopenbindconnectioncount");
        chainingSuffixInfo.openOperationMadeConnectionCount = DSUtil.getAttrValue(lDAPEntry, "nsopenopconnectioncount");
    }

    private void updatePanelData() {
        if (this._htData == null) {
            this._htData = new Hashtable(this._suffixList.size());
        } else {
            this._htData.clear();
        }
        this._htData.putAll(this._htReadData);
        Object e = this._list.getSelectedValue();
        this._listModel.clear();
        ListIterator listIterator = ((AbstractList)this._suffixList).listIterator();
        while (listIterator.hasNext()) {
            this._listModel.addElement(((Suffix)listIterator.next()).getName());
        }
        if (e != null && this._listModel.contains(e)) {
            this._list.setSelectedValue(e, true);
        }
        if (this._listModel.getSize() == 0) {
            this._listModel.addElement(this.NO_CHAINING_SUFFIXES_AVAILABLE);
            this._list.setEnabled(false);
        } else {
            this._list.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

