/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.status.ErrorLogData;
import com.netscape.admin.dirserv.status.ErrorLogParser;
import com.netscape.admin.dirserv.status.ErrorLogTableModel;
import com.netscape.admin.dirserv.status.ILogFileListener;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.LogData;
import com.netscape.admin.dirserv.status.StatusLogBasePanel;
import com.netscape.admin.dirserv.status.TableViewOptions;
import com.netscape.management.client.util.MultilineLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class StatusErrorLogPanel
extends StatusLogBasePanel
implements ILogFileListener {
    private String[] _headers;

    public StatusErrorLogPanel(IStatusModel iStatusModel) {
        super(iStatusModel);
        this._model.getFramework().getServerObject().addLogFileListener(this);
    }

    public void logFileChanged(int n) {
        if (n == 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    StatusErrorLogPanel.this.refresh();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected void initResources() {
        this._helpToken = "status-logs-error-help";
        this._taRights = new MultilineLabel(this._resource.getString("errorlogpanel", "rights-label"), 8, 50);
        this._taError = new MultilineLabel(8, 50);
        this.CURRENT_LOG_FILE_ATTRIBUTE = "nsslapd-errorlog";
        this.LOG_FILE_LIST_ATTRIBUTE = "nsslapd-errorlog-list";
        this.LOG_SORTED_BY = "ERRORLOG_SORTED_BY";
        this.LOG_SORT_ASCENDING = "ERRORLOG_SORT_ASCENDING";
        this.LOG_VISIBLE_COLUMNS = "ERRORLOG_VISIBLE_COLUMNS";
        this.LOG_COLUMN_ORDER = "ERRORLOG_COLUMN_ORDER";
        String[] stringArray = new String[]{this._resource.getString("errorlogpanel", "date-header"), this._resource.getString("errorlogpanel", "messagetype-header"), this._resource.getString("errorlogpanel", "source-header"), this._resource.getString("errorlogpanel", "connectionnumber-header"), this._resource.getString("errorlogpanel", "operationnumber-header"), this._resource.getString("errorlogpanel", "messageid-header"), this._resource.getString("errorlogpanel", "detail-header")};
        this._headers = stringArray;
        String[] stringArray2 = new String[]{this._resource.getString("errorlogpanel", "date-tooltip"), this._resource.getString("errorlogpanel", "messagetype-tooltip"), this._resource.getString("errorlogpanel", "source-tooltip"), this._resource.getString("errorlogpanel", "connectionnumber-tooltip"), this._resource.getString("errorlogpanel", "operationnumber-tooltip"), this._resource.getString("errorlogpanel", "messageid-tooltip"), this._resource.getString("errorlogpanel", "detail-tooltip")};
        this._toolTips = stringArray2;
    }

    protected void createTableModel() {
        this._tableModel = new ErrorLogTableModel();
        ((ErrorLogTableModel)this._tableModel).setHeaders(this._headers);
    }

    protected void createDefaultViewOptions() {
        int n;
        this._defaultViewOptions = new TableViewOptions();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[tableColumnModel.getColumnCount()];
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            tableColumnArray[n2] = tableColumnModel.getColumn(n2);
            ++n2;
        }
        this._defaultViewOptions.init(tableColumnArray, 0, true);
        if (this._toolTips != null) {
            n = 0;
            while (n < this._defaultViewOptions.columns.length) {
                this._defaultViewOptions.columns[n].toolTip = this._toolTips[n];
                ++n;
            }
        }
        n = 0;
        while (n < this._defaultViewOptions.columns.length) {
            this._defaultViewOptions.columns[n].isVisible = true;
            ++n;
        }
    }

    protected void updateTableModel(LogData[] logDataArray) {
        ((ErrorLogTableModel)this._tableModel).updateData(logDataArray);
    }

    protected void createParser() {
        this._logParser = new ErrorLogParser();
    }

    protected void sortLogs(LogData[] logDataArray, int n, boolean bl) {
        if (n != 0) {
            String[] stringArray = null;
            int[] nArray = null;
            switch (n) {
                case 1: {
                    stringArray = new String[logDataArray.length];
                    int n2 = 0;
                    while (n2 < logDataArray.length) {
                        stringArray[n2] = ((ErrorLogData)logDataArray[n2]).messageType;
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    stringArray = new String[logDataArray.length];
                    int n3 = 0;
                    while (n3 < logDataArray.length) {
                        stringArray[n3] = ((ErrorLogData)logDataArray[n3]).source;
                        ++n3;
                    }
                    break;
                }
                case 3: {
                    nArray = new int[logDataArray.length];
                    int n4 = 0;
                    while (n4 < logDataArray.length) {
                        if (logDataArray[n4].connectionNumber.length() > 0) {
                            try {
                                nArray[n4] = Integer.parseInt(logDataArray[n4].connectionNumber);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n4] = -2;
                        }
                        ++n4;
                    }
                    break;
                }
                case 4: {
                    nArray = new int[logDataArray.length];
                    int n5 = 0;
                    while (n5 < logDataArray.length) {
                        if (logDataArray[n5].operationNumber.length() > 0) {
                            try {
                                nArray[n5] = Integer.parseInt(logDataArray[n5].operationNumber);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n5] = -2;
                        }
                        ++n5;
                    }
                    break;
                }
                case 5: {
                    nArray = new int[logDataArray.length];
                    int n6 = 0;
                    while (n6 < logDataArray.length) {
                        if (logDataArray[n6].messageId.length() > 0) {
                            try {
                                nArray[n6] = Integer.parseInt(logDataArray[n6].messageId);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            nArray[n6] = -2;
                        }
                        ++n6;
                    }
                    break;
                }
                case 6: {
                    stringArray = new String[logDataArray.length];
                    int n7 = 0;
                    while (n7 < logDataArray.length) {
                        stringArray[n7] = logDataArray[n7].detail;
                        ++n7;
                    }
                    break;
                }
                default: {
                    Thread.dumpStack();
                }
            }
            if (stringArray != null) {
                this.sortBasedOnString(stringArray, logDataArray, bl);
            }
            if (nArray != null) {
                this.sortBasedOnInt(nArray, logDataArray, bl);
            }
        } else {
            this.sortBasedOnLineNumber(logDataArray, bl);
        }
    }
}

