/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.AccessErrorLogReader;
import com.netscape.admin.dirserv.status.DSStatusPage;
import com.netscape.admin.dirserv.status.ILogParser;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.LogData;
import com.netscape.admin.dirserv.status.LogReaderException;
import com.netscape.admin.dirserv.status.NoLogsAvailableException;
import com.netscape.admin.dirserv.status.SortTableHeaderRenderer;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.admin.dirserv.status.TableViewOptions;
import com.netscape.admin.dirserv.status.ToolTipCellRenderer;
import com.netscape.admin.dirserv.status.ViewOptionsDialog;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public abstract class StatusLogBasePanel
extends StatusRefreshPanel
implements ItemListener,
TableColumnModelListener {
    private AccessErrorLogReader _logReader;
    private JButton _bViewOptions;
    protected TableModel _tableModel;
    protected JTable _table;
    protected String[] _toolTips;
    private boolean _tableInitialized;
    private ViewOptionsDialog _viewDlg;
    protected TableViewOptions _viewOptions;
    protected TableViewOptions _defaultViewOptions;
    protected ILogParser _logParser;
    private boolean _ignoreColumnModelEvents = false;
    private JTextField _tfLinesToShow;
    private JTextField _tfFilter;
    private JComboBox _comboFileName;
    private JCheckBox _cbDoNotShowConsoleLogs;
    private ArrayList _logFiles;
    private int _connectionId;
    private boolean _ignoreChangeStateEvents;
    protected String CURRENT_LOG_FILE_ATTRIBUTE;
    protected String LOG_FILE_LIST_ATTRIBUTE;
    protected String LOG_SORTED_BY;
    protected String LOG_SORT_ASCENDING;
    protected String LOG_VISIBLE_COLUMNS;
    protected String LOG_COLUMN_ORDER;
    private LogData[] _logLines;
    protected Preferences _preferences = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0").getPreferences("DS_MISCELLANEOUS");
    private final int DEFAULT_LINE_COUNT = 50;
    private final JLabel REFRESH_LABEL = new JLabel(DSStatusPage._resource.getString("logbasepanel", "reading-label"));
    static /* synthetic */ Class class$java$lang$String;

    public StatusLogBasePanel(IStatusModel iStatusModel) {
        this._model = iStatusModel;
        this.initResources();
        this.basicLayout(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bViewOptions) {
            this.actionViewOptions();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._comboFileName) {
            this.refresh();
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (!this._ignoreColumnModelEvents && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
            TableColumnModel tableColumnModel = (TableColumnModel)tableColumnModelEvent.getSource();
            int n = -1;
            TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModelEvent.getFromIndex());
            int n2 = -1;
            TableColumn tableColumn2 = tableColumnModel.getColumn(tableColumnModelEvent.getToIndex());
            int n3 = this._viewOptions.columns.length;
            int n4 = 0;
            while (n4 < n3 && (n == -1 || n2 == -1)) {
                TableColumn tableColumn3 = this._viewOptions.columns[n4].column;
                if (tableColumn3 == tableColumn) {
                    n = n4;
                } else if (tableColumn3 == tableColumn2) {
                    n2 = n4;
                }
                ++n4;
            }
            int n5 = this._viewOptions.columns[n].position;
            this._viewOptions.columns[n].position = this._viewOptions.columns[n2].position;
            this._viewOptions.columns[n2].position = n5;
            String string = "";
            int n6 = 0;
            while (n6 < this._viewOptions.columns.length) {
                string = n6 == 0 ? string + String.valueOf(this._viewOptions.columns[n6].position) : string + " " + this._viewOptions.columns[n6].position;
                ++n6;
            }
            this._preferences.set(this.LOG_COLUMN_ORDER, string);
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void createContentPane() {
        Serializable serializable;
        this._contentPane = new JPanel(new GridBagLayout());
        this._comboFileName = new JComboBox();
        this._comboFileName.addItemListener(this);
        JLabel jLabel = UIFactory.makeJLabel("logbasepanel", "lselectlog", this._resource);
        jLabel.setLabelFor(this._comboFileName);
        JLabel jLabel2 = UIFactory.makeJLabel("logbasepanel", "llinestoshow", this._resource);
        this._tfLinesToShow = UIFactory.makeJTextField(null, "logbasepanel", "llinestoshow", String.valueOf(50), 5, this._resource);
        jLabel2.setLabelFor(this._tfLinesToShow);
        JLabel jLabel3 = UIFactory.makeJLabel("logbasepanel", "lfilter", this._resource);
        this._tfFilter = UIFactory.makeJTextField(null, "logbasepanel", "lfilter", null, 10, this._resource);
        jLabel3.setLabelFor(this._tfFilter);
        this._cbDoNotShowConsoleLogs = UIFactory.makeJCheckBox(null, "logbasepanel", "cbdonotshowconsolelogs", false, this._resource);
        this.createTableModel();
        this._table = new JTable(this._tableModel);
        this._table.setAutoResizeMode(3);
        this._table.setColumnSelectionAllowed(false);
        ToolTipCellRenderer toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(this._toolTips);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusLogBasePanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = StatusLogBasePanel.this._table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = StatusLogBasePanel.this._table.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    StatusLogBasePanel.this._viewOptions.sortAscending = !StatusLogBasePanel.this._viewOptions.sortAscending;
                    StatusLogBasePanel.this._viewOptions.sortedBy = n2;
                    SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)StatusLogBasePanel.this._viewOptions.columns[0].column.getHeaderRenderer());
                    sortTableHeaderRenderer.setSortAscending(StatusLogBasePanel.this._viewOptions.sortAscending);
                    sortTableHeaderRenderer.setSortColumn(StatusLogBasePanel.this._viewOptions.sortedBy);
                    StatusLogBasePanel.this._preferences.set(StatusLogBasePanel.this.LOG_SORTED_BY, StatusLogBasePanel.this._viewOptions.sortedBy);
                    StatusLogBasePanel.this._preferences.set(StatusLogBasePanel.this.LOG_SORT_ASCENDING, StatusLogBasePanel.this._viewOptions.sortAscending);
                    StatusLogBasePanel.this.sortLogs(StatusLogBasePanel.this._logLines, StatusLogBasePanel.this._viewOptions.sortedBy, StatusLogBasePanel.this._viewOptions.sortAscending);
                    StatusLogBasePanel.this._table.tableChanged(new TableModelEvent(StatusLogBasePanel.this._tableModel));
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.addColumnModelListener(this);
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        SortTableHeaderRenderer sortTableHeaderRenderer = new SortTableHeaderRenderer();
        sortTableHeaderRenderer.setDefaultHeaderRenderer(tableColumnModel.getColumn(0).getHeaderRenderer());
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setHeaderRenderer((TableCellRenderer)((Object)sortTableHeaderRenderer));
        }
        serializable = new GridBagConstraints();
        JPanel jPanel = this.createRefreshArea();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable).anchor = 17;
        jPanel2.add((Component)jLabel, serializable);
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._comboFileName, serializable);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).gridwidth = 4;
        ((GridBagConstraints)serializable).insets.left = 0;
        jPanel3.add((Component)jLabel2, serializable);
        --((GridBagConstraints)serializable).gridwidth;
        ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._tfLinesToShow, serializable);
        ((GridBagConstraints)serializable).insets.left = UIFactory.getDifferentSpace();
        --((GridBagConstraints)serializable).gridwidth;
        jPanel3.add((Component)jLabel3, serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).insets.left = UIFactory.getComponentSpace();
        jPanel3.add((Component)this._tfFilter, serializable);
        ((GridBagConstraints)serializable).insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        this._contentPane.add((Component)jPanel, serializable);
        ((GridBagConstraints)serializable).insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jPanel2, serializable);
        this._contentPane.add((Component)jPanel3, serializable);
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).anchor = 17;
        this._contentPane.add((Component)this._cbDoNotShowConsoleLogs, serializable);
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this._contentPane.add((Component)new JScrollPane(this._table), serializable);
    }

    protected JPanel createButtonPanel() {
        this._bHelp = UIFactory.makeJButton(this, "refreshpanel", "bhelp", this._resource);
        this._bViewOptions = UIFactory.makeJButton(this, "logbasepanel", "bviewoptions", this._resource);
        this._bViewOptions.setVisible(false);
        this._bHelp.setVisible(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this._bViewOptions, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bHelp, gridBagConstraints);
        return jPanel;
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            if (this.hasRights()) {
                try {
                    if (this._contentPane == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this.REFRESH_LABEL, true);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                StatusLogBasePanel.this._lUpdating.setVisible(true);
                            }
                        });
                    }
                    this.readConnectionId();
                    this.readLogFiles();
                    this.readLogLines();
                    if (this._contentPane == null) {
                        this.createContentPane();
                        this.createDefaultViewOptions();
                        this.createViewOptions();
                    }
                    this.sortLogs(this._logLines, this._viewOptions.sortedBy, this._viewOptions.sortAscending);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                StatusLogBasePanel.this.updateTableModel(StatusLogBasePanel.this._logLines);
                                if (!StatusLogBasePanel.this._tableInitialized) {
                                    StatusLogBasePanel.this.updateTableWithViewOptions(StatusLogBasePanel.this._viewOptions);
                                    StatusLogBasePanel.this._tableInitialized = true;
                                }
                                StatusLogBasePanel.this.updateLogFilesCombo();
                                StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._contentPane, false);
                                StatusLogBasePanel.this._lUpdating.setVisible(false);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (LogReaderException logReaderException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusLogBasePanel.this._taError.setText(logReaderException.getMessage());
                            StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._taError, true);
                        }
                    });
                }
                catch (LDAPException lDAPException) {
                    final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusLogBasePanel.this._taError.setText(StatusLogBasePanel.this._resource.getString("logbasepanel", "error-reading-logfiles-label", stringArray));
                            StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._taError, true);
                        }
                    });
                }
                catch (NullPointerException nullPointerException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._taRights, true);
                        }
                    });
                }
                catch (NoLogsAvailableException noLogsAvailableException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusLogBasePanel.this._taError.setText(StatusLogBasePanel.this._resource.getString("logbasepanel", "no-log-files-available-label"));
                            StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._taError, true);
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusLogBasePanel.this.showComponent(StatusLogBasePanel.this._taRights, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    protected boolean hasRights() {
        DSAdmin dSAdmin = this._model.getFramework().getServerObject();
        boolean bl = dSAdmin.isTaskAvailable("ViewLog");
        return bl;
    }

    protected void showComponent(JComponent jComponent, boolean bl) {
        super.showComponent(jComponent, bl);
        this._bViewOptions.setVisible(!bl);
    }

    protected void sortBasedOnLineNumber(LogData[] logDataArray, boolean bl) {
        int n = 0;
        while (n < logDataArray.length - 1) {
            int n2 = n + 1;
            while (n2 < logDataArray.length) {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = logDataArray[n].logLineNumber > logDataArray[n2].logLineNumber;
                boolean bl5 = bl ? bl3 : (bl2 = !bl3);
                if (bl2) {
                    LogData logData = logDataArray[n];
                    logDataArray[n] = logDataArray[n2];
                    logDataArray[n2] = logData;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void sortBasedOnInt(int[] nArray, LogData[] logDataArray, boolean bl) {
        int n = 0;
        while (n < nArray.length - 1) {
            int n2 = n + 1;
            while (n2 < nArray.length) {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = nArray[n] > nArray[n2];
                if (!bl3 && nArray[n] == nArray[n2]) {
                    boolean bl5 = bl3 = logDataArray[n].logLineNumber > logDataArray[n2].logLineNumber;
                }
                boolean bl6 = bl ? bl3 : (bl2 = !bl3);
                if (bl2) {
                    int n3 = nArray[n];
                    nArray[n] = nArray[n2];
                    nArray[n2] = n3;
                    LogData logData = logDataArray[n];
                    logDataArray[n] = logDataArray[n2];
                    logDataArray[n2] = logData;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void sortBasedOnString(String[] stringArray, LogData[] logDataArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = stringArray[n].compareTo(stringArray[n2]) > 0;
                if (!bl3 && stringArray[n].equals(stringArray[n2])) {
                    boolean bl5 = bl3 = logDataArray[n].logLineNumber > logDataArray[n2].logLineNumber;
                }
                boolean bl6 = bl ? bl3 : (bl2 = !bl3);
                if (bl2) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n2];
                    stringArray[n2] = string;
                    LogData logData = logDataArray[n];
                    logDataArray[n] = logDataArray[n2];
                    logDataArray[n2] = logData;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected abstract void createTableModel();

    protected abstract void createDefaultViewOptions();

    protected abstract void updateTableModel(LogData[] var1);

    protected abstract void createParser();

    protected abstract void sortLogs(LogData[] var1, int var2, boolean var3);

    private void readLogLines() throws LogReaderException {
        Object object;
        if (this._logReader == null) {
            this._logReader = new AccessErrorLogReader();
            this._logReader.setServerInfo(this.getServerInfo());
            this.createParser();
            this._logReader.setParser(this._logParser);
        }
        this._logParser.reset();
        if (this._contentPane != null) {
            object = (String)this._comboFileName.getSelectedItem();
            this._logReader.setLogFileName((String)object);
            int n = 0;
            try {
                n = Integer.parseInt(this._tfLinesToShow.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                n = this._logReader.getLineCount();
                String string = String.valueOf(n);
                this._tfLinesToShow.setText(string);
            } else {
                this._logReader.setLineCount(n);
            }
            this._logReader.setFilter(this._tfFilter.getText());
            if (this._cbDoNotShowConsoleLogs.isSelected()) {
                this._logReader.ignoreConnection(this._connectionId);
            } else {
                this._logReader.ignoreConnection(-1);
            }
        } else {
            object = (String)this._logFiles.get(0);
            this._logReader.setLogFileName((String)object);
            this._logReader.setLineCount(50);
        }
        object = this._logReader.getLogs();
        this._logLines = new LogData[((ArrayList)object).size()];
        ((ArrayList)object).toArray(this._logLines);
    }

    private void readLogFiles() throws LDAPException, NoLogsAvailableException {
        Enumeration enumeration;
        if (this._logFiles == null) {
            this._logFiles = new ArrayList();
        } else {
            this._logFiles.clear();
        }
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{this.CURRENT_LOG_FILE_ATTRIBUTE, this.LOG_FILE_LIST_ATTRIBUTE};
        LDAPEntry lDAPEntry = lDAPConnection.read("cn=config", stringArray);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.CURRENT_LOG_FILE_ATTRIBUTE);
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                this._logFiles.add(enumeration.nextElement());
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute(this.LOG_FILE_LIST_ATTRIBUTE)) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                this._logFiles.add(enumeration.nextElement());
            }
        }
        if (this._logFiles.size() == 0) {
            throw new NoLogsAvailableException();
        }
    }

    private void readConnectionId() throws LDAPException {
        Enumeration enumeration;
        this._connectionId = -1;
        String[] stringArray = new String[]{"ClientConnectionID"};
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        LDAPEntry lDAPEntry = lDAPConnection.read("cn=monitor", stringArray);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("ClientConnectionID");
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                this._connectionId = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateLogFilesCombo() {
        this._ignoreChangeStateEvents = true;
        Object object = this._comboFileName.getSelectedItem();
        Object var2_2 = null;
        this._comboFileName.removeAllItems();
        ListIterator listIterator = ((AbstractList)this._logFiles).listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            this._comboFileName.addItem(e);
            if (var2_2 != null || !e.equals(object)) continue;
            var2_2 = e;
        }
        if (var2_2 == null) {
            this._comboFileName.setSelectedIndex(0);
        } else {
            this._comboFileName.setSelectedItem(var2_2);
        }
        this._ignoreChangeStateEvents = false;
    }

    private void createViewOptions() {
        this._viewOptions = new TableViewOptions();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[tableColumnModel.getColumnCount()];
        int n = 0;
        while (n < tableColumnArray.length) {
            tableColumnArray[n] = tableColumnModel.getColumn(n);
            ++n;
        }
        int n2 = this._preferences.getInt(this.LOG_SORTED_BY, this._defaultViewOptions.sortedBy);
        boolean bl = this._preferences.getBoolean(this.LOG_SORT_ASCENDING, this._defaultViewOptions.sortAscending);
        this._viewOptions.init(tableColumnArray, n2, bl);
        SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
        sortTableHeaderRenderer.setSortAscending(this._viewOptions.sortAscending);
        sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
        String string = "";
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < this._defaultViewOptions.columns.length) {
            if (this._defaultViewOptions.columns[n3].isVisible) {
                string = bl2 ? string + " " + n3 : string + String.valueOf(n3);
                bl2 = true;
            }
            ++n3;
        }
        String string2 = this._preferences.getString(this.LOG_VISIBLE_COLUMNS, string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                this._viewOptions.columns[n4].isVisible = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string3 = "";
        int n5 = 0;
        while (n5 < this._defaultViewOptions.columns.length) {
            string3 = n5 != 0 ? string3 + " " + this._defaultViewOptions.columns[n5].position : string3 + String.valueOf(this._defaultViewOptions.columns[n5].position);
            ++n5;
        }
        String string4 = this._preferences.getString(this.LOG_COLUMN_ORDER, string3);
        stringTokenizer = new StringTokenizer(string4);
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n7;
                this._viewOptions.columns[n6].position = n7 = Integer.parseInt(stringTokenizer.nextToken());
                if (this._toolTips != null) {
                    this._viewOptions.columns[n6].toolTip = this._toolTips[n6];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n6;
        }
    }

    private void actionViewOptions() {
        if (this._viewDlg == null) {
            this._viewDlg = new ViewOptionsDialog((JFrame)((Object)this._model.getFramework()), this._viewOptions, this._defaultViewOptions);
            this._viewDlg.pack();
        }
        this._viewDlg.updateDialogFromViewOptions(this._viewOptions);
        this._viewDlg.show();
        if (!this._viewDlg.isCancelled()) {
            this._viewDlg.updateViewOptionsFromDialog(this._viewOptions);
            this.sortLogs(this._logLines, this._viewOptions.sortedBy, this._viewOptions.sortAscending);
            this.updateTableWithViewOptions(this._viewOptions);
            this._table.tableChanged(new TableModelEvent(this._tableModel));
            SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
            sortTableHeaderRenderer.setSortAscending(this._viewOptions.sortAscending);
            sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
            this._preferences.set(this.LOG_SORTED_BY, this._viewOptions.sortedBy);
            this._preferences.set(this.LOG_SORT_ASCENDING, this._viewOptions.sortAscending);
            String string = "";
            String string2 = "";
            boolean bl = false;
            int n = 0;
            while (n < this._viewOptions.columns.length) {
                if (this._viewOptions.columns[n].isVisible) {
                    if (bl) {
                        string = string + " " + n;
                    } else {
                        bl = true;
                        string = string + String.valueOf(n);
                    }
                }
                string2 = n == 0 ? string2 + String.valueOf(this._viewOptions.columns[n].position) : string2 + " " + this._viewOptions.columns[n].position;
                ++n;
            }
            this._preferences.set(this.LOG_VISIBLE_COLUMNS, string);
            this._preferences.set(this.LOG_COLUMN_ORDER, string2);
        }
    }

    private void updateTableWithViewOptions(TableViewOptions tableViewOptions) {
        int n;
        int n2;
        this._ignoreColumnModelEvents = true;
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        int n3 = tableColumnModel.getColumnCount();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(n4));
            --n4;
        }
        int n5 = 0;
        while (n5 < tableViewOptions.columns.length) {
            n2 = 0;
            n = 0;
            while (n < tableViewOptions.columns.length && n2 == 0) {
                int n6 = n2 = tableViewOptions.columns[n].position == n5 ? 1 : 0;
                if (n2 != 0 && tableViewOptions.columns[n].isVisible) {
                    tableColumnModel.addColumn(tableViewOptions.columns[n].column);
                }
                ++n;
            }
            ++n5;
        }
        n2 = 0;
        n = 0;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        SortTableHeaderRenderer sortTableHeaderRenderer = (SortTableHeaderRenderer)((Object)this._viewOptions.columns[0].column.getHeaderRenderer());
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            sortTableHeaderRenderer.setSortColumn(n);
            Component component = sortTableHeaderRenderer.getTableCellRendererComponent(this._table, tableColumn.getHeaderValue(), true, true, 0, n);
            TableCellRenderer tableCellRenderer = this._table.getCellRenderer(0, n);
            int n7 = (int)component.getPreferredSize().getWidth();
            int n8 = 0;
            while (n8 < this._table.getRowCount()) {
                component = tableCellRenderer.getTableCellRendererComponent(this._table, this._table.getValueAt(n8, n), true, true, n8, n);
                int n9 = (int)component.getPreferredSize().getWidth();
                n7 = Math.max(n7, n9);
                ++n8;
            }
            tableColumn.setPreferredWidth(n7 += this._table.getIntercellSpacing().width);
            n2 += n7;
            ++n;
        }
        sortTableHeaderRenderer.setSortColumn(this._viewOptions.sortedBy);
        int n10 = this.getWidth() - 2 * UIFactory.getComponentSpace();
        if (n2 > n10) {
            this._table.setAutoResizeMode(0);
        } else {
            this._table.setAutoResizeMode(3);
        }
        this._ignoreColumnModelEvents = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

