/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.IStatusNode;
import com.netscape.admin.dirserv.status.IStatusPanel;
import com.netscape.admin.dirserv.status.StatusChainingSuffixNode;
import com.netscape.admin.dirserv.status.StatusLogNode;
import com.netscape.admin.dirserv.status.StatusNode;
import com.netscape.admin.dirserv.status.StatusReplicationNode;
import com.netscape.admin.dirserv.status.StatusRootPanel;
import com.netscape.admin.dirserv.status.StatusSuffixNode;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class StatusRootNode
extends StatusNode {
    private static final String SERVER_ICON_NAME = "directory.gif";

    public StatusRootNode(IStatusModel iStatusModel) {
        this._model = iStatusModel;
        this._name = this.getServerInfo().getHost() + ":" + this.getServerInfo().getPort();
        this._icon = DSUtil.getPackageImage(SERVER_ICON_NAME);
        this._isLeaf = false;
        this._isRefreshNeededOnExpansion = false;
    }

    public void addChildren() {
        DefaultTreeModel defaultTreeModel = this._model.getTreeModel();
        defaultTreeModel.insertNodeInto(new StatusSuffixNode(this._model), this, 0);
        defaultTreeModel.insertNodeInto(new StatusChainingSuffixNode(this._model), this, 1);
        defaultTreeModel.insertNodeInto(new StatusLogNode(this._model), this, 2);
        defaultTreeModel.insertNodeInto(new StatusReplicationNode(this._model), this, 3);
    }

    public void refreshNode() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            ((IStatusNode)((Object)treeNode)).refreshNode();
        }
        if (this._customPanel != null) {
            this._refreshPanelOnRequest = true;
        }
    }

    protected IStatusPanel createCustomPanel() {
        return new StatusRootPanel(this._model);
    }
}

