/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.status;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.status.DatabaseCacheInfo;
import com.netscape.admin.dirserv.status.DatabaseCacheTableModel;
import com.netscape.admin.dirserv.status.EntryCacheInfo;
import com.netscape.admin.dirserv.status.EntryCacheTableModel;
import com.netscape.admin.dirserv.status.GlobalDatabaseCacheInfo;
import com.netscape.admin.dirserv.status.IStatusModel;
import com.netscape.admin.dirserv.status.ShowSuffixDialog;
import com.netscape.admin.dirserv.status.StatusRefreshPanel;
import com.netscape.admin.dirserv.status.ToolTipCellRenderer;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

class StatusSuffixPanel
extends StatusRefreshPanel
implements TableColumnModelListener,
ListSelectionListener {
    private JTable _tEntryCache;
    private EntryCacheTableModel _modelEntryCache;
    private JList _listIndex;
    private DefaultListModel _listModelIndex;
    private JTable _tIndex;
    private DatabaseCacheTableModel _modelIndex;
    private JTable _tDatabaseCache;
    private DatabaseCacheTableModel _modelDatabaseCache;
    private JTable _tGlobalDatabaseCache;
    private DatabaseCacheTableModel _modelGlobalDatabaseCache;
    private JButton _bShowSuffixes;
    private ArrayList _suffixesToShow;
    private ShowSuffixDialog _showSuffixDlg;
    private JLabel _lWriteEvict;
    private JLabel _lReadEvict;
    private GlobalDatabaseCacheInfo _globalDatabaseCacheInfo;
    private DatabaseCacheInfo[] _databaseCacheInfo;
    private EntryCacheInfo[] _entryCacheInfo;
    private ArrayList _indexNameList;
    private Hashtable _htDbCacheIndex;
    private Hashtable _htReadDbCacheIndex;
    private boolean _ignoreColumnEvents = false;
    private DatabaseCacheInfo VOID_DATABASE_CACHE_INFO;
    private DatabaseCacheInfo[] _voidDatabaseCacheArray;
    private final JLabel REFRESH_LABEL = new JLabel(this._resource.getString("suffixpanel", "reading-label"));
    private static final int ENTRY_CACHE_COLUMNS = 8;
    private static final int DATABASE_CACHE_COLUMS = 6;
    private static final int INDEX_LIST_ROWS = 6;
    private final String[] LDBM_PLUGIN_ATTRS = new String[]{"dbcachehits", "dbcachetries", "dbcachehitratio", "dbcachepagein", "dbcachepageout", "dbcacheroevict", "dbcacherwevict"};
    private final String INDEX_NOT_DEFINED = this._resource.getString("suffixpanel", "indexnotdefined-label");
    private final String UNLIMITED_CACHE_SIZE = this._resource.getString("suffixpanel", "unlimitedcachesize-label");
    private final String NO_INDEX_AVAILABLE = this._resource.getString("suffixpanel", "indexnotavailable-label");
    static /* synthetic */ Class class$java$lang$String;

    public StatusSuffixPanel(IStatusModel iStatusModel) {
        super(iStatusModel, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bShowSuffixes) {
            this.actionShowSuffixes();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this._listIndex.getSelectedValue();
        if (e != null && e != this.NO_INDEX_AVAILABLE) {
            this._modelIndex.updateData((DatabaseCacheInfo[])this._htDbCacheIndex.get(e));
        } else {
            this._modelIndex.updateData(this._voidDatabaseCacheArray);
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (!this._ignoreColumnEvents) {
            this._ignoreColumnEvents = true;
            Object object = changeEvent.getSource();
            if (object == this._tIndex.getColumnModel()) {
                TableColumnModel tableColumnModel = this._tIndex.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = tableColumnModel.getColumn(n2).getWidth();
                    this._tDatabaseCache.getColumnModel().getColumn(n2).setPreferredWidth(n3);
                    this._tGlobalDatabaseCache.getColumnModel().getColumn(n2).setPreferredWidth(n3);
                    ++n2;
                }
            } else if (object == this._tDatabaseCache.getColumnModel()) {
                TableColumnModel tableColumnModel = this._tDatabaseCache.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                int n4 = 0;
                while (n4 < n) {
                    int n5 = tableColumnModel.getColumn(n4).getWidth();
                    this._tIndex.getColumnModel().getColumn(n4).setPreferredWidth(n5);
                    this._tGlobalDatabaseCache.getColumnModel().getColumn(n4).setPreferredWidth(n5);
                    ++n4;
                }
            } else if (object == this._tGlobalDatabaseCache.getColumnModel()) {
                TableColumnModel tableColumnModel = this._tGlobalDatabaseCache.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                int n6 = 0;
                while (n6 < n) {
                    int n7 = tableColumnModel.getColumn(n6).getWidth();
                    this._tIndex.getColumnModel().getColumn(n6).setPreferredWidth(n7);
                    this._tDatabaseCache.getColumnModel().getColumn(n6).setPreferredWidth(n7);
                    ++n6;
                }
            }
            this._ignoreColumnEvents = false;
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (!this._ignoreColumnEvents) {
            this._ignoreColumnEvents = true;
            Object object = tableColumnModelEvent.getSource();
            if (object == this._tIndex.getColumnModel()) {
                if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                    int n = tableColumnModelEvent.getFromIndex();
                    int n2 = tableColumnModelEvent.getToIndex();
                    this._tDatabaseCache.getColumnModel().moveColumn(n, n2);
                    this._tGlobalDatabaseCache.getColumnModel().moveColumn(n, n2);
                }
            } else if (object == this._tDatabaseCache.getColumnModel()) {
                if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                    int n = tableColumnModelEvent.getFromIndex();
                    int n3 = tableColumnModelEvent.getToIndex();
                    this._tIndex.getColumnModel().moveColumn(n, n3);
                    this._tGlobalDatabaseCache.getColumnModel().moveColumn(n, n3);
                }
            } else if (object == this._tGlobalDatabaseCache.getColumnModel() && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                int n = tableColumnModelEvent.getFromIndex();
                int n4 = tableColumnModelEvent.getToIndex();
                this._tIndex.getColumnModel().moveColumn(n, n4);
                this._tDatabaseCache.getColumnModel().moveColumn(n, n4);
            }
            this._ignoreColumnEvents = false;
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void initResources() {
        this._helpToken = "status-suffix-help";
        this._taRights = new MultilineLabel(this._resource.getString("suffixpanel", "rights-label"), 2, 50);
        this._taError = new MultilineLabel(2, 50);
        this._suffixesToShow = new ArrayList();
        this.VOID_DATABASE_CACHE_INFO = new DatabaseCacheInfo();
        this.VOID_DATABASE_CACHE_INFO.suffix = "";
        this.VOID_DATABASE_CACHE_INFO.index = "";
        this.VOID_DATABASE_CACHE_INFO.hits = "";
        this.VOID_DATABASE_CACHE_INFO.tries = "";
        this.VOID_DATABASE_CACHE_INFO.hitRatio = "";
        this.VOID_DATABASE_CACHE_INFO.pageReadsIn = "";
        this.VOID_DATABASE_CACHE_INFO.pageWrittenOut = "";
    }

    protected void readAndUpdate() {
        if (!this._isReloading) {
            this._isReloading = true;
            try {
                if (this._contentPane == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusSuffixPanel.this.showComponent(StatusSuffixPanel.this.REFRESH_LABEL, true);
                        }
                    });
                    this.createContentPane();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusSuffixPanel.this._lUpdating.setVisible(true);
                        }
                    });
                }
                this.readData();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusSuffixPanel.this.updatePanelData();
                        StatusSuffixPanel.this.updateTableSizes();
                        StatusSuffixPanel.this.showComponent(StatusSuffixPanel.this._contentPane, false);
                        StatusSuffixPanel.this._lUpdating.setVisible(false);
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusSuffixPanel.this.showComponent(StatusSuffixPanel.this._taRights, true);
                    }
                });
            }
            catch (LDAPException lDAPException) {
                final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StatusSuffixPanel.this._taError.setText(StatusSuffixPanel.this._resource.getString("suffixpanel", "error-reloading-label", stringArray));
                        StatusSuffixPanel.this.showComponent(StatusSuffixPanel.this._taError, true);
                    }
                });
            }
            this._isReloading = false;
        }
    }

    protected JPanel createButtonPanel() {
        this._bHelp = UIFactory.makeJButton(this, "refreshpanel", "bhelp", this._resource);
        this._bShowSuffixes = UIFactory.makeJButton(this, "suffixpanel", "bshowsuffixes", this._resource);
        this._bShowSuffixes.setVisible(false);
        this._bHelp.setVisible(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this._bShowSuffixes, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bHelp, gridBagConstraints);
        return jPanel;
    }

    protected void showComponent(JComponent jComponent, boolean bl) {
        super.showComponent(jComponent, bl);
        this._bShowSuffixes.setVisible(!bl);
    }

    private void createContentPane() {
        this._contentPane = new JPanel(new GridBagLayout());
        JPanel jPanel = this.createRefreshArea();
        String[] stringArray = new String[8];
        String[] stringArray2 = new String[8];
        int n = 0;
        while (n < 8) {
            stringArray[n] = this._resource.getString("suffixpanel", "entrycacheheaders" + n);
            stringArray2[n] = this._resource.getString("suffixpanel", "entrycachetooltips" + n);
            ++n;
        }
        this._modelEntryCache = new EntryCacheTableModel();
        this._modelEntryCache.setHeaders(stringArray);
        ToolTipCellRenderer toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(stringArray2);
        this._tEntryCache = new JTable(this._modelEntryCache);
        this._tEntryCache.setAutoResizeMode(3);
        this._tEntryCache.setColumnSelectionAllowed(false);
        this._tEntryCache.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusSuffixPanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        JLabel jLabel = UIFactory.makeJLabel("suffixpanel", "lentrycache", this._resource);
        jLabel.setLabelFor(this._tEntryCache);
        JScrollPane jScrollPane = new JScrollPane(this._tEntryCache, 21, 30);
        this._listModelIndex = new DefaultListModel();
        this._listIndex = new JList(this._listModelIndex);
        this._listIndex.setVisibleRowCount(6);
        this._listIndex.setSelectionMode(0);
        this._listIndex.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this._listIndex, 20, 30);
        Component component = this._listIndex.getCellRenderer().getListCellRendererComponent(this._listIndex, "123456789012345", 0, true, true);
        jScrollPane2.setPreferredSize(new Dimension((int)component.getPreferredSize().getWidth(), (int)jScrollPane2.getPreferredSize().getHeight()));
        String[] stringArray3 = new String[6];
        String[] stringArray4 = new String[6];
        int n2 = 0;
        while (n2 < 6) {
            stringArray3[n2] = this._resource.getString("suffixpanel", "databasecacheheaders" + n2);
            stringArray4[n2] = this._resource.getString("suffixpanel", "databasecachetooltips" + n2);
            ++n2;
        }
        this._modelIndex = new DatabaseCacheTableModel();
        this._modelIndex.setHeaders(stringArray3);
        toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(stringArray4);
        this._tIndex = new JTable(this._modelIndex);
        this._tIndex.setAutoResizeMode(3);
        this._tIndex.setColumnSelectionAllowed(false);
        this._tIndex.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusSuffixPanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        TableColumnModel tableColumnModel = this._tIndex.getColumnModel();
        tableColumnModel.addColumnModelListener(this);
        JLabel jLabel2 = UIFactory.makeJLabel("suffixpanel", "lindex", this._resource);
        jLabel2.setLabelFor(this._tIndex);
        JScrollPane jScrollPane3 = new JScrollPane(this._tIndex, 21, 30);
        this._modelDatabaseCache = new DatabaseCacheTableModel();
        toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(stringArray4);
        this._tDatabaseCache = new JTable(this._modelDatabaseCache);
        this._tDatabaseCache.setAutoResizeMode(3);
        this._tDatabaseCache.setColumnSelectionAllowed(false);
        this._tDatabaseCache.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusSuffixPanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        JLabel jLabel3 = UIFactory.makeJLabel("suffixpanel", "ldatabasecache", this._resource);
        jLabel3.setLabelFor(this._tDatabaseCache);
        JScrollPane jScrollPane4 = new JScrollPane(this._tDatabaseCache, 21, 30);
        this._modelGlobalDatabaseCache = new DatabaseCacheTableModel();
        toolTipCellRenderer = new ToolTipCellRenderer();
        toolTipCellRenderer.setToolTips(stringArray4);
        this._tGlobalDatabaseCache = new JTable(this._modelGlobalDatabaseCache);
        this._tGlobalDatabaseCache.setAutoResizeMode(3);
        this._tGlobalDatabaseCache.setColumnSelectionAllowed(false);
        this._tGlobalDatabaseCache.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = StatusSuffixPanel.class$("java.lang.String")) : class$java$lang$String, toolTipCellRenderer);
        JLabel jLabel4 = UIFactory.makeJLabel("suffixpanel", "lglobaldatabasecache", this._resource);
        jLabel4.setLabelFor(this._tGlobalDatabaseCache);
        JScrollPane jScrollPane5 = new JScrollPane(this._tGlobalDatabaseCache, 21, 30);
        JLabel jLabel5 = UIFactory.makeJLabel("suffixpanel", "lwriteevict", this._resource);
        this._lWriteEvict = new JLabel();
        jLabel5.setLabelFor(this._lWriteEvict);
        this._lWriteEvict.setLabelFor(jLabel5);
        JLabel jLabel6 = UIFactory.makeJLabel("suffixpanel", "lreadevict", this._resource);
        this._lReadEvict = new JLabel();
        jLabel6.setLabelFor(this._lReadEvict);
        this._lReadEvict.setLabelFor(jLabel6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this._contentPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        this._contentPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this._contentPane.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        this._contentPane.add((Component)new JSeparator(0), gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        this._contentPane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this._contentPane.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this._contentPane.add((Component)jScrollPane3, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this._contentPane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this._contentPane.add((Component)jScrollPane4, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = UIFactory.getDifferentSpace();
        this._contentPane.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this._contentPane.add((Component)jScrollPane5, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._lWriteEvict, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel2.add((Component)this._lReadEvict, gridBagConstraints);
        gridBagConstraints.insets = new Insets(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this._contentPane.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPane.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void updateTableSizes() {
        int n = this.getTotalHeight(this._tEntryCache);
        this._tEntryCache.setPreferredScrollableViewportSize(new Dimension(10, n));
        n = this.getTotalHeight(this._tIndex);
        this._tIndex.setPreferredScrollableViewportSize(new Dimension(10, n));
        n = this.getTotalHeight(this._tDatabaseCache);
        this._tDatabaseCache.setPreferredScrollableViewportSize(new Dimension(10, n));
        n = this.getTotalHeight(this._tGlobalDatabaseCache);
        this._tGlobalDatabaseCache.setPreferredScrollableViewportSize(new Dimension(10, n));
    }

    private int getTotalHeight(JTable jTable) {
        return jTable.getRowCount() * jTable.getRowHeight();
    }

    private void readData() throws LDAPException {
        Object object;
        Object object2;
        DatabaseCacheInfo[] databaseCacheInfoArray;
        Object object3;
        Object object4;
        Object object5;
        Vector vector;
        Object object6;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DatabaseConfig databaseConfig = this._model.getFramework().getServerObject().getDatabaseConfig();
        ListIterator listIterator = ((AbstractList)databaseConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext()) {
            object6 = (Suffix)listIterator.next();
            vector = ((Suffix)object6).getDatabases();
            if (vector.size() != 1 || ((Database)(object5 = (Database)vector.elementAt(0))).getType() != 0) continue;
            arrayList.add(object6);
        }
        if (this._suffixesToShow.size() == 0) {
            object6 = arrayList;
        } else {
            int n = this._suffixesToShow.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                object4 = ((Suffix)this._suffixesToShow.get(n2)).getName();
                boolean bl = false;
                listIterator = ((AbstractList)arrayList).listIterator();
                while (listIterator.hasNext() && !bl) {
                    object3 = (Suffix)listIterator.next();
                    if (!((Suffix)object3).getName().equals(object4)) continue;
                    bl = true;
                    this._suffixesToShow.set(n2, object3);
                }
                if (!bl) {
                    this._suffixesToShow.remove(n2);
                }
                --n2;
            }
            object6 = this._suffixesToShow;
        }
        listIterator = ((AbstractList)object6).listIterator();
        vector = this.getServerInfo().getLDAPConnection();
        object5 = new ArrayList();
        object4 = new ArrayList();
        if (this._indexNameList == null) {
            this._indexNameList = new ArrayList(12);
        } else {
            this._indexNameList.clear();
        }
        ArrayList arrayList2 = new ArrayList(12);
        while (listIterator.hasNext()) {
            object3 = new ArrayList();
            Suffix suffix = (Suffix)listIterator.next();
            databaseCacheInfoArray = (Database)suffix.getDatabases().get(0);
            try {
                String string = "cn=monitor, " + databaseCacheInfoArray.getDn();
                object2 = vector.read(string);
                if (object2 == null) {
                    throw new NullPointerException();
                }
                object = new EntryCacheInfo();
                this.updateEntryCacheInfo((EntryCacheInfo)object, (LDAPEntry)object2, suffix.getName());
                ((ArrayList)object5).add(object);
                LDAPAttributeSet lDAPAttributeSet = object2.getAttributeSet();
                int n = 0;
                while (n < lDAPAttributeSet.size()) {
                    String string2;
                    LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(n);
                    if (lDAPAttribute != null && (string2 = lDAPAttribute.getName()).startsWith("dbfilename-")) {
                        String string3 = string2.substring(11);
                        String string4 = DSUtil.getAttrValue((LDAPEntry)object2, string2);
                        String string5 = this.getIndexFromFilename(string4).toLowerCase();
                        DatabaseCacheInfo databaseCacheInfo = new DatabaseCacheInfo();
                        this.updateDatabaseCacheInfo(databaseCacheInfo, (LDAPEntry)object2, string5, suffix.getName(), string3);
                        if (!string5.equalsIgnoreCase("id2entry")) {
                            int n3 = this._indexNameList.indexOf(string5);
                            if (n3 < 0) {
                                this._indexNameList.add(string5);
                                arrayList2.add(new ArrayList());
                                n3 = arrayList2.size() - 1;
                            }
                            ((ArrayList)arrayList2.get(n3)).add(databaseCacheInfo);
                        } else {
                            ((ArrayList)object4).add(databaseCacheInfo);
                        }
                    }
                    ++n;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) continue;
                throw lDAPException;
            }
        }
        this._entryCacheInfo = new EntryCacheInfo[((ArrayList)object5).size()];
        ((ArrayList)object5).toArray(this._entryCacheInfo);
        this._databaseCacheInfo = new DatabaseCacheInfo[((ArrayList)object4).size()];
        ((ArrayList)object4).toArray(this._databaseCacheInfo);
        listIterator = ((AbstractList)object6).listIterator();
        while (listIterator.hasNext()) {
            object3 = ((Suffix)listIterator.next()).getName();
            int n = 0;
            while (n < arrayList2.size()) {
                databaseCacheInfoArray = (ArrayList)arrayList2.get(n);
                boolean bl = false;
                object2 = databaseCacheInfoArray.listIterator();
                while (object2.hasNext() && !bl) {
                    object = (DatabaseCacheInfo)object2.next();
                    boolean bl2 = bl = ((DatabaseCacheInfo)object).suffix == object3;
                }
                if (!bl) {
                    databaseCacheInfoArray.add(this.createNotDefinedDatabaseCacheInfo((String)object3, (String)this._indexNameList.get(n)));
                }
                ++n;
            }
        }
        if (this._htReadDbCacheIndex == null) {
            this._htReadDbCacheIndex = new Hashtable(this._indexNameList.size());
        } else {
            this._htReadDbCacheIndex.clear();
        }
        int n = 0;
        while (n < arrayList2.size()) {
            ArrayList arrayList3 = (ArrayList)arrayList2.get(n);
            databaseCacheInfoArray = new DatabaseCacheInfo[arrayList3.size()];
            arrayList3.toArray(databaseCacheInfoArray);
            this._htReadDbCacheIndex.put(this._indexNameList.get(n), databaseCacheInfoArray);
            ++n;
        }
        int n4 = ((ArrayList)object5).size();
        this._voidDatabaseCacheArray = new DatabaseCacheInfo[n4];
        int n5 = 0;
        while (n5 < n4) {
            this._voidDatabaseCacheArray[n5] = this.VOID_DATABASE_CACHE_INFO;
            ++n5;
        }
        LDAPEntry lDAPEntry = vector.read("cn=monitor, cn=ldbm database, cn=plugins, cn=config", this.LDBM_PLUGIN_ATTRS);
        if (lDAPEntry == null) {
            throw new NullPointerException();
        }
        if (this._globalDatabaseCacheInfo == null) {
            this._globalDatabaseCacheInfo = new GlobalDatabaseCacheInfo();
            this._globalDatabaseCacheInfo.suffix = this._resource.getString("suffixpanel", "globaldatabasecacheinfo-suffix");
            this._globalDatabaseCacheInfo.index = "";
        }
        this.updateGlobalDatabaseCacheInfo(this._globalDatabaseCacheInfo, lDAPEntry);
    }

    private void updateGlobalDatabaseCacheInfo(GlobalDatabaseCacheInfo globalDatabaseCacheInfo, LDAPEntry lDAPEntry) {
        globalDatabaseCacheInfo.hits = DSUtil.getAttrValue(lDAPEntry, "dbcachehits");
        globalDatabaseCacheInfo.tries = DSUtil.getAttrValue(lDAPEntry, "dbcachetries");
        globalDatabaseCacheInfo.hitRatio = DSUtil.getAttrValue(lDAPEntry, "dbcachehitratio");
        globalDatabaseCacheInfo.pageReadsIn = DSUtil.getAttrValue(lDAPEntry, "dbcachepagein");
        globalDatabaseCacheInfo.pageWrittenOut = DSUtil.getAttrValue(lDAPEntry, "dbcachepageout");
        globalDatabaseCacheInfo.readEvict = DSUtil.getAttrValue(lDAPEntry, "dbcacheroevict");
        globalDatabaseCacheInfo.writeEvict = DSUtil.getAttrValue(lDAPEntry, "dbcacherwevict");
    }

    private void updateEntryCacheInfo(EntryCacheInfo entryCacheInfo, LDAPEntry lDAPEntry, String string) {
        entryCacheInfo.suffix = string;
        entryCacheInfo.hits = DSUtil.getAttrValue(lDAPEntry, "entrycachehits");
        entryCacheInfo.tries = DSUtil.getAttrValue(lDAPEntry, "entrycachetries");
        entryCacheInfo.hitRatio = DSUtil.getAttrValue(lDAPEntry, "entrycachehitratio");
        entryCacheInfo.currentSize = this.getMbString(DSUtil.getAttrValue(lDAPEntry, "currententrycachesize"));
        entryCacheInfo.maxSize = this.getMbString(DSUtil.getAttrValue(lDAPEntry, "maxentrycachesize"));
        entryCacheInfo.currentEntryCount = DSUtil.getAttrValue(lDAPEntry, "currententrycachecount");
        entryCacheInfo.maxEntryCount = DSUtil.getAttrValue(lDAPEntry, "maxentrycachecount");
        if (entryCacheInfo.maxEntryCount.equals("-1")) {
            entryCacheInfo.maxEntryCount = this.UNLIMITED_CACHE_SIZE;
        }
    }

    private String getMbString(String string) {
        float f = 0.0f;
        if (!string.equals("")) {
            float f2 = Long.parseLong(string);
            f = f2 / 1048576.0f;
            f = (float)((double)((long)(((double)f + 0.05) * 10.0)) / 10.0);
        }
        return String.valueOf(f);
    }

    private String getIndexFromFilename(String string) {
        int n = string.lastIndexOf(95);
        int n2 = string.lastIndexOf(46);
        return string.substring(n + 1, n2);
    }

    private void updateDatabaseCacheInfo(DatabaseCacheInfo databaseCacheInfo, LDAPEntry lDAPEntry, String string, String string2, String string3) {
        databaseCacheInfo.suffix = string2;
        databaseCacheInfo.index = string;
        databaseCacheInfo.hits = DSUtil.getAttrValue(lDAPEntry, "dbfilecachehit-" + string3);
        long l = Long.parseLong(databaseCacheInfo.hits);
        long l2 = Long.parseLong(DSUtil.getAttrValue(lDAPEntry, "dbfilecachemiss-" + string3));
        databaseCacheInfo.tries = String.valueOf(l + l2);
        long l3 = 100L * l / (l + l2);
        databaseCacheInfo.hitRatio = String.valueOf(l3);
        databaseCacheInfo.pageReadsIn = DSUtil.getAttrValue(lDAPEntry, "dbfilepagein-" + string3);
        databaseCacheInfo.pageWrittenOut = DSUtil.getAttrValue(lDAPEntry, "dbfilepageout-" + string3);
    }

    private DatabaseCacheInfo createNotDefinedDatabaseCacheInfo(String string, String string2) {
        DatabaseCacheInfo databaseCacheInfo = new DatabaseCacheInfo();
        databaseCacheInfo.suffix = string;
        databaseCacheInfo.index = string2;
        databaseCacheInfo.hits = this.INDEX_NOT_DEFINED;
        databaseCacheInfo.tries = this.INDEX_NOT_DEFINED;
        databaseCacheInfo.hitRatio = this.INDEX_NOT_DEFINED;
        databaseCacheInfo.pageReadsIn = this.INDEX_NOT_DEFINED;
        databaseCacheInfo.pageWrittenOut = this.INDEX_NOT_DEFINED;
        return databaseCacheInfo;
    }

    private void updatePanelData() {
        this._modelEntryCache.updateData(this._entryCacheInfo);
        if (this._htDbCacheIndex == null) {
            this._htDbCacheIndex = new Hashtable(this._indexNameList.size());
        } else {
            this._htDbCacheIndex.clear();
        }
        this._htDbCacheIndex.putAll(this._htReadDbCacheIndex);
        Object e = this._listIndex.getSelectedValue();
        String[] stringArray = new String[this._indexNameList.size()];
        this._indexNameList.toArray(stringArray);
        DSUtil.bubbleSort(stringArray);
        this._listModelIndex.clear();
        int n = 0;
        while (n < stringArray.length) {
            this._listModelIndex.addElement(stringArray[n]);
            ++n;
        }
        if (this._listModelIndex.getSize() == 0) {
            this._listModelIndex.addElement(this.NO_INDEX_AVAILABLE);
            this._listIndex.setEnabled(false);
        } else {
            if (e != null && this._listModelIndex.contains(e)) {
                this._listIndex.setSelectedValue(e, true);
            } else {
                this._listIndex.setSelectedIndex(0);
            }
            this._listIndex.setEnabled(true);
        }
        this._modelDatabaseCache.updateData(this._databaseCacheInfo);
        DatabaseCacheInfo[] databaseCacheInfoArray = new DatabaseCacheInfo[]{this._globalDatabaseCacheInfo};
        this._modelGlobalDatabaseCache.updateData(databaseCacheInfoArray);
        this._lWriteEvict.setText(this._globalDatabaseCacheInfo.writeEvict);
        this._lReadEvict.setText(this._globalDatabaseCacheInfo.readEvict);
        if (this._showSuffixDlg != null) {
            DatabaseConfig databaseConfig = this._model.getFramework().getServerObject().getDatabaseConfig();
            this._showSuffixDlg.updateDataFromDatabaseConfig(databaseConfig);
        }
    }

    private void actionShowSuffixes() {
        if (this._showSuffixDlg == null) {
            this._showSuffixDlg = new ShowSuffixDialog(this._model.getFramework());
            this._showSuffixDlg.pack();
        }
        this._showSuffixDlg.setSuffixesToShow(this._suffixesToShow);
        this._showSuffixDlg.show();
        if (!this._showSuffixDlg.isCancelled()) {
            this._suffixesToShow = this._showSuffixDlg.getSuffixesToShow();
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

