/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.LDAPAddProgressDialog;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPConnection;

class LDAPAddDialog
extends AbstractDialog
implements ActionListener,
DocumentListener {
    DSFramework _framework;
    private JPanel _contentPanel;
    private JTextField _tfFile;
    private JButton _bBrowse;
    private JTextField _tfRejects;
    private JButton _bBrowseRejects;
    private JCheckBox _cbAddOnly;
    private JCheckBox _cbContinueOnError;
    private boolean _isCancelled = true;
    private String _defaultPath;
    private static final String HELP_TOKEN = "tasks-import-help";
    private static ResourceSet _resource = DSUtil._resource;

    public LDAPAddDialog(DSFramework dSFramework) {
        super((Frame)((Object)dSFramework), null, true, 11);
        this._framework = dSFramework;
        ((Dialog)((Object)this)).setTitle(_resource.getString("ldapadddialog", "title"));
        this.createContentPanel();
        this.setComponent(this._contentPanel);
        this.setFocusComponent(this._tfFile);
        this.setOKButtonEnabled(false);
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bBrowse) {
            this.actionBrowse(this._tfFile, true);
        } else if (object == this._bBrowseRejects) {
            this.actionBrowse(this._tfRejects, false);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl;
        String string = this._tfFile.getText().trim();
        boolean bl2 = bl = !string.equals("");
        if (bl) {
            bl = !string.equals(this._tfRejects.getText().trim());
        }
        this.setOKButtonEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    protected void helpInvoked() {
        DSUtil.help(HELP_TOKEN, this._framework.getServerObject().getServerInfo().getAdminURL());
    }

    protected void okInvoked() {
        boolean bl = this.testImportFile();
        if (!bl) {
            bl = this.testRejectsFile();
        }
        if (!bl) {
            String string = this._tfFile.getText();
            String string2 = this._tfRejects.getText();
            if (string2.length() == 0) {
                string2 = null;
            }
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            boolean bl2 = this._cbAddOnly.isSelected();
            boolean bl3 = this._cbContinueOnError.isSelected();
            final DSExportImport dSExportImport = new DSExportImport(lDAPConnection, string, bl2, bl3, string2);
            LDAPAddProgressDialog lDAPAddProgressDialog = new LDAPAddProgressDialog((JFrame)((Object)this._framework), dSExportImport, string2);
            dSExportImport.addEntryChangeListener(lDAPAddProgressDialog);
            this._isCancelled = false;
            super.okInvoked();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dSExportImport.run();
                }
            });
            thread.start();
            lDAPAddProgressDialog.packAndShow();
        }
    }

    private void createContentPanel() {
        String string;
        Object object;
        this._contentPanel = new JPanel(new GridBagLayout());
        boolean bl = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        if (bl) {
            object = (String)this._framework.getServerObject().getServerInfo().get("InstallPath");
            string = (String)this._framework.getServerObject().getServerInfo().get("ServerInstance");
            this._defaultPath = (String)object + '/' + string + "/ldif";
        } else {
            this._defaultPath = ".";
        }
        string = bl ? "lfile" : "lfileonconsole";
        object = UIFactory.makeJLabel("ldapadddialog", string, _resource);
        this._tfFile = UIFactory.makeJTextField(this, "ldapadddialog", string, null, 30, _resource);
        ((JLabel)object).setLabelFor(this._tfFile);
        this._bBrowse = UIFactory.makeJButton(this, "ldapadddialog", "bbrowse", _resource);
        this._cbAddOnly = UIFactory.makeJCheckBox(null, "ldapadddialog", "cbaddonly", false, _resource);
        this._cbContinueOnError = UIFactory.makeJCheckBox(null, "ldapadddialog", "cbcontinueonerror", true, _resource);
        this._cbContinueOnError.setSelected(true);
        JLabel jLabel = UIFactory.makeJLabel("ldapadddialog", "lrejects", _resource);
        this._tfRejects = UIFactory.makeJTextField(this, "ldapadddialog", "lrejects", null, 30, _resource);
        jLabel.setLabelFor(this._tfRejects);
        this._bBrowseRejects = UIFactory.makeJButton(this, "ldapadddialog", "bbrowserejects", _resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this._contentPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)this._tfFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)this._bBrowse, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        gridBagConstraints.insets.left = 0;
        this._contentPanel.add((Component)this._cbAddOnly, gridBagConstraints);
        this._contentPanel.add((Component)this._cbContinueOnError, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._tfRejects, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bBrowseRejects, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void actionBrowse(JTextField jTextField, boolean bl) {
        String string;
        String string2 = jTextField.getText().trim();
        String[] stringArray = new String[]{"ldif"};
        String[] stringArray2 = new String[]{_resource.getString("ldapadddialog", "ldif-description")};
        if (DSFileDialog.getDefaultDirectory() == null) {
            DSFileDialog.setDefaultDirectory(this._defaultPath);
        }
        if ((string = DSFileDialog.browseFiles(string2, false, (String[])(bl ? stringArray : null), (String[])(bl ? stringArray2 : null), bl ? this._bBrowse : this._bBrowseRejects)) != null) {
            jTextField.setText(string);
        }
    }

    private boolean testImportFile() {
        boolean bl = false;
        String string = this._tfFile.getText().trim();
        File file = new File(string);
        if (!file.isAbsolute()) {
            string = DSFileDialog.getDefaultDirectory() != null ? DSFileDialog.getDefaultDirectory() + File.separator + string : this._defaultPath + File.separator + string;
        }
        file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{DSUtil.inverseAbreviateString(string, 40)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "cannotreadfile-title", "cannotreadfile-msg", stringArray, "ldapadddialog", _resource);
            bl = true;
        }
        this._tfFile.setText(string);
        return bl;
    }

    private boolean testRejectsFile() {
        boolean bl = false;
        String string = this._tfRejects.getText().trim();
        if (string.length() > 0) {
            String[] stringArray;
            File file;
            File file2 = new File(string);
            if (!file2.isAbsolute()) {
                string = DSFileDialog.getDefaultDirectory() != null ? DSFileDialog.getDefaultDirectory() + File.separator + string : this._defaultPath + File.separator + string;
            }
            if ((file2 = new File(string)).equals(file = new File(this._tfFile.getText()))) {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "rejectsfileisimportfile-title", "rejectsfileisimportfile-msg", null, "ldapadddialog", _resource);
                bl = true;
            }
            if (!bl && DSUtil.fileExists(file2)) {
                stringArray = new String[]{DSUtil.inverseAbreviateString(string, 40)};
                int n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirm-delete-reject-file", stringArray, "ldadadddialog", _resource);
                bl = n != 0;
            }
            try {
                stringArray = new FileOutputStream(file2);
            }
            catch (Exception exception) {
                String[] stringArray2 = new String[]{DSUtil.inverseAbreviateString(string, 40)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "cannotwritefile-title", "cannotwritefile-msg", stringArray2, "ldapadddialog", _resource);
                bl = true;
            }
        }
        this._tfRejects.setText(string);
        return bl;
    }
}

