/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.config.Database;
import com.netscape.admin.dirserv.task.LDAPExportException;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;

class LDAPExport
implements Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private String _fileName;
    private String _includeSuffix;
    private Database[] _dbs;
    private boolean _taskCancelled;
    private String _taskDn;
    private static ResourceSet _resource = DSUtil._resource;

    public LDAPExport(DSFramework dSFramework, String string, String string2) {
        this._framework = dSFramework;
        this._fileName = string;
        this._includeSuffix = string2;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            this.initTask();
        }
        catch (LDAPException lDAPException) {
            bl = true;
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)LDAPExport.this._framework), "error-launching-title", "error-launching-msg", stringArray, "ldapexport", _resource);
                }
            });
        }
        catch (LDAPExportException lDAPExportException) {
            bl = true;
            final String[] stringArray2 = new String[]{lDAPExportException.getMessage()};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)LDAPExport.this._framework), "ldapexportexception-launching-title", "ldapexportexception-launching-msg", stringArray2, "ldapexport", _resource);
                }
            });
        }
        if (!bl) {
            try {
                this.updateProgressDialog();
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)LDAPExport.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "ldapexport", _resource);
                    }
                });
            }
            this._dlg.waitForClose();
        } else {
            this._dlg.closeCallBack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("ldapexport", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "ldapexport", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("ldapexport", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("ldapexport", "title"), null, this);
        String[] stringArray = new String[]{DSUtil.inverseAbreviateString(this._fileName, 40)};
        this._dlg.setTextInLabel(_resource.getString("ldapexport", "exporting-label", stringArray));
        this._dlg.setLabelRows(2);
        this._dlg.disableCancelButton();
        this._dlg.addStep(_resource.getString("ldapexport", "firststep-label"));
        this._dlg.addStep(_resource.getString("ldapexport", "secondstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("ldapexport", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException, LDAPExportException {
        String[] stringArray;
        this._taskCancelled = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsFilename", this._fileName));
        ArrayList arrayList = this._framework.getServerObject().getDatabaseConfig().getDatabases();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            stringArray = (String[])arrayList.get(n);
            boolean bl2 = false;
            if (stringArray.getSuffix() != null && stringArray.getType() == 0) {
                bl = true;
                if (this._includeSuffix != null) {
                    DN dN = new DN(this._includeSuffix);
                    DN dN2 = new DN(stringArray.getSuffix().getName());
                    if (dN.equals(dN2) || dN.isDescendantOf(dN2)) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                arrayList2.add(stringArray);
                arrayList3.add(stringArray.getName());
            }
            ++n;
        }
        if (arrayList2.size() == 0) {
            if (bl) {
                stringArray = new String[]{this._includeSuffix};
                throw new LDAPExportException(_resource.getString("ldapexport", "subtreedoesnotexist-msg", stringArray));
            }
            throw new LDAPExportException(_resource.getString("ldapexport", "noldbmdatabases-msg"));
        }
        this._dbs = new Database[arrayList2.size()];
        arrayList2.toArray(this._dbs);
        stringArray = new String[arrayList3.size()];
        arrayList3.toArray(stringArray);
        lDAPAttributeSet.add(new LDAPAttribute("nsInstance", stringArray));
        lDAPAttributeSet.add(new LDAPAttribute("nsUseOneFile", "TRUE"));
        lDAPAttributeSet.add(new LDAPAttribute("nsExportReplica", "TRUE"));
        if (this._includeSuffix != null) {
            lDAPAttributeSet.add(new LDAPAttribute("nsIncludeSuffix", this._includeSuffix));
        }
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=export" + System.currentTimeMillis() + ", cn=export, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        String string = null;
        String string2 = null;
        int n = -1;
        String[] stringArray = new String[4];
        if (this._dbs.length == 0) {
            bl = true;
            this._dlg.setTextInLabel(_resource.getString("ldapexport", "successful-label"));
        } else {
            string = this._dbs[0].getName();
            if (this._dbs.length > 1) {
                string2 = this._dbs[1].getName();
            }
            n = 1;
            stringArray[0] = DSUtil.inverseAbreviateString(this._fileName, 40);
            stringArray[1] = DSUtil.abreviateString(this._dbs[0].getSuffix().getName(), 40);
            stringArray[2] = String.valueOf(n);
            stringArray[3] = String.valueOf(this._dbs.length);
            this._dlg.setTextInLabel(_resource.getString("ldapexport", "progress-label", stringArray));
        }
        while (!bl && !this._taskCancelled) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                String string3 = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                boolean bl2 = false;
                while (!bl2) {
                    boolean bl3;
                    if (string3.lastIndexOf("Beginning export of '" + string) >= 0) {
                        this._dlg.stepCompleted(0);
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    } else {
                        bl2 = true;
                    }
                    boolean bl4 = bl3 = string3.indexOf("Export finished.") > 0;
                    if (!bl3 && string2 != null) {
                        boolean bl5 = bl3 = string3.lastIndexOf("Beginning export of '" + string2) >= 0;
                    }
                    if (!bl3) {
                        int n2 = string3.lastIndexOf(string + ": Processed");
                        boolean bl6 = bl3 = n2 >= 0 && string3.lastIndexOf("(100%).") > n2;
                    }
                    if (bl3) {
                        this._dlg.stepCompleted(1);
                        ++n;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n <= this._dbs.length && !this._taskCancelled) {
                            string = this._dbs[n - 1].getName();
                            string2 = this._dbs.length > n ? this._dbs[n].getName() : null;
                            this._dlg.reset();
                            stringArray[0] = DSUtil.inverseAbreviateString(this._fileName, 40);
                            stringArray[1] = DSUtil.abreviateString(this._dbs[n - 1].getSuffix().getName(), 40);
                            stringArray[2] = String.valueOf(n);
                            stringArray[3] = String.valueOf(this._dbs.length);
                            this._dlg.setTextInLabel(_resource.getString("ldapexport", "progress-label", stringArray));
                            continue;
                        }
                        bl2 = true;
                        continue;
                    }
                    bl2 = true;
                }
                this._dlg.setTextInTextArea(string3);
                String string4 = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (string4.equals("")) continue;
                bl = true;
                if (string4.equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("ldapexport", "successful-label"));
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("ldapexport", "unsuccessful-label"));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                this._dlg.setTextInLabel(_resource.getString("ldapexport", "successful-label"));
            }
        }
    }
}

