/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

class LDAPRestore
implements Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private int _numberOfCurrentFile;
    private String _fileName;
    private boolean _taskCancelled;
    private String _taskDn;
    private static ResourceSet _resource = DSUtil._resource;

    public LDAPRestore(DSFramework dSFramework, String string) {
        this._framework = dSFramework;
        this._fileName = string;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        String[] stringArray;
        boolean bl = false;
        try {
            this.initTask();
        }
        catch (LDAPException lDAPException) {
            bl = true;
            stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)LDAPRestore.this._framework), "error-launching-title", "error-launching-msg", stringArray, "ldaprestore", _resource);
                }
            });
        }
        if (!bl) {
            try {
                this.updateProgressDialog();
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)LDAPRestore.this._framework), "error-updating-dialog-title", "error-updating-dialog-msg", stringArray, "ldaprestore", _resource);
                    }
                });
            }
            this._dlg.waitForClose();
        } else {
            this._dlg.closeCallBack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("ldaprestore", "cancelling-label"));
            this._taskCancelled = true;
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute("nsTaskCancel", "true"));
            try {
                lDAPConnection.modify(this._taskDn, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                DSUtil.showErrorDialog((Component)((Object)this._framework), "error-cancelling-title", "error-cancelling-msg", stringArray, "ldaprestore", _resource);
            }
            this._dlg.setTextInLabel(_resource.getString("ldaprestore", "cancelled-label"));
            this._dlg.waitForClose();
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    private void createProgressDialog() {
        String[] stringArray = new String[]{this._fileName};
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("ldaprestore", "title", stringArray), null, this);
        this._dlg.setTextInLabel(_resource.getString("ldaprestore", "start-label"));
        this._dlg.setLabelRows(1);
        this._dlg.disableCancelButton();
        this._dlg.addStep(_resource.getString("ldaprestore", "firststep-label"));
        this._dlg.addStep(_resource.getString("ldaprestore", "secondstep-label"));
        this._dlg.addStep(_resource.getString("ldaprestore", "thirdstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("ldaprestore", "logs-label"));
        this._dlg.setTextAreaRows(5);
    }

    private void initTask() throws LDAPException {
        this._taskCancelled = false;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        lDAPAttributeSet.add(new LDAPAttribute("objectclass", "extensibleobject"));
        lDAPAttributeSet.add(new LDAPAttribute("nsArchiveDir", this._fileName));
        lDAPAttributeSet.add(new LDAPAttribute("nsDatabaseType", "ldbm database"));
        lDAPAttributeSet.add(new LDAPAttribute("ttl", "8"));
        this._taskDn = "cn=restore" + System.currentTimeMillis() + ", cn=restore, cn=tasks, cn=config";
        LDAPEntry lDAPEntry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    protected void updateProgressDialog() throws LDAPException {
        boolean bl = false;
        this._numberOfCurrentFile = 1;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        while (!bl && !this._taskCancelled) {
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object object;
                LDAPEntry lDAPEntry = lDAPConnection.read(this._taskDn);
                String string = DSUtil.getAttrValue(lDAPEntry, "nsTaskLog");
                if (string.lastIndexOf("Beginning restore") >= 0) {
                    this._dlg.stepCompleted(0);
                }
                boolean bl2 = false;
                while (string.lastIndexOf("Restoring file " + this._numberOfCurrentFile) >= 0) {
                    if (!bl2) {
                        this._dlg.stepCompleted(1);
                        bl2 = true;
                    }
                    object = new String[]{String.valueOf(this._numberOfCurrentFile)};
                    String string2 = _resource.getString("ldaprestore", "progress-label", (String[])object);
                    this._dlg.setTextInLabel(string2);
                    ++this._numberOfCurrentFile;
                }
                if (string.lastIndexOf("Restore finished") >= 0) {
                    this._dlg.stepCompleted(2);
                }
                this._dlg.setTextInTextArea(string);
                object = DSUtil.getAttrValue(lDAPEntry, "nsTaskExitCode");
                if (((String)object).equals("")) continue;
                bl = true;
                if (((String)object).equals("0")) {
                    this._dlg.setTextInLabel(_resource.getString("ldaprestore", "successful-label"));
                    continue;
                }
                this._dlg.setTextInLabel(_resource.getString("ldaprestore", "unsuccessful-label"));
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                bl = true;
                this._dlg.setTextInLabel(_resource.getString("ldaprestore", "successful-label"));
            }
        }
    }
}

