/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.util;

public class WildCardPattern {
    private int filterType;
    public static final int ANY = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int CONTAINS = 3;
    public static final int EQUALS = 4;
    private String match = null;
    private String lcMatch = null;

    public WildCardPattern(String pattern) {
        if (pattern == null || pattern.length() == 0 || pattern.equals("*")) {
            this.filterType = 0;
        } else {
            this.match = pattern;
            this.filterType = 0;
            if (this.match.startsWith("*")) {
                this.filterType |= 2;
                this.match = this.match.substring(1);
            }
            if (this.match.endsWith("*")) {
                this.filterType |= 1;
                this.match = this.match.substring(0, this.match.length() - 1);
            }
            if (this.filterType == 0) {
                this.filterType = 4;
            }
        }
        if (this.match != null) {
            this.lcMatch = this.match.toLowerCase();
        }
    }

    public boolean match(String input) {
        if (input == null || input == "") {
            return false;
        }
        if (this.filterType == 0) {
            return true;
        }
        switch (this.filterType) {
            case 4: {
                return input.equals(this.match);
            }
            case 3: {
                return input.indexOf(this.match) >= 0;
            }
            case 1: {
                return input.startsWith(this.match);
            }
            case 2: {
                return input.endsWith(this.match);
            }
        }
        return true;
    }

    public boolean matchIgnoreCase(String input) {
        String lcInput = input.toLowerCase();
        switch (this.filterType) {
            case 4: {
                return lcInput.equals(this.lcMatch);
            }
            case 3: {
                return lcInput.indexOf(this.lcMatch) >= 0;
            }
            case 1: {
                return lcInput.startsWith(this.lcMatch);
            }
            case 2: {
                return lcInput.endsWith(this.lcMatch);
            }
        }
        return true;
    }

    public int getFilterType() {
        return this.filterType;
    }
}

