/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.xmpp;

import com.sun.im.service.XMLUtil;
import com.sun.im.xmpp.RosterItem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RosterDocument {
    public static final String ELEMENT_IQ = "iq";
    public static final String ELEMENT_QUERY = "query";
    public static final String ELEMENT_ITEM = "item";
    public static final String ELEMENT_GROUP = "group";
    public static final String ATTRIBUTE_SUBSCRIPTION = "subscription";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_JID = "jid";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String NAMESPACE = "jabber:iq:roster";
    private Hashtable _jid2items = new Hashtable();
    private Hashtable _jid2elements = new Hashtable();
    private static DocumentBuilderFactory _fac;
    static TransformerFactory tf;
    Document _rosterDoc;

    public RosterDocument(Reader in) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = _fac.newDocumentBuilder();
        InputSource inputSrc = new InputSource(in);
        this._rosterDoc = builder.parse(inputSrc);
        this.index();
    }

    public RosterDocument(String s) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = _fac.newDocumentBuilder();
        StringReader strReader = new StringReader(s);
        strReader.ready();
        InputSource inputSrc = new InputSource(strReader);
        this._rosterDoc = builder.parse(inputSrc);
        this.index();
    }

    public RosterDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = _fac.newDocumentBuilder();
        this._rosterDoc = builder.parse(in);
        this.index();
    }

    public RosterDocument() throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = _fac.newDocumentBuilder();
        DOMImplementation DOMImpl = builder.getDOMImplementation();
        this._rosterDoc = DOMImpl.createDocument(NAMESPACE, ELEMENT_QUERY, null);
    }

    private void index() {
        NodeList items = this._rosterDoc.getElementsByTagName(ELEMENT_ITEM);
        int i = 0;
        while (i < items.getLength()) {
            Element elt = (Element)items.item(i);
            NamedNodeMap nnm = elt.getAttributes();
            String jid = null;
            String subscription = null;
            String name = null;
            Node nc = nnm.getNamedItem(ATTRIBUTE_JID);
            if (nc != null) {
                jid = nc.getNodeValue();
            }
            if ((nc = nnm.getNamedItem(ATTRIBUTE_NAME)) != null) {
                name = nc.getNodeValue();
            }
            if ((nc = nnm.getNamedItem(ATTRIBUTE_SUBSCRIPTION)) != null) {
                subscription = nc.getNodeValue();
            }
            RosterItem item = new RosterItem(jid, name, subscription);
            nc = nnm.getNamedItem(ATTRIBUTE_TYPE);
            if (nc != null) {
                item.setType(nc.getNodeValue());
            }
            NodeList groups = elt.getElementsByTagName(ELEMENT_GROUP);
            int j = 0;
            while (j < groups.getLength()) {
                Element g = (Element)groups.item(j);
                String groupName = XMLUtil.getElementText((Element)g);
                if (groupName != null) {
                    item.addToFolder(groupName);
                }
                ++j;
            }
            if (jid != null) {
                this._jid2items.put(jid, item);
                this._jid2elements.put(jid, elt);
            }
            ++i;
        }
    }

    private Map getGroup(String name) {
        return null;
    }

    public RosterItem getItem(String jid) {
        return (RosterItem)this._jid2items.get(jid);
    }

    public void updateRoster(RosterItem item) {
        this._jid2items.put(item.getJID(), item);
        Element elt = (Element)this._jid2elements.get(item.getJID());
        if (elt != null) {
            this._rosterDoc.getDocumentElement().removeChild(elt);
        }
        this.appendItem(item, this._rosterDoc);
    }

    public void removeItem(String jid) {
        this._jid2items.remove(jid);
        Element elt = (Element)this._jid2elements.get(jid);
        if (elt != null) {
            this._rosterDoc.getDocumentElement().removeChild(elt);
        }
    }

    public Collection getItems() {
        return this._jid2items.values();
    }

    public int size() {
        return this._jid2items.size();
    }

    public void merge(RosterDocument roster) {
        Iterator i = roster.getItems().iterator();
        while (i.hasNext()) {
            RosterItem item = (RosterItem)i.next();
            this.updateRoster(item);
        }
    }

    public void write(Writer out) throws IOException {
        try {
            Transformer t = tf.newTransformer();
            DOMSource source = new DOMSource(this._rosterDoc);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(OutputStream out) throws IOException {
        try {
            Transformer t = tf.newTransformer();
            DOMSource source = new DOMSource(this._rosterDoc);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        try {
            Transformer t = tf.newTransformer();
            DOMSource source = new DOMSource(this._rosterDoc);
            StringWriter w = new StringWriter();
            StreamResult result = new StreamResult(w);
            t.transform(source, result);
            return w.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void appendItem(RosterItem item, Document doc) {
        String[] folder;
        Element e = doc.createElement(ELEMENT_ITEM);
        e.setAttribute(ATTRIBUTE_JID, item.getJID());
        if (item.getName() != null) {
            e.setAttribute(ATTRIBUTE_NAME, item.getName());
        }
        if (item.getSubscription() != null) {
            e.setAttribute(ATTRIBUTE_SUBSCRIPTION, item.getSubscription());
        }
        if (item.getType() != null) {
            e.setAttribute(ATTRIBUTE_TYPE, item.getType());
        }
        if ((folder = item.getFolderNames()) != null && folder.length > 0) {
            int i = 0;
            while (i < folder.length) {
                Element ge = doc.createElement(ELEMENT_GROUP);
                Text t = doc.createTextNode(folder[i]);
                ge.appendChild(t);
                e.appendChild(ge);
                ++i;
            }
        }
        doc.getDocumentElement().appendChild(e);
    }

    public static void main(String[] arg) throws Exception {
        FileInputStream in = new FileInputStream(arg[0]);
        RosterDocument doc = new RosterDocument(in);
        if (arg.length > 2 && arg[1].equals("remove")) {
            doc.removeItem(arg[2]);
        }
        if (arg.length > 1) {
            FileInputStream in1 = new FileInputStream(arg[1]);
            RosterDocument doc1 = new RosterDocument(in1);
            doc.merge(doc1);
        }
        System.out.println("\n---\n" + doc.toString() + "\n---");
    }

    static {
        tf = TransformerFactory.newInstance();
        _fac = DocumentBuilderFactory.newInstance();
        _fac.setValidating(false);
        _fac.setNamespaceAware(false);
        _fac.setIgnoringElementContentWhitespace(true);
        _fac.setIgnoringComments(true);
        _fac.setCoalescing(true);
    }
}

