/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.InviteNotifier;
import com.iplanet.im.client.api.NewMessageNotifier;
import com.iplanet.im.client.api.PollRecord;
import com.iplanet.im.client.api.iIMCollaborationPrincipal;
import com.iplanet.im.client.api.iIMConference;
import com.iplanet.im.client.api.iIMContact;
import com.iplanet.im.client.api.iIMContactGroup;
import com.iplanet.im.client.api.iIMContactList;
import com.iplanet.im.client.api.iIMMessage;
import com.iplanet.im.client.api.iIMNewsChannel;
import com.iplanet.im.client.api.iIMPresenceAccessRule;
import com.iplanet.im.client.api.iIMPresenceSubscription;
import com.iplanet.im.client.api.iIMProfile;
import com.iplanet.im.client.api.iIMSessionFactory;
import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.ConnectionEvent;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.ConnectionStatusListener;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.MessageStatusEvent;
import com.iplanet.im.net.MsgStatusListener;
import com.iplanet.im.net.QueueMsg;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.UserEvent;
import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.UserStatus;
import com.iplanet.im.net.UserStatusListener;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.util.StringUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.ConferenceSessionListener;
import com.sun.im.service.MessagePart;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.NewsSession;
import com.sun.im.service.NotificationSession;
import com.sun.im.service.NotificationSessionListener;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreSession;
import com.sun.im.service.Poll;
import com.sun.im.service.PollHelper;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceAccessRule;
import com.sun.im.service.PresenceHelper;
import com.sun.im.service.PresenceInfoListener;
import com.sun.im.service.PresenceSession;
import com.sun.im.service.PresenceSubscription;
import com.sun.im.service.PresenceTuple;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class iIMSession
implements PresenceSession,
ConferenceSession,
NewsSession,
NotificationSession,
UserStatusListener,
MessageListener,
MsgStatusListener,
PersonalStoreSession,
ConnectionStatusListener {
    Properties _props;
    protected ConnectionFactory connectionFactory;
    protected iIMQueue myDestination;
    protected Connection myConnection;
    private Hashtable _subscriptions = new Hashtable();
    CollaborationSessionListener _sessionListener;
    iIMSessionFactory _fac;
    private int _status = 2;
    private Hashtable _messageStatusListeners = new Hashtable();
    private Hashtable _pollRecords = new Hashtable();
    private Hashtable _contactLists = new Hashtable();
    private Hashtable _userSettings = new Hashtable();
    private Hashtable _userCache = new Hashtable();
    private Hashtable _polls = new Hashtable();
    private Vector _personalFolders = null;
    private Config _config;
    private int _loginType;
    private Hashtable _profiles = new Hashtable();
    private Hashtable _noSaveAttrs = new Hashtable();
    private iIMProfile _personalProfile;
    private static final String ID_CUST_GROUP = "custom.";
    private static final String ID_CUST_USER = "custusr.";
    private static final String ID_CUST_USER_COUNT = "cust.usr.num.";
    private static final String ID_CUST_LDAP_GROUP = "g:";
    private ArrayList _acl;
    private boolean _grant;
    private BooleanAccessControlList _bacl;

    public iIMSession() throws CollaborationException {
    }

    void init(iIMSessionFactory fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener) {
        this._fac = fac;
        this._sessionListener = listener;
        this._loginType = loginType;
        this._props = new Properties();
        ((Hashtable)this._props).put("net.nms", serviceUrl);
        ((Hashtable)this._props).put("net.user", loginName);
        ((Hashtable)this._props).put("net.password", password);
        ((Hashtable)this._props).put("net.login", new Integer(loginType).toString());
    }

    void checkContactListLoaded() throws CollaborationException {
        if (this._personalFolders == null) {
            this._personalFolders = this.loadContactList(this._config.userSettings, null);
        }
    }

    void start() throws CollaborationException {
        this._config = this.connectionFactory.login();
        if (this._config.queues != null && this._loginType == 1) {
            int i = 0;
            while (i < this._config.queues.length) {
                Connection c = this.connectionFactory.createConnection(this._config.queues[i]);
                if (this.myConnection == null) {
                    this.myConnection = c;
                }
                c.addChangeListener(this);
                c.start();
                ++i;
            }
            this.myDestination = this._config.queues[0];
        }
        this.connectionFactory.addUserStatusListener(this);
        this.connectionFactory.addMsgStatusListener(this);
        this.connectionFactory.addConnectionStatusListener(this);
        this._personalProfile = this.loadProfile(this._config.me.getAttributes(), this._config.userSettings, null);
    }

    public iIMSession(iIMSessionFactory fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener) throws CollaborationException {
        this.init(fac, serviceUrl, loginName, password, loginType, listener);
        iIMSessionFactory.debug("connecting to " + serviceUrl);
        this.connectionFactory = new ConnectionFactory(this._props);
        try {
            this.connectionFactory.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CollaborationException(e.toString());
        }
        iIMSessionFactory.debug("Server Version: " + this.connectionFactory.getServerVersionDisplayString());
        this.start();
        iIMSessionFactory.debug("Authenticated to server " + this.connectionFactory.getServerName() + " as " + loginName);
    }

    public void setSessionListener(CollaborationSessionListener listener) {
        this._sessionListener = listener;
    }

    public CollaborationSession accessService(String service) throws CollaborationException {
        if (!(service.equals("presence") || service.equals("news") || service.equals("conference") || service.equals("pstore") || service.equals("notification"))) {
            throw new CollaborationException("Service not implemented");
        }
        return this;
    }

    public void logout() {
        if (this._status != 2) {
            this._status = 2;
            if (this._loginType == 1) {
                try {
                    this.connectionFactory.setUserStatus(2, "disconnected");
                }
                catch (Exception e) {
                    iIMSessionFactory.debug("Failed to update status");
                }
            }
        }
        this._fac.removeSession(this);
        this.connectionFactory.close();
    }

    public String[] getValues(String attribute) throws CollaborationException {
        return null;
    }

    public void sendMessage(com.sun.im.service.Message message, MessageStatusListener listener) throws CollaborationException {
        Message m = ((iIMMessage)message).getNetMessage();
        if (listener != null) {
            Destination[] rcpts = m.getTo();
            try {
                if (message.getContentType().equals("application/x-iim-poll")) {
                    MessagePart[] parts = message.getParts();
                    PollRecord pr = new PollRecord();
                    pr.helper = new PollHelper((String)m.getBody());
                    pr.refCount = rcpts.length;
                    this._pollRecords.put(message.getMessageId(), pr);
                    Vector<String> answers = new Vector<String>();
                    int i = 0;
                    while (i < pr.helper.countAnswers()) {
                        answers.addElement(pr.helper.getAnswer(i));
                        ++i;
                    }
                    Hashtable<String, Object> ht = new Hashtable<String, Object>();
                    m.setSubject(pr.helper.getQuestion());
                    ht.put("BODY", answers);
                    if (pr.helper.isCustomAnswerAllowed()) {
                        ht.put("CUSTOM", " ");
                    }
                    m.setBody(ht);
                } else if (message.getContentType().equals("text/x-iim-url")) {
                    URL url = new URL((String)m.getBody());
                    m.setBody(url);
                }
            }
            catch (Exception e) {
                throw new CollaborationException(e.toString());
            }
            int i = 0;
            while (i < rcpts.length) {
                String key = this.getMessageListenerKey(message.getMessageId(), rcpts[i]);
                this._messageStatusListeners.put(key, listener);
                iIMSessionFactory.debug("Requesting message status from " + key);
                ++i;
            }
        }
        this.connectionFactory.addMsg(m);
    }

    protected PollHelper getPollHelper(String msgId) {
        PollRecord pr = (PollRecord)this._pollRecords.get(msgId);
        if (pr != null) {
            if (pr.refCount-- < 1) {
                this._pollRecords.remove(msgId);
            }
            return pr.helper;
        }
        return null;
    }

    protected Poll getPoll(String msgId) {
        Poll ph = (Poll)this._polls.get(msgId);
        if (ph != null) {
            this._polls.remove(msgId);
        }
        return ph;
    }

    public NewsChannel newNewsChannel(String destination, NewsChannelListener listener, int defaultAccess) throws CollaborationException {
        return new iIMNewsChannel(this, destination, listener, defaultAccess);
    }

    public com.sun.im.service.Message createMessage(String destination) throws CollaborationException {
        iIMQueue q = this.createQueue(destination);
        return new iIMMessage(this, q, this.myDestination);
    }

    public com.sun.im.service.Message createMessage() throws CollaborationException {
        return new iIMMessage(this, this.myDestination);
    }

    protected String getUserId() {
        return (String)((Hashtable)this._props).get("net.user");
    }

    protected String getServiceUrl() {
        return (String)((Hashtable)this._props).get("net.nms");
    }

    public Conference setupConference(ConferenceListener listener, int accessLevel) throws CollaborationException {
        return new iIMConference(this, listener, accessLevel);
    }

    public Conference setupPublicConference(String destination, ConferenceListener listener, int accessLevel) throws CollaborationException {
        return new iIMConference(this, destination, listener, accessLevel);
    }

    public synchronized Conference joinPublicConference(String destination, ConferenceListener listener) throws CollaborationException {
        return this.joinPublicConference(destination, listener, null);
    }

    public synchronized Conference joinPublicConference(String destination, ConferenceListener listener, String note) throws CollaborationException {
        Room[] r = this.connectionFactory.searchRooms(null, destination);
        if (r == null) {
            throw new CollaborationException("Conference " + destination + " not found.");
        }
        return new iIMConference(this, r[0], listener, note);
    }

    private Room findRoom(String destination) throws CollaborationException {
        String sUid = StringUtility.appendDomainToAddress(destination, this.connectionFactory.getServerName());
        Room[] r = this.connectionFactory.searchRooms("*", sUid);
        if (r != null && r.length == 1) {
            return r[0];
        }
        return null;
    }

    private Topic findTopic(String destination) throws CollaborationException {
        String sUid = StringUtility.appendDomainToAddress(destination, this.connectionFactory.getServerName());
        Topic[] t = this.connectionFactory.searchTopics("*", sUid);
        if (t != null && t.length == 1) {
            return t[0];
        }
        return null;
    }

    public synchronized NewsChannel getNewsChannel(String destination, NewsChannelListener listener) throws CollaborationException {
        Topic t = this.findTopic(destination);
        if (t == null) {
            return null;
        }
        return new iIMNewsChannel(this, t, listener);
    }

    public PresenceSubscription subscribe(String presentity, PresenceInfoListener listener) throws CollaborationException {
        return this.subscribe(presentity, listener, null);
    }

    public PresenceSubscription subscribe(String[] presentity, PresenceInfoListener listener) throws CollaborationException {
        return this.subscribe(presentity, listener, null);
    }

    public PresenceSubscription subscribe(String presentity, PresenceInfoListener listener, Date expires) throws CollaborationException {
        iIMPresenceSubscription subs = new iIMPresenceSubscription(this, listener);
        iIMQueue q = this.createQueue(presentity);
        try {
            UserStatus s = this.connectionFactory.getUserStatus(q, true);
            listener.onPresenceInfo(iIMSession.encodePresenceInfo(presentity, s));
            subs.setStatus(q, s);
            this._subscriptions.put(q.getUID(), subs);
        }
        catch (Exception e) {
            subs = null;
            this._subscriptions.remove(q.getUID());
            throw new CollaborationException(e.toString());
        }
        return subs;
    }

    /*
     * Unable to fully structure code
     */
    public PresenceSubscription subscribe(String[] presentity, PresenceInfoListener listener, Date expires) throws CollaborationException {
        block5: {
            subs = new iIMPresenceSubscription(this, listener);
            q = new iIMQueue[presentity.length];
            i = 0;
            while (i < presentity.length) {
                q[i] = this.createQueue(presentity[i]);
                ++i;
            }
            try {
                s = this.connectionFactory.getUserStatus(q, true);
                subs.setStatus(q, s);
                i = 0;
                while (i < s.length) {
                    this._subscriptions.put(q[i].getUID(), subs);
                    listener.onPresenceInfo(iIMSession.encodePresenceInfo(presentity[i], s[i]));
                    ++i;
                }
                break block5;
            }
            catch (Exception e) {
                subs = null;
                i = 0;
                ** while (i < presentity.length)
            }
lbl-1000:
            // 1 sources

            {
                this._subscriptions.remove(q[i].getUID());
                ++i;
                continue;
            }
lbl27:
            // 1 sources

            throw new CollaborationException(e.toString());
        }
        return subs;
    }

    public void unsubscribe(String[] presentity) throws CollaborationException {
        iIMQueue[] q = new iIMQueue[presentity.length];
        int i = 0;
        while (i < presentity.length) {
            q[i] = this.createQueue(presentity[i]);
            iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(q[i].getUID());
            if (subs != null) {
                this._subscriptions.remove(q[i].getUID());
                subs.close();
            }
            ++i;
        }
    }

    public void unsubscribe(String presentity) throws CollaborationException {
        iIMQueue q = this.createQueue(presentity);
        iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(q.getUID());
        if (subs != null) {
            subs.close();
        }
        this._subscriptions.remove(q.getUID());
    }

    protected static UserStatus decodePresenceInfo(String presenceInfo) throws CollaborationException {
        int intStatus;
        PresenceHelper ph;
        try {
            ph = new PresenceHelper(presenceInfo);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
        PresenceTuple pt = (PresenceTuple)ph.getTuples().iterator().next();
        if (pt.getStatus().equals("OPEN")) {
            intStatus = 1;
        } else if (pt.getStatus().equals("CLOSED")) {
            intStatus = 2;
        } else if (pt.getStatus().equals("AWAY")) {
            intStatus = 3;
        } else if (pt.getStatus().equals("IDLE")) {
            intStatus = 4;
        } else if (pt.getStatus().equals("BUSY")) {
            intStatus = 4;
        } else if (pt.getStatus().equals("FORWARDED")) {
            intStatus = 6;
        } else {
            throw new CollaborationException("Unsupported Presence status: " + pt.getStatus());
        }
        return new UserStatus(intStatus, pt.getNote(), -1);
    }

    protected static String encodePresenceInfo(String destination, UserStatus status) throws CollaborationException {
        Presence p = new Presence(destination);
        PresenceTuple tuple = new PresenceTuple(destination);
        tuple.addNote(status.getReason());
        switch (status.getStatus()) {
            case 1: {
                tuple.setStatus("OPEN");
                break;
            }
            case 2: {
                tuple.setStatus("CLOSED");
                break;
            }
            case 3: {
                tuple.setStatus("AWAY");
                break;
            }
            case 4: {
                tuple.setStatus("IDLE");
                break;
            }
            case 6: {
                tuple.setStatus("FORWARDED");
                break;
            }
            case -1: {
                throw new CollaborationException("An error occurred while retrieving presence status");
            }
            default: {
                throw new CollaborationException("Unsupported Status value: " + status.getStatus());
            }
        }
        p.addTuple(tuple);
        return p.toString();
    }

    public void publish(String presenceInfo) throws CollaborationException {
        if (this._loginType != 1) {
            return;
        }
        UserStatus s = iIMSession.decodePresenceInfo(presenceInfo);
        this.connectionFactory.setUserStatus(s.getStatus(), s.getReason());
    }

    public void fetch(String presentity, PresenceInfoListener listener) throws CollaborationException {
        iIMQueue q = this.createQueue(presentity);
        iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(q.getUID());
        UserStatus s = subs != null ? subs.getStatus(q) : this.connectionFactory.getUserStatus(q, false);
        listener.onPresenceInfo(iIMSession.encodePresenceInfo(presentity, s));
    }

    public String fetch(String presentity) throws CollaborationException {
        iIMQueue q = this.createQueue(presentity);
        iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(q.getUID());
        UserStatus s = subs != null ? subs.getStatus(q) : this.connectionFactory.getUserStatus(q, false);
        return iIMSession.encodePresenceInfo(presentity, s);
    }

    public void fetch(String[] presentity, PresenceInfoListener listener) throws CollaborationException {
        ArrayList<iIMQueue> list = new ArrayList<iIMQueue>();
        int i = 0;
        while (i < presentity.length) {
            iIMQueue q = this.createQueue(presentity[i]);
            iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(q.getUID());
            if (subs != null) {
                UserStatus s = subs.getStatus(q);
                listener.onPresenceInfo(iIMSession.encodePresenceInfo(presentity[i], s));
            } else {
                list.add(q);
            }
            ++i;
        }
        iIMQueue[] qarray = new iIMQueue[list.size()];
        int ix = 0;
        Iterator i2 = ((AbstractList)list).iterator();
        while (i2.hasNext()) {
            qarray[ix++] = (iIMQueue)i2.next();
        }
        try {
            UserStatus[] s = this.connectionFactory.getUserStatus(qarray, false);
            int i3 = 0;
            while (i3 < qarray.length) {
                listener.onPresenceInfo(iIMSession.encodePresenceInfo(qarray[i3].getUID(), s[i3]));
                ++i3;
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    protected iIMQueue createQueue(String address) {
        String domain;
        String name;
        int n = address.indexOf(64);
        if (n <= 0) {
            name = address;
            domain = this.connectionFactory.getServerName();
        } else {
            name = address.substring(0, n);
            domain = address.substring(n + 1);
        }
        return new iIMQueue(name, domain);
    }

    /*
     * Unable to fully structure code
     */
    public String[] fetch(String[] presentity) throws CollaborationException {
        result = new String[presentity.length];
        list = new ArrayList<iIMQueue>();
        i = 0;
        while (i < presentity.length) {
            q = this.createQueue(presentity[i]);
            subs = (iIMPresenceSubscription)this._subscriptions.get(q.getUID());
            if (subs != null) {
                s = subs.getStatus(q);
                result[i] = iIMSession.encodePresenceInfo(presentity[i], s);
            } else {
                result[i] = null;
                list.add(q);
            }
            ++i;
        }
        qarray = new iIMQueue[list.size()];
        ix = 0;
        i = list.iterator();
        while (i.hasNext()) {
            qarray[ix++] = (iIMQueue)i.next();
        }
        s = this.connectionFactory.getUserStatus(qarray, false);
        j = 0;
        i = 0;
        ** GOTO lbl31
        {
            ++j;
            do {
                if (result[j] != null) continue block2;
                result[j++] = iIMSession.encodePresenceInfo(presentity[i], s[i]);
                ++i;
lbl31:
                // 2 sources

            } while (i < qarray.length);
        }
        return result;
    }

    public synchronized Collection listNewsChannels(String domain) throws CollaborationException {
        iIMSessionFactory.debug("Looking for bulletin boards in " + this.connectionFactory.getServerName());
        Topic[] topics = this.connectionFactory.getTopics(domain);
        ArrayList<iIMNewsChannel> list = new ArrayList<iIMNewsChannel>();
        if (topics != null) {
            int i = 0;
            while (i < topics.length) {
                iIMSessionFactory.debug("Found news channel: " + topics[i].getName());
                list.add(new iIMNewsChannel(this, topics[i]));
                ++i;
            }
        }
        return list;
    }

    public synchronized Collection listPublicConferences(String domain) throws CollaborationException {
        iIMSessionFactory.debug("Looking for public conferences in " + this.connectionFactory.getServerName());
        Room[] rooms = this.connectionFactory.searchRooms(domain, "*");
        ArrayList<iIMConference> list = new ArrayList<iIMConference>();
        if (rooms != null) {
            int i = 0;
            while (i < rooms.length) {
                iIMSessionFactory.debug("Found conference: " + rooms[i].getName());
                list.add(new iIMConference(this, rooms[i]));
                ++i;
            }
        }
        return list;
    }

    public synchronized Conference getPublicConference(String destination) throws CollaborationException {
        iIMConference c = null;
        String domain = StringUtility.getDomainFromAddress(destination, this.connectionFactory.getServerName());
        Room r = this.findRoom(destination);
        if (r != null) {
            c = new iIMConference(this, r);
        }
        return c;
    }

    public void userStatusChange(UserEvent e) {
        iIMPresenceSubscription subs = (iIMPresenceSubscription)this._subscriptions.get(e.getUID());
        try {
            if (subs != null) {
                subs.fire(iIMSession.encodePresenceInfo(e.getUID(), e.getStatus()));
                subs.setStatus(e.getUID(), e.getStatus());
            }
        }
        catch (CollaborationException x) {
            x.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageAdded(MessageEvent e) {
        iIMSessionFactory.debug("message received");
        if (e.getConnection().equals(this.myConnection)) {
            QueueMsg m = (QueueMsg)e.getMsg();
            iIMSessionFactory.debug("message received for me: " + this.connectionFactory.getCurrentUser().getUID() + " from " + m.getFrom().getUID());
            String ct = m.getContentType();
            try {
                if (ct.equals("net/invite")) {
                    iIMSessionFactory.debug("invite received");
                    Object[] a = (Object[])m.getBody();
                    iIMSessionFactory.debug(a.length + " objects in body");
                    String invitation = (String)a[0];
                    Room room = (Room)a[1];
                    iIMSessionFactory.debug("invitation to join " + room.toString() + " : " + invitation);
                    iIMConference c = new iIMConference(this, room);
                    if (this._sessionListener instanceof ConferenceSessionListener) {
                        iIMMessage message = new iIMMessage(this, m);
                        message.setContent(invitation);
                        InviteNotifier inv = new InviteNotifier(c, message, (ConferenceSessionListener)this._sessionListener);
                        this._fac.addRunnable(inv);
                        return;
                    }
                    iIMSessionFactory.debug("Not a Conference Session - cannot process invites");
                    return;
                }
                if (ct.equals("net/html") || ct.equals("net/htmlex") || ct.equals("net/text") || ct.equals("net/url") || ct.equals("net/urlex")) {
                    if (!(this._sessionListener instanceof NotificationSessionListener)) return;
                    iIMMessage message = new iIMMessage(this, m);
                    NewMessageNotifier nmn = new NewMessageNotifier(message, (NotificationSessionListener)this._sessionListener);
                    this._fac.addRunnable(nmn);
                    return;
                }
                if (ct.equals("net/reply")) {
                    String key = this.getMessageListenerKey(m.getCorrelationMsgId(), m.getFrom());
                    MessageStatusListener msl = (MessageStatusListener)this._messageStatusListeners.get(key);
                    if (msl != null) {
                        iIMMessage message = new iIMMessage(this, m);
                        msl.onReply(message);
                        this._messageStatusListeners.remove(key);
                        iIMSessionFactory.debug("Removed status listener: " + key);
                        return;
                    }
                    iIMSessionFactory.debug(" !!! No listener corresponds to this reply");
                    return;
                }
                if (ct.equals("net/pollreply")) {
                    if (!(this._sessionListener instanceof NotificationSessionListener)) return;
                    String key = this.getMessageListenerKey(m.getCorrelationMsgId(), m.getFrom());
                    MessageStatusListener msl = (MessageStatusListener)this._messageStatusListeners.get(key);
                    if (msl != null) {
                        PollHelper ph = this.getPollHelper(m.getCorrelationMsgId());
                        if (ph != null) {
                            String content = ph.createResponse((String)m.getBody());
                            iIMMessage message = new iIMMessage(this, m);
                            message.setContent(content);
                            msl.onReply(message);
                        } else {
                            iIMSessionFactory.debug(" !!! No poll corresponds to this poll response");
                        }
                        this._messageStatusListeners.remove(key);
                        iIMSessionFactory.debug("Removed status listener: " + key);
                        return;
                    }
                    iIMSessionFactory.debug(" !!! No listener corresponds to this reply: " + this.getMessageListenerKey(m.getCorrelationMsgId(), m.getFrom()));
                    return;
                }
                if (ct.equals("net/poll")) {
                    if (!(this._sessionListener instanceof NotificationSessionListener)) return;
                    iIMMessage message = new iIMMessage(this, m);
                    Hashtable ht = (Hashtable)m.getBody();
                    Vector answers = (Vector)ht.get("BODY");
                    boolean allowCustom = false;
                    if (ht.get("CUSTOM") != null) {
                        allowCustom = true;
                    }
                    Poll helper = new Poll(m.getSubject(), answers, allowCustom);
                    message.setContent(helper.toString());
                    this._polls.put(m.getMsgid(), helper);
                    NewMessageNotifier nmn = new NewMessageNotifier(message, (NotificationSessionListener)this._sessionListener);
                    this._fac.addRunnable(nmn);
                    return;
                }
                iIMSessionFactory.debug("Unrecognized content type: " + m.getContentType());
                return;
            }
            catch (CollaborationException ex) {
                ex.printStackTrace();
                return;
            }
        } else {
            iIMSessionFactory.debug("Connection mismatch");
        }
    }

    public void messageDeleted(MessageEvent e) {
        iIMSessionFactory.debug("GROS CACA");
    }

    protected static int getNetAccessLevel(int accessLevel) throws CollaborationException {
        switch (accessLevel) {
            case 1: {
                return 1;
            }
            case 2: 
            case 14: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 30: {
                return 14;
            }
        }
        throw new CollaborationException("Invalid access level " + accessLevel);
    }

    protected static int getConference(int netAccessLevel) throws CollaborationException {
        switch (netAccessLevel) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 14: {
                return 30;
            }
        }
        throw new CollaborationException("Invalid net access level " + netAccessLevel);
    }

    private int getApiStatus(int netStatus) throws CollaborationException {
        switch (netStatus) {
            case 0: {
                return 1;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 4;
            }
            case -1: {
                return 2;
            }
            case -2: {
                return 2;
            }
            case -3: {
                return 6;
            }
            case -4: {
                return 3;
            }
            case 3: {
                return 5;
            }
        }
        throw new CollaborationException("Unsupported Net Message status: " + netStatus);
    }

    private int getNetStatus(int status) throws CollaborationException {
        switch (status) {
            case 1: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return -1;
            }
            case 6: {
                return -3;
            }
            case 3: {
                return -4;
            }
            case 5: {
                return 3;
            }
        }
        throw new CollaborationException("Unsupported Message status: " + status);
    }

    private String getMessageListenerKey(String messageId, Destination d) {
        return messageId + ";" + d.getUID();
    }

    public void msgStatusChange(MessageStatusEvent e) {
        String key = this.getMessageListenerKey(e.getMsgid(), e.getDestination());
        MessageStatusListener l = (MessageStatusListener)this._messageStatusListeners.get(key);
        if (l != null) {
            int status = 2;
            try {
                status = this.getApiStatus(e.getStatus());
            }
            catch (CollaborationException x) {
                x.printStackTrace();
            }
            boolean more = l.onReceipt(e.getDestination().getUID(), status);
            if (!more || status == 2 || status == 6 || status == 3) {
                this._messageStatusListeners.remove(key);
                iIMSessionFactory.debug("Removed status listener: " + key);
            }
        }
    }

    private Vector loadContactList(Properties p, iIMUser owner) throws CollaborationException {
        Vector<iIMContactList> folders = new Vector<iIMContactList>(10);
        ArrayList<PersonalStoreEntry> contactList = new ArrayList<PersonalStoreEntry>(10);
        ArrayList<String> uidList = new ArrayList<String>(10);
        ArrayList<String> gidList = new ArrayList<String>(10);
        if (p == null) {
            return folders;
        }
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            int num;
            String grp;
            iIMContactList folder;
            String temp = (String)e.nextElement();
            if (!temp.startsWith(ID_CUST_GROUP) || folders.contains(folder = new iIMContactList(this, grp = p.getProperty(temp), owner))) continue;
            folders.addElement(folder);
            String grpkey = grp.replace(' ', '_');
            String sCount = p.getProperty(ID_CUST_USER_COUNT + grpkey);
            ((Hashtable)p).remove(temp);
            iIMSessionFactory.debug("Found folder : " + grp);
            if (sCount == null) continue;
            try {
                num = Integer.parseInt(sCount);
            }
            catch (Exception x) {
                x.printStackTrace();
                continue;
            }
            iIMSessionFactory.debug("# contacts = " + num);
            int n = 0;
            while (n < num) {
                String usrkey = ID_CUST_USER + grpkey + Integer.toString(n);
                String id = p.getProperty(usrkey);
                if (id != null) {
                    PersonalStoreEntry contact;
                    iIMSessionFactory.debug("Found user : " + id);
                    if (id.startsWith(ID_CUST_LDAP_GROUP)) {
                        id = id.substring(ID_CUST_LDAP_GROUP.length());
                        contact = new iIMContactGroup(this, id);
                        ((iIMContactGroup)contact).addToFolder(folder);
                        gidList.add(id);
                        contactList.add(contact);
                    } else {
                        contact = new iIMContact(this, id);
                        ((iIMContact)contact).addToFolder(folder);
                        uidList.add(id);
                        contactList.add(contact);
                    }
                    ((Hashtable)p).remove(usrkey);
                }
                ++n;
            }
        }
        int n = uidList.size();
        int i = 0;
        String[] uidArray = new String[n];
        Iterator iter = ((AbstractList)uidList).iterator();
        while (iter.hasNext()) {
            uidArray[i++] = (String)iter.next();
        }
        int m = gidList.size();
        int j = 0;
        String[] gidArray = new String[m];
        Iterator iter2 = ((AbstractList)gidList).iterator();
        while (iter2.hasNext()) {
            gidArray[j++] = (String)iter2.next();
        }
        i = 0;
        j = 0;
        iIMContact[] contactArray = new iIMContact[n];
        iIMContactGroup[] contactGroupArray = new iIMContactGroup[m];
        Iterator iter3 = ((AbstractList)contactList).iterator();
        while (iter3.hasNext()) {
            PersonalStoreEntry entry = (PersonalStoreEntry)iter3.next();
            if (entry.getType() == "contact") {
                contactArray[i++] = (iIMContact)entry;
                continue;
            }
            contactGroupArray[j++] = (iIMContactGroup)entry;
        }
        iIMUser[] users = this.connectionFactory.getiIMUsersFromUIDs(uidArray);
        j = 0;
        while (j < users.length) {
            if (users[j] != null) {
                contactArray[j].setiIMUser(users[j]);
            } else {
                contactArray[j].remove();
            }
            ++j;
        }
        iIMGroup[] groups = this.connectionFactory.getiIMGroupsFromUIDs(gidArray);
        j = 0;
        while (j < groups.length) {
            if (groups[j] != null) {
                contactGroupArray[j].setiIMGroup(groups[j]);
            } else {
                contactGroupArray[j].remove();
            }
            ++j;
        }
        return folders;
    }

    public void save() throws CollaborationException {
        this.checkContactListLoaded();
        this.save(this._config.userSettings, this._personalFolders, null);
        Enumeration e = this._contactLists.keys();
        while (e.hasMoreElements()) {
            String uid = (String)e.nextElement();
            Properties p = (Properties)this._userSettings.get(uid);
            iIMUser u = (iIMUser)this._userCache.get(uid);
            Collection folders = (Collection)this._contactLists.get(uid);
            if (u == null || folders == null || p == null) continue;
            iIMSessionFactory.debug("Saving for: " + uid + "/" + u.getUID());
            this.save(p, folders, u);
        }
        this._contactLists.clear();
        this._userSettings.clear();
        this._userCache.clear();
    }

    public void save(iIMUser owner) throws CollaborationException {
        if (owner == null) {
            this.save();
            return;
        }
        try {
            String uid = owner.getUID();
            Properties p = (Properties)this._userSettings.get(uid);
            Collection folders = (Collection)this._contactLists.get(uid);
            if (folders != null && p != null) {
                this.save(p, folders, owner);
                this._contactLists.remove(uid);
                this._userSettings.remove(uid);
                this._userCache.remove(uid);
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    protected void save(Properties props, Collection folders, iIMUser user) throws CollaborationException {
        Properties p = props != null ? (Properties)((Hashtable)props).clone() : new Properties();
        Iterator iter = folders.iterator();
        while (iter.hasNext()) {
            iIMContactList cl = (iIMContactList)iter.next();
            Collection entries = cl.getEntries();
            String grp = cl.getDisplayName();
            String grpkey = grp.replace(' ', '_');
            ((Hashtable)p).put(ID_CUST_GROUP + grpkey, grp);
            ((Hashtable)p).put(ID_CUST_USER_COUNT + grpkey, Integer.toString(entries.size()));
            int index = 0;
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                PersonalStoreEntry e = (PersonalStoreEntry)i.next();
                if (e.getType() == "contact") {
                    iIMContact c = (iIMContact)e;
                    ((Hashtable)p).put(ID_CUST_USER + grpkey + Integer.toString(index), c.getAddress("im"));
                } else {
                    iIMContactGroup g = (iIMContactGroup)e;
                    ((Hashtable)p).put(ID_CUST_USER + grpkey + Integer.toString(index), ID_CUST_LDAP_GROUP + g.getEntryId());
                }
                ++index;
            }
        }
        try {
            this.connectionFactory.saveUserSettings(user, p, false);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public Collection getEntries(String entryType) throws CollaborationException {
        if (entryType.equals("conference")) {
            Room[] r = this.connectionFactory.getRooms("*");
            LinkedList<iIMConference> l = new LinkedList<iIMConference>();
            if (r == null) {
                return l;
            }
            int i = 0;
            while (i < r.length) {
                l.add(new iIMConference(this, r[i]));
                ++i;
            }
            return l;
        }
        return null;
    }

    public PersonalStoreEntry getEntry(String entryType, String entryId) throws CollaborationException {
        if (entryType.equals("conference")) {
            Room[] r = this.connectionFactory.getRooms("*");
            int i = 0;
            while (i < r.length) {
                if (r[i].getFQName().equals(entryId)) {
                    return new iIMConference(this, r[i]);
                }
                ++i;
            }
            return null;
        }
        this.checkContactListLoaded();
        return this.getEntry(entryType, entryId, this._personalFolders);
    }

    public PersonalStoreEntry getEntry(CollaborationPrincipal principal, String entryType, String entryId) throws CollaborationException {
        Collection folders = this.getFolders(principal, "book");
        if (folders != null) {
            return this.getEntry(entryType, entryId, folders);
        }
        return null;
    }

    public PersonalStoreEntry getEntry(String entryType, String entryId, Collection folders) throws CollaborationException {
        block4: {
            block5: {
                block3: {
                    if (!entryType.equals("abook") && !entryType.equals("book")) break block3;
                    Iterator iter = folders.iterator();
                    while (iter.hasNext()) {
                        iIMContactList cl = (iIMContactList)iter.next();
                        if (!cl.getDisplayName().equals(entryId)) continue;
                        return cl;
                    }
                    break block4;
                }
                if (!entryType.equals("contact")) break block5;
                String uid = StringUtility.appendDomainToAddress(entryId, this.connectionFactory.getServerName());
                Iterator iter = folders.iterator();
                while (iter.hasNext()) {
                    iIMContactList cl = (iIMContactList)iter.next();
                    PersonalStoreEntry c = cl.getEntry(uid);
                    if (c == null) continue;
                    return c;
                }
                break block4;
            }
            if (!entryType.equals("group")) break block4;
            String gid = StringUtility.appendDomainToAddress(entryId, this.connectionFactory.getServerName());
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                iIMContactList cl = (iIMContactList)iter.next();
                PersonalStoreEntry c = cl.getEntry(gid);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public Collection getFolders(String entryType) throws CollaborationException {
        this.checkContactListLoaded();
        return this._personalFolders;
    }

    public Collection getFolders(CollaborationPrincipal p, String entryType) throws CollaborationException {
        iIMUser u = (iIMUser)((iIMCollaborationPrincipal)p).getiIMPrincipal();
        return this.getFolders(u, entryType);
    }

    public Collection getFolders(iIMUser u, String entryType) throws CollaborationException {
        try {
            this.checkContactListLoaded();
            Collection folders = (Collection)this._contactLists.get(u.getUID());
            if (folders == null) {
                Properties settings = this.connectionFactory.getUserSettings(u);
                folders = this.loadContactList(settings, u);
                this._contactLists.put(u.getUID(), folders);
                this._userSettings.put(u.getUID(), settings);
                this._userCache.put(u.getUID(), u);
            }
            return folders;
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public PersonalStoreEntry createEntry(String entryType, String displayName) throws CollaborationException {
        return this.createEntry(null, entryType, displayName, this._personalFolders);
    }

    public PersonalStoreEntry createEntry(CollaborationPrincipal principal, String entryType, String displayName) throws CollaborationException {
        this.checkContactListLoaded();
        iIMUser u = (iIMUser)((iIMCollaborationPrincipal)principal).getiIMPrincipal();
        Vector folders = this.getFolders(principal, "book");
        if (folders == null) {
            folders = new Vector();
        }
        return this.createEntry(u, entryType, displayName, folders);
    }

    private PersonalStoreEntry createEntry(iIMUser u, String entryType, String displayName, Collection folders) throws CollaborationException {
        this.checkContactListLoaded();
        if (entryType.equals("book") || entryType.equals("abook")) {
            PersonalStoreEntry entry = this.getEntry(entryType, displayName, folders);
            if (entry != null) {
                throw new CollaborationException("Folder name " + displayName + " already present!");
            }
            iIMContactList newcl = new iIMContactList(this, displayName, u);
            folders.add(newcl);
            return newcl;
        }
        if (entryType.equals("contact")) {
            return new iIMContact(this, displayName);
        }
        if (entryType.equals("group")) {
            return new iIMContactGroup(this, displayName);
        }
        throw new CollaborationException("Unsupported entry type: " + entryType);
    }

    protected void removeContactList(iIMContactList cl, iIMUser u) throws CollaborationException {
        Collection folders;
        this.checkContactListLoaded();
        if (u != null) {
            iIMSessionFactory.debug("removing contact list " + cl.getDisplayName() + " for " + u.getUID());
            folders = this.getFolders(u, "book");
        } else {
            iIMSessionFactory.debug("removing contact list " + cl.getDisplayName());
            folders = this._personalFolders;
        }
        if (folders != null) {
            folders.remove(cl);
        }
        this.save(u);
    }

    private iIMProfile loadProfile(Map m, Properties p, iIMUser owner) throws CollaborationException {
        Properties prop = new Properties();
        iIMUser u = owner;
        if (u == null) {
            u = this.connectionFactory.getCurrentUser();
        }
        this._noSaveAttrs.put(u.getUID(), m.keySet());
        ((Hashtable)prop).putAll(m);
        if (p != null) {
            Iterator i = ((Hashtable)p).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String temp = (String)e.getKey();
                if (temp.startsWith(ID_CUST_GROUP) || temp.startsWith(ID_CUST_USER) || temp.startsWith(ID_CUST_USER_COUNT)) continue;
                ((Hashtable)prop).put(temp, e.getValue());
            }
        }
        iIMProfile profile = new iIMProfile(this, "IM Profile", prop, owner);
        return profile;
    }

    public PersonalProfile getProfile() throws CollaborationException {
        return this._personalProfile;
    }

    public PersonalProfile getProfile(CollaborationPrincipal principal) throws CollaborationException {
        iIMUser u = (iIMUser)((iIMCollaborationPrincipal)principal).getiIMPrincipal();
        return this.getProfile(u);
    }

    private PersonalProfile getProfile(iIMUser u) throws CollaborationException {
        if (u == null) {
            return this._personalProfile;
        }
        PersonalProfile profile = null;
        try {
            profile = (PersonalProfile)this._profiles.get(u.getUID());
            if (profile == null) {
                Properties p = (Properties)this._userSettings.get(u.getUID());
                profile = this.loadProfile(u.getAttributes(), p, u);
                this._profiles.put(u.getUID(), profile);
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
        return profile;
    }

    public void saveProfile() throws CollaborationException {
        this.saveProfile(this._personalProfile, this.connectionFactory.getCurrentUser());
    }

    public void saveProfile(iIMUser owner) throws CollaborationException {
        if (owner == null) {
            this.saveProfile();
            return;
        }
        try {
            String uid = owner.getUID();
            iIMProfile profile = (iIMProfile)this._profiles.get(uid);
            if (profile != null) {
                this.saveProfile(profile, owner);
                this._profiles.remove(uid);
                this._noSaveAttrs.remove(uid);
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    protected void saveProfile(iIMProfile profile, iIMUser u) throws CollaborationException {
        Properties pclean;
        Properties props = (Properties)profile.getProperties();
        Set nosave = (Set)this._noSaveAttrs.get(u.getUID());
        if (nosave != null) {
            pclean = new Properties();
            Iterator i = ((Hashtable)props).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String temp = (String)e.getKey();
                if (nosave.contains(temp)) continue;
                ((Hashtable)pclean).put(temp, e.getValue());
            }
        } else {
            pclean = props;
        }
        try {
            this.connectionFactory.saveUserSettings(u, pclean, true);
        }
        catch (Exception ex) {
            throw new CollaborationException(ex.toString());
        }
    }

    public void removeProfile() throws CollaborationException {
        this.removeProfile(this._personalProfile, null);
    }

    public void removeProfile(iIMUser owner) throws CollaborationException {
        if (owner == null) {
            this.removeProfile();
            return;
        }
        try {
            String uid = owner.getUID();
            iIMProfile profile = (iIMProfile)this._profiles.get(uid);
            if (profile != null) {
                this.removeProfile(profile, owner);
                this._profiles.remove(uid);
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    protected void removeProfile(iIMProfile profile, iIMUser u) throws CollaborationException {
        Properties p = (Properties)profile.getProperties();
        ((Hashtable)p).clear();
        try {
            this.connectionFactory.saveUserSettings(u, p, false);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public void addAccessRule(PresenceAccessRule rule) throws CollaborationException {
        throw new CollaborationException("Only one rule is supported");
    }

    public Collection getAccessRules(String presentity) throws CollaborationException {
        if (this._acl == null) {
            this._acl = new ArrayList();
            this._bacl = this.connectionFactory.getUserACL(this.connectionFactory.getServerName(), this.connectionFactory.getCurrentUser());
            if (this._bacl == null) {
                this._bacl = new BooleanAccessControlList();
                this._bacl.setDefault(true);
            }
            iIMPresenceAccessRule par = new iIMPresenceAccessRule(this, this._bacl);
            this._acl.add(par);
        }
        return this._acl;
    }

    public void saveAccessRules() throws CollaborationException {
        ((iIMPresenceAccessRule)this._acl.get(0)).save();
    }

    public CollaborationPrincipal createPrincipal(String uid) throws CollaborationException {
        iIMPrincipal p = this.getNetPrincipal(uid);
        if (p == null) {
            throw new CollaborationException("Principal " + uid + " not found");
        }
        return new iIMCollaborationPrincipal(p);
    }

    protected iIMPrincipal getNetPrincipal(String uid) throws CollaborationException {
        return this.connectionFactory.getiIMUserFromUID(StringUtility.appendDomainToAddress(uid, this.connectionFactory.getServerName()));
    }

    public CollaborationPrincipal getPrincipal() throws CollaborationException {
        return new iIMCollaborationPrincipal(this.connectionFactory.getCurrentUser());
    }

    public void updateAvailable(ConnectionEvent e) {
    }

    public void connectionLost(ConnectionEvent e) {
        iIMSessionFactory.debug("Connection lost: " + e.toString());
        this._fac.removeSession(this);
        if (this._sessionListener != null) {
            this._sessionListener.onError(new CollaborationException(e.toString()));
        }
    }

    public CollaborationPrincipal[] searchPrincipals(int searchType, String pattern) throws CollaborationException {
        String wildcard = pattern;
        boolean byid = false;
        switch (searchType) {
            case 0: {
                byid = true;
                break;
            }
            case 1: {
                wildcard = "*" + pattern + "*";
                break;
            }
            case 3: {
                wildcard = "*" + pattern;
                break;
            }
            case 2: {
                wildcard = pattern + "*";
            }
        }
        UserSearchReply r = this.connectionFactory.searchForiIMUsers("", wildcard, byid);
        iIMPrincipal[] p = r.getPrincipals();
        if (p == null && p.length == 0) {
            return null;
        }
        CollaborationPrincipal[] result = new iIMCollaborationPrincipal[p.length];
        int i = 0;
        while (i < p.length) {
            result[i] = new iIMCollaborationPrincipal(p[i]);
            ++i;
        }
        return result;
    }

    private String getFilter(String pattern, int searchType) {
        String filter = pattern;
        switch (searchType) {
            case 1: {
                filter = "*" + pattern + "*";
                break;
            }
            case 3: {
                filter = "*" + pattern;
                break;
            }
            case 2: {
                filter = pattern + "*";
            }
        }
        return filter;
    }

    public PersonalStoreEntry[] search(int searchType, String pattern, String entryType) throws CollaborationException {
        if (entryType.equals("conference")) {
            String filter = this.getFilter(pattern, searchType);
            Room[] r = this.connectionFactory.searchRooms("*", filter);
            if (r == null) {
                return null;
            }
            PersonalStoreEntry[] result = new iIMConference[r.length];
            int i = 0;
            while (i < r.length) {
                result[i] = new iIMConference(this, r[i]);
                ++i;
            }
            return result;
        }
        if (entryType.equals("contact") || entryType.equals("group")) {
            CollaborationPrincipal[] p = this.searchPrincipals(searchType, pattern);
            return null;
        }
        return null;
    }

    public void removeRoomSubscription(Destination d) throws CollaborationException {
        this.connectionFactory.unsubscribe(d, this.connectionFactory.getCurrentUser());
    }

    public void addRoomSubscription(Destination d) throws CollaborationException {
        this.connectionFactory.subscribe(d, this.connectionFactory.getCurrentUser());
    }
}

