/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class DestinationAccessControlList
implements Serializable {
    static final long serialVersionUID = 8496595709808651411L;
    public static final int NONE = 1;
    public static final int READ = 2;
    public static final int LISTEN = 2;
    public static final int WRITE = 6;
    public static final int SPEAK = 6;
    public static final int VIEW = 6;
    public static final int MANAGE = 14;
    public static final int FULL = 14;
    private Vector v = new Vector();
    private int defaultAccess = 1;

    public void setDefault(int access) {
        this.defaultAccess = access;
    }

    public int getDefault() {
        return this.defaultAccess;
    }

    public Enumeration entries() {
        return new EntryEnum();
    }

    private Entry findEntry(iIMPrincipal p) {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            iIMPrincipal t = entry.p;
            if (p instanceof iIMUser && t instanceof iIMUser && p.getUID().equals(t.getUID())) {
                return entry;
            }
            if (!(p instanceof iIMGroup) || !(t instanceof iIMGroup) || !p.getUID().equals(t.getUID())) continue;
            return entry;
        }
        return null;
    }

    private Collection getGroups() {
        ArrayList<iIMPrincipal> list = new ArrayList<iIMPrincipal>();
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            iIMPrincipal t = entry.p;
            if (!(t instanceof iIMGroup)) continue;
            list.add(t);
        }
        return list;
    }

    public void add(iIMPrincipal p, int access) {
        Entry e = this.findEntry(p);
        if (e == null) {
            this.v.addElement(new Entry(p, access));
        }
    }

    public void remove(iIMPrincipal p) {
        Entry e = this.findEntry(p);
        if (e != null) {
            this.v.removeElement(e);
        }
    }

    public void removeAll() {
        this.v.removeAllElements();
    }

    public int getAccess(iIMPrincipal p) {
        Entry e = this.findEntry(p);
        if (e == null) {
            return this.defaultAccess;
        }
        return e.access;
    }

    public int getAccess(iIMPrincipal p, iIMRealm r) {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            iIMPrincipal t = entry.p;
            if (p instanceof iIMUser && t instanceof iIMUser && p.getUID().equals(t.getUID())) {
                return entry.access;
            }
            if (p instanceof iIMGroup && t instanceof iIMGroup && p.getUID().equals(t.getUID())) {
                return entry.access;
            }
            if (!(p instanceof iIMUser) || !(t instanceof iIMGroup) || !r.isMemberOfGroup(p, (iIMGroup)t)) continue;
            return entry.access;
        }
        return this.defaultAccess;
    }

    class EntryEnum
    implements Enumeration {
        Enumeration e;

        public EntryEnum() {
            Vector tmp = (Vector)DestinationAccessControlList.this.v.clone();
            this.e = tmp.elements();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            Entry entry = (Entry)this.e.nextElement();
            return entry.p;
        }
    }

    class Entry
    implements Serializable {
        iIMPrincipal p;
        int access;

        Entry(iIMPrincipal p, int access) {
            this.p = p;
            this.access = access;
        }
    }
}

