/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.BaseMessageImpl;
import com.iplanet.im.net.Message;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.MessagePart;
import com.sun.im.service.ReadOnlyMessagePart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MessagePartImpl
implements MessagePart {
    public Message _message;
    private byte[] _bytes = null;
    private String _filename = "1";
    private String _contentType = "application/octet-stream";
    private boolean _isTextPart = true;
    String _sContent = null;
    String _encoding = null;
    BaseMessageImpl _parent = null;

    public MessagePartImpl(Message m) {
        this._message = m;
        this._contentType = BaseMessageImpl.getContentType(this._message);
        this._sContent = Message.toString(this._message);
    }

    public MessagePartImpl() {
        this._isTextPart = true;
    }

    public MessagePartImpl(boolean isTextPart) {
        this._isTextPart = isTextPart;
    }

    public MessagePartImpl(BaseMessageImpl parent, Message m, String filename, byte[] b) {
        this._filename = filename;
        this._message = m;
        this._bytes = b;
        this._isTextPart = false;
        this._parent = parent;
    }

    public MessagePartImpl(Message m, String s) {
        this._sContent = s;
        this._message = m;
    }

    public int getSize() {
        if (this._isTextPart) {
            return this._sContent.length();
        }
        return this._bytes.length;
    }

    public String getContent() throws CollaborationException {
        if (this._isTextPart) {
            return this._sContent;
        }
        return null;
    }

    public synchronized InputStream getInputStream() throws CollaborationException {
        if (!this._isTextPart) {
            if (this._bytes != null) {
                return new ByteArrayInputStream(this._bytes, 0, this._bytes.length);
            }
        } else if (this._sContent != null) {
            byte[] b = this._sContent.getBytes();
            return new ByteArrayInputStream(b, 0, b.length);
        }
        return null;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getContentName() {
        return this._filename;
    }

    public String getContentID() {
        return this._filename;
    }

    public String getContentEncoding() {
        return this._encoding;
    }

    public void setContent(byte[] content, String enc) throws CollaborationException {
        if (this._isTextPart) {
            if (enc != null) {
                this._encoding = enc;
            }
            try {
                this._sContent = new String(content, this._encoding);
                this._message.setBody(this._sContent);
            }
            catch (Exception e) {
                throw new CollaborationException(e.toString());
            }
        } else {
            this._bytes = content;
            this.resetAttachment(false);
        }
    }

    public void setContent(InputStream is, String enc) throws CollaborationException {
        try {
            if (this._isTextPart) {
                if (enc != null) {
                    this._encoding = enc;
                }
                InputStreamReader isr = new InputStreamReader(is, this._encoding);
                StringBuffer buf = new StringBuffer();
                char[] c = new char[1024];
                while (isr.ready()) {
                    int len = isr.read(c, 0, c.length);
                    buf.append(c, 0, len);
                }
                this._sContent = buf.toString();
                this._message.setBody(this._sContent);
                isr.close();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                while (is.available() > 0) {
                    int len = is.read(b);
                    baos.write(b, 0, len);
                }
                this._bytes = baos.toByteArray();
                this.resetAttachment(false);
                baos.close();
            }
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public void clearContent() throws CollaborationException {
        if (this._isTextPart) {
            this._message.setBody("");
        } else {
            this._bytes = null;
            this.resetAttachment(true);
        }
    }

    private void resetAttachment(boolean remove) {
        if (!this._isTextPart) {
            if (remove) {
                this._message.removeAttachment(this._filename);
            }
            if (this._bytes != null) {
                this._message.addAttachment(this._filename, this._bytes);
            }
        }
    }

    public void setContent(String content) throws CollaborationException {
        this._message.setText(content);
        this._sContent = content;
        this._bytes = content.getBytes();
        if (!this._isTextPart) {
            this.resetAttachment(false);
        }
    }

    public void setContentName(String name) throws CollaborationException {
        if (!this._isTextPart) {
            this._message.renameAttachment(this._filename, name);
        }
        this._filename = name;
    }

    public void setContentType(String contentType) throws CollaborationException {
        if (contentType.equals("text/plain")) {
            this._message.setContentType("net/text");
        } else if (contentType.equals("text/html")) {
            this._message.setContentType("net/html");
        } else if (contentType.equals("text/x-iim-url")) {
            this._message.setContentType("net/url");
        } else if (contentType.equals("application/x-iim-poll")) {
            this._message.setContentType("net/poll");
        } else if (contentType.equals("application/x-iim-poll-reply")) {
            this._message.setContentType("net/pollreply");
        } else if (contentType.equals("application/x-iim-extended")) {
            this._message.setContentType("net/extended");
        } else if (!contentType.equals("text/xml")) {
            throw new CollaborationException("unsupported content type : " + contentType);
        }
    }

    public String getHeader(String header) {
        return null;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public void setHeader(String header, String value) throws CollaborationException {
    }

    public void addPart(MessagePart part) throws CollaborationException {
    }

    public void removePart(MessagePart part) throws CollaborationException {
    }

    public ReadOnlyMessagePart getParent() {
        return this._parent;
    }
}

