/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.MultiplexConnectionFactory;
import com.iplanet.im.net.MultiplexSocket;
import com.iplanet.im.util.HostPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class MultiplexSocketFactory {
    private ArrayList _sockets = new ArrayList();
    public static final String CAPACITY_PROP_NAME = "com.iplanet.im.mux.capacity";
    public static final String MAXCONNS_PROP_NAME = "com.iplanet.im.mux.maxconns";
    private static int _capacity = 256;
    private static int _maxconns = -1;

    private synchronized MultiplexSocket findSocket(InetAddress host, int port) throws IOException {
        MultiplexSocket h = null;
        Iterator i = ((AbstractList)this._sockets).iterator();
        while (i.hasNext()) {
            h = (MultiplexSocket)i.next();
            if (!h.matches(host, port) || h.isPrettyFull()) continue;
            return h;
        }
        if (_maxconns < 1 || this._sockets.size() < _maxconns) {
            h = new MultiplexSocket(this, host, port, _capacity);
            this._sockets.add(0, h);
            return h;
        }
        throw new IOException("TCP connection limit exceeded");
    }

    public MultiplexConnectionFactory createChannel(InetAddress clientHost, int clientPort, Properties props) throws IOException, UnknownHostException {
        String sHost = props.getProperty("net.nms", "localhost");
        HostPort hp = new HostPort(sHost, 9999);
        MultiplexSocket h = this.findSocket(hp.getHost(), hp.getPort());
        return h.createChannel(clientHost, clientPort, props);
    }

    public void close() {
        while (this._sockets.size() > 0) {
            try {
                MultiplexSocket s = (MultiplexSocket)this._sockets.remove(0);
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._sockets.clear();
    }

    public synchronized void remove(MultiplexSocket s) {
        ((AbstractCollection)this._sockets).remove(s);
    }

    static {
        try {
            String s = System.getProperty(CAPACITY_PROP_NAME);
            if (s != null) {
                _capacity = Integer.parseInt(s) * 2;
            }
            if ((s = System.getProperty(MAXCONNS_PROP_NAME)) != null) {
                _maxconns = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

