/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.util;

import com.iplanet.im.jni.JNILink;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class macOSErrorClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileType;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_2_2 = 5;
    private static final int WINDOWS_NT4 = 20;
    private static final int WINDOWS_NT5 = 21;
    private static final int WINDOWS_9x = 29;
    private static final int SUNOS = 4;
    private static final int LINUX = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWSNT_PARAMETER = "url.dll,FileProtocolHandler";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String NETSCAPE_OPEN_PARAMETER_START = " -remote openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")";
    private static String errorMessage;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
                    macOSErrorClass = Class.forName("com.apple.MacOS.MacOSError");
                    Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = BrowserLauncher.class$("java.lang.String")) : class$java$lang$String);
                    makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", class$java$lang$String == null ? (class$java$lang$String = BrowserLauncher.class$("java.lang.String")) : class$java$lang$String);
                    putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)keyDirectObjectField.get(null);
                    Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
                    Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", class$java$io$File == null ? (class$java$io$File = BrowserLauncher.class$("java.io.File")) : class$java$io$File);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer finderCreatorCode = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object aeTarget = aeTargetConstructor.newInstance(finderCreatorCode);
                    Integer gurlType = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object appleEvent = appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, kAutoGenerateReturnID, kAnyTransactionID);
                    return appleEvent;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InstantiationException ie) {
                    browser = null;
                    errorMessage = ie.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getMessage();
                    return browser;
                }
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                int i = 0;
                while (i < systemFolderFiles.length) {
                    try {
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (file.isFile() && FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString())) {
                            browser = file.toString();
                            return browser;
                        }
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                    ++i;
                }
                browser = null;
                break;
            }
            case 29: {
                browser = "cmd.exe";
                break;
            }
            case 21: {
                browser = "rundll32.exe";
                break;
            }
            case 20: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                Integer major = null;
                Integer minor = null;
                Integer relno = null;
                String os_vers = System.getProperty("os.version");
                StringTokenizer st = new StringTokenizer(os_vers, "-.");
                if (st.hasMoreTokens()) {
                    major = new Integer(st.nextToken());
                } else {
                    System.out.println("Major version number problem.");
                    browser = "netscape";
                }
                if (st.hasMoreTokens()) {
                    minor = new Integer(st.nextToken());
                } else {
                    System.out.println("Minor version number problem.");
                    browser = "netscape";
                }
                if (st.hasMoreTokens()) {
                    relno = new Integer(st.nextToken());
                } else {
                    System.out.println("Release number problem.");
                    browser = "netscape";
                }
                if (browser == null && (major > 2 || major == 2 && minor > 4 || major == 2 && minor == 4 && relno >= 18)) {
                    browser = "mozilla";
                    break;
                }
                browser = "netscape";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    private static void exec(String[] s) {
        Runtime rt = Runtime.getRuntime();
        System.out.println();
        int n = 0;
        while (n < s.length) {
            System.out.println(s[n]);
            ++n;
        }
        try {
            Process child = rt.exec(s);
            child.waitFor();
            System.out.println("Process exit code is: " + child.exitValue());
        }
        catch (IOException e) {
            System.err.println("IOException starting process!");
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for process!");
        }
        System.out.println();
    }

    public static void openURL(String url) throws IOException {
        BrowserLauncher.openURL(url, null);
    }

    public static void openURL(String url, String target) throws IOException {
        String osName = System.getProperty("os.name");
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        if (!url.toLowerCase().startsWith("http")) {
            url = "\"" + url + "\"";
        }
        switch (jvm) {
            case 0: {
                Object aeDesc = null;
                try {
                    try {
                        aeDesc = aeDescConstructor.newInstance(url);
                        putParameter.invoke(browser, keyDirectObject, aeDesc);
                        sendNoReply.invoke(browser, new Object[0]);
                    }
                    catch (InvocationTargetException ite) {
                        throw new IOException("InvocationTargetException while creating AEDesc: " + ite.getMessage());
                    }
                    catch (IllegalAccessException iae) {
                        throw new IOException("IllegalAccessException while building AppleEvent: " + iae.getMessage());
                    }
                    catch (InstantiationException ie) {
                        throw new IOException("InstantiationException while creating AEDesc: " + ie.getMessage());
                    }
                    Object var9_5 = null;
                    aeDesc = null;
                    browser = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    aeDesc = null;
                    browser = null;
                    throw throwable;
                }
            }
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
                break;
            }
            case 5: {
                try {
                    System.out.println(" open 2_2");
                    Class<?> c = Class.forName("com.apple.mrj.MRJFileUtils");
                    System.out.println(" got c");
                    Method m = c.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = BrowserLauncher.class$("java.lang.String")) : class$java$lang$String);
                    System.out.println(" got m");
                    m.invoke(browser, url);
                    System.out.println("finished invoke");
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
                break;
            }
            case 21: {
                BrowserLauncher.exec(new String[]{(String)browser, FIRST_WINDOWSNT_PARAMETER, "javascript:window.location='" + url + "'"});
                break;
            }
            case 20: {
                if (!JNILink.USE_WIN_JNI) break;
                JNILink.executeWinApp(url);
                break;
            }
            case 29: {
                if (JNILink.USE_WIN_JNI) {
                    JNILink.executeWinApp(url);
                    break;
                }
                BrowserLauncher.exec(new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, "javascript:window.location='" + url + "'"});
                break;
            }
            default: {
                String openURLArgs = url;
                if (target != null && !target.equals("")) {
                    openURLArgs = openURLArgs + ",new-window";
                }
                Process process = Runtime.getRuntime().exec((String)browser + NETSCAPE_OPEN_PARAMETER_START + openURLArgs + NETSCAPE_OPEN_PARAMETER_END);
                System.out.println("Exec on " + System.getProperty("os.name") + ": " + (String)browser + NETSCAPE_OPEN_PARAMETER_START + openURLArgs + NETSCAPE_OPEN_PARAMETER_END);
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    System.out.println("Browser launch failed: " + exitCode);
                    break;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
        }
    }

    public static void main(String[] arg) {
        String url = null;
        String target = null;
        int i = 0;
        while (i < arg.length) {
            if (arg[i].equals("-h") || arg[i].equals("-help")) {
                System.out.println("BrowserLauncher -h|help | [ -n|new ] url");
                return;
            }
            if (arg[i].equals("-n") || arg[i].equals("-new")) {
                target = "_blank";
            } else {
                url = arg[i];
            }
            ++i;
        }
        try {
            BrowserLauncher.openURL(url, target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block8: {
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            if ("Mac OS".equals(osName)) {
                String mrjVersion = System.getProperty("mrj.version");
                String majorMRJVersion = mrjVersion.substring(0, 3);
                try {
                    double version = Double.valueOf(majorMRJVersion);
                    if (version == 2.0) {
                        jvm = 0;
                        break block8;
                    }
                    if (version >= 2.1) {
                        jvm = 1;
                        break block8;
                    }
                    if (version >= 2.2) {
                        System.out.println(" GOT MRJ 2.2");
                        jvm = 5;
                        break block8;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + version;
                }
                catch (NumberFormatException nfe) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + mrjVersion;
                }
            } else {
                jvm = osName.startsWith("Windows") ? (osName.indexOf("9") != -1 ? 29 : (osVersion != null && osVersion.startsWith("4") ? 20 : 21)) : (osName.startsWith("Sun") ? 4 : (osName.startsWith("Linux") ? 6 : -1));
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

