/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ExampleArchiveProvider;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.StringUtility;
import com.sun.im.provider.ArchiveProvider;
import com.sun.im.provider.NewsArchiveProvider;
import com.sun.im.provider.PollArchiveProvider;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ArchiveProviders
extends ArchiveProvider
implements PollArchiveProvider,
NewsArchiveProvider {
    public static final String USE_ARCHIVE = "iim_server.msg_archive";
    public static final String ARCHIVE_URL = "iim_server.msg_archive.url";
    public static final String ARCHIVE_PROVIDER = "iim_server.msg_archive.provider";
    public static final String AUTO_ARCHIVE = "iim_server.msg_archive.auto";
    private boolean _archiveEnabled = false;
    private boolean _pollArchiveEnabled = false;
    private boolean _newsArchiveEnabled = false;
    private boolean _autoArchive = false;
    private LinkedList _providers = new LinkedList();
    private static ArchiveProviders me = null;

    protected boolean enabled() {
        return this._archiveEnabled;
    }

    protected boolean autoArchive() {
        return this._autoArchive;
    }

    protected boolean isPollArchiveEnabled() {
        return this._pollArchiveEnabled;
    }

    protected boolean isNewsArchiveEnabled() {
        return this._newsArchiveEnabled;
    }

    public static ArchiveProviders getArchiveProvider() {
        if (me == null) {
            me = new ArchiveProviders();
        }
        return me;
    }

    public ArchiveProviders() {
        ServerConfig sc = ServerConfig.getServerConfig();
        try {
            this._archiveEnabled = StringUtility.getBoolean(sc.getSetting(USE_ARCHIVE, "false"));
        }
        catch (Exception e) {
            this._archiveEnabled = false;
        }
        if (this._archiveEnabled) {
            String s = sc.getSetting(ARCHIVE_PROVIDER);
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    ArchiveProvider archive = null;
                    try {
                        archive = (ArchiveProvider)Class.forName(st.nextToken().trim()).newInstance();
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load archive provider: " + s);
                    }
                    try {
                        archive.open();
                        this._providers.add(archive);
                        if (archive instanceof PollArchiveProvider) {
                            this._pollArchiveEnabled = true;
                        }
                        if (!(archive instanceof NewsArchiveProvider)) continue;
                        this._newsArchiveEnabled = true;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to open archive provider");
                    }
                }
            } else {
                ExampleArchiveProvider archive = new ExampleArchiveProvider(sc.getSetting(ARCHIVE_URL, NMS.getLogDir() + File.separator + "iim_msg.log"));
                this._providers.add(archive);
            }
            try {
                this._autoArchive = StringUtility.getBoolean(sc.getSetting(AUTO_ARCHIVE, "false"));
            }
            catch (Exception e) {
                this._autoArchive = false;
            }
        }
    }

    public void onLogin(String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLogin(uid);
        }
    }

    public void onLogout(String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLogout(uid);
        }
    }

    public void onSetup(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onSetup(conferenceAddress, uid);
        }
    }

    public void onJoin(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onJoin(conferenceAddress, uid);
        }
    }

    public void onLeave(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLeave(conferenceAddress, uid);
        }
    }

    public void onClose(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onClose(conferenceAddress, uid);
        }
    }

    public void onInvite(String conferenceAddress, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onInvite(conferenceAddress, message);
        }
    }

    public void onMessage(ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onMessage(message);
        }
    }

    public void onMessage(List accessList, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onMessage(accessList, message);
        }
    }

    public void onConferenceMessage(String conferenceAddress, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onConferenceMessage(conferenceAddress, message);
        }
    }

    public void open() throws Exception {
    }

    public void close() {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.close();
        }
    }

    public void onNewsMessage(String addr, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onNewsMessage(addr, message);
        }
    }

    public void onSubscribe(String addr, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onSubscribe(addr, uid);
        }
    }

    public void onUnsubscribe(String addr, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onUnsubscribe(addr, uid);
        }
    }

    public void newPoll(String originator, Poll pollData) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof PollArchiveProvider)) continue;
            ((PollArchiveProvider)p).newPoll(originator, pollData);
        }
    }

    public void pollAnswer(String originator, String pollId, String answer) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof PollArchiveProvider)) continue;
            ((PollArchiveProvider)p).pollAnswer(originator, pollId, answer);
        }
    }
}

