/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.AccessControlListImpl;
import com.iplanet.im.server.AclException;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.RealmException;
import com.iplanet.im.util.PlatformUtil;
import com.iplanet.im.util.SafeResourceBundle;
import com.iplanet.im.util.StringUtility;
import com.sun.im.provider.AccessControlList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;

class DestinationAcl {
    private static SafeResourceBundle res = new SafeResourceBundle("com.iplanet.im.server.NMSBundle");
    static final String TOPICNAME = "topic";
    static final String ROOMNAME = "room";
    static final String EXT = ".acl";
    static final String SUBDIR = "acls";

    DestinationAcl() {
    }

    private static String getFilename(Destination dest) {
        String destName = dest.getLocation().equalsIgnoreCase(NMS.getName()) ? dest.getName() : dest.getFQName();
        Object f = null;
        String filename = dest instanceof Room ? ROOMNAME + destName + EXT : (dest instanceof Topic ? TOPICNAME + destName + EXT : (dest == null ? "nullDest.acl" : "unknownDestType.acl"));
        return filename;
    }

    public static boolean check(Destination dest, iIMUser u, int access) {
        if (IMPolicy.isAdmin(u)) {
            return true;
        }
        if (!dest.getLocation().equalsIgnoreCase(u.getServer()) && NMS.get().getInboundConnectionFromDomain(u.getServer()) == null) {
            return false;
        }
        DestinationAccessControlList acl = DestinationAcl.load((iIMPrincipal)u, dest);
        if (acl != null) {
            Realm r = NMS.getRealm();
            int actual = acl.getAccess((iIMPrincipal)u, (iIMRealm)r);
            return access <= actual;
        }
        Log.out.info("[DestinationACL] Access Denied: " + u + " to " + dest.getUID());
        return false;
    }

    public static int getAccess(Destination dest, iIMUser u) {
        if (IMPolicy.isAdmin(u)) {
            return 14;
        }
        DestinationAccessControlList acl = DestinationAcl.load((iIMPrincipal)u, dest);
        if (acl != null) {
            Realm r = NMS.getRealm();
            return acl.getAccess((iIMPrincipal)u, (iIMRealm)r);
        }
        return 1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static boolean checkOld(Destination dest, iIMUser u, int access) {
        boolean aclFileExists;
        boolean matched;
        int defaultAccess;
        int realAccess;
        block22: {
            String line;
            if (IMPolicy.isAdmin(u)) {
                return true;
            }
            String filename = DestinationAcl.getFilename(dest);
            realAccess = 0;
            BufferedReader d = null;
            defaultAccess = 1;
            matched = false;
            aclFileExists = true;
            File f = new File(NMS.getDBDir(), SUBDIR);
            f = new File(f, filename);
            d = new BufferedReader(new FileReader(f));
            Log.out.debug("check in DestinationAcls " + filename);
            while ((line = d.readLine()) != null) {
                String sAccess;
                boolean in;
                StringTokenizer st;
                block21: {
                    String type;
                    block24: {
                        String server;
                        String group;
                        block25: {
                            String uid;
                            block23: {
                                void var10_11;
                                line = var10_11.trim();
                                if (line.equals("")) continue;
                                st = new StringTokenizer(line, ":");
                                type = st.nextToken();
                                type = type.trim();
                                in = false;
                                if (!type.equals("u")) break block23;
                                uid = st.nextToken();
                                uid = uid.trim();
                                uid = StringUtility.appendDomainToAddress(uid, NMS.getName());
                                if (u.getUID().equalsIgnoreCase(uid)) {
                                    in = true;
                                }
                                break block21;
                            }
                            if (!type.equals("g")) break block24;
                            uid = st.nextToken();
                            uid = uid.trim();
                            uid = StringUtility.appendDomainToAddress(uid, NMS.getName());
                            group = StringUtility.getLocalPartFromAddress(uid);
                            server = StringUtility.getDomainFromAddress(uid, NMS.getName());
                            if (!server.equalsIgnoreCase(NMS.getName())) break block25;
                            Realm r = NMS.getRealm();
                            try {
                                NMSGroup nmsg = r.getGroup((iIMPrincipal)u, uid);
                                if (nmsg != null && nmsg.hasMember((iIMPrincipal)u)) {
                                    in = true;
                                }
                                break block21;
                            }
                            catch (RealmException e) {}
                            break block21;
                        }
                        NMSGroup nmsg = NMS.get().getInboundGroup(server, group);
                        if (nmsg == null || !nmsg.hasMember((iIMPrincipal)u)) break block21;
                        in = true;
                        break block21;
                    }
                    if (type.equals("d")) {
                        sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        defaultAccess = Integer.parseInt(sAccess);
                        continue;
                    }
                    Log.out.error(res.getString("unknown_p_type") + f);
                    continue;
                }
                if (!in) continue;
                matched = true;
                sAccess = st.nextToken();
                sAccess = sAccess.trim();
                int lineAccess = Integer.parseInt(sAccess);
                realAccess |= lineAccess;
            }
            Object var20_22 = null;
            try {
                if (d != null) {
                    d.close();
                }
                break block22;
            }
            catch (Exception e2) {}
            break block22;
            {
                catch (Exception e) {
                    aclFileExists = false;
                    Log.out.error(res.getString("acl_missing") + e.toString());
                    Object var20_23 = null;
                    try {
                        if (d != null) {
                            d.close();
                        }
                        break block22;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                try {
                    if (d != null) {
                        d.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (!aclFileExists) {
            return true;
        }
        if (realAccess & true) {
            return false;
        }
        if (matched) {
            return (realAccess & access) == access;
        }
        return (defaultAccess & access) == access;
    }

    public static DestinationAccessControlList get(Destination dest, iIMUser u) throws AclException {
        DestinationAccessControlList acl = DestinationAcl.load((iIMPrincipal)u, dest);
        Realm r = NMS.getRealm();
        if (acl != null && acl.getAccess((iIMPrincipal)u, (iIMRealm)r) == 14) {
            return acl;
        }
        throw new AclException(res.getString("Access_Denied"));
    }

    public static AccessControlList getAccessControlList(Destination dest) throws AclException {
        DestinationAccessControlList dacl = DestinationAcl.load(null, dest);
        if (dacl != null) {
            return new AccessControlListImpl(dacl);
        }
        return new AccessControlListImpl();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DestinationAccessControlList load(iIMPrincipal p, Destination dest) {
        filename = DestinationAcl.getFilename(dest);
        d = null;
        try {
            try {
                r = NMS.getRealm();
                ret = new DestinationAccessControlList();
                dir = new File(NMS.getDBDir(), "acls");
                f = new File(dir, filename);
                d = new BufferedReader(new FileReader(f));
                v0 = migrated = dest instanceof Room == false;
                while (true) {
                    if ((line = d.readLine()) == null) {
                        var10_12 = ret;
                        var21_26 = null;
                        break;
                    }
                    line = var8_11.trim();
                    if (line.equals("")) continue;
                    st = new StringTokenizer(line, ":");
                    type = st.nextToken();
                    if ((type = type.trim()).equals("u")) {
                        uid = st.nextToken();
                        uid = uid.trim();
                        sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        lineAccess = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess == 2) {
                            lineAccess = 6;
                        }
                        if ((server = StringUtility.getDomainFromAddress(uid = StringUtility.appendDomainToAddress(uid, NMS.getName()), NMS.getName())).equalsIgnoreCase(p.getServer())) {
                            try {
                                nmsUser = r.getUser(p, uid);
                                ret.add((iIMPrincipal)nmsUser.getiIMUser(), lineAccess);
                            }
                            catch (RealmException re) {
                                Log.out.warning(DestinationAcl.res.getString("cant_find_user_in_acl") + re);
                            }
                            continue;
                        }
                        remoteuids = new String[]{uid};
                        nc = Command.create((int)208, (Object)new Boolean(true), (Object)remoteuids);
                        nc.user = null;
                        reply = NMS.get().forwardToServer(server, nc);
                        if (reply == null) {
                            name = StringUtility.getLocalPartFromAddress(uid);
                            ret.add((iIMPrincipal)new iIMUser(name, server, name), lineAccess);
                            continue;
                        }
                        if (Command.getReplyCode((CommandData)reply) < 0) {
                            name = StringUtility.getLocalPartFromAddress(uid);
                            ret.add((iIMPrincipal)new iIMUser(name, server, name), lineAccess);
                            continue;
                        }
                        gotIt = (iIMUser[])Command.getReplyArg1((CommandData)reply);
                        ret.add((iIMPrincipal)gotIt[0], lineAccess);
                        continue;
                    }
                    if (type.equals("g")) {
                        uid = st.nextToken();
                        uid = uid.trim();
                        sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        lineAccess = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess == 2) {
                            lineAccess = 6;
                        }
                        group = StringUtility.getLocalPartFromAddress(uid);
                        server = StringUtility.getDomainFromAddress(uid, NMS.getName());
                        if (server.equalsIgnoreCase(p.getServer())) {
                            try {
                                nmsg = r.getGroup(p, group);
                                ret.add((iIMPrincipal)nmsg.getiIMGroup(), lineAccess);
                            }
                            catch (RealmException e) {
                                Log.out.warning("Invalid group " + uid + " in acl : " + f.getName());
                            }
                            continue;
                        }
                        nmsg = NMS.get().getInboundGroup(server, group);
                        if (nmsg != null) {
                            ret.add((iIMPrincipal)nmsg.getiIMGroup(), lineAccess);
                            continue;
                        }
                        ret.add((iIMPrincipal)new iIMGroup(group, server, group), lineAccess);
                        continue;
                    }
                    if (type.equals("d")) {
                        sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        lineAccess = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess == 2) {
                            lineAccess = 6;
                        }
                        ret.setDefault(lineAccess);
                        continue;
                    }
                    if (!type.equals("v") || !(sVersion = st.nextToken()).equals("3.0.1")) continue;
                    migrated = true;
                }
            }
            catch (Exception e) {
                Log.out.error(DestinationAcl.res.getString("acl_missing") + e.toString());
                var5_7 = null;
                var21_27 = null;
                try {
                    if (d == null) return var5_7;
                    d.close();
                    return var5_7;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return var5_7;
            }
        }
        catch (Throwable var20_32) {
            var21_28 = null;
            try {}
            catch (Exception e) {
                throw var20_32;
            }
            if (d == null) throw var20_32;
            d.close();
            throw var20_32;
        }
        ** try [egrp 4[TRYBLOCK] [4 : 802->813)] { 
lbl110:
        // 1 sources

        if (d == null) return var10_12;
        d.close();
        return var10_12;
lbl113:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
        return var10_12;
    }

    public static void set(Destination dest, DestinationAccessControlList l, iIMUser u) throws AclException, IOException {
        if (!DestinationAcl.check(dest, u, 14)) {
            throw new AclException(res.getString("Access_Denied"));
        }
        String filename = DestinationAcl.getFilename(dest);
        PrintWriter d = null;
        try {
            File f = new File(NMS.getDBDir(), SUBDIR);
            f = new File(f, filename);
            File tmpfile = PlatformUtil.getTempFile(f);
            d = new PrintWriter(new BufferedWriter(new FileWriter(tmpfile)));
            d.println("v:3.0.1");
            Enumeration e = l.entries();
            while (e.hasMoreElements()) {
                iIMPrincipal p = (iIMPrincipal)e.nextElement();
                int access = l.getAccess(p);
                String uid = NMS.getName().equalsIgnoreCase(p.getServer()) ? p.getName() : p.getUID();
                if (p instanceof iIMUser) {
                    d.println("u:" + uid + ":" + access);
                    continue;
                }
                if (!(p instanceof iIMGroup)) continue;
                d.println("g:" + uid + ":" + access);
            }
            d.println("d:" + l.getDefault());
            d.close();
            d = null;
            if (!PlatformUtil.renameTempFile(tmpfile, f)) {
                Log.out.error("Renaming the file from " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath() + " failed");
            }
        }
        catch (IOException e) {
            Log.out.error(res.getString("writing_acl") + e.toString());
            if (d != null) {
                d.close();
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    public static void createDestinationAcls(Destination dest, iIMUser u) {
        block12: {
            String uid = NMS.getName().equalsIgnoreCase(u.getServer()) ? u.getName() : u.getUID();
            OutputStreamWriter fw = null;
            File f = new File(NMS.getDBDir(), SUBDIR);
            if (!f.exists() && !f.mkdirs()) {
                Log.out.error("Unable to create dir: " + f.toString());
            }
            String filename = DestinationAcl.getFilename(dest);
            f = new File(f, filename);
            fw = new FileWriter(f);
            fw.write("u:" + uid + ":" + 14);
            fw.close();
            Object var7_7 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    Log.out.error(res.getString("creating_acl_for") + dest.getName());
                    Object var7_8 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void deleteDestinationAcls(Destination dest) {
        String filename;
        File sub = new File(NMS.getDBDir(), SUBDIR);
        File f = new File(sub, filename = DestinationAcl.getFilename(dest));
        if (!f.delete()) {
            Log.out.debug("deleteDestinationAcls failed to delete" + f.toString());
            Log.out.error(res.getString("delete_failed") + f.toString());
        }
    }
}

