/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.JMSMessageListenerFactory;
import com.iplanet.im.server.JMSProvider;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class JMSManager {
    private static final String PARAM_CONSUMERS = "jms.consumers";
    private static final String PARAM_PROVIDERS = "jms.providers";
    private static final String PARAM_CONSUMER_PREFIX = "jms.consumer.";
    private static final String PARAM_PROVIDER_PREFIX = "jms.provider.";
    private static final String PARAM_BROKER_SUFFIX = ".broker";
    private static final String PARAM_FACTORY_SUFFIX = ".factory";
    private static final String PARAM_PROVIDER_SUFFIX = ".provider";
    private static final String PARAM_DESTINATION_SUFFIX = ".destination";
    private static final String PARAM_PARAMETER_SUFFIX = ".param";
    private static final String PARAM_TYPE_SUFFIX = ".type";
    private static HashMap _providers = new HashMap(3);
    public static long RETRY_PERIOD = 30000L;
    private static boolean _shutdown = false;

    private static JMSMessageListenerFactory getMessageListenerFactory(String factory, String topic, String param) {
        try {
            return (JMSMessageListenerFactory)Class.forName(factory).newInstance();
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            return null;
        }
    }

    public static void initialize() throws Exception {
        String sKey;
        StringTokenizer st;
        ServerConfig sc = ServerConfig.getServerConfig();
        String s = sc.getSetting(PARAM_PROVIDERS);
        if (s != null) {
            st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                JMSProvider p;
                sKey = st.nextToken().trim();
                String sFactory = sc.getSetting(PARAM_PROVIDER_PREFIX + sKey + PARAM_FACTORY_SUFFIX, null);
                String sBroker = sc.getSetting(PARAM_PROVIDER_PREFIX + sKey + PARAM_BROKER_SUFFIX, null);
                if (sFactory == null || (p = new JMSProvider(sFactory, sBroker)) == null) continue;
                _providers.put(sKey, p);
            }
        }
        if ((s = sc.getSetting(PARAM_CONSUMERS)) != null) {
            st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                sKey = st.nextToken().trim();
                String sTopic = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_DESTINATION_SUFFIX);
                String sParam = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_PARAMETER_SUFFIX);
                String sFactory = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_FACTORY_SUFFIX);
                JMSMessageListenerFactory mlf = JMSManager.getMessageListenerFactory(sFactory, sTopic, sParam);
                String sProvider = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_PROVIDER_SUFFIX, null);
                if (sProvider == null) continue;
                JMSProvider p = (JMSProvider)_providers.get(sProvider);
                String sType = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_TYPE_SUFFIX);
                if (!sType.equalsIgnoreCase("topic") || mlf == null) continue;
                p.addSubscriber(sTopic, sParam, mlf);
            }
        }
    }

    public static void start() {
        Iterator i = _providers.values().iterator();
        while (i.hasNext()) {
            JMSProvider p = (JMSProvider)i.next();
            p.start();
        }
    }

    public static void stop() {
        _shutdown = true;
        Iterator i = _providers.values().iterator();
        while (i.hasNext()) {
            JMSProvider p = (JMSProvider)i.next();
            p.stop();
        }
    }

    public static void connectionClosed(Object o) {
        JMSProvider p = (JMSProvider)o;
        p.stop();
        if (!_shutdown) {
            p.start();
        }
    }
}

