/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.im.server.LDAPRealm;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.Settings;
import com.iplanet.im.util.StringUtility;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.im.identity.util.Auth;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public final class MigrateAcl {
    public static final String IM_SERVICE = "SunIM";
    public static final String PRESENCE_SERVICE = "SunPresence";
    private static String _configFile = "../config/iim.conf";
    private static String _instanceDir;
    private static boolean _migrated;
    static final String EXT = ".acl";
    static final String SUBDIR = "acls";
    private static PolicyManager pm;
    private static AuthContext lc;
    private static LDAPConnection ld;
    private static String searchBase;
    private static String uidSearchFilter;
    private static String groupSearchFilter;
    private static SSOToken token;

    static SSOToken getToken() {
        try {
            String bindDN = Auth.getAdminDN();
            String password = Auth.getAdminPassword();
            SSOTokenManager manager = SSOTokenManager.getInstance();
            token = manager.createSSOToken((Principal)new AuthPrincipal(bindDN), password);
        }
        catch (Exception e) {
            Log.out.error("(MigrateAcl) getToken exception: " + e.toString());
        }
        return token;
    }

    private static String getConfigDir() {
        return _instanceDir + File.separator + "config";
    }

    private static File getFile(String key) {
        String filename = key + EXT;
        File f = new File(MigrateAcl.getConfigDir(), SUBDIR);
        return new File(f, filename);
    }

    private static boolean init() {
        Log.out.debug("(MigrateAcl) init");
        ServerConfig sc = ServerConfig.getServerConfig();
        _instanceDir = sc.getSetting("iim.instancedir", ".");
        String version = sc.getSetting("iim.policy.store", "identity");
        if (version.equals("identity")) {
            _migrated = true;
            return true;
        }
        searchBase = LDAPRealm.removeSpaces(sc.getSetting("iim_ldap.searchbase", ""));
        uidSearchFilter = sc.getSetting("iim_ldap.loginfilter", "(&(objectclass=inetorgperson)(uid={0}))");
        groupSearchFilter = sc.getSetting("iim_ldap.groupbrowsefilter", "(objectclass=groupofuniquenames)");
        Log.out.debug("(MigrateAcl) searchBase: " + searchBase);
        Log.out.debug("(MigrateAcl) uidSearchFilter: " + uidSearchFilter);
        Log.out.debug("(MigrateAcl) groupSearchFilter: " + groupSearchFilter);
        try {
            token = MigrateAcl.getToken();
            pm = new PolicyManager(token);
        }
        catch (Exception e) {
            Log.out.error("(MigrateAcl) init exception: " + e.toString());
            return false;
        }
        try {
            String ldapServer = sc.getSetting("iim_ldap.host", "");
            int n = ldapServer.indexOf(58);
            String ldapHost = null;
            int ldapPort = 389;
            if (n <= 0) {
                ldapHost = ldapServer;
                ldapPort = 389;
            } else {
                ldapHost = ldapServer.substring(0, n);
                ldapPort = Integer.parseInt(ldapServer.substring(n + 1));
            }
            Log.out.debug("(MigrateAcl) ldapHost: " + ldapHost);
            Log.out.debug("(MigrateAcl) ldapPort: " + ldapPort);
            ld = new LDAPConnection();
            ld.connect(3, ldapHost, ldapPort, Auth.getAdminDN(), Auth.getAdminPassword());
        }
        catch (LDAPException le) {
            Log.out.error("(MigrateAcl) Failed to init ldap host : " + le.toString());
            return false;
        }
        catch (Exception e) {
            Log.out.error("(MigrateAcl) Failed to init ldap host : " + e.toString());
            return false;
        }
        return true;
    }

    private static void done() {
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    private static String getUserDN(String uid) {
        String userDN = null;
        int searchScope = 2;
        String[] getAttrs = new String[]{"cn", "uid"};
        try {
            String searchfor = StringUtility.replaceString("{0}", StringUtility.unquoteSpecialCharacters(uid), uidSearchFilter);
            Log.out.debug("(MigrateAcl) searchfilter: " + searchfor);
            LDAPSearchResults res = ld.search(searchBase, searchScope, searchfor, getAttrs, false);
            while (res.hasMoreElements()) {
                LDAPEntry entry = res.next();
                LDAPAttribute attr = entry.getAttribute("uid");
                Enumeration vals = attr.getStringValues();
                String val = null;
                if (vals != null) {
                    val = (String)vals.nextElement();
                }
                if (val == null || !val.equalsIgnoreCase(uid)) continue;
                userDN = entry.getDN();
                Log.out.debug("(MigrateAcl) Found userDN: " + userDN);
                break;
            }
        }
        catch (LDAPException e) {
            Log.out.error("(MigrateAcl) Failed to search for uid - " + uid + " : " + e.toString());
        }
        return userDN;
    }

    private static String getGroupDN(String group) {
        String groupDN = null;
        int searchScope = 2;
        String[] getAttrs = new String[]{"cn", "dn"};
        try {
            LDAPSearchResults res = ld.search(searchBase, searchScope, groupSearchFilter, getAttrs, false);
            while (res.hasMoreElements()) {
                LDAPEntry entry = res.next();
                String dn = entry.getDN();
                if (dn == null || !dn.equalsIgnoreCase(group)) continue;
                groupDN = dn;
                Log.out.debug("(MigrateAcl) Found groupDN: " + groupDN);
                break;
            }
        }
        catch (LDAPException e) {
            Log.out.error("(MigrateAcl) Failed to search for group - " + group + " : " + e.toString());
        }
        return groupDN;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static void migrate(File f, String service, String attr, String policyString, String roleString) {
        block22: {
            BufferedReader d;
            block21: {
                Iterator i;
                String line;
                d = null;
                Log.out.debug("(MigrateAcl) migrating access based on " + f.getAbsolutePath() + " for attribute " + attr);
                String defaultRule = null;
                defaultRule = service.equals(IM_SERVICE) ? "IMDefaultRule" : "PresenceDefaultRule";
                boolean defaultAccess = false;
                HashSet<String> userList = new HashSet<String>();
                HashSet<String> groupList = new HashSet<String>();
                d = new BufferedReader(new FileReader(f));
                while ((line = d.readLine()) != null) {
                    StringTokenizer st;
                    void var10_10;
                    line = var10_10.trim();
                    if (line.equals("") || (st = new StringTokenizer(line, ":")).countTokens() < 2) continue;
                    String type = st.nextToken();
                    type = type.trim();
                    String value = st.nextToken();
                    value = value.trim();
                    if (type.equals("u")) {
                        userList.add(value);
                        continue;
                    }
                    if (type.equals("g")) {
                        groupList.add(value);
                        continue;
                    }
                    if (!type.equals("d")) continue;
                    Policy p = pm.getPolicy("Default instant messaging and presence access");
                    Rule r = p.getRule(defaultRule);
                    Map actionValues = r.getActionValues();
                    HashMap<String, Set> newActions = new HashMap<String, Set>();
                    if (actionValues != null && !actionValues.isEmpty()) {
                        Iterator i2 = actionValues.keySet().iterator();
                        while (i2.hasNext()) {
                            String action = (String)i2.next();
                            Set values = (Set)actionValues.get(action);
                            if (action.equalsIgnoreCase(attr)) {
                                String v = "deny";
                                Object val = null;
                                if (value.equalsIgnoreCase("true")) {
                                    v = "allow";
                                    defaultAccess = true;
                                }
                                values.clear();
                                values.add(v);
                            }
                            newActions.put(action, values);
                        }
                    }
                    Rule nr = new Rule(defaultRule, r.getServiceTypeName(), r.getResourceName(), newActions);
                    p.replaceRule(nr);
                    Log.out.debug("(MigrateAcl) replace policy rule: " + nr);
                    pm.replacePolicy(p);
                }
                if (defaultAccess || userList.size() <= 0 && groupList.size() <= 0) break block21;
                AMStoreConnection connection = new AMStoreConnection(token);
                String roleDN = "cn=" + roleString + "," + searchBase;
                AMRole role = connection.getRole(roleDN);
                HashSet<String> addList = new HashSet<String>();
                if (userList.size() > 0) {
                    i = userList.iterator();
                    while (i.hasNext()) {
                        String userDN = MigrateAcl.getUserDN((String)i.next());
                        if (userDN == null) continue;
                        addList.add(userDN);
                    }
                }
                role.addUsers(addList);
                if (groupList.size() <= 0) break block21;
                i = groupList.iterator();
                while (i.hasNext()) {
                    String groupDN = MigrateAcl.getGroupDN((String)i.next());
                    if (groupDN == null) continue;
                    SubjectTypeManager stm = pm.getSubjectTypeManager();
                    Policy p = pm.getPolicy(policyString);
                    Subject subject = stm.getSubject("LDAPGroups");
                    HashSet<String> subjectValues = new HashSet<String>();
                    subjectValues.add(groupDN);
                    subject.setValues(subjectValues);
                    p.addSubject("ldapgroups", subject);
                    pm.replacePolicy(p);
                }
            }
            Object var24_24 = null;
            try {
                if (d != null) {
                    d.close();
                }
                break block22;
            }
            catch (Exception e2) {}
            break block22;
            {
                catch (Exception e) {
                    Log.out.warning("(MigrateAcl) migrate exception: " + e.toString());
                    Object var24_25 = null;
                    try {
                        if (d != null) {
                            d.close();
                        }
                        break block22;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var24_26 = null;
                try {
                    if (d != null) {
                        d.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static void migrateTopicsAddDel() {
        MigrateAcl.migrate(MigrateAcl.getFile("sysTopicsAdd"), IM_SERVICE, "sunIMAllowNewsManage", "Ability to manage instant messaging news channels", "IM News Administrator");
    }

    static void migrateSendAlerts() {
        MigrateAcl.migrate(MigrateAcl.getFile("sysSendAlerts"), IM_SERVICE, "sunIMAllowAlertsSend", "Ability to send instant messaging alerts", "IM Allow Send Alerts Role");
    }

    static void migrateRoomsAddDel() {
        MigrateAcl.migrate(MigrateAcl.getFile("sysRoomsAdd"), IM_SERVICE, "sunIMAllowForumManage", "Ability to manage instant messaging conference rooms", "IM Conference Rooms Administrator");
    }

    static void migrateSaveUserSettings() {
        MigrateAcl.migrate(MigrateAcl.getFile("sysSaveUserSettings"), IM_SERVICE, "sunIMAllowUserSettings", "Ability to change own instant messaging user settings", "IM Allow User Settings Role");
    }

    static void migrateWatch() {
        MigrateAcl.migrate(MigrateAcl.getFile("sysWatch"), PRESENCE_SERVICE, "sunPresenceAllowAccess", "Ability to watch changes on other instant messaging users", "IM Allow Watch Changes Role");
    }

    /*
     * WARNING - void declaration
     */
    static void migrateAdmin() {
        BufferedReader d = null;
        Log.out.debug("(MigrateAcl) migrating sysAdmin");
        HashSet<String> userList = new HashSet<String>();
        AMRole role = null;
        try {
            String line;
            File f = MigrateAcl.getFile("sysAdmin");
            d = new BufferedReader(new FileReader(f));
            AMStoreConnection connection = new AMStoreConnection(token);
            String roleDN = "cn=IMAdminUser," + searchBase;
            role = connection.getRole(roleDN);
            while ((line = d.readLine()) != null) {
                String groupDN;
                StringTokenizer st;
                void var6_7;
                line = var6_7.trim();
                if (line.equals("") || (st = new StringTokenizer(line, ":")).countTokens() < 2) continue;
                String type = st.nextToken();
                type = type.trim();
                String value = st.nextToken();
                value = value.trim();
                if (type.equals("u")) {
                    String userDN = MigrateAcl.getUserDN(value);
                    if (userDN == null) continue;
                    userList.add(userDN);
                    continue;
                }
                if (!type.equals("g") || (groupDN = MigrateAcl.getGroupDN(value)) == null) continue;
                SubjectTypeManager stm = pm.getSubjectTypeManager();
                Policy p = pm.getPolicy("Ability to administer Instant Messaging and Presence Service");
                Subject subject = stm.getSubject("LDAPGroups");
                HashSet<String> subjectValues = new HashSet<String>();
                subjectValues.add(groupDN);
                subject.setValues(subjectValues);
                p.addSubject("ldapgroups", subject);
                pm.replacePolicy(p);
            }
            if (userList != null && !userList.isEmpty()) {
                role.addUsers(userList);
            }
        }
        catch (Exception e) {
            Log.out.error("(MigrateAcl) migrateAdmin exception: " + e.toString());
        }
    }

    public static void main(String[] args) {
        Settings s = Settings.getSettings();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c") && i + 1 < args.length) {
                _configFile = args[++i];
                Log.out.debug("(MigrateAcl) config file: " + _configFile);
            }
            ++i;
        }
        if (MigrateAcl.init()) {
            if (_migrated) {
                System.out.println("Access control files already migrated to Identity Server.  In order to re-migrate, change iim.policy.store to \"file\"");
            } else {
                MigrateAcl.migrateTopicsAddDel();
                MigrateAcl.migrateSendAlerts();
                MigrateAcl.migrateRoomsAddDel();
                MigrateAcl.migrateSaveUserSettings();
                MigrateAcl.migrateWatch();
                MigrateAcl.migrateAdmin();
                MigrateAcl.done();
            }
            System.exit(0);
        } else {
            Log.out.error("(MigrateAcl) init fails");
            System.exit(1);
        }
    }

    static {
        _migrated = false;
        pm = null;
        lc = null;
        ld = null;
        searchBase = null;
        uidSearchFilter = null;
        groupSearchFilter = null;
        token = null;
    }
}

