/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.iIMUser;
import com.iplanet.im.server.DSAMESSOProvider;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.Realm;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.util.StringUtility;
import com.sun.im.provider.SSOProvider;
import java.util.Map;
import java.util.Set;

public class SSO {
    private static final String SSOTOKEN_ATTR = "ssotoken";
    private static final String SSOProviderName = "iim_server.ssoprovider";
    private static final String usessoName = "iim_server.usesso";
    private static final String ssoUpdateName = "iim_server.sso.update";
    private static boolean _update = false;
    protected static final int NO_SSO = 0;
    protected static final int USE_SSO = 1;
    protected static final int SSO_ONLY = -1;
    private static SSOProvider _provider = null;
    private static int mode = 0;

    public static int getMode() {
        return mode;
    }

    public static void init() {
        ServerConfig sc = ServerConfig.getServerConfig();
        if (SSO.getMode() == 0) {
            return;
        }
        String providerClassName = sc.getSetting(SSOProviderName);
        if (providerClassName != null) {
            try {
                _provider = (SSOProvider)Class.forName(providerClassName).newInstance();
            }
            catch (Exception e) {
                Log.out.error("Failed to load SSO provider " + providerClassName + " : " + e.toString());
                Log.out.printStackTrace(e);
                _provider = null;
            }
        } else {
            try {
                Class<?> c = Class.forName("com.iplanet.am.sdk.AMException");
                Realm realm = NMS.getRealm();
                _provider = new DSAMESSOProvider();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.out.printStackTrace(e);
                Log.out.info("Not using Single-Sign-On");
                _provider = null;
            }
        }
        try {
            if (_provider != null) {
                _provider.open();
            }
        }
        catch (Exception e) {
            Log.out.printStackTrace(e);
            _provider = null;
        }
    }

    protected static boolean usingIdentity() {
        return _provider instanceof DSAMESSOProvider;
    }

    protected static boolean refresh(iIMUser u) {
        if (_provider != null && _update && u.getAttribute(SSOTOKEN_ATTR) != null) {
            return _provider.refresh(u.getUID());
        }
        return true;
    }

    public static boolean isEnabled() {
        return _provider != null;
    }

    public static boolean verify(String uid, String token, Map attrs, Set attributeNames) {
        String UID;
        boolean res = false;
        if (_provider != null && (res = _provider.verify(UID = StringUtility.unquoteSpecialCharacters(uid), token, attrs, attributeNames))) {
            attrs.put(SSOTOKEN_ATTR, token);
        }
        return res;
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        String t = sc.getSetting(usessoName, "0");
        if (t != null) {
            mode = Integer.parseInt(t);
        }
        t = sc.getSetting(ssoUpdateName, "true");
        try {
            _update = StringUtility.getBoolean(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

