/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class ASN1Util {
    public static byte[] encode(ASN1Value aSN1Value) {
        return ASN1Util.encode(aSN1Value.getTag(), aSN1Value);
    }

    public static byte[] encode(Tag tag, ASN1Value aSN1Value) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1Value.encode(tag, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.notReached("Encoding to byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return aSN1Template.decode(byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(Tag tag, ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return aSN1Template.decode(tag, byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read(byArray, n, byArray.length - n);
            if (n2 == -1) {
                throw new EOFException();
            }
            n += n2;
        }
    }
}

