/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;

class CountingStream
extends InputStream {
    private int count = 0;
    private int markpos;
    private InputStream source;
    private static final boolean DEBUG = false;

    private CountingStream() {
    }

    public CountingStream(InputStream inputStream) {
        this.source = inputStream;
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void mark(int n) {
        this.source.mark(n);
        this.markpos = this.count;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        int n = this.source.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n != -1) {
            this.count += n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.source.read(byArray, n, n2);
        if (n3 != -1) {
            this.count += n3;
        }
        return n3;
    }

    public void reset() throws IOException {
        this.source.reset();
        this.count = this.markpos;
    }

    public long skip(long l) throws IOException {
        this.count = (int)((long)this.count + l);
        return this.source.skip(l);
    }

    public int getNumRead() {
        return this.count;
    }

    public void resetNumRead() {
        this.count = 0;
        this.markpos = 0;
    }
}

