/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.CipherContextProxy;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Assert;

final class PK11Cipher
extends Cipher {
    private PK11Token token;
    private EncryptionAlgorithm algorithm;
    private AlgorithmParameterSpec parameters = null;
    private SymmetricKey key = null;
    private byte[] IV = null;
    private CipherContextProxy contextProxy = null;
    private int state = 0;
    private static final int UNINITIALIZED = 0;
    private static final int ENCRYPT = 1;
    private static final int DECRYPT = 2;

    private PK11Cipher() {
    }

    PK11Cipher(PK11Token pK11Token, EncryptionAlgorithm encryptionAlgorithm) {
        this.token = pK11Token;
        this.algorithm = encryptionAlgorithm;
    }

    public void initEncrypt(SymmetricKey symmetricKey) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.initEncrypt(symmetricKey, null);
    }

    public void initDecrypt(SymmetricKey symmetricKey) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.initDecrypt(symmetricKey, null);
    }

    public void initEncrypt(SymmetricKey symmetricKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.reset();
        this.checkKey(symmetricKey);
        this.checkParams(algorithmParameterSpec);
        if (algorithmParameterSpec instanceof IVParameterSpec) {
            this.IV = ((IVParameterSpec)algorithmParameterSpec).getIV();
        }
        this.key = symmetricKey;
        this.parameters = algorithmParameterSpec;
        this.state = 1;
        this.contextProxy = PK11Cipher.initContext(true, symmetricKey, this.algorithm, this.IV);
    }

    public void initDecrypt(SymmetricKey symmetricKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException, TokenException {
        this.reset();
        this.checkKey(symmetricKey);
        this.checkParams(algorithmParameterSpec);
        if (algorithmParameterSpec instanceof IVParameterSpec) {
            this.IV = ((IVParameterSpec)algorithmParameterSpec).getIV();
        }
        this.key = symmetricKey;
        this.parameters = algorithmParameterSpec;
        this.state = 2;
        this.contextProxy = PK11Cipher.initContext(false, symmetricKey, this.algorithm, this.IV);
    }

    public byte[] update(byte[] byArray) throws IllegalStateException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        return PK11Cipher.updateContext(this.contextProxy, byArray, this.algorithm.getBlockSize());
    }

    public byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException, TokenException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.update(byArray2);
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = this.update(byArray);
        byte[] byArray3 = PK11Cipher.finalizeContext(this.contextProxy, this.algorithm.getBlockSize(), this.algorithm.isPadded());
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        return byArray4;
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.doFinal(byArray2);
    }

    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, TokenException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        return PK11Cipher.finalizeContext(this.contextProxy, this.algorithm.getBlockSize(), this.algorithm.isPadded());
    }

    private static native CipherContextProxy initContext(boolean var0, SymmetricKey var1, EncryptionAlgorithm var2, byte[] var3) throws TokenException;

    private static native byte[] updateContext(CipherContextProxy var0, byte[] var1, int var2) throws TokenException;

    private static native byte[] finalizeContext(CipherContextProxy var0, int var1, boolean var2) throws TokenException, IllegalBlockSizeException, BadPaddingException;

    private void reset() {
        this.parameters = null;
        this.key = null;
        this.IV = null;
        this.state = 0;
        this.contextProxy = null;
    }

    private void checkParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Class clazz = this.algorithm.getParameterClass();
        if (algorithmParameterSpec == null) {
            if (clazz != null) {
                throw new InvalidAlgorithmParameterException(this.algorithm + " requires an algorithm parameter");
            }
        } else {
            if (clazz == null) {
                throw new InvalidAlgorithmParameterException(this.algorithm + " does not take a parameter");
            }
            if (!clazz.isInstance(algorithmParameterSpec)) {
                throw new InvalidAlgorithmParameterException(this.algorithm + " expects a parameter of type " + clazz);
            }
        }
    }

    private void checkKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        if (!symmetricKey.getOwningToken().equals(this.token)) {
            throw new InvalidKeyException("Key does not reside on the current token");
        }
        if (!(symmetricKey instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        try {
            if (((PK11SymKey)symmetricKey).getKeyType() != KeyType.getKeyTypeFromAlgorithm(this.algorithm)) {
                throw new InvalidKeyException("Key is not the right type for this algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("Unknown algorithm");
        }
    }
}

