/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import org.mozilla.jss.asn1.InvalidBERException;

public class Tag {
    private long num;
    private Class tClass;
    public static final Class UNIVERSAL = Class.UNIVERSAL;
    public static final Class APPLICATION = Class.APPLICATION;
    public static final Class CONTEXT_SPECIFIC = Class.CONTEXT_SPECIFIC;
    public static final Class PRIVATE = Class.PRIVATE;
    public static final Tag END_OF_CONTENTS;
    public static final Tag EOC;
    private static final int numTagInstances = 10;
    private static Tag[] tagInstances;

    public long getNum() {
        return this.num;
    }

    public Class getTagClass() {
        return this.tClass;
    }

    private Tag() {
    }

    public Tag(Class clazz, long l) {
        this.tClass = clazz;
        this.num = l;
    }

    public Tag(long l) {
        this(Class.CONTEXT_SPECIFIC, l);
    }

    public static Tag get(long l) {
        if (l >= 0L && l < 10L) {
            return tagInstances[(int)l];
        }
        return new Tag(l);
    }

    public int hashCode() {
        return this.tClass.toInt() * 131 + (int)this.num;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)object;
        return this.num == tag.num && this.tClass == tag.tClass;
    }

    public String toString() {
        return this.tClass + " " + this.num;
    }

    static {
        EOC = END_OF_CONTENTS = new Tag(UNIVERSAL, 0L);
        tagInstances = new Tag[10];
        int n = 0;
        while (n < 10) {
            Tag.tagInstances[n] = new Tag(n);
            ++n;
        }
    }

    public static class Class {
        private int encoding;
        private String name;
        public static final Class UNIVERSAL = new Class(0, "UNIVERSAL");
        public static final Class APPLICATION = new Class(1, "APPLICATION");
        public static final Class CONTEXT_SPECIFIC = new Class(2, "CONTEXT-SPECIFIC");
        public static final Class PRIVATE = new Class(3, "PRIVATE");

        private Class() {
        }

        private Class(int n, String string) {
            this.encoding = n;
            this.name = string;
        }

        public int toInt() {
            return this.encoding;
        }

        public String toString() {
            return this.name;
        }

        public static Class fromInt(int n) throws InvalidBERException {
            if (n == 0) {
                return UNIVERSAL;
            }
            if (n == 1) {
                return APPLICATION;
            }
            if (n == 2) {
                return CONTEXT_SPECIFIC;
            }
            if (n == 3) {
                return PRIVATE;
            }
            throw new InvalidBERException("Invalid tag class: " + n);
        }
    }
}

