/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class UniversalString
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 28L);
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public UniversalString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public UniversalString(String string) throws CharConversionException {
        super(string);
    }

    CharConverter getCharConverter() {
        return new UniversalConverter();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class UniversalConverter
    implements CharConverter {
        public static final int MAX_UNICODE = 65535;
        public static final int MAX_UTF16 = 0x10FFFF;
        public static final char REPLACEMENT_CHAR = '\ufffd';
        public static final int UTF16_BASE = 0x100000;
        public static final int HALF_SHIFT = 10;
        public static final int HALF_MASK = 1023;
        public static final int UTF16_HIGH_START = 55296;
        public static final int UTF16_HIGH_END = 56575;
        public static final int UTF16_LOW_START = 56320;
        public static final int UTF16_LOW_END = 57343;

        private UniversalConverter() {
        }

        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            CharArrayWriter charArrayWriter = new CharArrayWriter(n2 / 4);
            int n3 = n + n2;
            while (n < n3) {
                if (n3 - n < 4) {
                    throw new CharConversionException("input exhausted");
                }
                int n4 = (byArray[n++] & 0xFF) << 24;
                n4 += (byArray[n++] & 0xFF) << 16;
                n4 += (byArray[n++] & 0xFF) << 8;
                if ((n4 += byArray[n++] & 0xFF) <= 65535) {
                    charArrayWriter.write(n4 & 0xFFFF);
                    continue;
                }
                if (n4 <= 0x10FFFF) {
                    charArrayWriter.write(((n4 -= 0x100000) >>> 10) + 55296);
                    charArrayWriter.write((n4 & 0x3FF) + 56320);
                    continue;
                }
                charArrayWriter.write(65533);
            }
            return charArrayWriter.toCharArray();
        }

        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 * 4);
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                char c;
                if ((c = cArray[n++]) >= '\ud800' && c <= '\udcff') {
                    char c2;
                    if (n == n3) {
                        throw new CharConversionException("input exhausted");
                    }
                    if ((c2 = cArray[n++]) < '\udc00' || c2 > '\udfff') {
                        throw new CharConversionException("UTF16 high character not followed by a UTF16 low character");
                    }
                    n4 = 0x100000;
                    n4 += c - 55296 << 10;
                    n4 += c2 - 56320;
                } else {
                    n4 = c & 0xFFFF;
                }
                byteArrayOutputStream.write((n4 & 0xFF000000) >>> 24);
                byteArrayOutputStream.write((n4 & 0xFF0000) >>> 16);
                byteArrayOutputStream.write((n4 & 0xFF00) >>> 8);
                byteArrayOutputStream.write(n4 & 0xFF);
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected CharConverter getCharConverter() {
            return new UniversalConverter();
        }

        protected CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new UniversalString(cArray);
        }

        protected String typeName() {
            return "UniversalString";
        }
    }
}

