/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;

public class Certificate
implements ASN1Value {
    private CertificateInfo info;
    private byte[] infoEncoding;
    private byte[] signature;
    private AlgorithmIdentifier algId;
    SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private Certificate() {
    }

    Certificate(CertificateInfo certificateInfo, byte[] byArray, AlgorithmIdentifier algorithmIdentifier, byte[] byArray2) throws IOException {
        this.info = certificateInfo;
        this.infoEncoding = byArray;
        this.algId = algorithmIdentifier;
        this.signature = byArray2;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(certificateInfo);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(new BIT_STRING(byArray2, 0));
    }

    public Certificate(CertificateInfo certificateInfo, PrivateKey privateKey, SignatureAlgorithm signatureAlgorithm) throws IOException, CryptoManager.NotInitializedException, TokenException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, SignatureException {
        if (!(privateKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException("Private Key is does not belong to this provider");
        }
        org.mozilla.jss.crypto.PrivateKey privateKey2 = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        this.algId = signatureAlgorithm.getSigningAlg() == SignatureAlgorithm.RSASignature ? new AlgorithmIdentifier(signatureAlgorithm.toOID(), null) : new AlgorithmIdentifier(signatureAlgorithm.toOID());
        if (!certificateInfo.getSignatureAlgId().getOID().equals(this.algId.getOID())) {
            throw new CertificateException("Signing Algorithm does not match the one specified in the CertificateInfo");
        }
        this.info = certificateInfo;
        this.infoEncoding = ASN1Util.encode(certificateInfo);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = privateKey2.getOwningToken();
        Signature signature = cryptoToken.getSignatureContext(signatureAlgorithm);
        signature.initSign(privateKey2);
        signature.update(this.infoEncoding);
        this.signature = signature.sign();
        this.sequence = new SEQUENCE();
        this.sequence.addElement(certificateInfo);
        this.sequence.addElement(this.algId);
        this.sequence.addElement(new BIT_STRING(this.signature, 0));
    }

    public void verify() throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyFormatException {
        this.verify(this.info.getSubjectPublicKeyInfo().toPublicKey());
    }

    public void verify(PublicKey publicKey) throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        this.verify(publicKey, cryptoManager.getInternalCryptoToken());
    }

    public void verify(PublicKey publicKey, CryptoToken cryptoToken) throws NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyException {
        Signature signature = cryptoToken.getSignatureContext(SignatureAlgorithm.fromOID(this.info.getSignatureAlgId().getOID()));
        signature.initVerify(publicKey);
        signature.update(this.infoEncoding);
        if (!signature.verify(this.signature)) {
            throw new CertificateException("Signature is invalid");
        }
    }

    public CertificateInfo getInfo() {
        return this.info;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 2 || stringArray.length < 1) {
                System.out.println("Usage: Certificate <dbdir> [<certfile>]");
                System.exit(0);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[1]));
            Certificate certificate = (Certificate)Certificate.getTemplate().decode(bufferedInputStream);
            CertificateInfo certificateInfo = certificate.getInfo();
            certificateInfo.print(System.out);
            certificate.verify();
            System.out.println("verified");
            FileOutputStream fileOutputStream = new FileOutputStream("certinfo.der");
            certificateInfo.encode(fileOutputStream);
            fileOutputStream.close();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(512);
            System.out.println("Generating a new key pair...");
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            System.out.println("Generated key pair");
            certificateInfo.setSubjectPublicKeyInfo(keyPair.getPublic());
            int n = certificateInfo.getSerialNumber().intValue() + 1;
            certificateInfo.setSerialNumber(new INTEGER(n));
            Name name = new Name();
            name.addCommonName("Stra\u00dfenverk\u00e4ufer 'R' Us");
            name.addCountryName("US");
            name.addOrganizationName("Some Corporation");
            name.addOrganizationalUnitName("some org unit?");
            name.addLocalityName("Silicon Valley");
            name.addStateOrProvinceName("California");
            certificateInfo.setIssuer(name);
            certificateInfo.setSubject(name);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1997, 3, 1);
            certificateInfo.setNotBefore(calendar.getTime());
            calendar.set(2010, 3, 1);
            certificateInfo.setNotAfter(calendar.getTime());
            System.out.println("About to create a new cert...");
            Certificate certificate2 = new Certificate(certificateInfo, keyPair.getPrivate(), SignatureAlgorithm.RSASignatureWithMD5Digest);
            System.out.println("Created new cert");
            certificate2.verify();
            System.out.println("Cert verifies!");
            fileOutputStream = new FileOutputStream("gencert.der");
            certificate2.encode(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new ANY.Template());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            ANY aNY = (ANY)sEQUENCE.elementAt(0);
            byte[] byArray = aNY.getEncoded();
            CertificateInfo certificateInfo = (CertificateInfo)aNY.decodeWith(CertificateInfo.getTemplate());
            BIT_STRING bIT_STRING = (BIT_STRING)sEQUENCE.elementAt(2);
            if (bIT_STRING.getPadCount() != 0) {
                throw new InvalidBERException("signature does not fall into an integral number of bytes");
            }
            byte[] byArray2 = bIT_STRING.getBits();
            return new Certificate(certificateInfo, byArray, (AlgorithmIdentifier)sEQUENCE.elementAt(1), byArray2);
        }
    }
}

