/*
 * Copyright 1998-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 *	@(#)net_secpolicy.h	7.62	03/10/16
 */

#ifndef	_SYS_NET_SECPOLICY_H
#define	_SYS_NET_SECPOLICY_H

#pragma ident	"@(#)net_secpolicy.h	7.62	03/10/16 SMI; TSOL 2.x"

#include <sys/types.h>
#include <sys/kmem.h>
#include <sys/stream.h>
#include <sys/secpolicy.h>
#include <netinet/in.h>
#include <netinet/ip6.h>
#include <inet/udp.h>
#include <inet/tcp.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define	_SUN_TPI_VERSION	2
#include <sys/tihdr.h>

/*
 * 	IP data management
 */
int secpolicy_ip_adjust_msg(ipha_t *, uchar_t *, int);
void secpolicy_ip_adjust_mp(mblk_t *);
int secpolicy_ip_check_ipopt(mblk_t *, void *, uchar_t **, int *);
int secpolicy_ip_check_msg(queue_t *, mblk_t **, ipha_t **);
int secpolicy_ip_check_msg_v6(queue_t *, mblk_t **, ip6_t **);
int secpolicy_ip_get_attr(mblk_t *, void *, strattr_t *, uint8_t,
    secpolicy_buf_t *);
int secpolicy_ip_get_offset(ipha_t *, int *);
int secpolicy_ip_get_porttype(mblk_t *, ipc_t *);
void secpolicy_ip_local(mblk_t *, ire_t *);
int secpolicy_ip_match_port(mblk_t *, ipc_t *);
int secpolicy_ip_rput(queue_t *, mblk_t *, ire_t *);
int secpolicy_ip_send_icmp(queue_t *, mblk_t *, ipha_t *, secpolicy_buf_t *);
int secpolicy_ip_verify_ipopt(uchar_t *, uint32_t, intptr_t *, ipha_t *);
void secpolicy_ip_driver_header(mblk_t *, mblk_t *);
void secpolicy_ipc_init_attrs(mblk_t *, ipc_t *, ipc_t ***, icf_t *);
int secpolicy_ipif_addr_init(ipif_t *);
int secpolicy_ipif_init(ipif_t *);
int secpolicy_ip_siocgetrt(mblk_t *, queue_t *, ire_t *, struct tsol_rtentry *);
int secpolicy_rtentry_init_ire(struct rtentry *, int, ire_t *);
int secpolicy_rtmsg_change_ire(rt_msghdr_t *, ire_t *);
int secpolicy_rtmsg_init_ire(rt_msghdr_t *, ire_t *);
mblk_t *secpolicy_rts_alloc_msg(size_t, rt_msghdr_t *, ire_t *);
void secpolicy_rts_get_secattr(mblk_t *);
int secpolicy_ire_init_attr(ire_t *, ire_attr_t);
void secpolicy_ire_delete(ire_t *);
int secpolicy_ire_match_attr(ire_t *, mblk_t *mp);
int secpolicy_ire_match_attr_v6(ire_t *, mblk_t *mp);
kmem_cache_t *secpolicy_ire_cache_create(int (*constructor)(),
    void (*destructor)(), void (*reclaim)());
int secpolicy_ip6opt(queue_t *q, mblk_t *, uint8_t *, ip6_t *);
void secpolicy_ip_local(mblk_t *, ire_t *);

/*
 * 	TCP data management
 */
int secpolicy_tcp_accept(mblk_t *, tcp_t *, tcp_t *, mblk_t *);
int secpolicy_tcp_add_flags(uchar_t *, int);
int secpolicy_tcp_adjust_msg(mblk_t **, int *);
int secpolicy_tcp_attrs_slow(tcp_t *, mblk_t **);
int secpolicy_tcp_check_attr(mblk_t *, int *, int *);
int secpolicy_tcp_create(void *, queue_t *);
int secpolicy_tcp_ctl_mp(tcpb_t *, mblk_t *, int);
int secpolicy_tcp_deferred_read(queue_t *, tcp_t *, mblk_t **, int *, int *,
    uint_t *, int *);
int secpolicy_tcp_flags(tcp_t *, uint_t);
int secpolicy_tcp_free(tcpb_t *);
void secpolicy_tcp_get_attrsrc(tcp_t *, mblk_t *mp, int *, int *, int *);
int secpolicy_tcp_get_optlen(tcp_t *, ire_t *);
int secpolicy_tcp_get_porttype(mblk_t *, tcp_t *);
void secpolicy_tcp_inactive(tcp_t *);
int secpolicy_tcp_init(tcpb_t *, boolean_t);
int secpolicy_tcp_ip_notify(tcp_t *, mblk_t *);
int secpolicy_tcp_ismlp(tcp_t *);
int secpolicy_tcp_listener_ipv4(mblk_t *, tcp_t *, tcp_t *);
int secpolicy_tcp_listener_ipv6(mblk_t *, tcp_t *, tcp_t *);
int secpolicy_tcp_match_sl(mblk_t *, tcpb_t *);
int secpolicy_tcp_not_deferred(tcpb_t *, int);
int secpolicy_tcp_read(queue_t *, mblk_t *, tcp_t *, int);
int secpolicy_tcp_reass(tcp_t *, mblk_t *);
int secpolicy_tcp_recv_conn(mblk_t *, tcp_t *, tcp_t *, mblk_t *);
void secpolicy_tcp_reinit(tcp_t *);
int secpolicy_tcp_rsrv(queue_t *);
int secpolicy_tcp_connect(mblk_t *, tcp_t *);
int secpolicy_tcp_send_ind(tcp_t *, mblk_t *, uint_t *);
int secpolicy_tcp_set_flag(tcpb_t *, uint_t *);
int secpolicy_tcp_snmp_get(mblk_t *, void *, tcpb_t *, boolean_t);
int secpolicy_tcp_wput(tcp_t *, mblk_t *);
int secpolicy_tcp_wput_slow(tcp_t *, mblk_t *);
int secpolicy_tcp_xmit_early_reset(tcp_t *, mblk_t *, ushort_t);
int secpolicy_tcp_xmit_mp(tcp_t *, mblk_t *, int);
int secpolicy_tcp_send_syn(tcp_t *, mblk_t *);

/*
 * 	NET data management
 */
int secpolicy_transport_add_privport(in_port_t *, int);

/*
 * 	UDP data management
 */
int secpolicy_udp_get_offset(void *, int *);
int secpolicy_udp_get_porttype(mblk_t *, udp_t *);
int secpolicy_udp_read(queue_t *, mblk_t *, int);
int secpolicy_udp_snmp_get(mblk_t *, void *, udp_t *, boolean_t);
int secpolicy_udp_wput(queue_t *, mblk_t *, ipaddr_t, uint16_t);
int secpolicy_udp_wput_ipv6(queue_t *, mblk_t *, ip6_pkt_t *, sin6_t *);

/*
 *	net policy
 */
int secpolicy_arp_table_modify(cred_t *, mblk_t *, queue_t *);
cred_t *secpolicy_get_cred(cred_t *, mblk_t *);
int secpolicy_ip_accredchk_bcast_if(ire_t *, mblk_t *);
int secpolicy_ip_accredchk_fwdbcast(queue_t *, mblk_t **, ire_t *);
int secpolicy_ip_import(queue_t *, mblk_t *, ire_t *, ipha_t **, uchar_t *);
int secpolicy_ip_import_v6(queue_t *, mblk_t *, ire_t *, ip6_t *, ill_t *);
int secpolicy_ip_export(queue_t *, mblk_t **);
int secpolicy_ip_export_v6(queue_t *, mblk_t *);
int secpolicy_ip_forward(ill_t *, ire_t *, mblk_t **, ipha_t **);
int secpolicy_ipif_create(cred_t *, mblk_t *);
int secpolicy_keysock_open(cred_t *);
int secpolicy_nca_open(cred_t *);
int secpolicy_net_config(cred_t *, boolean_t);
int secpolicy_net_names_modify(cred_t *, mblk_t *);
int secpolicy_net_params_tune(cred_t *, mblk_t *);
int secpolicy_net_remote_logind_fix_sl(queue_t *, mblk_t *);
int secpolicy_net_table_modify(cred_t *, mblk_t *);
int secpolicy_sockopt_priv(cred_t *, t_uscalar_t, t_uscalar_t, int);
int secpolicy_raw_socket_create(cred_t *, queue_t *, cred_t *);
int secpolicy_rtsocket_reopen(cred_t *, cred_t *);
int secpolicy_tcp_compare_port(tcp_t *, tcpb_t *);
int secpolicy_tcp_defq_set(cred_t *, mblk_t *);
int secpolicy_tcp_seqnum_get(cred_t *, mblk_t *);
int secpolicy_transport_bind(cred_t *, mblk_t *);
int secpolicy_udp_compare_port(udp_t *, udp_t *);
int secpolicy_udp_reopen(cred_t *, cred_t *);
int secpolicy_tcp_report_rate(cred_t *, mblk_t *);

/*
 * Flag values passed to secpolicy_tcp_not_deferred().
 */
#define	SKIP_IF_TSIX		1
#define	PROCESS_IF_TSIX		2

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_NET_SECPOLICY_H */
