/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel;

import com.iplanet.idar.common.DescriptorMap;
import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanListener;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class IDARReference
implements BeanListenable {
    public static final String NULL = "NULL";
    public static final IDARReference NULL_REFERENCE = new IDARReference("NULL:NULL:NULL");
    public static int refCount = 0;
    public int thisCount = 0;
    IDARReference parent = NULL_REFERENCE;
    IDARModelBean bean = null;
    String id;
    String[] oldIds;
    String descriptor;
    Class beanClass;
    String handle;
    Vector listeners = new Vector();
    private static Hashtable localizedDescriptors = new Hashtable();

    public static synchronized String[] parseReference(String string) {
        Debug.println((int)7, (String)("IDARReference.parseString: ref=" + string));
        String[] stringArray = new String[3];
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (3 == stringTokenizer.countTokens()) {
                stringArray[0] = stringTokenizer.nextToken();
                stringArray[1] = stringTokenizer.nextToken();
                stringArray[2] = stringTokenizer.nextToken();
            } else {
                Debug.println((int)6, (String)("IDARReference.parseRef: ERROR: malformed reference string " + string));
                Debug.println((String)(" tokens=" + stringTokenizer.countTokens()));
            }
        }
        return stringArray;
    }

    IDARReference(String string, String string2, String string3) {
        this.thisCount = refCount++;
        this.setId(string);
        this.setDescriptor(string2);
        this.setHandle(string3);
    }

    public IDARReference(String string) {
        String[] stringArray = IDARReference.parseReference(string);
        this.thisCount = refCount++;
        this.setId(stringArray[0]);
        this.setDescriptor(stringArray[1]);
        this.setHandle(stringArray[2]);
        this.setBeanClass(DescriptorMap.lookupBeanClass(this.getDescriptor()));
        this.setParentConfiguration(this.parent);
    }

    public IDARReference(IDARReference iDARReference, String string) {
        this(string);
        this.setParentConfiguration(iDARReference);
    }

    public boolean isNull() {
        return !this.isValid() || this.id.equals(NULL) && this.descriptor.equals(NULL);
    }

    public boolean isValid() {
        return this.id != null && this.descriptor != null && this.handle != null;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof IDARReference && this.id != null && this.descriptor != null && this.handle != null) {
            IDARReference iDARReference = (IDARReference)object;
            bl = this.handle.equals(iDARReference.getHandle()) && this.descriptor.equals(iDARReference.getDescriptor());
        }
        return bl;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(this.handle);
        stringBuffer.append(this.descriptor);
        return stringBuffer.toString().hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String[] getOldIds() {
        return this.oldIds;
    }

    public void setId(String string) {
        if (this.id != null) {
            int n;
            if (this.oldIds == null) {
                this.oldIds = new String[1];
                n = 0;
            } else {
                String[] stringArray = new String[this.oldIds.length + 1];
                for (int i = 0; i < this.oldIds.length; ++i) {
                    stringArray[i] = this.oldIds[i];
                }
                this.oldIds = stringArray;
                n = stringArray.length - 1;
            }
            this.oldIds[n] = this.id;
        }
        this.id = string;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String string) {
        this.descriptor = string;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String string) {
        this.handle = string;
    }

    public IDARReference getParentConfiguration() {
        return this.parent;
    }

    public void setParentConfiguration(IDARReference iDARReference) {
        this.parent = iDARReference;
    }

    public IDARModelBean getBean() throws NoSuchBeanException, RetrievalException {
        if (this.bean == null) {
            this.bean = BeanSpace.getInstance().retrieveBean(this);
        }
        return this.bean;
    }

    public IDARModelBean getLoadedBean() {
        return this.bean;
    }

    public IDARReference getSelfReference() {
        return this;
    }

    public String toString() {
        return this.getId() + ":" + this.getDescriptor() + ":" + this.getHandle();
    }

    public boolean beanHasBeenLoaded() {
        return BeanSpace.getInstance().beanHasBeenLoaded(this);
    }

    public void addBeanListener(BeanListener beanListener) {
        Debug.println((int)6, (String)("IDARReference.addBeanListener: " + beanListener));
        if (this.bean == null && BeanSpace.getInstance().beanHasBeenLoaded(this)) {
            try {
                this.bean = this.getBean();
                this.transferListeners(this.bean);
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
        }
        if (this.bean != null) {
            Debug.println((int)6, (String)"IDARReference.addBeanListener: listener added to bean");
            this.bean.addBeanListener(beanListener);
        } else if (this.listeners != null) {
            Debug.println((int)6, (String)"IDARReference.addBeanListener: listener added to ref");
            this.listeners.add(beanListener);
        }
    }

    public void removeBeanListener(BeanListener beanListener) {
        Debug.println((int)6, (String)("IDARReference.removeBeanListener: " + beanListener));
        if (beanListener != null) {
            if (this.listeners == null && this.bean != null) {
                this.bean.removeBeanListener(beanListener);
            } else if (this.listeners != null) {
                this.listeners.remove(beanListener);
            }
        }
    }

    public void fireBeanLoaded(IDARModelBean iDARModelBean) {
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BeanListener beanListener = (BeanListener)enumeration.nextElement();
            if (beanListener == null) continue;
            beanListener.beanLoaded(new BeanEvent(this, iDARModelBean));
        }
        this.transferListeners(iDARModelBean);
    }

    private void transferListeners(IDARModelBean iDARModelBean) {
        Debug.println((int)6, (String)("IDARReference.transferListeners: of ref " + this + " to " + iDARModelBean));
        if (this.listeners != null && iDARModelBean != null) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                BeanListener beanListener = (BeanListener)enumeration.nextElement();
                iDARModelBean.addBeanListener(beanListener);
            }
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public String getLocalizableDescriptor() {
        String string = (String)localizedDescriptors.get(this.descriptor);
        if (string != null) {
            return string;
        }
        return "";
    }

    static {
        localizedDescriptors.put("idar-server", IDARResourceSet.getString("configType", "DPS_DESCRIPTOR"));
        localizedDescriptors.put("configuration", IDARResourceSet.getString("configType", "CONFIGURATION_DESCRIPTOR"));
        localizedDescriptors.put("system", IDARResourceSet.getString("configType", "SYSTEM_DESCRIPTOR"));
        localizedDescriptors.put("group", IDARResourceSet.getString("configType", "GROUP_DESCRIPTOR"));
        localizedDescriptors.put("network-group", IDARResourceSet.getString("configType", "NETWORK_GROUP_DESCRIPTOR"));
        localizedDescriptors.put("non-network-group", IDARResourceSet.getString("configType", "NON_NETWORK_GROUP_DESCRIPTOR"));
        localizedDescriptors.put("rule", IDARResourceSet.getString("configType", "EVENT_DESCRIPTOR"));
        localizedDescriptors.put("rule", IDARResourceSet.getString("configType", "EVENT_DESCRIPTOR"));
        localizedDescriptors.put("on-ssl", IDARResourceSet.getString("configType", "ON_SSL_EVENT_DESCRIPTOR"));
        localizedDescriptors.put("on-bind", IDARResourceSet.getString("configType", "ON_BIND_EVENT_DESCRIPTOR"));
        localizedDescriptors.put("action", IDARResourceSet.getString("configType", "ACTION_DESCRIPTOR"));
        localizedDescriptors.put("change-group", IDARResourceSet.getString("configType", "CHANGE_GROUP_ACTION_DESCRIPTOR"));
        localizedDescriptors.put("property", IDARResourceSet.getString("configType", "PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("attribute-renaming", IDARResourceSet.getString("configType", "ATTRIBUTE_RENAMING_PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("forbidden-entry", IDARResourceSet.getString("configType", "FORBIDDEN_ENTRY_PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("ldap-server", IDARResourceSet.getString("configType", "LDAP_SERVER_PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("load-balancing", IDARResourceSet.getString("configType", "LOAD_BALANCING_PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("log", IDARResourceSet.getString("configType", "LOGGING_PROPERTY_DESCRIPTOR"));
        localizedDescriptors.put("search-size-limit", IDARResourceSet.getString("configType", "SEARCH_SIZE_LIMIT_PROPERTY_DESCRIPTOR"));
    }
}

