/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class ConfigurationBean
extends IDARConfigurationModelBean
implements IDARConstants {
    public static final String CN = "cn";
    public static final String[] CONFIG_ELEMENT_DESCRIPTORS = new String[]{"network-group", "rule", "action", "property"};
    private static final String PREDELETE_MESSAGE = IDARResourceSet.getString("error", "CONFIG_DELETE");

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "CONFIGURATION_DESCRIPTOR");
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isLegal() {
        return true;
    }

    public String getIllegalityExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        boolean bl = true;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray.length > 0) {
            bl = false;
        }
        return bl;
    }

    public String getPredeletionMessage() {
        String string = null;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(PREDELETE_MESSAGE);
            stringBuffer.append('\n');
            for (int i = 0; i < iDARReferenceArray.length && i < 5; ++i) {
                stringBuffer.append("  ");
                stringBuffer.append(iDARReferenceArray[i].getId());
                if (i == 4 && iDARReferenceArray.length > 5) {
                    stringBuffer.append("\n  " + AND_OTHERS);
                }
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(IDARReference.NULL_REFERENCE, "idar-server");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof IDARBean) {
                    IDARBean iDARBean = (IDARBean)e;
                    String string2 = iDARBean.getSharedConfigurationName();
                    if (string2 == null || !string2.equals(string)) continue;
                    vector.add(iDARBean.getSelfReference());
                    continue;
                }
                Debug.println((String)"ConfigurationBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"ConfigurationBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getIdField() {
        return CN;
    }

    protected static String getIdPrefix() {
        return "configuration";
    }

    public void addBelongsTo(String string) {
        Debug.println((String)("ConfigurationBean.addBelongsTo: config=" + this.getId() + " serverid=" + string));
        super.addBelongsTo(string);
        this.addBelongsToToElements(string);
    }

    public void removeBelongsTo(String string) {
        Debug.println((String)("ConfigurationBean.removeBelongsTo: config=" + this.getId() + " serverid=" + string));
        super.removeBelongsTo(string);
        this.removeBelongsToFromElements(string);
    }

    public String getDescriptor() {
        return ConfigurationBean.getIdPrefix();
    }

    public String getConfigurationName() {
        return this.getId();
    }

    public void setConfigurationName(String string) throws UniqueNameException {
        this.setId(string);
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        super.doPersist(new TaskParameters());
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        super.doSynchronize();
    }

    IDARReference invokeCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.createConfiguration(string);
        }
        throw new CreationException("Bean management command not set by instantiator");
    }

    void invokeDelete(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand == null) {
            throw new DeletionException("Bean management command not set by instantiator");
        }
        httpCommand.deleteConfiguration(iDARReference);
    }

    IDARReference invokeRename(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.renameConfiguration(iDARReference, string);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokePersist(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        return null;
    }

    TaskResult invokeSynchronize(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.synchronize(iDARReference);
        }
        throw new RetrievalException("Bean management command not set by instantiator");
    }

    public Vector getChildBeans() {
        Vector vector = null;
        try {
            IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(this.getSelfReference(), CONFIG_ELEMENT_DESCRIPTORS);
            if (iDARBeanCollection != null) {
                vector = iDARBeanCollection.toBeanVector();
            }
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
        return vector;
    }

    public Vector getChildReferences() {
        Vector vector = null;
        try {
            IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(this.getSelfReference(), CONFIG_ELEMENT_DESCRIPTORS);
            if (iDARBeanCollection != null) {
                vector = iDARBeanCollection.toReferenceVector();
            }
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
        return vector;
    }

    private void addBelongsToToElements(String string) {
        Debug.println((String)("ConfigurationBean.addBelongsToToElements: id=" + string));
        Vector vector = this.getChildReferences();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                IDARReference iDARReference = (IDARReference)enumeration.nextElement();
                if (!iDARReference.beanHasBeenLoaded()) continue;
                try {
                    Debug.println((String)("ConfigurationBean.addBelongsToToElements: id=" + string + " bean=" + iDARReference.getId()));
                    IDARConfigurationModelBean iDARConfigurationModelBean = (IDARConfigurationModelBean)iDARReference.getBean();
                    iDARConfigurationModelBean.addBelongsTo(string);
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
            }
        }
    }

    private void removeBelongsToFromElements(String string) {
        Debug.println((String)("ConfigurationBean.removeBelongsToFromElements: id=" + string));
        Vector vector = this.getChildReferences();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                IDARReference iDARReference = (IDARReference)enumeration.nextElement();
                if (!iDARReference.beanHasBeenLoaded()) continue;
                try {
                    Debug.println((String)("ConfigurationBean.removeBelongsToFromElements: id=" + string + " bean=" + iDARReference.getId()));
                    IDARConfigurationModelBean iDARConfigurationModelBean = (IDARConfigurationModelBean)iDARReference.getBean();
                    iDARConfigurationModelBean.removeBelongsTo(string);
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
            }
        }
    }
}

