/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanListener;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.DN;

public abstract class IDARModelBean
implements IModelBean,
BeanListenable {
    protected static final String IN_USE = IDARResourceSet.getString("error", "IN_USE");
    protected static final String AND_OTHERS = IDARResourceSet.getString("error", "AND_OTHERS");
    private static final boolean DEBUG = false;
    private IDARReference configuration = null;
    private IDARReference reference = null;
    private boolean isDirty = false;
    private boolean ethereal = false;
    private String[] subscribingIDARs;
    private HttpCommand command = null;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private PropertyChangeSupport persistSupport = new PropertyChangeSupport(this);
    private Hashtable currentProperties;
    private Vector listeners = new Vector();
    protected static final int MAX_REF_ITEMS_TO_DISPLAY = 5;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangePersistanceListener(PropertyChangeListener propertyChangeListener) {
        this.persistSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangePersistanceListener(String string, PropertyChangeListener propertyChangeListener) {
        this.persistSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangePersistanceListener(PropertyChangeListener propertyChangeListener) {
        this.persistSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangePersistanceListener(String string, PropertyChangeListener propertyChangeListener) {
        this.persistSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public IDARReference getSelfReference() {
        return this.reference;
    }

    public void setSelfReference(IDARReference iDARReference) {
        this.reference = iDARReference;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        Debug.println((int)7, (String)("IDARModelBean.setDirty: bean=" + this.getId() + " dirty=" + bl));
        this.isDirty = bl;
    }

    protected static String getIdPrefix() {
        return "";
    }

    public static String normalizeId(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " :+;\",#", false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        string = stringBuffer.toString();
        return string.toLowerCase();
    }

    public IDARReference getParentConfiguration() {
        return this.configuration;
    }

    public void setParentConfiguration(IDARReference iDARReference) {
        this.configuration = iDARReference;
    }

    public String getId() {
        String string = null;
        IDARReference iDARReference = this.getSelfReference();
        if (iDARReference != null) {
            string = iDARReference.getId();
        }
        return string;
    }

    public void setId(String string) throws UniqueNameException {
        String string2 = this.getId();
        Debug.println((String)("IDARModelBean.setId: id=" + string + " current=" + string2));
        String string3 = IDARModelBean.normalizeId(string);
        if (!string2.equals(string3)) {
            try {
                if (!BeanSpace.getInstance().idIsUnique(this.getParentConfiguration(), string3, this.getDescriptor())) {
                    throw new UniqueNameException(IDARResourceSet.getString("error", "UNIQUE_NAME", string3));
                }
                String string4 = this.getSelfReference().getId();
                Debug.println((String)("IDARModelBean.setId: renaming system " + string4 + " to " + string3));
                this.getSelfReference().setId(string3);
                this.setDirty(true);
                this.firePropertyChange("id", string4, string3);
                this.firePropertyChange(this.getIdField(), string4, string3);
            }
            catch (IDARBeanException iDARBeanException) {
                Debug.println((int)0, (String)("ERROR: " + iDARBeanException.getLocalizedMessage()));
                throw new UniqueNameException(IDARResourceSet.getString("error", "CANNOT_DETERMINE_UNIQUENESS", string3));
            }
        }
    }

    public abstract String getLocalizableDescriptor();

    public abstract String getIdField();

    public abstract boolean isQuestionable();

    public abstract String getQuestionableExplanationMessage();

    public abstract boolean isLegal();

    public abstract String getIllegalityExplanationMessage();

    public abstract boolean isDeletable();

    public String getPredeletionMessage() {
        String string = null;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(IN_USE);
            stringBuffer.append('\n');
            for (int i = 0; i < iDARReferenceArray.length && i < 5; ++i) {
                stringBuffer.append("  ");
                stringBuffer.append(iDARReferenceArray[i].getId());
                if (i == 4 && iDARReferenceArray.length > 5) {
                    stringBuffer.append("\n  " + AND_OTHERS);
                }
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public abstract IDARReference[] getSubscribers();

    public String getDescriptor() {
        return this.reference.getDescriptor();
    }

    public String getTypeDisplayString() {
        String string = this.getDescriptor();
        if (string.equals("idar-server")) {
            return IDARResourceSet.getString("object", "idar_server");
        }
        if (string.equals("configuration")) {
            return IDARResourceSet.getString("object", "configuration");
        }
        if (string.equals("system")) {
            return IDARResourceSet.getString("object", "system");
        }
        if (string.equals("group")) {
            return IDARResourceSet.getString("object", "group");
        }
        if (string.equals("network-group")) {
            return IDARResourceSet.getString("group", "network_group");
        }
        if (string.equals("non-network-group")) {
            return IDARResourceSet.getString("object", "group");
        }
        if (string.equals("rule")) {
            return IDARResourceSet.getString("object", "event");
        }
        if (string.equals("rule")) {
            return IDARResourceSet.getString("object", "event");
        }
        if (string.equals("on-ssl")) {
            return IDARResourceSet.getString("object", "on_ssl_event");
        }
        if (string.equals("on-bind")) {
            return IDARResourceSet.getString("object", "on_bind_event");
        }
        if (string.equals("action")) {
            return IDARResourceSet.getString("object", "action");
        }
        if (string.equals("change-group")) {
            return IDARResourceSet.getString("object", "change_group_action");
        }
        if (string.equals("property")) {
            return IDARResourceSet.getString("object", "property");
        }
        if (string.equals("attribute-renaming")) {
            return IDARResourceSet.getString("object", "attribute_renaming_property");
        }
        if (string.equals("forbidden-entry")) {
            return IDARResourceSet.getString("object", "forbidden_entry_property");
        }
        if (string.equals("ldap-server")) {
            return IDARResourceSet.getString("object", "ldap_server_property");
        }
        if (string.equals("load-balancing")) {
            return IDARResourceSet.getString("object", "load_balance_property");
        }
        if (string.equals("log")) {
            return IDARResourceSet.getString("object", "log_property");
        }
        if (string.equals("search-size-limit")) {
            return IDARResourceSet.getString("object", "search_size_limit_property");
        }
        return "";
    }

    public DN getDn() {
        return new DN(this.getHandle());
    }

    public void setDn(String string) {
    }

    public String getHandle() {
        return this.reference.getHandle();
    }

    public String[] getSubscribingIDARs() {
        return this.subscribingIDARs;
    }

    public void setSubscribingIDARs(String[] stringArray) {
        this.subscribingIDARs = stringArray;
    }

    public boolean isEthereal() {
        return this.ethereal;
    }

    public void setEthereal(boolean bl) {
        this.ethereal = bl;
    }

    public void setCommand(HttpCommand httpCommand) {
        this.command = httpCommand;
    }

    public HttpCommand getCommand() {
        return this.command;
    }

    public abstract void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException;

    public abstract void synchronize() throws NoSuchBeanException, RetrievalException;

    public void delete() throws NoSuchBeanException, DeletionException {
        BeanSpace.getInstance().deleteBean(this);
    }

    private void create(TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        Vector vector;
        String string = this.getDescriptor();
        try {
            vector = BeanSpace.getInstance().getExistingClientAndServerSideIdsAsVector(this.getParentConfiguration(), string);
        }
        catch (RetrievalException retrievalException) {
            Debug.println((String)("BeanSpace:  error querying ids for " + string));
            throw new CreationException("Unable to compute a unique id for the new bean");
        }
        int n = 1;
        String string2 = null;
        while (vector.contains(string2 = string + "-" + Integer.toString(n++))) {
        }
        taskParameters.addParameter(this.getIdField(), string2);
        this.reference = this.invokeCreate(this.getParentConfiguration(), string2, this.getDescriptor(), taskParameters);
        this.setSelfReference(this.reference);
        this.saveProperties(taskParameters.toHashtable(), this.getId());
    }

    public void fDelete() throws NoSuchBeanException, DeletionException {
        if (this.command == null) {
            throw new DeletionException("Bean persistence command not set by instantiator");
        }
        this.invokeDelete(this.getSelfReference());
    }

    public IDARReference rename(String string) throws NoSuchBeanException, PersistenceException {
        return BeanSpace.getInstance().renameBean(this, string);
    }

    public IDARReference fRename(String string) throws NoSuchBeanException, PersistenceException {
        if (this.command == null) {
            throw new PersistenceException("Bean persistence command not set by instantiator");
        }
        return this.invokeRename(this.getSelfReference(), string);
    }

    abstract IDARReference invokeCreate(IDARReference var1, String var2, String var3, TaskParameters var4) throws BeanAlreadyExistsException, CreationException;

    abstract void invokeDelete(IDARReference var1) throws NoSuchBeanException, DeletionException;

    abstract IDARReference invokeRename(IDARReference var1, String var2) throws PersistenceException, NoSuchBeanException;

    abstract TaskResult invokePersist(IDARReference var1, TaskParameters var2) throws PersistenceException, NoSuchBeanException;

    abstract TaskResult invokeSynchronize(IDARReference var1) throws RetrievalException, NoSuchBeanException;

    protected synchronized TaskResult doPersist(TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException, UniqueNameException {
        TaskResult taskResult = null;
        IDARReference iDARReference = this.getSelfReference();
        Debug.println((int)6, (String)("IDARModelBean.doPersist: ref=" + iDARReference));
        if (this.command == null) {
            throw new PersistenceException("Bean persistence command not set by instantiator");
        }
        if (iDARReference == null) {
            Debug.println((int)6, (String)"Bean has no reference, calling create");
            try {
                this.removeBeanManagementProperties(taskParameters.toHashtable());
                this.create(taskParameters);
            }
            catch (CreationException creationException) {
                throw new PersistenceException("Creation failed: " + creationException.getMessage(), creationException.getErrorCode());
            }
            catch (BeanAlreadyExistsException beanAlreadyExistsException) {
                throw new PersistenceException("Creation failed: " + beanAlreadyExistsException.getMessage(), beanAlreadyExistsException.getErrorCode());
            }
            this.setEthereal(true);
        } else {
            if (this.currentProperties != null) {
                String string = this.getId();
                Debug.println((int)6, (String)("IDARModelBean.doPersist: current id=" + string));
                Object v = this.currentProperties.get("id");
                if (v == null) {
                    throw new PersistenceException("IDARModelBean:  " + string + " did not property record an " + "id property when it was initially synchronized");
                }
                if (!(v instanceof String)) {
                    throw new PersistenceException("IDARModelBean:  " + string + " submitted own \"" + "id" + "\" parameter for persistance.  This " + "parameter should only managed by IDARModelBean");
                }
                String string2 = (String)v;
                Debug.println((int)6, (String)("IDARModelBean.doPersist: previous id=" + string2));
                if (!string2.equalsIgnoreCase(string)) {
                    iDARReference = this.rename(string);
                    this.currentProperties.put("id", string);
                    this.fireBeanRenamed();
                }
            }
            this.removeBeanManagementProperties(taskParameters.toHashtable());
            taskResult = this.invokePersist(iDARReference, taskParameters);
            this.comparePersistedProperties(taskParameters.toHashtable());
            this.setDirty(false);
            this.setEthereal(false);
        }
        this.fireBeanPersisted();
        return taskResult;
    }

    protected synchronized TaskResult doSynchronize() throws RetrievalException, NoSuchBeanException {
        Hashtable hashtable;
        TaskResult taskResult = this.invokeSynchronize(this.getSelfReference());
        if (taskResult == null) {
            throw new RetrievalException("sync invocation returned null result");
        }
        String string = taskResult.getAttributeValue(this.getIdField());
        String string2 = this.getId();
        if (!string2.equals(string)) {
            this.getSelfReference().setId(string);
            this.firePropertyChange("id", string2, string);
            this.firePropertyChange(this.getIdField(), string2, string);
        }
        if (null == (hashtable = taskResult.toHashtable()).get("id") && string != null) {
            hashtable.put("id", string);
            this.saveProperties(hashtable, string);
            this.removeBeanManagementProperties(hashtable);
        }
        this.setDirty(false);
        return taskResult;
    }

    protected Hashtable getCurrentProperties() {
        return this.currentProperties;
    }

    protected void saveProperties(Hashtable hashtable, String string) {
        this.currentProperties = (Hashtable)hashtable.clone();
        this.removeBeanManagementProperties(this.currentProperties);
        this.currentProperties.put("id", string);
        Debug.println((int)6, (String)("IDARModelBean.saveProperties:  properties=" + this.currentProperties));
    }

    protected void comparePersistedProperties(Hashtable hashtable) {
        if (hashtable != null) {
            Hashtable hashtable2 = (Hashtable)hashtable.clone();
            this.removeBeanManagementProperties(hashtable2);
            if (this.currentProperties != null) {
                Object v;
                String string;
                Hashtable hashtable3 = (Hashtable)this.currentProperties.clone();
                this.removeBeanManagementProperties(hashtable3);
                Iterator iterator = hashtable3.keySet().iterator();
                while (iterator.hasNext()) {
                    string = iterator.next().toString();
                    if (hashtable2.containsKey(string)) continue;
                    v = hashtable3.get(string);
                    this.firePropertyChangePersisted(string, v, null);
                }
                iterator = hashtable2.keySet().iterator();
                while (iterator.hasNext()) {
                    string = iterator.next().toString();
                    v = hashtable2.get(string);
                    Object v2 = hashtable3.get(string);
                    Debug.println((int)7, (String)("IDARModelBean.compareProperties: key=" + string + " old=" + v2 + " new=" + v));
                    if (v.equals(v2)) continue;
                    this.firePropertyChangePersisted(string, v2, v);
                }
            }
            this.saveProperties(hashtable2, this.getId());
        }
    }

    protected void removeBeanManagementProperties(Hashtable hashtable) {
        hashtable.remove("task");
        hashtable.remove("basedn");
        hashtable.remove("desc");
        hashtable.remove("new-id");
        hashtable.remove("handle");
        hashtable.remove("objectclass");
        hashtable.remove("createtimestamp");
        hashtable.remove("creatorsname");
        hashtable.remove("modifytimestamp");
        hashtable.remove("modifiersname");
        hashtable.remove("session-id");
        hashtable.remove("id");
        hashtable.remove("installationtimestamp");
        hashtable.remove("serverproductname");
        hashtable.remove("cn");
        hashtable.remove("uniquemember");
        hashtable.remove("description");
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChange: event=" + propertyChangeEvent.toString()));
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChange: pn=" + string + " old=" + object + " new=" + object2));
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public void firePropertyChange(String string, int n, int n2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChange: pn=" + string + " old=" + n + " new=" + n2));
        this.changeSupport.firePropertyChange(string, n, n2);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChange: pn=" + string + " old=" + bl + " new=" + bl2));
        this.changeSupport.firePropertyChange(string, bl, bl2);
    }

    public void firePropertyChangePersisted(PropertyChangeEvent propertyChangeEvent) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChange: event=" + propertyChangeEvent.toString()));
        this.persistSupport.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChangePersisted(String string, Object object, Object object2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChangePersisted: pn=" + string + " old=" + object + " new=" + object2));
        this.persistSupport.firePropertyChange(string, object, object2);
    }

    public void firePropertyChangePersisted(String string, int n, int n2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChangePersisted: pn=" + string + " old=" + n + " new=" + n2));
        this.persistSupport.firePropertyChange(string, n, n2);
    }

    public void firePropertyChangePersisted(String string, boolean bl, boolean bl2) {
        Debug.println((int)4, (String)("IDARModelBean.firePropertyChangePersisted: pn=" + string + " old=" + bl + " new=" + bl2));
        this.persistSupport.firePropertyChange(string, bl, bl2);
    }

    public String toString() {
        return "IDARModelBean id=" + this.getId() + " ref=" + this.getSelfReference();
    }

    public void addBeanListener(BeanListener beanListener) {
        Debug.println((int)6, (String)("IDARModelBean.addBeanListener: " + beanListener));
        this.listeners.add(beanListener);
    }

    public void removeBeanListener(BeanListener beanListener) {
        Debug.println((int)6, (String)("IDARModelBean.removeBeanListener: " + beanListener));
        this.listeners.remove(beanListener);
    }

    public void fireBeanDeleted() {
        Debug.println((int)6, (String)"IDARModelBean.fireBeanDeleted");
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BeanListener beanListener = (BeanListener)enumeration.nextElement();
            if (beanListener == null) continue;
            beanListener.beanDeleted(new BeanEvent(this.getSelfReference(), this));
        }
    }

    public void fireBeanPersisted() {
        Debug.println((int)6, (String)"IDARModelBean.fireBeanPersisted");
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BeanListener beanListener = (BeanListener)enumeration.nextElement();
            if (beanListener == null) continue;
            beanListener.beanPersisted(new BeanEvent(this.getSelfReference(), this));
        }
    }

    public void fireBeanRenamed() {
        Debug.println((int)6, (String)"IDARModelBean.fireBeanRenamed");
        Vector vector = (Vector)this.listeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BeanListener beanListener = (BeanListener)enumeration.nextElement();
            if (beanListener == null) continue;
            beanListener.beanRenamed(new BeanEvent(this.getSelfReference(), this));
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof IDARModelBean) {
            IDARReference iDARReference = ((IDARModelBean)object).getSelfReference();
            IDARReference iDARReference2 = this.getSelfReference();
            if (iDARReference != null && iDARReference2 != null) {
                bl = iDARReference2.equals(iDARReference);
            }
        }
        return bl;
    }
}

