/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanReferenceMonitor;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.LoadBalanceData;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class LoadBalancePropertyBean
extends PropertyBean
implements IDARConstants {
    private static final String PREDELETION_MESSAGE = IDARResourceSet.getString("error", "LOAD_BALANCE_PROPERTY_DELETE");
    private static final String NO_SERVERS = IDARResourceSet.getString("error", "MISSING_SERVERS");
    private static final String PERCENTAGE_ERROR = IDARResourceSet.getString("error", "LOAD_BALANCE_PERCENTAGE");
    private LoadBalanceBeanReferenceMonitor monitor = null;
    String illegalityMessage;
    Vector lbData = new Vector();

    protected static String getIdPrefix() {
        return "load-balancing";
    }

    public LoadBalancePropertyBean() {
        this.monitor = new LoadBalanceBeanReferenceMonitor(this);
    }

    public boolean isLegal() {
        boolean bl = true;
        this.illegalityMessage = null;
        if (this.lbData.size() == 0) {
            bl = false;
            this.illegalityMessage = NO_SERVERS;
        } else if (this.getPercentageTotal() != 100) {
            bl = false;
            this.illegalityMessage = PERCENTAGE_ERROR;
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalityMessage;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        boolean bl = true;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray.length > 0) {
            bl = false;
        }
        return bl;
    }

    public String getPredeletionMessage() {
        String string = null;
        IDARReference[] iDARReferenceArray = this.getSubscribers();
        if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(PREDELETION_MESSAGE);
            stringBuffer.append('\n');
            for (int i = 0; i < iDARReferenceArray.length && i < 5; ++i) {
                stringBuffer.append("  ");
                stringBuffer.append(iDARReferenceArray[i].getId());
                if (i == 4 && iDARReferenceArray.length > 5) {
                    stringBuffer.append("\n  " + AND_OTHERS);
                }
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "network-group");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof NetworkGroupBean) {
                    NetworkGroupBean networkGroupBean = (NetworkGroupBean)e;
                    Vector vector3 = networkGroupBean.getLoadBalancePropertyIds();
                    if (vector3 == null) continue;
                    Enumeration enumeration2 = vector3.elements();
                    while (enumeration2.hasMoreElements()) {
                        String string2 = enumeration2.nextElement().toString();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(networkGroupBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"LoadBalancePropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"LoadBalancePropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getDescriptor() {
        return LoadBalancePropertyBean.getIdPrefix();
    }

    public int getDataCount() {
        return this.lbData.size();
    }

    public LoadBalanceData[] getLoadBalanceData() {
        LoadBalanceData[] loadBalanceDataArray = new LoadBalanceData[]{};
        if (this.lbData != null) {
            loadBalanceDataArray = new LoadBalanceData[this.lbData.size()];
            for (int i = 0; i < loadBalanceDataArray.length; ++i) {
                loadBalanceDataArray[i] = (LoadBalanceData)((LoadBalanceData)this.lbData.elementAt(i)).clone();
            }
        }
        return loadBalanceDataArray;
    }

    public LoadBalanceData getDataItemAt(int n) {
        return (LoadBalanceData)((LoadBalanceData)this.lbData.elementAt(n)).clone();
    }

    public void addLoadBalanceData(LoadBalanceData loadBalanceData) {
        if (loadBalanceData.isValid()) {
            this.lbData.add(loadBalanceData);
            BeanListenable beanListenable = loadBalanceData.getServer();
            this.monitor.addMonitor(beanListenable);
        } else {
            Debug.println((String)("LoadBalancePropertyBean.addLoadBalanceData: invalid data " + loadBalanceData));
        }
    }

    public void removeLoadBalanceData(LoadBalanceData loadBalanceData) {
        if (loadBalanceData != null) {
            BeanListenable beanListenable = loadBalanceData.getServer();
            if (beanListenable != null) {
                this.monitor.removeMonitor(beanListenable.getSelfReference());
            }
            this.lbData.remove(loadBalanceData);
        }
    }

    public void removeAllLoadBalanceData() {
        this.monitor.removeAllMonitors();
        this.lbData.clear();
    }

    public void setLoadBalanceData(LoadBalanceData[] loadBalanceDataArray) {
        this.removeAllLoadBalanceData();
        for (int i = 0; i < loadBalanceDataArray.length; ++i) {
            this.addLoadBalanceData(loadBalanceDataArray[i]);
        }
    }

    public int getPercentageTotal() {
        int n = 0;
        TaskParameters taskParameters = new TaskParameters();
        if (this.lbData.size() == 0) {
            taskParameters.addParameter("ids-proxy-con-server", "");
        } else {
            Enumeration enumeration = this.lbData.elements();
            while (enumeration.hasMoreElements()) {
                LoadBalanceData loadBalanceData = (LoadBalanceData)enumeration.nextElement();
                Integer n2 = loadBalanceData.getPercentage();
                if (n2 == null) continue;
                n += n2.intValue();
            }
        }
        return n;
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        int n = 0;
        TaskParameters taskParameters = new TaskParameters();
        if (this.lbData.size() == 0) {
            taskParameters.addParameter("ids-proxy-con-server", "");
        } else {
            Enumeration enumeration = this.lbData.elements();
            while (enumeration.hasMoreElements()) {
                LoadBalanceData loadBalanceData = (LoadBalanceData)enumeration.nextElement();
                Integer n2 = loadBalanceData.getPercentage();
                if (n2 != null) {
                    n += n2.intValue();
                }
                taskParameters.addParameter("ids-proxy-con-server", loadBalanceData.toString());
            }
        }
        if (!this.lbData.isEmpty() && n != 100) {
            throw new IllegalPropertyException(PERCENTAGE_ERROR);
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        TaskResult taskResult = super.doSynchronize();
        this.lbData.clear();
        this.monitor.removeAllMonitors();
        String[] stringArray = taskResult.getAttributeValues("ids-proxy-con-server");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().equals("")) continue;
                this.addLoadBalanceData(new LoadBalanceData(this.getParentConfiguration(), stringArray[i]));
            }
        }
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "LOAD_BALANCING_PROPERTY_DESCRIPTOR");
    }

    class LoadBalanceBeanReferenceMonitor
    extends BeanReferenceMonitor {
        LoadBalanceBeanReferenceMonitor(IDARModelBean iDARModelBean) {
            super(iDARModelBean);
        }

        LoadBalanceBeanReferenceMonitor(IDARModelBean iDARModelBean, BeanListenable beanListenable) {
            super(iDARModelBean, beanListenable);
        }

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((int)6, (String)("LoadBalanceBeanReferenceMonitor.beanDeleted: evt=" + beanEvent));
            IDARReference iDARReference = beanEvent.getReference();
            LoadBalanceData loadBalanceData = null;
            if (iDARReference != null) {
                String string = iDARReference.getId();
                Enumeration enumeration = LoadBalancePropertyBean.this.lbData.elements();
                while (enumeration.hasMoreElements()) {
                    LoadBalanceData loadBalanceData2 = (LoadBalanceData)enumeration.nextElement();
                    BeanListenable beanListenable = loadBalanceData2.getServer();
                    if (beanListenable == null || !string.equals(beanListenable.getId())) continue;
                    loadBalanceData = loadBalanceData2;
                    break;
                }
            }
            if (loadBalanceData != null) {
                Debug.println((int)6, (String)("LoadBalanceBeanReferenceMonitor.beanDeleted: remove data=" + loadBalanceData));
                LoadBalancePropertyBean.this.removeLoadBalanceData(loadBalanceData);
                super.beanDeleted(beanEvent);
            }
        }
    }
}

