/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task;

import com.iplanet.idar.task.DefaultTaskEventManager;
import com.iplanet.idar.task.Task;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.TaskEventManager;
import com.iplanet.idar.task.TaskListener;
import com.iplanet.idar.task.TaskManagerFactory;
import com.netscape.management.client.util.Debug;
import java.util.Vector;

public abstract class AbstractTask
implements Task {
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    public static final int UNEXECUTED = -2;
    public static final int CANCELED = -3;
    private boolean finished = false;
    protected boolean executable = false;
    protected boolean enabled = true;
    protected boolean executing = false;
    protected boolean canceled = false;
    protected boolean autoEnable = true;
    protected boolean outstandingEnablementRequest = false;
    protected TaskEventManager eventManager;
    protected TaskDialogManager dialogManager;
    protected String message = "";
    int status = -2;

    protected abstract int doExecute();

    public abstract String getName();

    public abstract String getDescription();

    public int getPriority() {
        return 5;
    }

    public String getUnexecutableMessage() {
        return "";
    }

    public String getExecutionFailureMessage() {
        return "";
    }

    public void execute() {
        if (this.isEnabled()) {
            if (this.isExecutable()) {
                this.fireTaskStarted();
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            AbstractTask.this.status = AbstractTask.this.doExecute();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            AbstractTask.this.status = -1;
                        }
                        finally {
                            AbstractTask.this.fireTaskStopped();
                            AbstractTask.this.finish();
                        }
                    }
                });
                thread.setName("iDAR Task Runner");
                thread.setPriority(this.getPriority());
                Debug.println((String)("AbstractTask.execute: task=" + this.getName() + " priority=" + this.getPriority()));
                thread.start();
            } else {
                Debug.println((String)("AbstractTask.execute: " + this.getName() + " cannot execute - " + this.getUnexecutableMessage()));
            }
        } else {
            Debug.println((String)("AbstractTask.execute: " + this.getName() + " cannot execute - disabled"));
        }
    }

    public void execute(final TaskListener taskListener) {
        this.addTaskListener(new TaskAdapter(){

            public void taskStopped(TaskEvent taskEvent) {
                AbstractTask.this.removeTaskListener(this);
                taskListener.taskStopped(taskEvent);
            }
        });
        this.execute();
    }

    public synchronized int executeAndWait() {
        this.execute();
        this.waitForFinish();
        return this.getExecutionStatus();
    }

    public boolean isCancelable() {
        return false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean bl) {
        Debug.println((int)6, (String)("AbstractTask.setEnabled: task=" + this.getName() + " req=" + bl + " current=" + this.enabled + " executable=" + this.executable));
        if (!bl || bl && this.executable) {
            if (bl != this.enabled) {
                if (bl) {
                    this.fireTaskEnabled();
                } else {
                    this.fireTaskDisabled();
                }
            }
        } else {
            this.outstandingEnablementRequest = true;
        }
        return this.enabled;
    }

    public void setBecomeEnabledUponBecomingExecutable(boolean bl) {
        this.autoEnable = bl;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    protected void setExecutable(boolean bl) {
        Debug.println((int)6, (String)("AbstractTask.setExecutable: task=" + this.getName() + " executable=" + bl + " current=" + this.executable));
        if (bl != this.executable) {
            if (bl) {
                this.fireTaskExecutable();
                if (this.autoEnable && this.outstandingEnablementRequest) {
                    this.setEnabled(true);
                }
            } else {
                this.fireTaskUnexecutable();
            }
        }
    }

    public int getExecutionStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void addTaskListener(TaskListener taskListener) {
        Debug.println((int)6, (String)("AbstractTask.addTaskListener: listener=" + taskListener));
        this.getEventManager().addTaskListener(taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.getEventManager().removeTaskListener(taskListener);
    }

    public String toString() {
        return this.getName();
    }

    public TaskEventManager getEventManager() {
        Debug.println((int)7, (String)("AbstractTask.getEventManager: em=" + this.eventManager));
        if (this.eventManager == null) {
            try {
                TaskEventManager taskEventManager = TaskManagerFactory.createTaskEventManager(this);
                this.setEventManager(taskEventManager);
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
        return this.eventManager;
    }

    public TaskDialogManager getDialogManager() {
        if (this.dialogManager == null) {
            TaskDialogManager taskDialogManager = TaskManagerFactory.createTaskDialogManager(this);
            this.setDialogManager(taskDialogManager);
        }
        return this.dialogManager;
    }

    protected void fireTaskStarted() {
        Debug.println((String)("AbstractTask.fireTaskStarted: task=" + this.getName()));
        this.message = "";
        this.executing = true;
        this.canceled = false;
        this.getEventManager().fireTaskStarted();
    }

    protected void fireTaskStopped() {
        Debug.println((String)("AbstractTask.fireTaskStopped: task=" + this.getName()));
        this.executing = false;
        this.getEventManager().fireTaskStopped();
    }

    protected void fireTaskExecutable() {
        Debug.println((String)("AbstractTask.fireTaskExecutable: task=" + this.getName()));
        this.executable = true;
        this.getEventManager().fireTaskExecutable();
    }

    protected void fireTaskUnexecutable() {
        Debug.println((String)("AbstractTask.fireTaskUnexecutable: task=" + this.getName()));
        this.executable = false;
        this.getEventManager().fireTaskUnexecutable();
    }

    protected void fireTaskEnabled() {
        Debug.println((String)("AbstractTask.fireTaskEnabled: task=" + this.getName()));
        this.enabled = true;
        this.outstandingEnablementRequest = false;
        this.getEventManager().fireTaskEnabled();
    }

    protected void fireTaskDisabled() {
        Debug.println((String)("AbstractTask.fireTaskUnexecutable: task=" + this.getName()));
        this.enabled = false;
        this.outstandingEnablementRequest = false;
        this.getEventManager().fireTaskDisabled();
    }

    protected void fireTaskStatusChanged(String string) {
        Debug.println((String)("AbstractTask.fireTaskStatusChanged: task=" + this.getName() + " message=" + string));
        this.message = string;
        this.getEventManager().fireTaskStatusChanged(string);
    }

    private void setEventManager(TaskEventManager taskEventManager) {
        Debug.println((int)6, (String)("AbstractTask.setEventManager: em=" + taskEventManager));
        if (taskEventManager instanceof DefaultTaskEventManager) {
            if (this.eventManager != null && this.eventManager instanceof DefaultTaskEventManager) {
                Debug.println((int)6, (String)"AbstractTask.setEventManager: transferring listeners to new manager");
                Vector vector = ((DefaultTaskEventManager)this.eventManager).getListeners();
                ((DefaultTaskEventManager)taskEventManager).setListeners(vector);
            }
            ((DefaultTaskEventManager)taskEventManager).setTask(this);
        }
        this.eventManager = taskEventManager;
    }

    private void setDialogManager(TaskDialogManager taskDialogManager) {
        this.dialogManager = taskDialogManager;
    }

    public synchronized void waitForFinish() {
        Debug.println((int)6, (String)"AbstractTask.waitForFinish");
        while (this.executing) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        Debug.println((int)6, (String)"AbstractTask.waitForFinish:  DONE");
    }

    private synchronized void finish() {
        this.notifyAll();
    }
}

